/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.vocabulary.diagram.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.structure.DiagramStructure;
import org.eclipse.opencert.vocabulary.Vocabulary;
import org.eclipse.opencert.vocabulary.VocabularyPackage;
import org.eclipse.opencert.vocabulary.diagram.part.VocabularyDiagramEditorPlugin;

public class VocabularyVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.opencert.vocabulary.diagram/debug/visualID";
    public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure(){

        public int getVisualID(View view) {
            return VocabularyVisualIDRegistry.getVisualID(view);
        }

        public String getModelID(View view) {
            return VocabularyVisualIDRegistry.getModelID(view);
        }

        public int getNodeVisualID(View containerView, EObject domainElement) {
            return VocabularyVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
            return VocabularyVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(int visualID) {
            return VocabularyVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(int visualID) {
            return VocabularyVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }
    };

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("Vocabulary".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return VocabularyVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                VocabularyDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (VocabularyPackage.eINSTANCE.getVocabulary().isSuperTypeOf(domainElement.eClass()) && VocabularyVisualIDRegistry.isDiagram((Vocabulary)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = VocabularyVisualIDRegistry.getModelID(containerView);
        if (!"Vocabulary".equals(containerModelID) && !"vocabulary".equals(containerModelID)) {
            return -1;
        }
        if ("Vocabulary".equals(containerModelID)) {
            containerVisualID = VocabularyVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (VocabularyPackage.eINSTANCE.getTerm().isSuperTypeOf(domainElement.eClass())) {
                    return 2001;
                }
                if (VocabularyPackage.eINSTANCE.getCategory().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (!VocabularyPackage.eINSTANCE.getSourceOfDefinition().isSuperTypeOf(domainElement.eClass())) break;
                return 2003;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = VocabularyVisualIDRegistry.getModelID(containerView);
        if (!"Vocabulary".equals(containerModelID) && !"vocabulary".equals(containerModelID)) {
            return false;
        }
        if ("Vocabulary".equals(containerModelID)) {
            containerVisualID = VocabularyVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2002 == nodeVisualID) {
                    return true;
                }
                if (2003 != nodeVisualID) break;
                return true;
            }
            case 2001: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (5002 != nodeVisualID) break;
                return true;
            }
            case 2002: {
                if (5003 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (5005 != nodeVisualID) break;
                return true;
            }
            case 4001: {
                if (6001 != nodeVisualID) break;
                return true;
            }
            case 4002: {
                if (6002 != nodeVisualID) break;
                return true;
            }
            case 4003: {
                if (6003 != nodeVisualID) break;
                return true;
            }
            case 4004: {
                if (6004 != nodeVisualID) break;
                return true;
            }
            case 4005: {
                if (6005 != nodeVisualID) break;
                return true;
            }
            case 4006: {
                if (6006 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        return -1;
    }

    private static boolean isDiagram(Vocabulary element) {
        return true;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = VocabularyVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate;
    }

    public static boolean isCompartmentVisualID(int visualID) {
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 1000: {
                return false;
            }
            case 2001: 
            case 2002: 
            case 2003: {
                return true;
            }
        }
        return false;
    }
}

