/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.security.impl;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionProvider;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.security.PatternStyle;
import org.eclipse.emf.cdo.security.ResourceFilter;
import org.eclipse.emf.cdo.security.SecurityPackage;
import org.eclipse.emf.cdo.security.impl.PermissionFilterImpl;
import org.eclipse.emf.cdo.security.impl.PermissionImpl;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.WrappedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceFilterImpl
extends PermissionFilterImpl
implements ResourceFilter {
    private static final String USER_TOKEN = "${user}";
    private static final int USER_TOKEN_NONE = -1;
    private static final int USER_TOKEN_UNINITIALIZED = -2;
    private transient int userTokenPos = -2;
    private transient BasicEList<Matcher> matchers;
    private transient int lastVersion;

    protected ResourceFilterImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return SecurityPackage.Literals.RESOURCE_FILTER;
    }

    @Override
    public String getPath() {
        return (String)this.eGet((EStructuralFeature)SecurityPackage.Literals.RESOURCE_FILTER__PATH, true);
    }

    @Override
    public ResourceFilter setPath(String newPath) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.RESOURCE_FILTER__PATH, newPath);
        return this;
    }

    @Override
    public PatternStyle getPatternStyle() {
        return (PatternStyle)((Object)this.eGet((EStructuralFeature)SecurityPackage.Literals.RESOURCE_FILTER__PATTERN_STYLE, true));
    }

    @Override
    public ResourceFilter setPatternStyle(PatternStyle newPatternStyle) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.RESOURCE_FILTER__PATTERN_STYLE, (Object)newPatternStyle);
        return this;
    }

    @Override
    public boolean isFolders() {
        return (Boolean)this.eGet((EStructuralFeature)SecurityPackage.Literals.RESOURCE_FILTER__FOLDERS, true);
    }

    @Override
    public ResourceFilter setFolders(boolean newFolders) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.RESOURCE_FILTER__FOLDERS, newFolders);
        return this;
    }

    @Override
    public boolean isModelResources() {
        return (Boolean)this.eGet((EStructuralFeature)SecurityPackage.Literals.RESOURCE_FILTER__MODEL_RESOURCES, true);
    }

    @Override
    public ResourceFilter setModelResources(boolean newModelResources) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.RESOURCE_FILTER__MODEL_RESOURCES, newModelResources);
        return this;
    }

    @Override
    public boolean isModelObjects() {
        return (Boolean)this.eGet((EStructuralFeature)SecurityPackage.Literals.RESOURCE_FILTER__MODEL_OBJECTS, true);
    }

    @Override
    public ResourceFilter setModelObjects(boolean newModelObjects) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.RESOURCE_FILTER__MODEL_OBJECTS, newModelObjects);
        return this;
    }

    @Override
    public boolean isIncludeParents() {
        return (Boolean)this.eGet((EStructuralFeature)SecurityPackage.Literals.RESOURCE_FILTER__INCLUDE_PARENTS, true);
    }

    @Override
    public ResourceFilter setIncludeParents(boolean newIncludeParents) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.RESOURCE_FILTER__INCLUDE_PARENTS, newIncludeParents);
        return this;
    }

    @Override
    public boolean isIncludeRoot() {
        return (Boolean)this.eGet((EStructuralFeature)SecurityPackage.Literals.RESOURCE_FILTER__INCLUDE_ROOT, true);
    }

    @Override
    public ResourceFilter setIncludeRoot(boolean newIncludeRoot) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.RESOURCE_FILTER__INCLUDE_ROOT, newIncludeRoot);
        return this;
    }

    @Override
    public boolean isTextResources() {
        return (Boolean)this.eGet((EStructuralFeature)SecurityPackage.Literals.RESOURCE_FILTER__TEXT_RESOURCES, true);
    }

    @Override
    public ResourceFilter setTextResources(boolean newTextResources) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.RESOURCE_FILTER__TEXT_RESOURCES, newTextResources);
        return this;
    }

    @Override
    public boolean isBinaryResources() {
        return (Boolean)this.eGet((EStructuralFeature)SecurityPackage.Literals.RESOURCE_FILTER__BINARY_RESOURCES, true);
    }

    @Override
    public ResourceFilter setBinaryResources(boolean newBinaryResources) {
        this.eSet((EStructuralFeature)SecurityPackage.Literals.RESOURCE_FILTER__BINARY_RESOURCES, newBinaryResources);
        return this;
    }

    @Override
    public boolean isImpacted(PermissionImpl.CommitImpactContext context) {
        return ResourceFilterImpl.isResourceTreeImpacted(context);
    }

    @Override
    public String format() {
        String label = "?";
        String path = this.getPath();
        if (path != null) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            label = path;
        }
        String operator = this.formatOperator();
        return "resource" + operator + label;
    }

    protected String formatOperator() {
        PatternStyle patternStyle = this.getPatternStyle();
        switch (patternStyle) {
            case EXACT: {
                return " == ";
            }
            case TREE: {
                return " >= ";
            }
            case ANT: 
            case REGEX: {
                return " ~= ";
            }
        }
        throw new IllegalStateException("Unhandled pattern style: " + (Object)((Object)patternStyle));
    }

    @Override
    protected boolean filter(CDORevision revision, CDORevisionProvider revisionProvider, CDOBranchPoint securityContext, int level) throws Exception {
        if (!this.preChecks(revision, revisionProvider)) {
            return false;
        }
        String revisionPath = CDORevisionUtil.getResourceNodePath((CDORevision)revision, (CDORevisionProvider)revisionProvider);
        BasicEList<Matcher> list = this.getMatchers();
        Object[] matchers = list.data();
        int length = list.size();
        int i = 0;
        while (i < length) {
            Matcher matcher = (Matcher)matchers[i];
            if (matcher.matches(revisionPath)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean preChecks(CDORevision revision, CDORevisionProvider revisionProvider) {
        boolean modelObject;
        if (revisionProvider == null) {
            return false;
        }
        EClass eClass = revision.getEClass();
        boolean resourceNode = false;
        if (eClass == EresourcePackage.Literals.CDO_RESOURCE_FOLDER) {
            resourceNode = true;
            if (!this.isFolders()) {
                return false;
            }
        }
        if (eClass == EresourcePackage.Literals.CDO_RESOURCE) {
            resourceNode = true;
            boolean rootResource = CDOIDUtil.isNull((CDOID)((CDOID)((InternalCDORevision)revision).getContainerID()));
            if (rootResource ? !this.isIncludeRoot() : !this.isModelResources()) {
                return false;
            }
        }
        if (eClass == EresourcePackage.Literals.CDO_TEXT_RESOURCE) {
            resourceNode = true;
            if (!this.isTextResources()) {
                return false;
            }
        }
        if (eClass == EresourcePackage.Literals.CDO_BINARY_RESOURCE) {
            resourceNode = true;
            if (!this.isBinaryResources()) {
                return false;
            }
        }
        boolean bl = modelObject = !resourceNode;
        return !modelObject || this.isModelObjects();
    }

    private BasicEList<Matcher> getMatchers() {
        InternalCDORevision revision = this.cdoRevision();
        if (revision != null) {
            int currentVersion = revision.getVersion();
            if (currentVersion > this.lastVersion) {
                this.userTokenPos = -2;
                this.matchers = null;
                this.lastVersion = currentVersion;
            }
            if (this.matchers != null) {
                return this.matchers;
            }
        }
        String path = this.getPath();
        PatternStyle patternStyle = this.getPatternStyle();
        boolean includeParents = this.isIncludeParents();
        if (this.userTokenPos == -2 || revision == null) {
            this.userTokenPos = path.indexOf(USER_TOKEN);
        }
        if (this.userTokenPos != -1) {
            String user = this.getUser();
            if (user == null || user.length() == 0) {
                throw new IllegalStateException("User required for evaluation of path " + path);
            }
            path = String.valueOf(path.substring(0, this.userTokenPos)) + user + path.substring(this.userTokenPos + USER_TOKEN.length());
        }
        BasicEList list = new BasicEList(1);
        this.getMatchers((BasicEList<Matcher>)list, path, patternStyle, includeParents);
        if (this.userTokenPos == -1) {
            this.matchers = list;
        }
        return list;
    }

    private void getMatchers(BasicEList<Matcher> matchers, String path, PatternStyle patternStyle, boolean includeParents) {
        int pos;
        Matcher matcher = this.createMatcher(path, patternStyle);
        matchers.add((Object)matcher);
        if (includeParents && (pos = path.lastIndexOf("/")) != -1) {
            path = path.substring(0, pos);
            patternStyle = matcher.getParentPatternStyle();
            this.getMatchers(matchers, path, patternStyle, includeParents);
        }
    }

    private Matcher createMatcher(String path, PatternStyle patternStyle) {
        switch (patternStyle) {
            case EXACT: {
                return new ExactMatcher(path);
            }
            case TREE: {
                return new TreeMatcher(path);
            }
            case ANT: {
                return new AntMatcher(path);
            }
            case REGEX: {
                return new RegexMatcher(path);
            }
        }
        throw new IllegalStateException("Unhandled pattern style: " + (Object)((Object)patternStyle));
    }

    public static boolean isResourceTreeImpacted(PermissionImpl.CommitImpactContext context) {
        InternalCDORevisionDelta[] revisionDeltas = (InternalCDORevisionDelta[])context.getDirtyObjectDeltas();
        int i = 0;
        while (i < revisionDeltas.length) {
            InternalCDORevisionDelta revisionDelta = revisionDeltas[i];
            CDOFeatureDelta containerDelta = revisionDelta.getFeatureDelta((EStructuralFeature)CDOContainerFeatureDelta.CONTAINER_FEATURE);
            if (containerDelta != null) {
                return true;
            }
            CDOFeatureDelta nameDelta = revisionDelta.getFeatureDelta((EStructuralFeature)EresourcePackage.Literals.CDO_RESOURCE_NODE__NAME);
            if (nameDelta != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static class AntMatcher
    extends PathMatcher {
        public AntMatcher(String path) {
            super(path);
        }

        public boolean matches(String revisionPath) {
            return StringUtil.glob((String)this.path, (String)revisionPath);
        }

        public PatternStyle getParentPatternStyle() {
            return PatternStyle.ANT;
        }
    }

    protected static class ExactMatcher
    extends PathMatcher {
        public ExactMatcher(String path) {
            super(path);
        }

        public boolean matches(String revisionPath) {
            return this.path.equals(revisionPath);
        }

        public PatternStyle getParentPatternStyle() {
            return PatternStyle.EXACT;
        }
    }

    public static interface Matcher {
        public boolean matches(String var1);

        public PatternStyle getParentPatternStyle();
    }

    protected static abstract class PathMatcher
    implements Matcher {
        protected final String path;

        public PathMatcher(String path) {
            this.path = path == null || path.length() == 0 ? "/" : path;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "[" + this.path + "]";
        }
    }

    protected static class RegexMatcher
    implements Matcher {
        private final Pattern pattern;

        public RegexMatcher(String path) {
            try {
                this.pattern = Pattern.compile(path);
            }
            catch (PatternSyntaxException ex) {
                throw WrappedException.wrap((Exception)ex);
            }
        }

        public boolean matches(String revisionPath) {
            return this.pattern.matcher(revisionPath).matches();
        }

        public PatternStyle getParentPatternStyle() {
            return PatternStyle.REGEX;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + "[" + this.pattern.pattern() + "]";
        }
    }

    protected static class TreeMatcher
    extends PathMatcher {
        public TreeMatcher(String path) {
            super(path);
        }

        public boolean matches(String revisionPath) {
            if (revisionPath == null) {
                return this.path.length() == 0;
            }
            return revisionPath.startsWith(this.path);
        }

        public PatternStyle getParentPatternStyle() {
            return PatternStyle.EXACT;
        }
    }
}

