/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.servlet;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.eclipse.equinox.http.servlet.internal.context.ContextController;
import org.eclipse.equinox.http.servlet.internal.context.DispatchTargets;
import org.eclipse.equinox.http.servlet.internal.servlet.RequestDispatcherAdaptor;
import org.eclipse.equinox.http.servlet.internal.util.EventListeners;

public class HttpServletRequestWrapperImpl
extends HttpServletRequestWrapper {
    private final Stack<DispatchTargets> dispatchTargets = new Stack();
    private final HttpServletRequest request;
    private static final String[] dispatcherAttributes = new String[]{"javax.servlet.error.exception", "javax.servlet.error.exception_type", "javax.servlet.error.message", "javax.servlet.error.request_uri", "javax.servlet.error.servlet_name", "javax.servlet.error.status_code", "javax.servlet.forward.context_path", "javax.servlet.forward.path_info", "javax.servlet.forward.query_string", "javax.servlet.forward.request_uri", "javax.servlet.forward.servlet_path", "javax.servlet.include.context_path", "javax.servlet.include.path_info", "javax.servlet.include.query_string", "javax.servlet.include.request_uri", "javax.servlet.include.servlet_path"};

    public static HttpServletRequestWrapperImpl findHttpRuntimeRequest(HttpServletRequest request) {
        while (request instanceof HttpServletRequestWrapper) {
            if (request instanceof HttpServletRequestWrapperImpl) {
                return (HttpServletRequestWrapperImpl)request;
            }
            request = (HttpServletRequest)((HttpServletRequestWrapper)request).getRequest();
        }
        return null;
    }

    public HttpServletRequestWrapperImpl(HttpServletRequest request) {
        super(request);
        this.request = request;
    }

    public String getAuthType() {
        String authType = (String)this.getAttribute("org.osgi.service.http.authentication.type");
        if (authType != null) {
            return authType;
        }
        return this.request.getAuthType();
    }

    public String getRemoteUser() {
        String remoteUser = (String)this.getAttribute("org.osgi.service.http.authentication.remote.user");
        if (remoteUser != null) {
            return remoteUser;
        }
        return this.request.getRemoteUser();
    }

    public String getPathInfo() {
        if (this.dispatchTargets.peek().getServletName() != null || this.dispatchTargets.peek().getDispatcherType() == DispatcherType.INCLUDE) {
            return ((DispatchTargets)this.dispatchTargets.get(0)).getPathInfo();
        }
        return this.dispatchTargets.peek().getPathInfo();
    }

    public DispatcherType getDispatcherType() {
        return this.dispatchTargets.peek().getDispatcherType();
    }

    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Map<String, String[]> getParameterMap() {
        return this.dispatchTargets.peek().getParameterMap();
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    public String getQueryString() {
        if (this.dispatchTargets.peek().getServletName() != null || this.dispatchTargets.peek().getDispatcherType() == DispatcherType.INCLUDE) {
            return this.request.getQueryString();
        }
        return this.dispatchTargets.peek().getQueryString();
    }

    public String getRequestURI() {
        if (this.dispatchTargets.peek().getServletName() != null || this.dispatchTargets.peek().getDispatcherType() == DispatcherType.INCLUDE) {
            return this.request.getRequestURI();
        }
        return this.dispatchTargets.peek().getRequestURI();
    }

    public ServletContext getServletContext() {
        return this.dispatchTargets.peek().getServletRegistration().getServletContext();
    }

    public String getServletPath() {
        if (this.dispatchTargets.peek().getServletName() != null || this.dispatchTargets.peek().getDispatcherType() == DispatcherType.INCLUDE) {
            return ((DispatchTargets)this.dispatchTargets.get(0)).getServletPath();
        }
        if (this.dispatchTargets.peek().getServletPath().equals("/")) {
            return "";
        }
        return this.dispatchTargets.peek().getServletPath();
    }

    public String getContextPath() {
        return this.dispatchTargets.peek().getContextController().getFullContextPath();
    }

    public Object getAttribute(String attributeName) {
        DispatchTargets current = this.dispatchTargets.peek();
        if (current.getDispatcherType() == DispatcherType.ERROR) {
            if (Arrays.binarySearch(dispatcherAttributes, attributeName) > -1 && !attributeName.startsWith("javax.servlet.error.")) {
                return null;
            }
        } else if (current.getDispatcherType() == DispatcherType.INCLUDE) {
            if (attributeName.equals("javax.servlet.include.context_path")) {
                if (current.getServletName() != null) {
                    return null;
                }
                if (super.getAttribute("javax.servlet.include.context_path") != null) {
                    return super.getAttribute("javax.servlet.include.context_path");
                }
                return current.getContextController().getContextPath();
            }
            if (attributeName.equals("javax.servlet.include.path_info")) {
                if (current.getServletName() != null) {
                    return null;
                }
                if (super.getAttribute("javax.servlet.include.path_info") != null) {
                    return super.getAttribute("javax.servlet.include.path_info");
                }
                return current.getPathInfo();
            }
            if (attributeName.equals("javax.servlet.include.query_string")) {
                if (current.getServletName() != null) {
                    return null;
                }
                if (super.getAttribute("javax.servlet.include.query_string") != null) {
                    return super.getAttribute("javax.servlet.include.query_string");
                }
                return current.getQueryString();
            }
            if (attributeName.equals("javax.servlet.include.request_uri")) {
                if (current.getServletName() != null) {
                    return null;
                }
                if (super.getAttribute("javax.servlet.include.request_uri") != null) {
                    return super.getAttribute("javax.servlet.include.request_uri");
                }
                return current.getRequestURI();
            }
            if (attributeName.equals("javax.servlet.include.servlet_path")) {
                if (current.getServletName() != null) {
                    return null;
                }
                if (super.getAttribute("javax.servlet.include.servlet_path") != null) {
                    return super.getAttribute("javax.servlet.include.servlet_path");
                }
                return current.getServletPath();
            }
            if (Arrays.binarySearch(dispatcherAttributes, attributeName) > -1) {
                return null;
            }
        } else if (current.getDispatcherType() == DispatcherType.FORWARD) {
            DispatchTargets original = (DispatchTargets)this.dispatchTargets.get(0);
            if (attributeName.equals("javax.servlet.forward.context_path")) {
                if (current.getServletName() != null) {
                    return null;
                }
                return original.getContextController().getContextPath();
            }
            if (attributeName.equals("javax.servlet.forward.path_info")) {
                if (current.getServletName() != null) {
                    return null;
                }
                return original.getPathInfo();
            }
            if (attributeName.equals("javax.servlet.forward.query_string")) {
                if (current.getServletName() != null) {
                    return null;
                }
                return original.getQueryString();
            }
            if (attributeName.equals("javax.servlet.forward.request_uri")) {
                if (current.getServletName() != null) {
                    return null;
                }
                return original.getRequestURI();
            }
            if (attributeName.equals("javax.servlet.forward.servlet_path")) {
                if (current.getServletName() != null) {
                    return null;
                }
                return original.getServletPath();
            }
            if (Arrays.binarySearch(dispatcherAttributes, attributeName) > -1) {
                return null;
            }
        }
        return this.request.getAttribute(attributeName);
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        ContextController contextController = this.dispatchTargets.peek().getContextController();
        if (!path.startsWith("/")) {
            path = String.valueOf(this.dispatchTargets.peek().getServletPath()) + "/" + path;
        } else if (path.startsWith(contextController.getFullContextPath())) {
            path = path.substring(contextController.getFullContextPath().length());
        }
        DispatchTargets requestedDispatchTargets = contextController.getDispatchTargets(path, null);
        if (requestedDispatchTargets == null) {
            return null;
        }
        return new RequestDispatcherAdaptor(requestedDispatchTargets, path);
    }

    public static String getDispatchPathInfo(HttpServletRequest req) {
        if (req.getDispatcherType() == DispatcherType.INCLUDE) {
            return (String)req.getAttribute("javax.servlet.include.path_info");
        }
        return req.getPathInfo();
    }

    public HttpSession getSession() {
        HttpSession session = this.request.getSession();
        if (session != null) {
            return this.dispatchTargets.peek().getContextController().getSessionAdaptor(session, ((Servlet)this.dispatchTargets.peek().getServletRegistration().getT()).getServletConfig().getServletContext());
        }
        return null;
    }

    public HttpSession getSession(boolean create) {
        HttpSession session = this.request.getSession(create);
        if (session != null) {
            return this.dispatchTargets.peek().getContextController().getSessionAdaptor(session, ((Servlet)this.dispatchTargets.peek().getServletRegistration().getT()).getServletConfig().getServletContext());
        }
        return null;
    }

    public synchronized void pop() {
        if (this.dispatchTargets.size() > 1) {
            this.dispatchTargets.pop();
        }
    }

    public synchronized void push(DispatchTargets toPush) {
        toPush.addRequestParameters(this.request);
        this.dispatchTargets.push(toPush);
    }

    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
        EventListeners eventListeners = this.dispatchTargets.peek().getContextController().getEventListeners();
        List<ServletRequestAttributeListener> listeners = eventListeners.get(ServletRequestAttributeListener.class);
        if (listeners.isEmpty()) {
            return;
        }
        ServletRequestAttributeEvent servletRequestAttributeEvent = new ServletRequestAttributeEvent(this.dispatchTargets.peek().getServletRegistration().getServletContext(), (ServletRequest)this, name, null);
        for (ServletRequestAttributeListener servletRequestAttributeListener : listeners) {
            servletRequestAttributeListener.attributeRemoved(servletRequestAttributeEvent);
        }
    }

    public void setAttribute(String name, Object value) {
        boolean added = this.request.getAttribute(name) == null;
        this.request.setAttribute(name, value);
        EventListeners eventListeners = this.dispatchTargets.peek().getContextController().getEventListeners();
        List<ServletRequestAttributeListener> listeners = eventListeners.get(ServletRequestAttributeListener.class);
        if (listeners.isEmpty()) {
            return;
        }
        ServletRequestAttributeEvent servletRequestAttributeEvent = new ServletRequestAttributeEvent(this.dispatchTargets.peek().getServletRegistration().getServletContext(), (ServletRequest)this, name, value);
        for (ServletRequestAttributeListener servletRequestAttributeListener : listeners) {
            if (added) {
                servletRequestAttributeListener.attributeAdded(servletRequestAttributeEvent);
                continue;
            }
            servletRequestAttributeListener.attributeReplaced(servletRequestAttributeEvent);
        }
    }
}

