/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.helpers.Zone;
import org.eclipse.papyrus.uml.diagram.statemachine.providers.ElementInitializers;
import org.eclipse.papyrus.uml.diagram.statemachine.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.UMLFactory;

public class CustomFirstRegionInStateMachineCreateElementCommand
extends AbstractTransactionalCommand {
    IAdaptable adaptable;
    IAdaptable adaptableForDropped = null;
    PreferencesHint prefHints;
    CreateViewRequest.ViewDescriptor viewDescriptor;
    CreateElementRequest createElementRequest;
    String dropLocation = "";

    public CustomFirstRegionInStateMachineCreateElementCommand(IAdaptable adaptable, IAdaptable adaptableForDropped, PreferencesHint prefHints, TransactionalEditingDomain domain, String label, String dropLocation) {
        super(domain, label, null);
        this.adaptable = adaptable;
        this.adaptableForDropped = adaptableForDropped;
        this.prefHints = prefHints;
        this.viewDescriptor = new CreateViewRequest.ViewDescriptor(adaptable, prefHints);
        this.setResult(CommandResult.newOKCommandResult((Object)this.viewDescriptor));
        this.dropLocation = dropLocation;
    }

    protected void doConfigure(Region newElement, IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IElementType elementType = this.createElementRequest.getElementType();
        ConfigureRequest configureRequest = new ConfigureRequest(this.getEditingDomain(), (EObject)newElement, elementType);
        configureRequest.setClientContext(this.createElementRequest.getClientContext());
        configureRequest.addParameters(this.createElementRequest.getParameters());
        ICommand configureCommand = elementType.getEditCommand((IEditCommandRequest)configureRequest);
        if (configureCommand != null && configureCommand.canExecute()) {
            configureCommand.execute(monitor, info);
        }
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        View ownerView = (View)this.adaptable.getAdapter(View.class);
        Node compartment = (Node)ownerView.getChildren().get(1);
        int height = Zone.getHeight(ownerView);
        int width = Zone.getWidth(ownerView);
        if (height < 100) {
            height = 100;
            Zone.setHeight(ownerView, height);
        }
        if (width < 200) {
            width = 200;
            Zone.setWidth(ownerView, width);
        }
        if (this.adaptableForDropped == null) {
            Region umlRegion = UMLFactory.eINSTANCE.createRegion();
            this.createElementRequest = new CreateElementRequest(this.getEditingDomain(), (EObject)ownerView, UMLElementTypes.Region_Shape);
            StateMachine umlState = (StateMachine)ownerView.getElement();
            umlState.getRegions().add((Object)umlRegion);
            ElementInitializers.getInstance().init_Region_Shape(umlRegion);
            this.doConfigure(umlRegion, monitor, info);
            this.adaptableForDropped = new SemanticAdapter((EObject)umlRegion, null);
        }
        String semanticHint = ((IHintedType)UMLElementTypes.Region_Shape).getSemanticHint();
        Node newRegion = ViewService.getInstance().createNode(this.adaptableForDropped, (View)compartment, semanticHint, -1, this.prefHints);
        Zone.createRegionDefaultAnnotation((View)newRegion);
        LayoutConstraint lc = compartment.getLayoutConstraint();
        if (lc instanceof Bounds) {
            Bounds bounds = (Bounds)lc;
            Zone.setWidth((View)newRegion, bounds.getWidth());
            Zone.setHeight((View)newRegion, bounds.getHeight());
        }
        this.viewDescriptor.setView((View)newRegion);
        return CommandResult.newOKCommandResult((Object)this.viewDescriptor);
    }
}

