/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.resource;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.emf.resource.index.IWorkspaceModelIndexListener;
import org.eclipse.papyrus.infra.emf.resource.index.IWorkspaceModelIndexProvider;
import org.eclipse.papyrus.infra.emf.resource.index.WorkspaceModelIndex;
import org.eclipse.papyrus.infra.emf.resource.index.WorkspaceModelIndexAdapter;
import org.eclipse.papyrus.infra.emf.resource.index.WorkspaceModelIndexEvent;
import org.eclipse.papyrus.uml.decoratormodel.Activator;
import org.eclipse.papyrus.uml.decoratormodel.helper.DecoratorModelUtils;
import org.eclipse.papyrus.uml.decoratormodel.internal.messages.Messages;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.DecoratorModelIndexEvent;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.IDecoratorModelIndexListener;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.index.AbstractUMLIndexHandler;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.index.ModelIndexHandler;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.index.ProfileIndexHandler;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.xml.sax.helpers.DefaultHandler;

public class DecoratorModelIndex {
    private static final int MAX_INDEX_JOBS = 5;
    private static final DecoratorModelIndex INSTANCE = new DecoratorModelIndex();
    private final Object sync = new Object();
    private final SetMultimap<URI, URI> modelToDecorators = HashMultimap.create();
    private final SetMultimap<URI, URI> decoratorToModels = HashMultimap.create();
    private final SetMultimap<URI, URI> packageToDecoratorModels = HashMultimap.create();
    private final Map<URI, Map<URI, Map<URI, URI>>> decoratorModelToPackageToProfileApplications = Maps.newHashMap();
    private final Map<URI, String> decoratorModelNames = Maps.newHashMap();
    private final Map<URI, SetMultimap<URI, URI>> userModelToResourceToAppliedProfiles = Maps.newHashMap();
    private final WorkspaceModelIndex<IndexedFile<?>> index;
    private final CopyOnWriteArrayList<IDecoratorModelIndexListener> listeners = Lists.newCopyOnWriteArrayList();

    static {
        INSTANCE.initialize();
    }

    private DecoratorModelIndex() {
        this.index = new WorkspaceModelIndex("papyrusUMLProfiles", "org.eclipse.uml2.uml", this.indexer(), 5);
    }

    private void initialize() {
        this.index.addListener((IWorkspaceModelIndexListener)new WorkspaceModelIndexAdapter(){

            protected void indexAboutToCalculateOrRecalculate(WorkspaceModelIndexEvent event) {
                CacheAdapter.getInstance().clear();
            }

            protected void indexCalculatedOrRecalculated(WorkspaceModelIndexEvent event) {
                DecoratorModelIndex.this.notifyChanged();
            }
        });
    }

    public void dispose() {
        this.index.dispose();
        this.modelToDecorators.clear();
    }

    public static DecoratorModelIndex getInstance() {
        return INSTANCE;
    }

    public ListenableFuture<SetMultimap<URI, URI>> getDecoratorModelsAsync() {
        return this.afterIndex(this.getDecoratorModelsCallable());
    }

    public SetMultimap<URI, URI> getDecoratorModels() throws CoreException {
        return this.sync((Future)this.afterIndex(this.getDecoratorModelsCallable()));
    }

    Callable<SetMultimap<URI, URI>> getDecoratorModelsCallable() {
        return new SyncCallable<SetMultimap<URI, URI>>(this){

            @Override
            protected SetMultimap<URI, URI> doCall() {
                return ImmutableSetMultimap.copyOf((Multimap)modelToDecorators);
            }
        };
    }

    public ListenableFuture<Set<URI>> getDecoratorModelsAsync(URI modelResourceURI) {
        return this.afterIndex(this.getDecoratorModelsCallable(modelResourceURI));
    }

    public Set<URI> getDecoratorModels(URI modelResourceURI) throws CoreException {
        return this.sync((Future)this.afterIndex(this.getDecoratorModelsCallable(modelResourceURI)));
    }

    final <V> V sync(Future<V> future) throws CoreException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        catch (ExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.papyrus.uml.decoratormodel", Messages.DecoratorModelIndex_0, (Throwable)e));
        }
    }

    Callable<Set<URI>> getDecoratorModelsCallable(final URI modelResourceURI) {
        return new SyncCallable<Set<URI>>(this){

            @Override
            protected Set<URI> doCall() {
                return ImmutableSet.copyOf((Collection)modelToDecorators.get((Object)modelResourceURI));
            }
        };
    }

    public ListenableFuture<Set<URI>> getAppliedProfilesAsync(final URI packageURI, URI decoratorModel) {
        return Futures.transform(this.getAppliedProfilesByPackageAsync(decoratorModel), (Function)new Function<SetMultimap<URI, URI>, Set<URI>>(){

            public Set<URI> apply(SetMultimap<URI, URI> input) {
                return input.get((Object)packageURI);
            }
        });
    }

    public Set<URI> getAppliedProfiles(URI packageURI, URI decoratorModel) throws CoreException {
        return this.sync((Future)this.getAppliedProfilesAsync(packageURI, decoratorModel));
    }

    public ListenableFuture<SetMultimap<URI, URI>> getAppliedProfilesByPackageAsync(URI decoratorModel) {
        return this.afterIndex(this.getAppliedProfilesByPackageCallable(decoratorModel));
    }

    public SetMultimap<URI, URI> getAppliedProfilesByPackage(URI decoratorModel) throws CoreException {
        return this.sync((Future)this.afterIndex(this.getAppliedProfilesByPackageCallable(decoratorModel)));
    }

    Callable<SetMultimap<URI, URI>> getAppliedProfilesByPackageCallable(final URI decoratorModel) {
        return new SyncCallable<SetMultimap<URI, URI>>(this){

            @Override
            protected SetMultimap<URI, URI> doCall() {
                ImmutableSetMultimap result;
                Map packageToProfileApplications = (Map)decoratorModelToPackageToProfileApplications.get(decoratorModel);
                if (packageToProfileApplications == null) {
                    result = ImmutableSetMultimap.of();
                } else {
                    ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
                    for (Map.Entry next : packageToProfileApplications.entrySet()) {
                        builder.putAll((Object)((URI)next.getKey()), ((Map)next.getValue()).keySet());
                    }
                    result = builder.build();
                }
                return result;
            }
        };
    }

    public ListenableFuture<SetMultimap<URI, URI>> getAllAppliedProfilesAsync(URI package_) {
        return this.afterIndex(this.getAllAppliedProfilesCallable(package_));
    }

    public SetMultimap<URI, URI> getAllAppliedProfiles(URI package_) throws CoreException {
        return this.sync((Future)this.afterIndex(this.getAllAppliedProfilesCallable(package_)));
    }

    Callable<SetMultimap<URI, URI>> getAllAppliedProfilesCallable(final URI packageURI) {
        return new SyncCallable<SetMultimap<URI, URI>>(this){

            @Override
            protected SetMultimap<URI, URI> doCall() {
                ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
                for (URI paResource : modelToDecorators.get((Object)packageURI.trimFragment())) {
                    Map profileApplications;
                    Map packageToProfileApplications = (Map)decoratorModelToPackageToProfileApplications.get(paResource);
                    if (packageToProfileApplications == null || (profileApplications = (Map)packageToProfileApplications.get(packageURI)) == null) continue;
                    for (URI profile : profileApplications.keySet()) {
                        result.put((Object)profile, (Object)paResource);
                    }
                }
                return result.build();
            }
        };
    }

    public ListenableFuture<Map<URI, Map<URI, URI>>> getAllAppliedProfileDefinitionsAsync(URI package_) {
        return this.afterIndex(this.getAllAppliedProfileDefinitionsCallable(package_));
    }

    public Map<URI, Map<URI, URI>> getAllAppliedProfileDefinitions(URI package_) throws CoreException {
        return this.sync((Future)this.afterIndex(this.getAllAppliedProfileDefinitionsCallable(package_)));
    }

    Callable<Map<URI, Map<URI, URI>>> getAllAppliedProfileDefinitionsCallable(final URI packageURI) {
        return new SyncCallable<Map<URI, Map<URI, URI>>>(this){

            @Override
            protected Map<URI, Map<URI, URI>> doCall() {
                HashMap gather = Maps.newHashMap();
                for (URI paResource : modelToDecorators.get((Object)packageURI.trimFragment())) {
                    Map profileApplications;
                    Map packageToProfileApplications = (Map)decoratorModelToPackageToProfileApplications.get(paResource);
                    if (packageToProfileApplications == null || (profileApplications = (Map)packageToProfileApplications.get(packageURI)) == null) continue;
                    for (Map.Entry next : profileApplications.entrySet()) {
                        URI profile = (URI)next.getKey();
                        ImmutableMap.Builder builder = (ImmutableMap.Builder)gather.get(profile);
                        if (builder == null) {
                            builder = ImmutableMap.builder();
                            gather.put(profile, builder);
                        }
                        builder.put((Object)paResource, (Object)((URI)next.getValue()));
                    }
                }
                ImmutableMap.Builder result = ImmutableMap.builder();
                for (Map.Entry next : gather.entrySet()) {
                    result.put((Object)((URI)next.getKey()), (Object)((ImmutableMap.Builder)next.getValue()).build());
                }
                return result.build();
            }
        };
    }

    public ListenableFuture<Set<URI>> getDecoratorModelsForPackageAsync(URI package_) {
        return this.afterIndex(this.getDecoratorModelsForPackageCallable(package_));
    }

    public Set<URI> getDecoratorModelsForPackage(URI package_) throws CoreException {
        return this.sync((Future)this.afterIndex(this.getDecoratorModelsForPackageCallable(package_)));
    }

    Callable<Set<URI>> getDecoratorModelsForPackageCallable(final URI packageURI) {
        return new SyncCallable<Set<URI>>(this){

            @Override
            protected Set<URI> doCall() {
                return ImmutableSet.copyOf((Collection)packageToDecoratorModels.get((Object)packageURI));
            }
        };
    }

    public ListenableFuture<Map<URI, String>> getDecoratorModelNamesAsync() {
        return this.afterIndex(this.getDecoratorModelNamesCallable());
    }

    public Map<URI, String> getDecoratorModelNames() throws CoreException {
        return this.sync((Future)this.afterIndex(this.getDecoratorModelNamesCallable()));
    }

    Callable<Map<URI, String>> getDecoratorModelNamesCallable() {
        return new SyncCallable<Map<URI, String>>(this){

            @Override
            protected Map<URI, String> doCall() {
                return ImmutableMap.copyOf((Map)decoratorModelNames);
            }
        };
    }

    public ListenableFuture<String> getDecoratorModelNameAsync(final URI resourceURI) {
        return Futures.transform(this.getDecoratorModelNamesAsync(), (Function)new Function<Map<URI, String>, String>(){

            public String apply(Map<URI, String> input) {
                return input.get(resourceURI);
            }
        });
    }

    public String getDecoratorModelName(URI resourceURI) throws CoreException {
        return this.sync((Future)this.getDecoratorModelNameAsync(resourceURI));
    }

    public ListenableFuture<SetMultimap<URI, URI>> getUserModelsByDecoratorAsync() {
        return this.afterIndex(this.getUserModelsByDecoratorCallable());
    }

    public SetMultimap<URI, URI> getUserModelsByDecorator() throws CoreException {
        return this.sync((Future)this.afterIndex(this.getUserModelsByDecoratorCallable()));
    }

    Callable<SetMultimap<URI, URI>> getUserModelsByDecoratorCallable() {
        return new SyncCallable<SetMultimap<URI, URI>>(this){

            @Override
            protected SetMultimap<URI, URI> doCall() {
                return ImmutableSetMultimap.copyOf((Multimap)decoratorToModels);
            }
        };
    }

    public ListenableFuture<Set<URI>> getAllProfilesAppliedToPackagesAsync(URI userModelURI) {
        return this.afterIndex(this.getAllProfilesAppliedToPackagesCallable(userModelURI));
    }

    public Set<URI> getAllProfilesAppliedToPackages(URI userModelURI) throws CoreException {
        return this.sync((Future)this.afterIndex(this.getAllProfilesAppliedToPackagesCallable(userModelURI)));
    }

    Callable<Set<URI>> getAllProfilesAppliedToPackagesCallable(final URI userModelURI) {
        return new SyncCallable<Set<URI>>(this){

            @Override
            protected Set<URI> doCall() {
                SetMultimap resourceToAppliedProfiles = (SetMultimap)userModelToResourceToAppliedProfiles.get(userModelURI);
                return resourceToAppliedProfiles == null ? Collections.emptySet() : ImmutableSet.copyOf((Collection)resourceToAppliedProfiles.values());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<URI> getIntrinsicAppliedProfiles(URI umlResource) {
        IFile file;
        ImmutableSet result = Collections.emptySet();
        Object object = this.sync;
        synchronized (object) {
            SetMultimap<URI, URI> resourceToAppliedProfiles = this.userModelToResourceToAppliedProfiles.get(umlResource);
            if (resourceToAppliedProfiles != null && resourceToAppliedProfiles.containsKey((Object)umlResource)) {
                result = ImmutableSet.copyOf((Collection)resourceToAppliedProfiles.get((Object)umlResource));
            }
        }
        if (!result.isEmpty() && Activator.log.isTraceEnabled("index")) {
            Activator.log.trace("index", "Using last known intrinsically applied profiles for " + umlResource);
        }
        if (result.isEmpty() && umlResource.isPlatformResource() && (file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(umlResource.toPlatformString(true)))).isAccessible()) {
            this.indexUserModel(file);
            Object object2 = this.sync;
            synchronized (object2) {
                SetMultimap<URI, URI> resourceToAppliedProfiles = this.userModelToResourceToAppliedProfiles.get(umlResource);
                if (resourceToAppliedProfiles != null && resourceToAppliedProfiles.containsKey((Object)umlResource)) {
                    result = ImmutableSet.copyOf((Collection)resourceToAppliedProfiles.get((Object)umlResource));
                }
            }
            if (Activator.log.isTraceEnabled("index")) {
                Activator.log.trace("index", "Forced index of intrinsically applied profiles for " + umlResource);
            }
        }
        return result;
    }

    <V> ListenableFuture<V> afterIndex(Callable<V> callable) {
        return this.index.afterIndex(callable);
    }

    private void runIndexHandler(IFile file, URI resourceURI, DefaultHandler handler) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream input = file.getContents();){
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(true);
                SAXParser parser = factory.newSAXParser();
                parser.parse(input, handler, resourceURI.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private IndexedDecoratorModel indexDecoratorModel(IFile file) {
        URI decoratorURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        ProfileIndexHandler handler = new ProfileIndexHandler(decoratorURI);
        this.runIndexHandler(file, decoratorURI, handler);
        IndexedDecoratorModel result = new IndexedDecoratorModel(handler);
        this.indexDecoratorModel(file, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexDecoratorModel(IFile file, IndexedDecoratorModel index) {
        URI decoratorURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        Object object = this.sync;
        synchronized (object) {
            for (URI next : this.decoratorToModels.get((Object)decoratorURI)) {
                this.modelToDecorators.remove((Object)next, (Object)decoratorURI);
                SetMultimap<URI, URI> decoratorMap = this.userModelToResourceToAppliedProfiles.get(next);
                if (decoratorMap == null) continue;
                decoratorMap.removeAll((Object)decoratorURI);
            }
            this.decoratorToModels.replaceValues((Object)decoratorURI, index.getReferencedModelURIs());
            for (URI next : index.getReferencedModelURIs()) {
                this.modelToDecorators.put((Object)next, (Object)decoratorURI);
            }
            Map<URI, Map<URI, URI>> packageToProfileApplications = this.decoratorModelToPackageToProfileApplications.get(decoratorURI);
            if (packageToProfileApplications != null) {
                for (URI next : packageToProfileApplications.keySet()) {
                    this.packageToDecoratorModels.remove((Object)next, (Object)decoratorURI);
                }
            }
            for (URI next : index.getProfileApplicationsByPackage().keySet()) {
                this.packageToDecoratorModels.put((Object)next, (Object)decoratorURI);
            }
            this.decoratorModelToPackageToProfileApplications.put(decoratorURI, index.getProfileApplicationsByPackage());
            this.decoratorModelNames.put(decoratorURI, index.getExternalizationName());
            HashSet userModelsProcessed = Sets.newHashSet();
            for (Map.Entry<URI, Map<URI, URI>> next : index.getProfileApplicationsByPackage().entrySet()) {
                URI userModelURI = next.getKey().trimFragment();
                if (!userModelsProcessed.add(userModelURI)) continue;
                HashMultimap resourceToAppliedProfiles = this.userModelToResourceToAppliedProfiles.get(userModelURI);
                if (resourceToAppliedProfiles == null) {
                    resourceToAppliedProfiles = HashMultimap.create();
                    this.userModelToResourceToAppliedProfiles.put(userModelURI, (SetMultimap<URI, URI>)resourceToAppliedProfiles);
                }
                for (URI profileURI : next.getValue().keySet()) {
                    resourceToAppliedProfiles.put((Object)decoratorURI, (Object)profileURI);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unindexDecoratorModel(IFile file) {
        URI decoratorURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        Object object = this.sync;
        synchronized (object) {
            for (URI next : this.decoratorToModels.get((Object)decoratorURI)) {
                this.modelToDecorators.remove((Object)next, (Object)decoratorURI);
                SetMultimap<URI, URI> resourceToAppliedProfiles = this.userModelToResourceToAppliedProfiles.get(next);
                if (resourceToAppliedProfiles == null) continue;
                resourceToAppliedProfiles.removeAll((Object)decoratorURI);
            }
            this.decoratorToModels.removeAll((Object)decoratorURI);
            Map<URI, Map<URI, URI>> packageToProfileApplications = this.decoratorModelToPackageToProfileApplications.get(decoratorURI);
            if (packageToProfileApplications != null) {
                for (URI next : packageToProfileApplications.keySet()) {
                    this.packageToDecoratorModels.get((Object)next).remove(decoratorURI);
                }
            }
            this.decoratorModelToPackageToProfileApplications.remove(decoratorURI);
            this.decoratorModelNames.remove(decoratorURI);
        }
    }

    private IndexedUserModel indexUserModel(IFile file) {
        URI userModelURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        ModelIndexHandler handler = new ModelIndexHandler(userModelURI);
        this.runIndexHandler(file, userModelURI, handler);
        IndexedUserModel result = new IndexedUserModel(handler);
        this.indexUserModel(file, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexUserModel(IFile file, IndexedUserModel index) {
        URI userModelURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        Object object = this.sync;
        synchronized (object) {
            HashMultimap resourceToAppliedProfiles = this.userModelToResourceToAppliedProfiles.get(userModelURI);
            if (resourceToAppliedProfiles != null) {
                resourceToAppliedProfiles.removeAll((Object)userModelURI);
            }
            for (Map<URI, URI> next : index.getProfileApplicationsByPackage().values()) {
                if (resourceToAppliedProfiles == null) {
                    resourceToAppliedProfiles = HashMultimap.create();
                    this.userModelToResourceToAppliedProfiles.put(userModelURI, (SetMultimap<URI, URI>)resourceToAppliedProfiles);
                }
                resourceToAppliedProfiles.putAll((Object)userModelURI, next.keySet());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unindexUserModel(IFile file) {
        URI userModelURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        Object object = this.sync;
        synchronized (object) {
            SetMultimap<URI, URI> resourceToAppliedProfiles = this.userModelToResourceToAppliedProfiles.get(userModelURI);
            if (resourceToAppliedProfiles != null) {
                resourceToAppliedProfiles.removeAll((Object)userModelURI);
            }
        }
    }

    private WorkspaceModelIndex.PersistentIndexHandler<IndexedFile<?>> indexer() {
        return new WorkspaceModelIndex.PersistentIndexHandler<IndexedFile<?>>(){

            public IndexedFile<?> index(IFile file) {
                IndexedFile result = DecoratorModelUtils.isDecoratorModel(file) ? DecoratorModelIndex.this.indexDecoratorModel(file) : DecoratorModelIndex.this.indexUserModel(file);
                return result;
            }

            public void unindex(IFile file) {
                DecoratorModelIndex.this.unindexDecoratorModel(file);
                DecoratorModelIndex.this.unindexUserModel(file);
            }

            public boolean load(IFile file, IndexedFile<?> index) {
                boolean result = true;
                if (index instanceof IndexedDecoratorModel) {
                    DecoratorModelIndex.this.indexDecoratorModel(file, (IndexedDecoratorModel)index);
                } else if (index instanceof IndexedUserModel) {
                    DecoratorModelIndex.this.indexUserModel(file, (IndexedUserModel)index);
                } else {
                    result = false;
                }
                return result;
            }
        };
    }

    public void addIndexListener(IDecoratorModelIndexListener listener) {
        this.listeners.addIfAbsent(listener);
    }

    public void removeIndexListener(IDecoratorModelIndexListener listener) {
        this.listeners.remove(listener);
    }

    protected final void notifyChanged() {
        if (!this.listeners.isEmpty()) {
            DecoratorModelIndexEvent event = new DecoratorModelIndexEvent(this, 0);
            for (IDecoratorModelIndexListener next : this.listeners) {
                try {
                    next.indexChanged(event);
                }
                catch (Exception e) {
                    Activator.log.error("Uncaught exception in decorator model index listener.", (Throwable)e);
                }
            }
        }
    }

    public static final class IndexProvider
    implements IWorkspaceModelIndexProvider {
        public WorkspaceModelIndex<?> get() {
            return INSTANCE.index;
        }
    }

    static final class IndexedDecoratorModel
    extends IndexedFile<ProfileIndexHandler> {
        private static final long serialVersionUID = 1L;
        private String externalizationName;
        private Set<String> referencedModels;
        private transient Set<URI> referencedModelURIs;

        IndexedDecoratorModel(ProfileIndexHandler handler) {
            super(handler);
            this.externalizationName = handler.getExternalizationName();
            this.referencedModels = handler.getReferencedModelURIs();
        }

        String getExternalizationName() {
            return this.externalizationName;
        }

        Set<URI> getReferencedModelURIs() {
            if (this.referencedModelURIs == null) {
                this.referencedModelURIs = this.setToURIs(this.referencedModels);
            }
            return this.referencedModelURIs;
        }
    }

    static abstract class IndexedFile<H extends AbstractUMLIndexHandler>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Map<String, Map<String, String>> profileApplicationByPackage;
        private transient Map<URI, Map<URI, URI>> profileApplicationByPackageURI;

        IndexedFile(H handler) {
            this.profileApplicationByPackage = ((AbstractUMLIndexHandler)handler).getProfileApplicationsByPackage();
        }

        Map<URI, Map<URI, URI>> getProfileApplicationsByPackage() {
            if (this.profileApplicationByPackageURI == null) {
                this.profileApplicationByPackageURI = this.mapOfMapsToURIs(this.profileApplicationByPackage);
            }
            return this.profileApplicationByPackageURI;
        }

        final Set<URI> setToURIs(Set<String> uris) {
            return uris.stream().map(URI::createURI).collect(Collectors.toSet());
        }

        final Map<URI, Map<URI, URI>> mapOfMapsToURIs(Map<String, Map<String, String>> uris) {
            HashMap result = Maps.newHashMap();
            uris.forEach((uri, map2) -> {
                HashMap uriMap = Maps.newHashMap();
                map2.forEach((a, b) -> {
                    URI uRI = uriMap.put(URI.createURI((String)a), URI.createURI((String)b));
                });
                result.put(URI.createURI((String)uri), uriMap);
            });
            return result;
        }
    }

    static final class IndexedUserModel
    extends IndexedFile<ModelIndexHandler> {
        private static final long serialVersionUID = 1L;

        IndexedUserModel(ModelIndexHandler handler) {
            super(handler);
        }
    }

    abstract class SyncCallable<V>
    implements Callable<V> {
        SyncCallable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final V call() throws Exception {
            Object object = DecoratorModelIndex.this.sync;
            synchronized (object) {
                return this.doCall();
            }
        }

        protected abstract V doCall();
    }
}

