/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.infra.svnkit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class MainClass {
    private static final int EXCEPTION = 3;
    private static final int URL_NOT_FILE = 2;
    private static final int INCORRECT_URL = 1;
    private static final int NO_ERROR = 0;
    private static final String SVNInfo_REPOSITORY_TYPE = "OPENCERT_SVN_REPOSITORY_TYPE";
    private static final String SVNInfo_LOCAL_REPOSITORY_URL = "OPENCERT_SVN_LOCAL_REPOSITORY_URL";
    private static final String SVNInfo_REMOTE_REPOSITORY_URL = "OPENCERT_SVN_REMOTE_REPOSITORY_URL";
    private static final String SVNInfo_USER = "OPENCERT_SVN_USER";
    private static final String SVNInfo_PASS = "OPENCERT_SVN_PASS";
    private SVNRepository repository = null;

    public void deleteFile(String filePath) {
        try {
            ISVNEditor editor = this.repository.getCommitEditor("Delete file", null);
            editor.openRoot(-1L);
            editor.deleteEntry(filePath, -1L);
            editor.closeEdit();
        }
        catch (SVNException e) {
            e.printStackTrace();
        }
    }

    public int connectRepository(String urlCon, String name, String password) {
        this.setupLibrary();
        try {
            this.repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)urlCon));
        }
        catch (SVNException svne) {
            System.err.println("error while creating an SVNRepository for location '" + urlCon + "': " + svne.getMessage());
            return 3;
        }
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)name, (String)password);
        this.repository.setAuthenticationManager(authManager);
        return 0;
    }

    public int checkPath(String urlCon) {
        SVNNodeKind nodeKind;
        block4: {
            try {
                nodeKind = this.repository.checkPath("", -1L);
                if (nodeKind != SVNNodeKind.NONE) break block4;
                System.err.println("There is no entry at '" + urlCon + "'.");
                return 1;
            }
            catch (SVNException sVNException) {
                return 3;
            }
        }
        if (nodeKind == SVNNodeKind.FILE) {
            System.err.println("The entry at '" + urlCon + "' is a file while a directory was expected.");
            return 2;
        }
        return 0;
    }

    public boolean existsFileRepo(String localPath) {
        if (this.repository == null) {
            return false;
        }
        try {
            SVNNodeKind nodeKind = this.repository.checkPath(localPath, -1L);
            return nodeKind == SVNNodeKind.FILE;
        }
        catch (SVNException sVNException) {
            return true;
        }
    }

    public boolean existsFolderRepo(String localPath) {
        try {
            SVNNodeKind nodeKind = this.repository.checkPath(localPath, -1L);
            return nodeKind == SVNNodeKind.DIR;
        }
        catch (SVNException sVNException) {
            return true;
        }
    }

    public ArrayList<String> getFileHistory(String filePath) {
        ArrayList<String> entriesList = new ArrayList<String>();
        try {
            if (this.existsFileRepo(filePath)) {
                Collection logEntries = this.repository.log(new String[]{filePath}, null, 0L, -1L, true, true);
                for (SVNLogEntry logEntry : logEntries) {
                    SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                    String historyRev = String.valueOf(logEntry.getRevision()) + "#" + df.format(logEntry.getDate()) + "#" + logEntry.getAuthor() + "#" + logEntry.getMessage();
                    entriesList.add(historyRev);
                }
            }
        }
        catch (SVNException e) {
            e.printStackTrace();
        }
        return entriesList;
    }

    public String getFileFromRepo(String filePath) {
        try {
            if (this.existsFileRepo(filePath)) {
                SVNProperties fileProperties = new SVNProperties();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.repository.getFile(filePath, -1L, fileProperties, (OutputStream)baos);
                String tempDir = System.getProperty("java.io.tmpdir");
                String filename = filePath.substring(filePath.lastIndexOf("/") + 1);
                String fullPath = String.valueOf(tempDir) + filename;
                FileOutputStream outputStream = new FileOutputStream(fullPath);
                baos.writeTo(outputStream);
                baos.flush();
                ((OutputStream)outputStream).close();
                return fullPath;
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public String copyFileFromRepo(String sourceURI, String targetFolderURI, String comment) {
        String tempFile = this.getFileFromRepo(sourceURI);
        if (tempFile.equals("exists")) {
            return tempFile;
        }
        String finalLocation = this.addFileToRepo(tempFile, targetFolderURI, comment);
        return finalLocation;
    }

    public String updateFileFromRepo(String sourceURI, String targetFolderURI, String comment) {
        String tempFile = this.getFileFromRepo(sourceURI);
        if (tempFile.equals("exists")) {
            return tempFile;
        }
        String finalLocation = this.changeRepoFile(tempFile, targetFolderURI, comment);
        return finalLocation;
    }

    public String changeRepoFile(String localPath, String destinationDir, String comment) {
        ISVNEditor editor = null;
        try {
            editor = this.repository.getCommitEditor(comment, null);
            File file = new File(localPath);
            byte[] contentsNew = new byte[(int)file.length()];
            DataInputStream dis = new DataInputStream(new FileInputStream(file));
            dis.readFully(contentsNew);
            dis.close();
            String remotePath = String.valueOf(destinationDir) + "/" + file.getName();
            editor.openRoot(-1L);
            editor.openFile(remotePath, -1L);
            editor.applyTextDelta(remotePath, null);
            SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
            String checksum = deltaGenerator.sendDelta(remotePath, (InputStream)new ByteArrayInputStream(new byte[0]), 0L, (InputStream)new ByteArrayInputStream(contentsNew), (ISVNDeltaConsumer)editor, true);
            editor.closeFile(remotePath, checksum);
            editor.closeDir();
            editor.closeEdit();
            return remotePath;
        }
        catch (Exception svne) {
            svne.printStackTrace();
            try {
                editor.abortEdit();
            }
            catch (SVNException e) {
                e.printStackTrace();
            }
            return "An error has occurred updating the file to the Repository";
        }
    }

    public String addFolderToRepo(String destinationDir, String newFolderName, String comment) {
        ISVNEditor editor;
        block6: {
            editor = null;
            try {
                if (!this.existsFolderRepo(String.valueOf(destinationDir) + "/" + newFolderName)) break block6;
                return "exists";
            }
            catch (Exception svne) {
                svne.printStackTrace();
                try {
                    editor.abortEdit();
                }
                catch (SVNException e) {
                    e.printStackTrace();
                }
                return "An error has occurred adding the folder to the Repository";
            }
        }
        editor = this.repository.getCommitEditor(comment, null);
        editor.openRoot(-1L);
        editor.openDir(destinationDir, -1L);
        editor.addDir(newFolderName, null, -1L);
        editor.closeDir();
        editor.closeEdit();
        String returnString = String.valueOf(destinationDir) + "/" + newFolderName;
        if (returnString.startsWith("/")) {
            returnString = returnString.substring(1);
        }
        return returnString;
    }

    public String addFileToRepo(String localPath, String destinationDir, String comment) {
        String remotePath;
        File file;
        ISVNEditor editor;
        block5: {
            editor = null;
            try {
                file = new File(localPath);
                remotePath = file.getName();
                if (!this.existsFileRepo(String.valueOf(destinationDir) + "/" + remotePath)) break block5;
                return "exists";
            }
            catch (Exception svne) {
                svne.printStackTrace();
                try {
                    editor.abortEdit();
                }
                catch (SVNException e) {
                    e.printStackTrace();
                }
                return "An error has occurred adding the file to the Repository";
            }
        }
        editor = this.repository.getCommitEditor(comment, null);
        byte[] fileData = new byte[(int)file.length()];
        DataInputStream dis = new DataInputStream(new FileInputStream(file));
        dis.readFully(fileData);
        dis.close();
        editor.openRoot(-1L);
        editor.openDir(destinationDir, -1L);
        editor.addFile(remotePath, null, -1L);
        editor.applyTextDelta(remotePath, null);
        SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
        String checksum = deltaGenerator.sendDelta(remotePath, (InputStream)new ByteArrayInputStream(fileData), (ISVNDeltaConsumer)editor, true);
        editor.closeFile(remotePath, checksum);
        editor.closeDir();
        editor.closeEdit();
        return String.valueOf(destinationDir) + "/" + remotePath;
    }

    public ArrayList<SVNDirEntry> listEntries(String path, boolean onlyFolders) {
        ArrayList<SVNDirEntry> entriesList = new ArrayList<SVNDirEntry>();
        if (this.repository == null) {
            return entriesList;
        }
        try {
            Collection entries = this.repository.getDir(path, -1L, null, null);
            for (SVNDirEntry entry : entries) {
                if (entry.getKind() == SVNNodeKind.DIR) {
                    entriesList.add(entry);
                    continue;
                }
                if (onlyFolders) continue;
                entriesList.add(entry);
            }
        }
        catch (SVNException e) {
            e.printStackTrace();
        }
        return entriesList;
    }

    private void setupLibrary() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }
}

