/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.pkm.refframework.refframework.diagram.part;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.opencert.pkm.refframework.refframework.diagram.part.Messages;
import org.eclipse.opencert.pkm.refframework.refframework.diagram.part.RefframeworkCreationWizardPage;
import org.eclipse.opencert.pkm.refframework.refframework.diagram.part.RefframeworkDiagramEditorPlugin;
import org.eclipse.opencert.pkm.refframework.refframework.diagram.part.RefframeworkDiagramEditorUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class RefframeworkCreationWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    protected RefframeworkCreationWizardPage diagramModelFilePage;
    protected RefframeworkCreationWizardPage domainModelFilePage;
    protected Resource diagram;
    private boolean openNewlyCreatedDiagramEditor = true;

    public IWorkbench getWorkbench() {
        return this.workbench;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public final Resource getDiagram() {
        return this.diagram;
    }

    public final boolean isOpenNewlyCreatedDiagramEditor() {
        return this.openNewlyCreatedDiagramEditor;
    }

    public void setOpenNewlyCreatedDiagramEditor(boolean openNewlyCreatedDiagramEditor) {
        this.openNewlyCreatedDiagramEditor = openNewlyCreatedDiagramEditor;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(Messages.RefframeworkCreationWizardTitle);
        this.setDefaultPageImageDescriptor(RefframeworkDiagramEditorPlugin.getBundledImageDescriptor("icons/wizban/NewRefframeworkWizard.gif"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.diagramModelFilePage = new RefframeworkCreationWizardPage("DiagramModelFile", this.getSelection(), "refframework_diagram");
        this.diagramModelFilePage.setTitle(Messages.RefframeworkCreationWizard_DiagramModelFilePageTitle);
        this.diagramModelFilePage.setDescription(Messages.RefframeworkCreationWizard_DiagramModelFilePageDescription);
        this.addPage((IWizardPage)this.diagramModelFilePage);
        this.domainModelFilePage = new RefframeworkCreationWizardPage("DomainModelFile", this.getSelection(), "refframework"){

            public void setVisible(boolean visible) {
                if (visible) {
                    String fileName = RefframeworkCreationWizard.this.diagramModelFilePage.getFileName();
                    fileName = fileName.substring(0, fileName.length() - ".refframework_diagram".length());
                    this.setFileName(RefframeworkDiagramEditorUtil.getUniqueFileName(this.getContainerFullPath(), fileName, "refframework"));
                }
                super.setVisible(visible);
            }
        };
        this.domainModelFilePage.setTitle(Messages.RefframeworkCreationWizard_DomainModelFilePageTitle);
        this.domainModelFilePage.setDescription(Messages.RefframeworkCreationWizard_DomainModelFilePageDescription);
        this.addPage((IWizardPage)this.domainModelFilePage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                RefframeworkCreationWizard.this.diagram = RefframeworkDiagramEditorUtil.createDiagram(RefframeworkCreationWizard.this.diagramModelFilePage.getURI(), RefframeworkCreationWizard.this.domainModelFilePage.getURI(), monitor);
                if (RefframeworkCreationWizard.this.isOpenNewlyCreatedDiagramEditor() && RefframeworkCreationWizard.this.diagram != null) {
                    try {
                        RefframeworkDiagramEditorUtil.openDiagram(RefframeworkCreationWizard.this.diagram);
                    }
                    catch (PartInitException e) {
                        ErrorDialog.openError((Shell)RefframeworkCreationWizard.this.getContainer().getShell(), (String)Messages.RefframeworkCreationWizardOpenEditorError, null, (IStatus)e.getStatus());
                    }
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.RefframeworkCreationWizardCreationError, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                RefframeworkDiagramEditorPlugin.getInstance().logError("Error creating diagram", e.getTargetException());
            }
            return false;
        }
        return this.diagram != null;
    }
}

