/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.sam.arg.arg.diagram.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.structure.DiagramStructure;
import org.eclipse.opencert.sam.arg.arg.ArgPackage;
import org.eclipse.opencert.sam.arg.arg.Case;
import org.eclipse.opencert.sam.arg.arg.diagram.part.ArgDiagramEditorPlugin;

public class ArgVisualIDRegistry {
    private static final String DEBUG_KEY = "org.eclipse.opencert.sam.arg.diagram/debug/visualID";
    public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure(){

        public int getVisualID(View view) {
            return ArgVisualIDRegistry.getVisualID(view);
        }

        public String getModelID(View view) {
            return ArgVisualIDRegistry.getModelID(view);
        }

        public int getNodeVisualID(View containerView, EObject domainElement) {
            return ArgVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
            return ArgVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(int visualID) {
            return ArgVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(int visualID) {
            return ArgVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }
    };

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("Arg".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return ArgVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                ArgDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (ArgPackage.eINSTANCE.getCase().isSuperTypeOf(domainElement.eClass()) && ArgVisualIDRegistry.isDiagram((Case)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = ArgVisualIDRegistry.getModelID(containerView);
        if (!"Arg".equals(containerModelID) && !"arg".equals(containerModelID)) {
            return -1;
        }
        if ("Arg".equals(containerModelID)) {
            containerVisualID = ArgVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (ArgPackage.eINSTANCE.getClaim().isSuperTypeOf(domainElement.eClass())) {
                    return 2001;
                }
                if (ArgPackage.eINSTANCE.getAgreement().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (ArgPackage.eINSTANCE.getArgumentReasoning().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (ArgPackage.eINSTANCE.getArgumentation().isSuperTypeOf(domainElement.eClass())) {
                    return 2004;
                }
                if (ArgPackage.eINSTANCE.getInformationElementCitation().isSuperTypeOf(domainElement.eClass())) {
                    return 2005;
                }
                if (ArgPackage.eINSTANCE.getArgumentElementCitation().isSuperTypeOf(domainElement.eClass())) {
                    return 2006;
                }
                if (!ArgPackage.eINSTANCE.getChoice().isSuperTypeOf(domainElement.eClass())) break;
                return 2007;
            }
            case 2001: {
                if (!ArgPackage.eINSTANCE.getChoice().isSuperTypeOf(domainElement.eClass())) break;
                return 3001;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = ArgVisualIDRegistry.getModelID(containerView);
        if (!"Arg".equals(containerModelID) && !"arg".equals(containerModelID)) {
            return false;
        }
        if ("Arg".equals(containerModelID)) {
            containerVisualID = ArgVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2002 == nodeVisualID) {
                    return true;
                }
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (2004 == nodeVisualID) {
                    return true;
                }
                if (2005 == nodeVisualID) {
                    return true;
                }
                if (2006 == nodeVisualID) {
                    return true;
                }
                if (2007 != nodeVisualID) break;
                return true;
            }
            case 2001: {
                if (5003 == nodeVisualID) {
                    return true;
                }
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (3001 != nodeVisualID) break;
                return true;
            }
            case 2002: {
                if (5005 == nodeVisualID) {
                    return true;
                }
                if (5006 != nodeVisualID) break;
                return true;
            }
            case 2003: {
                if (5007 == nodeVisualID) {
                    return true;
                }
                if (5008 != nodeVisualID) break;
                return true;
            }
            case 2004: {
                if (5009 == nodeVisualID) {
                    return true;
                }
                if (5010 != nodeVisualID) break;
                return true;
            }
            case 2005: {
                if (5011 == nodeVisualID) {
                    return true;
                }
                if (5012 != nodeVisualID) break;
                return true;
            }
            case 2006: {
                if (5013 == nodeVisualID) {
                    return true;
                }
                if (5014 == nodeVisualID) {
                    return true;
                }
                if (5015 != nodeVisualID) break;
                return true;
            }
            case 2007: {
                if (5016 == nodeVisualID) {
                    return true;
                }
                if (5017 != nodeVisualID) break;
                return true;
            }
            case 3001: {
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (5002 != nodeVisualID) break;
                return true;
            }
            case 4001: {
                if (6001 != nodeVisualID) break;
                return true;
            }
            case 4002: {
                if (6002 != nodeVisualID) break;
                return true;
            }
            case 4003: {
                if (6003 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (ArgPackage.eINSTANCE.getAssertedInference().isSuperTypeOf(domainElement.eClass())) {
            return 4001;
        }
        if (ArgPackage.eINSTANCE.getAssertedEvidence().isSuperTypeOf(domainElement.eClass())) {
            return 4002;
        }
        if (ArgPackage.eINSTANCE.getAssertedContext().isSuperTypeOf(domainElement.eClass())) {
            return 4003;
        }
        if (ArgPackage.eINSTANCE.getAssertedChallenge().isSuperTypeOf(domainElement.eClass())) {
            return 4004;
        }
        if (ArgPackage.eINSTANCE.getAssertedCounterEvidence().isSuperTypeOf(domainElement.eClass())) {
            return 4005;
        }
        return -1;
    }

    private static boolean isDiagram(Case element) {
        return true;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = ArgVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate;
    }

    public static boolean isCompartmentVisualID(int visualID) {
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 1000: {
                return false;
            }
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: 
            case 2007: 
            case 3001: {
                return true;
            }
        }
        return false;
    }
}

