/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.emf.providers;

import com.google.common.collect.MapMaker;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.papyrus.infra.ui.emf.providers.StandardEMFLabelProvider;

public class ForwardingEMFLabelProvider
extends StandardEMFLabelProvider {
    private final ConcurrentMap<IChangeNotifier, INotifyChangedListener> forwards = new MapMaker().weakKeys().weakValues().makeMap();
    private INotifyChangedListener forwardingListener;

    public ForwardingEMFLabelProvider() {
        this.labelProviderListeners = new CopyOnWriteArrayList(this.labelProviderListeners);
        this.setFireLabelUpdateNotifications(true);
    }

    public void dispose() {
        try {
            for (Map.Entry next : this.forwards.entrySet()) {
                ((IChangeNotifier)next.getKey()).removeListener((INotifyChangedListener)next.getValue());
            }
            this.forwards.clear();
        }
        finally {
            super.dispose();
        }
    }

    @Override
    IItemLabelProvider adapt(AdapterFactory adapterFactory, EObject object) {
        IChangeNotifier notifier;
        IItemLabelProvider result = super.adapt(adapterFactory, object);
        if (result instanceof IChangeNotifier && this.forwards.putIfAbsent(notifier = (IChangeNotifier)result, this.getForwardingListener()) == null) {
            notifier.addListener(this.getForwardingListener());
        }
        return result;
    }

    private INotifyChangedListener getForwardingListener() {
        if (this.forwardingListener == null) {
            this.forwardingListener = notification -> this.notifyChanged(notification);
        }
        return this.forwardingListener;
    }
}

