/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.infra.mappings.mapping.components;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.eef.runtime.api.component.IPropertiesEditionComponent;
import org.eclipse.emf.eef.runtime.api.notify.EStructuralFeatureNotificationFilter;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionEvent;
import org.eclipse.emf.eef.runtime.api.notify.NotificationFilter;
import org.eclipse.emf.eef.runtime.context.PropertiesEditingContext;
import org.eclipse.emf.eef.runtime.context.impl.EObjectPropertiesEditionContext;
import org.eclipse.emf.eef.runtime.context.impl.EReferencePropertiesEditionContext;
import org.eclipse.emf.eef.runtime.impl.components.SinglePartPropertiesEditingComponent;
import org.eclipse.emf.eef.runtime.impl.utils.EEFConverterUtil;
import org.eclipse.emf.eef.runtime.policies.PropertiesEditingPolicy;
import org.eclipse.emf.eef.runtime.policies.impl.CreateEditingPolicy;
import org.eclipse.emf.eef.runtime.providers.PropertiesEditingProvider;
import org.eclipse.emf.eef.runtime.ui.widgets.referencestable.ReferencesTableSettings;
import org.eclipse.emf.eef.runtime.ui.widgets.settings.EEFEditorSettings;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.opencert.infra.general.general.GeneralPackage;
import org.eclipse.opencert.infra.mappings.mapping.Map;
import org.eclipse.opencert.infra.mappings.mapping.MapGroup;
import org.eclipse.opencert.infra.mappings.mapping.MapModel;
import org.eclipse.opencert.infra.mappings.mapping.MappingPackage;
import org.eclipse.opencert.infra.mappings.mapping.parts.MapModelPropertiesEditionPart;
import org.eclipse.opencert.infra.mappings.mapping.parts.MappingViewsRepository;

public class MapModelPropertiesEditionComponent
extends SinglePartPropertiesEditingComponent {
    public static String BASE_PART = "Base";
    protected ReferencesTableSettings mapGroupModelSettings;
    protected ReferencesTableSettings mapModelSettings;

    public MapModelPropertiesEditionComponent(PropertiesEditingContext editingContext, EObject mapModel, String editing_mode) {
        super(editingContext, mapModel, editing_mode);
        this.parts = new String[]{BASE_PART};
        this.repositoryKey = MappingViewsRepository.class;
        this.partKey = MappingViewsRepository.MapModel.class;
    }

    public void initPart(Object key, int kind, EObject elt, ResourceSet allResource) {
        this.setInitializing(true);
        if (this.editingPart != null && key == this.partKey) {
            this.editingPart.setContext(elt, allResource);
            MapModel mapModel = (MapModel)elt;
            MapModelPropertiesEditionPart basePart = (MapModelPropertiesEditionPart)this.editingPart;
            if (this.isAccessible(MappingViewsRepository.MapModel.Properties.id)) {
                basePart.setId(EEFConverterUtil.convertToString((EDataType)EcorePackage.Literals.ESTRING, (Object)mapModel.getId()));
            }
            if (this.isAccessible(MappingViewsRepository.MapModel.Properties.name)) {
                basePart.setName(EEFConverterUtil.convertToString((EDataType)EcorePackage.Literals.ESTRING, (Object)mapModel.getName()));
            }
            if (this.isAccessible(MappingViewsRepository.MapModel.Properties.description)) {
                basePart.setDescription(EEFConverterUtil.convertToString((EDataType)EcorePackage.Literals.ESTRING, (Object)mapModel.getDescription()));
            }
            if (this.isAccessible(MappingViewsRepository.MapModel.Properties.mapGroupModel)) {
                this.mapGroupModelSettings = new ReferencesTableSettings((EObject)mapModel, new EReference[]{MappingPackage.eINSTANCE.getMapModel_MapGroupModel()});
                basePart.initMapGroupModel(this.mapGroupModelSettings);
            }
            if (this.isAccessible(MappingViewsRepository.MapModel.Properties.mapModel_)) {
                this.mapModelSettings = new ReferencesTableSettings((EObject)mapModel, new EReference[]{MappingPackage.eINSTANCE.getMapModel_MapModel()});
                basePart.initMapModel(this.mapModelSettings);
            }
            if (this.isAccessible(MappingViewsRepository.MapModel.Properties.mapGroupModel)) {
                basePart.addFilterToMapGroupModel(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        return element instanceof String && element.equals("") || element instanceof MapGroup;
                    }
                });
            }
            if (this.isAccessible(MappingViewsRepository.MapModel.Properties.mapModel_)) {
                basePart.addFilterToMapModel(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        return element instanceof String && element.equals("") || element instanceof Map;
                    }
                });
            }
        }
        this.setInitializing(false);
    }

    public EStructuralFeature associatedFeature(Object editorKey) {
        if (editorKey == MappingViewsRepository.MapModel.Properties.id) {
            return GeneralPackage.eINSTANCE.getNamedElement_Id();
        }
        if (editorKey == MappingViewsRepository.MapModel.Properties.name) {
            return GeneralPackage.eINSTANCE.getNamedElement_Name();
        }
        if (editorKey == MappingViewsRepository.MapModel.Properties.description) {
            return GeneralPackage.eINSTANCE.getDescribableElement_Description();
        }
        if (editorKey == MappingViewsRepository.MapModel.Properties.mapGroupModel) {
            return MappingPackage.eINSTANCE.getMapModel_MapGroupModel();
        }
        if (editorKey == MappingViewsRepository.MapModel.Properties.mapModel_) {
            return MappingPackage.eINSTANCE.getMapModel_MapModel();
        }
        return super.associatedFeature(editorKey);
    }

    public void updateSemanticModel(IPropertiesEditionEvent event) {
        PropertiesEditingPolicy editionPolicy;
        PropertiesEditingPolicy policy;
        PropertiesEditingProvider provider;
        EReferencePropertiesEditionContext context;
        MapModel mapModel = (MapModel)this.semanticObject;
        if (MappingViewsRepository.MapModel.Properties.id == event.getAffectedEditor()) {
            mapModel.setId((String)EEFConverterUtil.createFromString((EDataType)EcorePackage.Literals.ESTRING, (String)((String)event.getNewValue())));
        }
        if (MappingViewsRepository.MapModel.Properties.name == event.getAffectedEditor()) {
            mapModel.setName((String)EEFConverterUtil.createFromString((EDataType)EcorePackage.Literals.ESTRING, (String)((String)event.getNewValue())));
        }
        if (MappingViewsRepository.MapModel.Properties.description == event.getAffectedEditor()) {
            mapModel.setDescription((String)EEFConverterUtil.createFromString((EDataType)EcorePackage.Literals.ESTRING, (String)((String)event.getNewValue())));
        }
        if (MappingViewsRepository.MapModel.Properties.mapGroupModel == event.getAffectedEditor()) {
            if (event.getKind() == 3) {
                context = new EReferencePropertiesEditionContext(this.editingContext, (IPropertiesEditionComponent)this, (EEFEditorSettings)this.mapGroupModelSettings, this.editingContext.getAdapterFactory());
                provider = (PropertiesEditingProvider)this.editingContext.getAdapterFactory().adapt((Notifier)this.semanticObject, PropertiesEditingProvider.class);
                if (provider != null && (policy = provider.getPolicy((PropertiesEditingContext)context)) instanceof CreateEditingPolicy) {
                    policy.execute();
                }
            } else if (event.getKind() == 9) {
                context = new EObjectPropertiesEditionContext(this.editingContext, (IPropertiesEditionComponent)this, (EObject)event.getNewValue(), this.editingContext.getAdapterFactory());
                provider = (PropertiesEditingProvider)this.editingContext.getAdapterFactory().adapt((Notifier)((EObject)event.getNewValue()), PropertiesEditingProvider.class);
                if (provider != null && (editionPolicy = provider.getPolicy((PropertiesEditingContext)context)) != null) {
                    editionPolicy.execute();
                }
            } else if (event.getKind() == 4) {
                this.mapGroupModelSettings.removeFromReference((EObject)event.getNewValue());
            } else if (event.getKind() == 7) {
                this.mapGroupModelSettings.move(event.getNewIndex(), (EObject)((MapGroup)event.getNewValue()));
            }
        }
        if (MappingViewsRepository.MapModel.Properties.mapModel_ == event.getAffectedEditor()) {
            if (event.getKind() == 3) {
                context = new EReferencePropertiesEditionContext(this.editingContext, (IPropertiesEditionComponent)this, (EEFEditorSettings)this.mapModelSettings, this.editingContext.getAdapterFactory());
                provider = (PropertiesEditingProvider)this.editingContext.getAdapterFactory().adapt((Notifier)this.semanticObject, PropertiesEditingProvider.class);
                if (provider != null && (policy = provider.getPolicy((PropertiesEditingContext)context)) instanceof CreateEditingPolicy) {
                    policy.execute();
                }
            } else if (event.getKind() == 9) {
                context = new EObjectPropertiesEditionContext(this.editingContext, (IPropertiesEditionComponent)this, (EObject)event.getNewValue(), this.editingContext.getAdapterFactory());
                provider = (PropertiesEditingProvider)this.editingContext.getAdapterFactory().adapt((Notifier)((EObject)event.getNewValue()), PropertiesEditingProvider.class);
                if (provider != null && (editionPolicy = provider.getPolicy((PropertiesEditingContext)context)) != null) {
                    editionPolicy.execute();
                }
            } else if (event.getKind() == 4) {
                this.mapModelSettings.removeFromReference((EObject)event.getNewValue());
            } else if (event.getKind() == 7) {
                this.mapModelSettings.move(event.getNewIndex(), (EObject)((Map)event.getNewValue()));
            }
        }
    }

    public void updatePart(Notification msg) {
        super.updatePart(msg);
        if (this.editingPart.isVisible()) {
            MapModelPropertiesEditionPart basePart = (MapModelPropertiesEditionPart)this.editingPart;
            if (GeneralPackage.eINSTANCE.getNamedElement_Id().equals(msg.getFeature()) && msg.getNotifier().equals(this.semanticObject) && basePart != null && this.isAccessible(MappingViewsRepository.MapModel.Properties.id)) {
                if (msg.getNewValue() != null) {
                    basePart.setId(EcoreUtil.convertToString((EDataType)EcorePackage.Literals.ESTRING, (Object)msg.getNewValue()));
                } else {
                    basePart.setId("");
                }
            }
            if (GeneralPackage.eINSTANCE.getNamedElement_Name().equals(msg.getFeature()) && msg.getNotifier().equals(this.semanticObject) && basePart != null && this.isAccessible(MappingViewsRepository.MapModel.Properties.name)) {
                if (msg.getNewValue() != null) {
                    basePart.setName(EcoreUtil.convertToString((EDataType)EcorePackage.Literals.ESTRING, (Object)msg.getNewValue()));
                } else {
                    basePart.setName("");
                }
            }
            if (GeneralPackage.eINSTANCE.getDescribableElement_Description().equals(msg.getFeature()) && msg.getNotifier().equals(this.semanticObject) && basePart != null && this.isAccessible(MappingViewsRepository.MapModel.Properties.description)) {
                if (msg.getNewValue() != null) {
                    basePart.setDescription(EcoreUtil.convertToString((EDataType)EcorePackage.Literals.ESTRING, (Object)msg.getNewValue()));
                } else {
                    basePart.setDescription("");
                }
            }
            if (MappingPackage.eINSTANCE.getMapModel_MapGroupModel().equals(msg.getFeature()) && this.isAccessible(MappingViewsRepository.MapModel.Properties.mapGroupModel)) {
                basePart.updateMapGroupModel();
            }
            if (MappingPackage.eINSTANCE.getMapModel_MapModel().equals(msg.getFeature()) && this.isAccessible(MappingViewsRepository.MapModel.Properties.mapModel_)) {
                basePart.updateMapModel();
            }
        }
    }

    protected NotificationFilter[] getNotificationFilters() {
        EStructuralFeatureNotificationFilter filter = new EStructuralFeatureNotificationFilter(new EStructuralFeature[]{GeneralPackage.eINSTANCE.getNamedElement_Id(), GeneralPackage.eINSTANCE.getNamedElement_Name(), GeneralPackage.eINSTANCE.getDescribableElement_Description(), MappingPackage.eINSTANCE.getMapModel_MapGroupModel(), MappingPackage.eINSTANCE.getMapModel_MapModel()});
        return new NotificationFilter[]{filter};
    }

    public Diagnostic validateValue(IPropertiesEditionEvent event) {
        Diagnostic ret = Diagnostic.OK_INSTANCE;
        if (event.getNewValue() != null) {
            try {
                Object newValue;
                if (MappingViewsRepository.MapModel.Properties.id == event.getAffectedEditor()) {
                    newValue = event.getNewValue();
                    if (newValue instanceof String) {
                        newValue = EEFConverterUtil.createFromString((EDataType)GeneralPackage.eINSTANCE.getNamedElement_Id().getEAttributeType(), (String)((String)newValue));
                    }
                    ret = Diagnostician.INSTANCE.validate(GeneralPackage.eINSTANCE.getNamedElement_Id().getEAttributeType(), newValue);
                }
                if (MappingViewsRepository.MapModel.Properties.name == event.getAffectedEditor()) {
                    newValue = event.getNewValue();
                    if (newValue instanceof String) {
                        newValue = EEFConverterUtil.createFromString((EDataType)GeneralPackage.eINSTANCE.getNamedElement_Name().getEAttributeType(), (String)((String)newValue));
                    }
                    ret = Diagnostician.INSTANCE.validate(GeneralPackage.eINSTANCE.getNamedElement_Name().getEAttributeType(), newValue);
                }
                if (MappingViewsRepository.MapModel.Properties.description == event.getAffectedEditor()) {
                    newValue = event.getNewValue();
                    if (newValue instanceof String) {
                        newValue = EEFConverterUtil.createFromString((EDataType)GeneralPackage.eINSTANCE.getDescribableElement_Description().getEAttributeType(), (String)((String)newValue));
                    }
                    ret = Diagnostician.INSTANCE.validate(GeneralPackage.eINSTANCE.getDescribableElement_Description().getEAttributeType(), newValue);
                }
            }
            catch (IllegalArgumentException iae) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)iae);
            }
            catch (WrappedException we) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)we);
            }
        }
        return ret;
    }
}

