/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library.ecore;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.internal.library.ecore.EcoreIdResolver;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorManager;
import org.eclipse.ocl.pivot.internal.library.executor.ExecutorStandardLibrary;
import org.eclipse.ocl.pivot.internal.library.executor.LazyModelManager;
import org.eclipse.ocl.pivot.messages.StatusCodes;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotObject;

public class EcoreExecutorManager
extends ExecutorManager {
    private final @Nullable Object contextObject;
    private ModelManager modelManager = null;
    private IdResolver idResolver = null;

    public EcoreExecutorManager(@Nullable Object contextObject, @NonNull ExecutorStandardLibrary standardLibrary) {
        super(standardLibrary);
        this.contextObject = contextObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @NonNull IdResolver createIdResolver() {
        ResourceSet resourceSet;
        if (!(this.contextObject instanceof EObject)) {
            @NonNull List<T> emptyList = Collections.emptyList();
            return new EcoreIdResolver(emptyList, this.getStandardLibrary());
        }
        EObject rootContainer = EcoreUtil.getRootContainer((EObject)((EObject)this.contextObject));
        Resource resource = rootContainer.eResource();
        Object notifier = resource != null ? ((resourceSet = resource.getResourceSet()) != null ? resourceSet : resource) : rootContainer;
        EObject eObject = notifier;
        synchronized (eObject) {
            Package root;
            EList eAdapters = notifier.eAdapters();
            for (Adapter adapter : eAdapters) {
                if (!(adapter instanceof EcoreIdResolver)) continue;
                return (EcoreIdResolver)adapter;
            }
            Object roots = null;
            if (resource != null) {
                ResourceSet resourceSet2 = resource.getResourceSet();
                if (resourceSet2 != null) {
                    roots = new ArrayList();
                    for (Resource r : resourceSet2.getResources()) {
                        roots.addAll(r.getContents());
                    }
                } else {
                    roots = resource.getContents();
                }
            }
            if ((root = this.standardLibrary.getPackage()) instanceof PivotObject) {
                if (roots == null) {
                    roots = new ArrayList();
                }
                roots.add(root);
            }
            if (roots == null) {
                roots = Collections.singletonList(rootContainer);
            }
            assert (roots != null);
            EcoreIdResolver adapter = new EcoreIdResolver((Iterable<? extends EObject>)roots, this.getStandardLibrary());
            eAdapters.add((Object)adapter);
            return adapter;
        }
    }

    @Override
    public @NonNull Type getDynamicTypeOf(@Nullable Object value) {
        IdResolver idResolver2 = this.idResolver;
        if (idResolver2 == null) {
            this.idResolver = idResolver2 = this.createIdResolver();
        }
        return idResolver2.getDynamicTypeOf(value);
    }

    @Override
    public @NonNull IdResolver getIdResolver() {
        IdResolver idResolver2 = this.idResolver;
        if (idResolver2 == null) {
            this.idResolver = idResolver2 = this.createIdResolver();
        }
        return idResolver2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull ModelManager getModelManager() {
        ModelManager modelManager2 = this.modelManager;
        if (modelManager2 == null) {
            EcoreExecutorManager ecoreExecutorManager = this;
            synchronized (ecoreExecutorManager) {
                modelManager2 = this.modelManager;
                if (modelManager2 == null) {
                    modelManager2 = this.contextObject instanceof EObject ? new LazyModelManager((EObject)this.contextObject){

                        @Override
                        protected boolean isInstance(@NonNull Type type, @NonNull EObject element) {
                            EClass eClass = ClassUtil.nonNullEMF(element.eClass());
                            Class elementType = EcoreExecutorManager.this.idResolver.getInheritance((EClassifier)eClass).getPivotClass();
                            return elementType.conformsTo(EcoreExecutorManager.this.standardLibrary, type);
                        }
                    } : ModelManager.NULL;
                    this.modelManager = modelManager2;
                }
            }
        }
        return modelManager2;
    }

    @Override
    public int getSeverity(@Nullable Object validationKey) {
        StatusCodes.Severity severity = this.getStandardLibrary().getSeverity(validationKey);
        return severity != null ? severity.getStatusCode() : 2;
    }

    @Override
    public @NonNull ExecutorStandardLibrary getStandardLibrary() {
        return (ExecutorStandardLibrary)this.standardLibrary;
    }

    @Override
    public @NonNull Class getStaticTypeOf(@Nullable Object value) {
        IdResolver idResolver2 = this.idResolver;
        if (idResolver2 == null) {
            this.idResolver = idResolver2 = this.createIdResolver();
        }
        return idResolver2.getStaticTypeOf(value);
    }

    @Override
    public @NonNull Class getStaticTypeOf(@Nullable Object value, Object ... values) {
        IdResolver idResolver2 = this.idResolver;
        if (idResolver2 == null) {
            this.idResolver = idResolver2 = this.createIdResolver();
        }
        return idResolver2.getStaticTypeOf(value, values);
    }

    @Override
    public @NonNull Class getStaticTypeOf(@Nullable Object value, @NonNull Iterable<?> values) {
        IdResolver idResolver2 = this.idResolver;
        if (idResolver2 == null) {
            this.idResolver = idResolver2 = this.createIdResolver();
        }
        return idResolver2.getStaticTypeOf(value, values);
    }
}

