/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.eval.ast.engine;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.JavaDebugUtils;
import org.eclipse.jdt.internal.debug.core.model.JDIReferenceType;
import org.eclipse.jdt.internal.debug.eval.ast.engine.BinaryBasedSourceGenerator;
import org.eclipse.jdt.internal.debug.eval.ast.engine.SourceBasedSourceGenerator;

public class EvaluationSourceGenerator {
    private String fCodeSnippet;
    private String[] fLocalVariableTypeNames;
    private String[] fLocalVariableNames;
    private String fSource;
    private String fCompilationUnitName;
    private int fSnippetStartPosition;
    private int fRunMethodStartPosition;
    private int fRunMethodLength;
    private IJavaProject fJavaProject;

    public EvaluationSourceGenerator(String[] localVariableTypesNames, String[] localVariableNames, String codeSnippet, IJavaProject javaProject) {
        this.fLocalVariableTypeNames = localVariableTypesNames;
        this.fLocalVariableNames = localVariableNames;
        this.fJavaProject = javaProject;
        this.fCodeSnippet = this.getCompleteSnippet(codeSnippet);
    }

    public EvaluationSourceGenerator(String codeSnippet, IJavaProject javaProject) {
        this(new String[0], new String[0], codeSnippet, javaProject);
    }

    protected String getCompleteSnippet(String codeSnippet) {
        codeSnippet = codeSnippet.trim();
        boolean inString = false;
        byte[] chars = codeSnippet.getBytes();
        int semicolonIndex = -1;
        int lastSemilcolonIndex = -1;
        int i = 0;
        int numChars = chars.length;
        while (i < numChars) {
            switch (chars[i]) {
                case 92: {
                    if (!inString) break;
                    ++i;
                    break;
                }
                case 34: 
                case 39: {
                    inString = !inString;
                    break;
                }
                case 59: {
                    if (inString) break;
                    semicolonIndex = lastSemilcolonIndex;
                    lastSemilcolonIndex = i;
                }
            }
            ++i;
        }
        StringBuffer wordBuffer = new StringBuffer();
        if (lastSemilcolonIndex != chars.length - 1) {
            semicolonIndex = lastSemilcolonIndex;
        }
        int i2 = 0;
        while (i2 < chars.length) {
            if (i2 > semicolonIndex && !Character.isWhitespace(chars[i2]) && chars[i2] != 125) break;
            wordBuffer.append(codeSnippet.charAt(i2));
            ++i2;
        }
        String lastSentence = codeSnippet.substring(i2);
        String returnString = "return ";
        int index = codeSnippet.lastIndexOf(returnString);
        if (index == -1) {
            if (this.needsReturn(lastSentence)) {
                wordBuffer.append(returnString);
            }
        } else if (index > i2) {
            if ((!Character.isWhitespace(chars[index - 1]) || !Character.isWhitespace(chars[index + 6]) && chars[index + 6] != 125) && this.needsReturn(lastSentence)) {
                wordBuffer.append(returnString);
            }
        } else if (chars[chars.length - 1] != 125 && (i2 + 7 > chars.length || i2 + 7 <= chars.length && !codeSnippet.substring(i2, i2 + 7).equals(returnString)) && this.needsReturn(lastSentence)) {
            wordBuffer.append(returnString);
        }
        while (i2 < chars.length) {
            wordBuffer.append(codeSnippet.charAt(i2));
            ++i2;
        }
        if (chars[chars.length - 1] != 59 && chars[chars.length - 1] != 125) {
            wordBuffer.append(';');
        } else if (chars[chars.length - 1] != 59 && chars[chars.length - 1] == 125) {
            int j = lastSentence.lastIndexOf(61);
            int k = lastSentence.lastIndexOf("==");
            if (j != -1 && j != k) {
                wordBuffer.append(';');
            }
        }
        return wordBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean needsReturn(String codeSnippet) {
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (String)this.fJavaProject.getOption("org.eclipse.jdt.core.compiler.source", true), (String)this.fJavaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true));
        scanner.setSource(codeSnippet.toCharArray());
        try {
            int token = scanner.getNextToken();
            int count = 0;
            while (true) {
                int currentToken;
                if (token == 158) {
                    return false;
                }
                if (count == 0 && (token == 5 || token == 23 || token == 22 || token == 21 || token == 18 || token == 20 || token == 25 || token == 24)) {
                    currentToken = token;
                    token = scanner.getNextToken();
                    if (token == 158 && currentToken == 5) {
                        return true;
                    }
                    count = 1;
                    continue;
                }
                if (count == 0 && (token == 94 || token == 99 || token == 214 || token == 101 || token == 102 || token == 103)) {
                    token = scanner.getNextToken();
                    continue;
                }
                if (count == 0 && token == 126) {
                    return false;
                }
                if (count == 1) {
                    if (token == 110) return true;
                    if (token == 167) {
                        return true;
                    }
                }
                if (count == 1 && (token == 69 || token == 15)) {
                    token = scanner.getNextToken();
                    count = 2;
                    continue;
                }
                if (count == 2 && (token == 68 || token == 166)) {
                    currentToken = token;
                    token = scanner.getNextToken();
                    if (token == 158 && currentToken == 166) {
                        return true;
                    }
                    count = 3;
                    continue;
                }
                if (count != 2) break;
                token = scanner.getNextToken();
            }
            if (count != 3) {
                if (count != 1) return true;
            }
            if (token != 5) return true;
            return false;
        }
        catch (InvalidInputException e) {
            e.printStackTrace();
        }
        return false;
    }

    public String getCompilationUnitName() {
        return this.fCompilationUnitName;
    }

    public int getSnippetStart() {
        return this.fSnippetStartPosition;
    }

    public int getRunMethodStart() {
        return this.fRunMethodStartPosition;
    }

    public int getRunMethodLength() {
        return this.fRunMethodLength;
    }

    protected void setSnippetStart(int position) {
        this.fSnippetStartPosition = position;
    }

    protected void setRunMethodStart(int position) {
        this.fRunMethodStartPosition = position;
    }

    protected void setRunMethodLength(int length) {
        this.fRunMethodLength = length;
    }

    public String getSnippet() {
        return this.fCodeSnippet;
    }

    private void createEvaluationSourceFromSource(String source, IType type, int line, boolean createInAStaticMethod, IJavaProject project) throws DebugException {
        ASTParser parser = ASTParser.newParser((int)4);
        parser.setSource(source.toCharArray());
        Map<String, String> options = EvaluationSourceGenerator.getCompilerOptions(project);
        String sourceLevel = project.getOption("org.eclipse.jdt.core.compiler.source", true);
        parser.setCompilerOptions(options);
        CompilationUnit unit = (CompilationUnit)parser.createAST(null);
        SourceBasedSourceGenerator visitor = new SourceBasedSourceGenerator(type, line, createInAStaticMethod, this.fLocalVariableTypeNames, this.fLocalVariableNames, this.fCodeSnippet, sourceLevel);
        unit.accept((ASTVisitor)visitor);
        if (visitor.hasError()) {
            throw new DebugException((IStatus)new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 0, visitor.getError(), null));
        }
        String sourceRes = visitor.getSource();
        if (sourceRes == null) {
            return;
        }
        this.setSource(sourceRes);
        this.setCompilationUnitName(visitor.getCompilationUnitName());
        this.setSnippetStart(visitor.getSnippetStart());
        this.setRunMethodStart(visitor.getRunMethodStart());
        this.setRunMethodLength(visitor.getRunMethodLength());
    }

    public static Map<String, String> getCompilerOptions(IJavaProject project) {
        Map options = project.getOptions(true);
        for (String key : options.keySet()) {
            String value = (String)options.get(key);
            if (!"error".equals(value) && !"warning".equals(value) && !"info".equals(value)) continue;
            options.put(key, "ignore");
        }
        options.put("org.eclipse.jdt.core.compiler.taskTags", "");
        return options;
    }

    private void createEvaluationSourceFromJDIObject(BinaryBasedSourceGenerator objectToEvaluationSourceMapper) {
        this.setCompilationUnitName(objectToEvaluationSourceMapper.getCompilationUnitName());
        this.setSnippetStart(objectToEvaluationSourceMapper.getSnippetStart());
        this.setRunMethodStart(objectToEvaluationSourceMapper.getRunMethodStart());
        this.setRunMethodLength(this.fCodeSnippet.length() + objectToEvaluationSourceMapper.getRunMethodLength());
        this.setSource(objectToEvaluationSourceMapper.getSource().insert(objectToEvaluationSourceMapper.getCodeSnippetPosition(), this.fCodeSnippet).toString());
    }

    private BinaryBasedSourceGenerator getInstanceSourceMapper(JDIReferenceType referenceType, boolean isInStaticMethod, IJavaProject project) {
        String sourceLevel = project.getOption("org.eclipse.jdt.core.compiler.source", true);
        BinaryBasedSourceGenerator objectToEvaluationSourceMapper = new BinaryBasedSourceGenerator(this.fLocalVariableTypeNames, this.fLocalVariableNames, isInStaticMethod, sourceLevel);
        objectToEvaluationSourceMapper.buildSource(referenceType);
        return objectToEvaluationSourceMapper;
    }

    public String getSource(IJavaReferenceType type, int line, IJavaProject javaProject, boolean isStatic) throws CoreException {
        if (this.fSource == null) {
            IType iType = JavaDebugUtils.resolveType(type);
            if (iType != null && !iType.isInterface()) {
                String baseSource = null;
                baseSource = iType.isBinary() ? iType.getClassFile().getSource() : iType.getCompilationUnit().getSource();
                if (baseSource != null) {
                    this.createEvaluationSourceFromSource(baseSource, iType, line, isStatic, javaProject);
                }
            }
            if (this.fSource == null) {
                BinaryBasedSourceGenerator mapper = this.getInstanceSourceMapper((JDIReferenceType)type, isStatic, javaProject);
                this.createEvaluationSourceFromJDIObject(mapper);
            }
        }
        return this.fSource;
    }

    protected void setCompilationUnitName(String name) {
        this.fCompilationUnitName = name;
    }

    protected void setSource(String source) {
        this.fSource = source;
    }
}

