/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.util.Iterator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionEndsCommand;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SemanticCreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.SetConnectionBendpointsCommand;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewAndElementRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.sequence.command.ChangeEdgeTargetCommand;
import org.eclipse.papyrus.uml.diagram.sequence.command.CreateElementAndNodeCommand;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.AbstractExecutionSpecificationEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.ExecutionSpecificationEndEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.GateEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.parts.LifelineEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.LifelineChildGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.edit.policies.LifelineXYLayoutEditPolicy;
import org.eclipse.papyrus.uml.diagram.sequence.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.sequence.util.FragmentsOrdererHelper;
import org.eclipse.papyrus.uml.diagram.sequence.util.SequenceUtil;
import org.eclipse.uml2.uml.ActionExecutionSpecification;
import org.eclipse.uml2.uml.BehaviorExecutionSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;

public class ExecutionSpecificationEndGraphicalNodeEditPolicy
extends GraphicalNodeEditPolicy {
    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        Command cmdRouter;
        INodeEditPart node = this.getConnectableEditPart();
        if (node == null) {
            return null;
        }
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        ConnectionAnchor targetAnchor = this.getTargetConnectionAnchor(request.getTarget(), (Request)request);
        INodeEditPart targetEP = this.getConnectionCompleteEditPart((Request)request);
        if (targetEP == null) {
            return null;
        }
        SetConnectionEndsCommand sceCommand = new SetConnectionEndsCommand(editingDomain, "");
        sceCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)request.getConnectionEditPart().getModel()));
        sceCommand.setNewTargetAdaptor((IAdaptable)targetEP);
        SetConnectionAnchorsCommand scaCommand = new SetConnectionAnchorsCommand(editingDomain, "");
        scaCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)request.getConnectionEditPart().getModel()));
        scaCommand.setNewTargetTerminal(targetEP.mapConnectionAnchorToTerminal(targetAnchor));
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_SetConnectionEndsCommand_Target);
        cc.compose((IUndoableOperation)sceCommand);
        cc.compose((IUndoableOperation)scaCommand);
        ICommandProxy cmd = new ICommandProxy((ICommand)cc);
        ConnectionEditPart cep = request.getConnectionEditPart();
        RoutingStyle style = (RoutingStyle)((View)cep.getModel()).getStyle(NotationPackage.eINSTANCE.getRoutingStyle());
        Routing currentRouter = Routing.MANUAL_LITERAL;
        if (style != null) {
            currentRouter = style.getRouting();
        }
        if ((cmdRouter = this.getRoutingAdjustment((IAdaptable)request.getConnectionEditPart(), this.getSemanticHint((Request)request), currentRouter, request.getTarget())) != null) {
            cmd = cmd == null ? cmdRouter : cmd.chain(cmdRouter);
            ConnectionAnchor sourceAnchor = node.getSourceConnectionAnchor((Request)request);
            PointList pointList = new PointList();
            pointList.addPoint(sourceAnchor.getLocation(targetAnchor.getReferencePoint()));
            pointList.addPoint(targetAnchor.getLocation(sourceAnchor.getReferencePoint()));
            SetConnectionBendpointsCommand sbbCommand = new SetConnectionBendpointsCommand(editingDomain);
            sbbCommand.setEdgeAdapter((IAdaptable)request.getConnectionEditPart());
            sbbCommand.setNewPointList(pointList, sourceAnchor.getReferencePoint(), targetAnchor.getReferencePoint());
            ICommandProxy cmdBP = new ICommandProxy((ICommand)sbbCommand);
            if (cmdBP != null) {
                Object object = cmd = cmd == null ? cmdBP : cmd.chain((Command)cmdBP);
            }
        }
        if (cmd.canExecute()) {
            return cmd.chain(FragmentsOrdererHelper.createOrderingFragmentsCommand(this.getHost(), request));
        }
        return cmd;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        INodeEditPart node = this.getConnectableEditPart();
        if (node == null) {
            return null;
        }
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        ConnectionAnchor sourceAnchor = this.getSourceConnectionAnchor(this.getHost(), (Request)request);
        SetConnectionEndsCommand sceCommand = new SetConnectionEndsCommand(editingDomain, "");
        sceCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)request.getConnectionEditPart().getModel())));
        sceCommand.setNewSourceAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)node.getModel())));
        SetConnectionAnchorsCommand scaCommand = new SetConnectionAnchorsCommand(editingDomain, "");
        scaCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)((View)request.getConnectionEditPart().getModel())));
        scaCommand.setNewSourceTerminal(node.mapConnectionAnchorToTerminal(sourceAnchor));
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_SetConnectionEndsCommand_Source);
        cc.compose((IUndoableOperation)sceCommand);
        cc.compose((IUndoableOperation)scaCommand);
        ICommandProxy result = new ICommandProxy((ICommand)cc);
        if (result.canExecute()) {
            return result.chain(FragmentsOrdererHelper.createOrderingFragmentsCommand((EditPart)node, request));
        }
        return result;
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        request.getExtendedData().put("Target model container", SequenceUtil.findInteractionFragmentContainerAt(this.getHostFigure().getBounds(), this.getHost()));
        ICommandProxy proxy = (ICommandProxy)request.getStartCommand();
        if (proxy == null) {
            return null;
        }
        INodeEditPart targetEP = this.getConnectionCompleteEditPart((Request)request);
        if (targetEP == null) {
            return null;
        }
        INodeEditPart sourceEditPart = this.getSourceEditPart(request.getSourceEditPart());
        if (request instanceof CreateConnectionViewRequest && ((IHintedType)UMLElementTypes.Message_SynchEdge).getSemanticHint().equals(((CreateConnectionViewRequest)request).getConnectionViewDescriptor().getSemanticHint())) {
            if (targetEP == sourceEditPart) {
                return UnexecutableCommand.INSTANCE;
            }
            if (targetEP instanceof AbstractExecutionSpecificationEditPart && this.getHost() instanceof ExecutionSpecificationEndEditPart) {
                EObject parentElement = ((AbstractExecutionSpecificationEditPart)targetEP).resolveSemanticElement();
                EObject element = ((ExecutionSpecificationEndEditPart)this.getHost()).resolveSemanticElement();
                if (parentElement instanceof ExecutionSpecification && element instanceof OccurrenceSpecification && element == ((ExecutionSpecification)parentElement).getFinish()) {
                    return UnexecutableCommand.INSTANCE;
                }
            }
        }
        CompositeCommand cc = (CompositeCommand)proxy.getICommand();
        ConnectionAnchor targetAnchor = this.getTargetConnectionAnchor(this.getHost(), (Request)request);
        Iterator commandItr = cc.iterator();
        commandItr.next();
        SetConnectionEndsCommand sceCommand = (SetConnectionEndsCommand)commandItr.next();
        sceCommand.setNewTargetAdaptor((IAdaptable)new EObjectAdapter((EObject)((IGraphicalEditPart)targetEP).getNotationView()));
        SetConnectionAnchorsCommand scaCommand = (SetConnectionAnchorsCommand)commandItr.next();
        scaCommand.setNewTargetTerminal(targetEP.mapConnectionAnchorToTerminal(targetAnchor));
        this.setViewAdapter(sceCommand.getEdgeAdaptor());
        ConnectionAnchor sourceAnchor = sourceEditPart.mapTerminalToConnectionAnchor(scaCommand.getNewSourceTerminal());
        PointList pointList = new PointList();
        if (request.getLocation() == null) {
            pointList.addPoint(sourceAnchor.getLocation(targetAnchor.getReferencePoint()));
            pointList.addPoint(targetAnchor.getLocation(sourceAnchor.getReferencePoint()));
        } else {
            pointList.addPoint(sourceAnchor.getLocation(request.getLocation()));
            pointList.addPoint(targetAnchor.getLocation(request.getLocation()));
        }
        SetConnectionBendpointsCommand sbbCommand = (SetConnectionBendpointsCommand)commandItr.next();
        sbbCommand.setNewPointList(pointList, sourceAnchor.getReferencePoint(), targetAnchor.getReferencePoint());
        return request.getStartCommand();
    }

    private INodeEditPart getSourceEditPart(EditPart sourceEditPart) {
        if (sourceEditPart instanceof ExecutionSpecificationEndEditPart) {
            return (INodeEditPart)((ExecutionSpecificationEndEditPart)sourceEditPart).getParent();
        }
        return (INodeEditPart)sourceEditPart;
    }

    private Command getCreateAdditionalESCommand(CreateConnectionRequest request) {
        boolean messageGoUphill;
        INodeEditPart sourceEP = this.getSourceEditPart(request.getSourceEditPart());
        INodeEditPart targetEP = this.getConnectionCompleteEditPart((Request)request);
        View targetView = (View)targetEP.getModel();
        EObject target = ViewUtil.resolveSemanticElement((View)targetView);
        if (target == null) {
            target = targetView;
        }
        if (targetEP == sourceEP) {
            return null;
        }
        if (!(targetEP instanceof AbstractExecutionSpecificationEditPart) || !(this.getHost() instanceof ExecutionSpecificationEndEditPart)) {
            return null;
        }
        IHintedType elementType = null;
        if (target instanceof ActionExecutionSpecification) {
            elementType = (IHintedType)UMLElementTypes.ActionExecutionSpecification_Shape;
        } else if (target instanceof BehaviorExecutionSpecification) {
            elementType = (IHintedType)UMLElementTypes.BehaviorExecutionSpecification_Shape;
        }
        if (elementType == null) {
            return null;
        }
        if (!(request instanceof CreateConnectionViewRequest)) {
            return null;
        }
        CreateConnectionViewRequest viewRequest = (CreateConnectionViewRequest)request;
        if (!((IHintedType)UMLElementTypes.Message_SynchEdge).getSemanticHint().equals(((CreateConnectionViewRequest)request).getConnectionViewDescriptor().getSemanticHint())) {
            return null;
        }
        InteractionFragment ift = SequenceUtil.findInteractionFragmentContainerAt(request.getLocation(), this.getHost());
        EObject parentElement = ((AbstractExecutionSpecificationEditPart)targetEP).resolveSemanticElement();
        EObject element = ((ExecutionSpecificationEndEditPart)this.getHost()).resolveSemanticElement();
        boolean executionLinkedAlready = parentElement instanceof ExecutionSpecification && element instanceof MessageOccurrenceSpecification;
        ConnectionAnchor sourceAnchor = this.getActualSourceConnectionAnchor(request);
        ConnectionAnchor targetAnchor = this.getSourceConnectionAnchor((EditPart)targetEP, (Request)request);
        Point sourceLocation = sourceAnchor.getLocation(targetAnchor.getReferencePoint()).getCopy();
        if (sourceEP instanceof GateEditPart) {
            Rectangle gateBounds = sourceEP.getFigure().getBounds().getCopy();
            sourceEP.getFigure().translateToAbsolute((Translatable)gateBounds);
            sourceLocation.y = gateBounds.y + gateBounds.height / 2;
        }
        Point targetLocation = targetEP.getFigure().getBounds().getTopLeft().getCopy();
        targetEP.getFigure().translateToAbsolute((Translatable)targetLocation);
        boolean bl = messageGoUphill = targetLocation.y < sourceLocation.y;
        if (!executionLinkedAlready && !messageGoUphill) {
            return null;
        }
        CompositeCommand compound = new CompositeCommand("InteractionFragment Container");
        Point newExecutionLocation = targetLocation.getCopy();
        INodeEditPart targetLifelineEP = (INodeEditPart)targetEP.getParent();
        if (messageGoUphill) {
            newExecutionLocation.y = sourceLocation.y;
            Rectangle targetBounds = targetEP.getFigure().getBounds().getCopy();
            targetEP.getFigure().translateToAbsolute((Translatable)targetBounds);
            int resizeAmount = newExecutionLocation.y + 50 + 5 - targetBounds.bottom();
            if (resizeAmount > 0) {
                ChangeBoundsRequest esRequest = new ChangeBoundsRequest((Object)"move");
                esRequest.setEditParts((EditPart)targetEP);
                esRequest.setResizeDirection(4);
                esRequest.setSizeDelta(new Dimension(0, resizeAmount));
                Command moveESCommand = LifelineXYLayoutEditPolicy.getResizeOrMoveChildrenCommand((LifelineEditPart)targetLifelineEP, esRequest, false, false, true);
                if (moveESCommand != null && !moveESCommand.canExecute()) {
                    return UnexecutableCommand.INSTANCE;
                }
                if (moveESCommand != null) {
                    compound.compose((IUndoableOperation)new CommandProxy(moveESCommand));
                }
            }
        }
        EObject targetLifeline = ViewUtil.resolveSemanticElement((View)((View)targetEP.getParent().getModel()));
        CreateElementAndNodeCommand createExecutionSpecificationCommand = new CreateElementAndNodeCommand(this.getEditingDomain(), (ShapeNodeEditPart)targetLifelineEP, targetLifeline, elementType, newExecutionLocation);
        createExecutionSpecificationCommand.putCreateElementRequestParameter("InteractionFragment Container", ift);
        compound.compose((IUndoableOperation)createExecutionSpecificationCommand);
        ChangeEdgeTargetCommand changeTargetCommand = new ChangeEdgeTargetCommand(this.getEditingDomain(), createExecutionSpecificationCommand, viewRequest.getConnectionViewDescriptor(), "(0.5, 0.0)");
        compound.compose((IUndoableOperation)changeTargetCommand);
        return new ICommandProxy((ICommand)compound);
    }

    protected Command getConnectionAndRelationshipCompleteCommand(CreateConnectionViewAndElementRequest request) {
        ICommandProxy result;
        request.getExtendedData().put("Target model container", SequenceUtil.findInteractionFragmentContainerAt(this.getHostFigure().getBounds(), this.getHost()));
        CreateElementRequestAdapter requestAdapter = request.getConnectionViewAndElementDescriptor().getCreateElementRequestAdapter();
        CreateRelationshipRequest createElementRequest = (CreateRelationshipRequest)requestAdapter.getAdapter(CreateRelationshipRequest.class);
        createElementRequest.setPrompt(!request.isUISupressed());
        INodeEditPart targetEP = (INodeEditPart)this.getHost();
        View sourceView = (View)request.getSourceEditPart().getModel();
        View targetView = (View)targetEP.getModel();
        EObject source = ViewUtil.resolveSemanticElement((View)sourceView);
        if (source == null) {
            source = sourceView;
        }
        createElementRequest.setSource(source);
        EObject target = ViewUtil.resolveSemanticElement((View)targetView);
        if (target == null) {
            target = targetView;
        }
        createElementRequest.setTarget(target);
        Command createElementCommand = targetEP.getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)((CreateRelationshipRequest)requestAdapter.getAdapter(CreateRelationshipRequest.class)), request.getExtendedData()));
        if (createElementCommand == null) {
            return null;
        }
        SemanticCreateCommand semanticCommand = new SemanticCreateCommand(requestAdapter, createElementCommand);
        Command viewCommand = this.getConnectionCompleteCommand((CreateConnectionRequest)request);
        if (viewCommand == null) {
            return null;
        }
        Command addESCommand = this.getCreateAdditionalESCommand((CreateConnectionRequest)request);
        CompositeCommand cc = new CompositeCommand(semanticCommand.getLabel());
        cc.compose((IUndoableOperation)semanticCommand);
        cc.compose((IUndoableOperation)new CommandProxy(viewCommand));
        if (addESCommand != null) {
            cc.compose((IUndoableOperation)new CommandProxy(addESCommand));
        }
        if ((result = new ICommandProxy((ICommand)cc)).canExecute()) {
            Command orderFragments = FragmentsOrdererHelper.createOrderingFragmentsCommand(this.getHost().getParent(), request);
            return result.chain(orderFragments);
        }
        return result;
    }

    protected Command getConnectionAndRelationshipCreateCommand(CreateConnectionViewAndElementRequest request) {
        request.getExtendedData().put("Source model container", SequenceUtil.findInteractionFragmentContainerAt(this.getHostFigure().getBounds(), this.getHost()));
        return super.getConnectionAndRelationshipCreateCommand(request);
    }

    private TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        if (!(request instanceof CreateConnectionViewRequest)) {
            return null;
        }
        request.getExtendedData().put("Source model container", SequenceUtil.findInteractionFragmentContainerAt(this.getHostFigure().getBounds(), this.getHost()));
        request.getExtendedData().put("Location of connection source point", request.getLocation());
        CreateConnectionViewRequest req = (CreateConnectionViewRequest)request;
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_CreateCommand_Connection_Label);
        Diagram diagramView = ((View)this.getHost().getModel()).getDiagram();
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        CreateCommand createCommand = new CreateCommand(editingDomain, (CreateViewRequest.ViewDescriptor)req.getConnectionViewDescriptor(), (View)diagramView.getDiagram());
        this.setViewAdapter((IAdaptable)createCommand.getCommandResult().getReturnValue());
        SetConnectionEndsCommand sceCommand = new SetConnectionEndsCommand(editingDomain, "");
        sceCommand.setEdgeAdaptor(this.getViewAdapter());
        sceCommand.setNewSourceAdaptor((IAdaptable)new EObjectAdapter((EObject)this.getView()));
        ConnectionAnchor sourceAnchor = this.getSourceConnectionAnchor(this.getHost(), (Request)request);
        SetConnectionAnchorsCommand scaCommand = new SetConnectionAnchorsCommand(editingDomain, "");
        scaCommand.setEdgeAdaptor(this.getViewAdapter());
        scaCommand.setNewSourceTerminal(this.getConnectableEditPart().mapConnectionAnchorToTerminal(sourceAnchor));
        SetConnectionBendpointsCommand sbbCommand = new SetConnectionBendpointsCommand(editingDomain);
        sbbCommand.setEdgeAdapter(this.getViewAdapter());
        cc.compose((IUndoableOperation)createCommand);
        cc.compose((IUndoableOperation)sceCommand);
        cc.compose((IUndoableOperation)scaCommand);
        cc.compose((IUndoableOperation)sbbCommand);
        ICommandProxy c = new ICommandProxy((ICommand)cc);
        request.setStartCommand((Command)c);
        return c;
    }

    protected View getView() {
        return (View)this.getHost().getParent().getModel();
    }

    protected INodeEditPart getConnectableEditPart() {
        return (INodeEditPart)this.getHost().getParent();
    }

    protected INodeEditPart getConnectionCompleteEditPart(Request request) {
        return (INodeEditPart)this.getHost().getParent();
    }

    protected Connection createDummyConnection(Request req) {
        Connection conn = super.createDummyConnection(req);
        conn.setForegroundColor(ColorConstants.black);
        return conn;
    }

    private ConnectionAnchor getActualSourceConnectionAnchor(CreateConnectionRequest request) {
        ICommandProxy proxy = (ICommandProxy)request.getStartCommand();
        if (proxy == null) {
            return null;
        }
        INodeEditPart sourceEditPart = this.getSourceEditPart(request.getSourceEditPart());
        CompositeCommand cc = (CompositeCommand)proxy.getICommand();
        Iterator commandItr = cc.iterator();
        commandItr.next();
        commandItr.next();
        SetConnectionAnchorsCommand scaCommand = (SetConnectionAnchorsCommand)commandItr.next();
        ConnectionAnchor sourceAnchor = sourceEditPart.mapTerminalToConnectionAnchor(scaCommand.getNewSourceTerminal());
        return sourceAnchor;
    }

    private ConnectionAnchor getSourceConnectionAnchor(EditPart sourceEditPart, Request request) {
        if (sourceEditPart instanceof ExecutionSpecificationEndEditPart) {
            EObject parentElement;
            request.getExtendedData().remove("Execution Fix Anchor Position");
            EObject element = ((ExecutionSpecificationEndEditPart)sourceEditPart).resolveSemanticElement();
            INodeEditPart parent = (INodeEditPart)sourceEditPart.getParent();
            if (parent instanceof IGraphicalEditPart && (parentElement = ((IGraphicalEditPart)parent).resolveSemanticElement()) instanceof ExecutionSpecification) {
                if (element == ((ExecutionSpecification)parentElement).getStart()) {
                    request.getExtendedData().put("Execution Fix Anchor Position", 8);
                } else if (element == ((ExecutionSpecification)parentElement).getFinish()) {
                    request.getExtendedData().put("Execution Fix Anchor Position", 32);
                }
            }
            ConnectionAnchor sourceConnectionAnchor = parent.getSourceConnectionAnchor(request);
            request.getExtendedData().remove("Execution Fix Anchor Position");
            return sourceConnectionAnchor;
        }
        return sourceEditPart instanceof INodeEditPart ? ((INodeEditPart)sourceEditPart).getSourceConnectionAnchor(request) : null;
    }

    private ConnectionAnchor getTargetConnectionAnchor(EditPart targetEditPart, Request request) {
        if (targetEditPart instanceof ExecutionSpecificationEndEditPart) {
            EObject parentElement;
            request.getExtendedData().remove("Execution Fix Anchor Position");
            EObject element = ((ExecutionSpecificationEndEditPart)targetEditPart).resolveSemanticElement();
            INodeEditPart parent = (INodeEditPart)targetEditPart.getParent();
            if (parent instanceof IGraphicalEditPart && (parentElement = ((IGraphicalEditPart)parent).resolveSemanticElement()) instanceof ExecutionSpecification) {
                if (element == ((ExecutionSpecification)parentElement).getStart()) {
                    request.getExtendedData().put("Execution Fix Anchor Position", 8);
                } else if (element == ((ExecutionSpecification)parentElement).getFinish()) {
                    request.getExtendedData().put("Execution Fix Anchor Position", 32);
                }
            }
            ConnectionAnchor targetConnectionAnchor = parent.getTargetConnectionAnchor(request);
            request.getExtendedData().remove("Execution Fix Anchor Position");
            return targetConnectionAnchor;
        }
        return targetEditPart instanceof INodeEditPart ? ((INodeEditPart)targetEditPart).getTargetConnectionAnchor(request) : null;
    }

    protected ConnectionRouter getDummyConnectionRouter(CreateConnectionRequest arg0) {
        return LifelineChildGraphicalNodeEditPolicy.messageRouter;
    }
}

