/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.infra.properties.property.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.opencert.infra.properties.property.DataTypeKind;
import org.eclipse.opencert.infra.properties.property.Property;
import org.eclipse.opencert.infra.properties.property.PropertyFactory;
import org.eclipse.opencert.infra.properties.property.PropertyModel;
import org.eclipse.opencert.infra.properties.property.PropertyPackage;
import org.eclipse.opencert.infra.properties.property.impl.PropertyImpl;
import org.eclipse.opencert.infra.properties.property.impl.PropertyModelImpl;

public class PropertyFactoryImpl
extends EFactoryImpl
implements PropertyFactory {
    public static PropertyFactory init() {
        try {
            PropertyFactory thePropertyFactory = (PropertyFactory)EPackage.Registry.INSTANCE.getEFactory("http://property/1.0");
            if (thePropertyFactory != null) {
                return thePropertyFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new PropertyFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createPropertyModel();
            }
            case 1: {
                return this.createProperty();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.createDataTypeKindFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 2: {
                return this.convertDataTypeKindToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public PropertyModel createPropertyModel() {
        PropertyModelImpl propertyModel = new PropertyModelImpl();
        return propertyModel;
    }

    @Override
    public Property createProperty() {
        PropertyImpl property = new PropertyImpl();
        return property;
    }

    public DataTypeKind createDataTypeKindFromString(EDataType eDataType, String initialValue) {
        DataTypeKind result = DataTypeKind.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertDataTypeKindToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public PropertyPackage getPropertyPackage() {
        return (PropertyPackage)this.getEPackage();
    }

    @Deprecated
    public static PropertyPackage getPackage() {
        return PropertyPackage.eINSTANCE;
    }
}

