/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.types.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IMetamodelType;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsFactory;
import org.eclipse.papyrus.infra.types.IconEntry;
import org.eclipse.papyrus.infra.types.MetamodelTypeConfiguration;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.infra.types.core.registries.ElementTypeSetConfigurationRegistry;
import org.eclipse.papyrus.uml.profile.types.generator.Identifiers;
import org.eclipse.papyrus.uml.profile.types.generator.UML;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Singleton
public class UMLElementTypes {
    private static final Pattern VISUAL_ID_PATTERN = Pattern.compile("\\d{4}");
    @Extension
    private static ElementTypesConfigurationsFactory elementtypesconfigurationsFactory = ElementTypesConfigurationsFactory.eINSTANCE;
    @Inject
    @Extension
    private Identifiers _identifiers;
    @Inject
    @Extension
    private UML _uML;

    public String getElementTypeID(Class metaclass) {
        String _name = metaclass.getName();
        return "org.eclipse.papyrus.uml." + _name;
    }

    public ElementTypeConfiguration getElementTypeConfiguration(final Class metaclass) {
        ElementTypeSetConfiguration _baseUMLElementTypeSet = this.getBaseUMLElementTypeSet();
        EList _elementTypeConfigurations = _baseUMLElementTypeSet.getElementTypeConfigurations();
        Functions.Function1<ElementTypeConfiguration, Boolean> _function = new Functions.Function1<ElementTypeConfiguration, Boolean>(){

            public Boolean apply(ElementTypeConfiguration it) {
                String _identifier = it.getIdentifier();
                String _elementTypeID = UMLElementTypes.this.getElementTypeID(metaclass);
                return Objects.equal((Object)_identifier, (Object)_elementTypeID);
            }
        };
        return (ElementTypeConfiguration)IterableExtensions.findFirst((Iterable)_elementTypeConfigurations, (Functions.Function1)_function);
    }

    public ElementTypeSetConfiguration getBaseUMLElementTypeSet() {
        ElementTypeSetConfigurationRegistry _instance = ElementTypeSetConfigurationRegistry.getInstance();
        Map _elementTypeSetConfigurations = _instance.getElementTypeSetConfigurations();
        String _contextId = this._identifiers.getContextId();
        Map _get = (Map)_elementTypeSetConfigurations.get(_contextId);
        String _umlElementTypesSet = this._identifiers.getUmlElementTypesSet();
        return (ElementTypeSetConfiguration)_get.get(_umlElementTypesSet);
    }

    public Iterable<IElementType> getBaseUMLElementTypes() {
        ElementTypeSetConfiguration _baseUMLElementTypeSet = this.getBaseUMLElementTypeSet();
        EList _elementTypeConfigurations = _baseUMLElementTypeSet.getElementTypeConfigurations();
        Functions.Function1<ElementTypeConfiguration, IElementType> _function = new Functions.Function1<ElementTypeConfiguration, IElementType>(){

            public IElementType apply(ElementTypeConfiguration it) {
                ElementTypeRegistry _instance = ElementTypeRegistry.getInstance();
                String _identifier = it.getIdentifier();
                return _instance.getType(_identifier);
            }
        };
        List _map = ListExtensions.map((List)_elementTypeConfigurations, (Functions.Function1)_function);
        return IterableExtensions.filterNull((Iterable)_map);
    }

    public EClass getEClass(Class metaclass) {
        String _name = metaclass.getName();
        EClassifier _eClassifier = UMLPackage.eINSTANCE.getEClassifier(_name);
        return (EClass)_eClassifier;
    }

    public IconEntry getIconEntry(Class metaclass) {
        ElementTypeConfiguration _elementTypeConfiguration = this.getElementTypeConfiguration(metaclass);
        IconEntry _iconEntry = null;
        if (_elementTypeConfiguration != null) {
            _iconEntry = _elementTypeConfiguration.getIconEntry();
        }
        return this.copy(_iconEntry);
    }

    private IconEntry copy(final IconEntry prototype) {
        IconEntry _createIconEntry = elementtypesconfigurationsFactory.createIconEntry();
        Procedures.Procedure1<IconEntry> _function = new Procedures.Procedure1<IconEntry>(){

            public void apply(IconEntry it) {
                String _bundleId = prototype.getBundleId();
                it.setBundleId(_bundleId);
                String _iconPath = prototype.getIconPath();
                it.setIconPath(_iconPath);
            }
        };
        return (IconEntry)ObjectExtensions.operator_doubleArrow((Object)_createIconEntry, (Procedures.Procedure1)_function);
    }

    public ElementTypeSetConfiguration getBaseElementTypeSet() {
        ElementTypeSetConfiguration _elvis = null;
        ElementTypeSetConfiguration _baseElementTypesSetConfiguration = this._identifiers.getBaseElementTypesSetConfiguration();
        if (_baseElementTypesSetConfiguration != null) {
            _elvis = _baseElementTypesSetConfiguration;
        } else {
            ElementTypeSetConfiguration _get_1;
            ElementTypeSetConfigurationRegistry _instance = ElementTypeSetConfigurationRegistry.getInstance();
            Map _elementTypeSetConfigurations = _instance.getElementTypeSetConfigurations();
            String _contextId = this._identifiers.getContextId();
            Map _get = (Map)_elementTypeSetConfigurations.get(_contextId);
            String _baseElementTypesSet = this._identifiers.getBaseElementTypesSet();
            _elvis = _get_1 = (ElementTypeSetConfiguration)_get.get(_baseElementTypesSet);
        }
        return _elvis;
    }

    public Iterable<ElementTypeConfiguration> getBaseElementTypes() {
        ElementTypeSetConfiguration _baseElementTypeSet = this.getBaseElementTypeSet();
        EList _elementTypeConfigurations = _baseElementTypeSet.getElementTypeConfigurations();
        Functions.Function1<ElementTypeConfiguration, Boolean> _function = new Functions.Function1<ElementTypeConfiguration, Boolean>(){

            public Boolean apply(ElementTypeConfiguration it) {
                return UMLElementTypes.this.validType(it);
            }
        };
        return IterableExtensions.filter((Iterable)_elementTypeConfigurations, (Functions.Function1)_function);
    }

    public boolean validType(ElementTypeConfiguration elementType) {
        EClass _metaclass = this.getMetaclass(elementType);
        return !Objects.equal((Object)_metaclass, null);
    }

    private boolean isDiagramSpecific() {
        ElementTypeSetConfiguration _baseUMLElementTypeSet;
        ElementTypeSetConfiguration _baseElementTypeSet = this.getBaseElementTypeSet();
        return !Objects.equal((Object)_baseElementTypeSet, (Object)(_baseUMLElementTypeSet = this.getBaseUMLElementTypeSet()));
    }

    public boolean isDiagramSpecific(ElementTypeConfiguration type) {
        String _hint = type.getHint();
        return this.isVisualID(_hint);
    }

    public boolean hasSemanticSupertype(ElementTypeConfiguration type) {
        boolean _isSuppressSemanticSuperElementTypes;
        boolean _not;
        boolean _and = false;
        boolean _isDiagramSpecific = this.isDiagramSpecific(type);
        _and = !_isDiagramSpecific ? false : (_not = !(_isSuppressSemanticSuperElementTypes = this._identifiers.isSuppressSemanticSuperElementTypes()));
        return _and;
    }

    private boolean isVisualID(String string) {
        boolean _not;
        boolean _and = false;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)string);
        boolean bl = _not = !_isNullOrEmpty;
        if (!_not) {
            _and = false;
        } else {
            boolean _contains_4;
            boolean _contains_3;
            boolean _contains_2;
            boolean _contains_1;
            boolean _contains;
            boolean _or = false;
            boolean _or_1 = false;
            boolean _or_2 = false;
            boolean _or_3 = false;
            boolean _or_4 = false;
            Matcher _matcher = VISUAL_ID_PATTERN.matcher(string);
            boolean _matches = _matcher.matches();
            _or_4 = _matches ? true : (_contains = string.contains("Diagram"));
            _or_3 = _or_4 ? true : (_contains_1 = string.contains("Shape"));
            _or_2 = _or_3 ? true : (_contains_2 = string.contains("Edge"));
            _or_1 = _or_2 ? true : (_contains_3 = string.contains("Label"));
            _or = _or_1 ? true : (_contains_4 = string.contains("Compartment"));
            _and = _or;
        }
        return _and;
    }

    public Iterable<? extends ElementTypeConfiguration> getDiagramSpecificElementTypes(final Class metaclass) {
        boolean _not;
        Iterable _xifexpression = null;
        boolean _isDiagramSpecific = this.isDiagramSpecific();
        boolean bl = _not = !_isDiagramSpecific;
        if (_not) {
            ElementTypeSetConfiguration _baseUMLElementTypeSet = this.getBaseUMLElementTypeSet();
            EList _elementTypeConfigurations = _baseUMLElementTypeSet.getElementTypeConfigurations();
            Functions.Function1<ElementTypeConfiguration, Boolean> _function = new Functions.Function1<ElementTypeConfiguration, Boolean>(){

                public Boolean apply(ElementTypeConfiguration it) {
                    boolean _and = false;
                    boolean _validType = UMLElementTypes.this.validType(it);
                    if (!_validType) {
                        _and = false;
                    } else {
                        boolean _equals;
                        String _identifier = it.getIdentifier();
                        String _elementTypeID = UMLElementTypes.this.getElementTypeID(metaclass);
                        _and = _equals = Objects.equal((Object)_identifier, (Object)_elementTypeID);
                    }
                    return _and;
                }
            };
            _xifexpression = IterableExtensions.filter((Iterable)_elementTypeConfigurations, (Functions.Function1)_function);
        } else {
            ElementTypeSetConfiguration _baseElementTypeSet = this.getBaseElementTypeSet();
            EList _elementTypeConfigurations_1 = _baseElementTypeSet.getElementTypeConfigurations();
            Iterable _filter = Iterables.filter((Iterable)_elementTypeConfigurations_1, SpecializationTypeConfiguration.class);
            Functions.Function1<SpecializationTypeConfiguration, Boolean> _function_1 = new Functions.Function1<SpecializationTypeConfiguration, Boolean>(){

                public Boolean apply(SpecializationTypeConfiguration it) {
                    boolean _and = false;
                    boolean _validType = UMLElementTypes.this.validType((ElementTypeConfiguration)it);
                    if (!_validType) {
                        _and = false;
                    } else {
                        boolean _contains;
                        EList _specializedTypesID = it.getSpecializedTypesID();
                        String _elementTypeID = UMLElementTypes.this.getElementTypeID(metaclass);
                        _and = _contains = _specializedTypesID.contains((Object)_elementTypeID);
                    }
                    return _and;
                }
            };
            _xifexpression = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function_1);
        }
        return _xifexpression;
    }

    private boolean canContain(IElementType containerType, final EClass containedEClass) {
        EClass _eClass = containerType.getEClass();
        EList _eAllContainments = _eClass.getEAllContainments();
        Functions.Function1<EReference, Boolean> _function = new Functions.Function1<EReference, Boolean>(){

            public Boolean apply(EReference it) {
                EClass _eReferenceType = it.getEReferenceType();
                return _eReferenceType.isSuperTypeOf(containedEClass);
            }
        };
        return IterableExtensions.exists((Iterable)_eAllContainments, (Functions.Function1)_function);
    }

    private boolean canContain(ElementTypeConfiguration containerType, EClass containedEClass) {
        ElementTypeRegistry _instance = ElementTypeRegistry.getInstance();
        String _identifier = containerType.getIdentifier();
        IElementType _type = _instance.getType(_identifier);
        boolean _canContain = false;
        if (_type != null) {
            _canContain = this.canContain(_type, containedEClass);
        }
        return _canContain;
    }

    protected boolean _canContainType(ElementTypeConfiguration containerType, ElementTypeConfiguration containedTypeConfiguration) {
        return false;
    }

    protected boolean _canContainType(ElementTypeConfiguration containerType, MetamodelTypeConfiguration containedTypeConfiguration) {
        EClass _eClass = containedTypeConfiguration.getEClass();
        return this.canContain(containerType, _eClass);
    }

    protected boolean _canContainType(final ElementTypeConfiguration containerType, SpecializationTypeConfiguration containedTypeConfiguration) {
        EList _specializedTypesID = containedTypeConfiguration.getSpecializedTypesID();
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String supertype) {
                ElementTypeRegistry _instance = ElementTypeRegistry.getInstance();
                IElementType _type = _instance.getType(supertype);
                EClass _eClass = _type.getEClass();
                return UMLElementTypes.this.canContain(containerType, _eClass);
            }
        };
        return IterableExtensions.exists((Iterable)_specializedTypesID, (Functions.Function1)_function);
    }

    public boolean isRelationship(IElementType elementType) {
        boolean _or = false;
        EClass _eClass = elementType.getEClass();
        boolean _equals = Objects.equal((Object)_eClass, null);
        if (_equals) {
            _or = true;
        } else {
            boolean _isRelationship;
            EClass _eClass_1 = elementType.getEClass();
            _or = _isRelationship = this._uML.isRelationship(_eClass_1);
        }
        return _or;
    }

    public boolean isRelationship(ElementTypeConfiguration elementType) {
        boolean _or = false;
        EClass _metaclass = this.getMetaclass(elementType);
        boolean _equals = Objects.equal((Object)_metaclass, null);
        if (_equals) {
            _or = true;
        } else {
            boolean _isRelationship;
            EClass _metaclass_1 = this.getMetaclass(elementType);
            _or = _isRelationship = this._uML.isRelationship(_metaclass_1);
        }
        return _or;
    }

    private EClass _getMetaclass(ElementTypeConfiguration elementType) {
        return null;
    }

    private EClass _getMetaclass(SpecializationTypeConfiguration elementType) {
        boolean _notEquals;
        EClass _xblockexpression = null;
        ElementTypeRegistry _instance = ElementTypeRegistry.getInstance();
        String _identifier = elementType.getIdentifier();
        IElementType registered = _instance.getType(_identifier);
        EClass _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)registered, null);
        if (_notEquals) {
            _xifexpression = this.getMetaclass(registered);
        } else {
            EList _specializedTypesID = elementType.getSpecializedTypesID();
            Functions.Function1<String, IElementType> _function = new Functions.Function1<String, IElementType>(){

                public IElementType apply(String it) {
                    ElementTypeRegistry _instance = ElementTypeRegistry.getInstance();
                    return _instance.getType(it);
                }
            };
            List _map = ListExtensions.map((List)_specializedTypesID, (Functions.Function1)_function);
            Iterable _filterNull = IterableExtensions.filterNull((Iterable)_map);
            IElementType _head = (IElementType)IterableExtensions.head((Iterable)_filterNull);
            EClass _eClass = null;
            if (_head != null) {
                _eClass = _head.getEClass();
            }
            _xifexpression = _eClass;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private EClass _getMetaclass(MetamodelTypeConfiguration elementType) {
        return elementType.getEClass();
    }

    private EClass _getMetaclass(IElementType elementType) {
        return null;
    }

    private EClass _getMetaclass(IMetamodelType elementType) {
        return elementType.getEClass();
    }

    private EClass _getMetaclass(ISpecializationType elementType) {
        IMetamodelType _metamodelType = elementType.getMetamodelType();
        EClass _eClass = null;
        if (_metamodelType != null) {
            _eClass = _metamodelType.getEClass();
        }
        return _eClass;
    }

    private boolean canSourceTo(final IElementType sourceType, EClass relationshipEClass) {
        Iterable<EReference> _sourceReferences = this._uML.getSourceReferences(relationshipEClass);
        Functions.Function1<EReference, Boolean> _function = new Functions.Function1<EReference, Boolean>(){

            public Boolean apply(EReference it) {
                EClass _eReferenceType = it.getEReferenceType();
                EClass _eClass = sourceType.getEClass();
                return _eReferenceType.isSuperTypeOf(_eClass);
            }
        };
        return IterableExtensions.exists(_sourceReferences, (Functions.Function1)_function);
    }

    private boolean canSourceTo(ElementTypeConfiguration sourceType, EClass relationshipEClass) {
        ElementTypeRegistry _instance = ElementTypeRegistry.getInstance();
        String _identifier = null;
        if (sourceType != null) {
            _identifier = sourceType.getIdentifier();
        }
        IElementType _type = _instance.getType(_identifier);
        boolean _canSourceTo = false;
        if (_type != null) {
            _canSourceTo = this.canSourceTo(_type, relationshipEClass);
        }
        return _canSourceTo;
    }

    protected boolean _canSourceToType(ElementTypeConfiguration sourceType, ElementTypeConfiguration relationshipTypeConfiguration) {
        return false;
    }

    protected boolean _canSourceToType(ElementTypeConfiguration sourceType, MetamodelTypeConfiguration relationshipTypeConfiguration) {
        EClass _eClass = relationshipTypeConfiguration.getEClass();
        return this.canSourceTo(sourceType, _eClass);
    }

    protected boolean _canSourceToType(final ElementTypeConfiguration sourceType, SpecializationTypeConfiguration relationshipTypeConfiguration) {
        EList _specializedTypesID = relationshipTypeConfiguration.getSpecializedTypesID();
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String supertypeID) {
                boolean _notEquals;
                boolean _xblockexpression = false;
                ElementTypeRegistry _instance = ElementTypeRegistry.getInstance();
                IElementType supertype = _instance.getType(supertypeID);
                boolean _and = false;
                boolean _and_1 = false;
                boolean bl = _notEquals = !Objects.equal((Object)supertype, null);
                if (!_notEquals) {
                    _and_1 = false;
                } else {
                    boolean _isRelationship;
                    EClass _eClass = supertype.getEClass();
                    _and_1 = _isRelationship = UMLElementTypes.this._uML.isRelationship(_eClass);
                }
                if (!_and_1) {
                    _and = false;
                } else {
                    boolean _canSourceTo;
                    EClass _eClass_1 = supertype.getEClass();
                    _and = _canSourceTo = UMLElementTypes.this.canSourceTo(sourceType, _eClass_1);
                }
                _xblockexpression = _and;
                return _xblockexpression;
            }
        };
        return IterableExtensions.exists((Iterable)_specializedTypesID, (Functions.Function1)_function);
    }

    private boolean canTargetFrom(final IElementType targetType, EClass relationshipEClass) {
        Iterable<EReference> _targetReferences = this._uML.getTargetReferences(relationshipEClass);
        Functions.Function1<EReference, Boolean> _function = new Functions.Function1<EReference, Boolean>(){

            public Boolean apply(EReference it) {
                EClass _eReferenceType = it.getEReferenceType();
                EClass _eClass = targetType.getEClass();
                return _eReferenceType.isSuperTypeOf(_eClass);
            }
        };
        return IterableExtensions.exists(_targetReferences, (Functions.Function1)_function);
    }

    private boolean canTargetFrom(ElementTypeConfiguration targetType, EClass relationshipEClass) {
        ElementTypeRegistry _instance = ElementTypeRegistry.getInstance();
        String _identifier = null;
        if (targetType != null) {
            _identifier = targetType.getIdentifier();
        }
        IElementType _type = _instance.getType(_identifier);
        boolean _canTargetFrom = false;
        if (_type != null) {
            _canTargetFrom = this.canTargetFrom(_type, relationshipEClass);
        }
        return _canTargetFrom;
    }

    protected boolean _canTargetFromType(ElementTypeConfiguration targetType, ElementTypeConfiguration relationshipTypeConfiguration) {
        return false;
    }

    protected boolean _canTargetFromType(ElementTypeConfiguration targetType, MetamodelTypeConfiguration relationshipTypeConfiguration) {
        EClass _eClass = relationshipTypeConfiguration.getEClass();
        return this.canTargetFrom(targetType, _eClass);
    }

    protected boolean _canTargetFromType(final ElementTypeConfiguration targetType, SpecializationTypeConfiguration relationshipTypeConfiguration) {
        EList _specializedTypesID = relationshipTypeConfiguration.getSpecializedTypesID();
        Functions.Function1<String, Boolean> _function = new Functions.Function1<String, Boolean>(){

            public Boolean apply(String supertypeID) {
                boolean _notEquals;
                boolean _xblockexpression = false;
                ElementTypeRegistry _instance = ElementTypeRegistry.getInstance();
                IElementType supertype = _instance.getType(supertypeID);
                boolean _and = false;
                boolean _and_1 = false;
                boolean bl = _notEquals = !Objects.equal((Object)supertype, null);
                if (!_notEquals) {
                    _and_1 = false;
                } else {
                    boolean _isRelationship;
                    EClass _eClass = supertype.getEClass();
                    _and_1 = _isRelationship = UMLElementTypes.this._uML.isRelationship(_eClass);
                }
                if (!_and_1) {
                    _and = false;
                } else {
                    boolean _canTargetFrom;
                    EClass _eClass_1 = supertype.getEClass();
                    _and = _canTargetFrom = UMLElementTypes.this.canTargetFrom(targetType, _eClass_1);
                }
                _xblockexpression = _and;
                return _xblockexpression;
            }
        };
        return IterableExtensions.exists((Iterable)_specializedTypesID, (Functions.Function1)_function);
    }

    public boolean canContainType(ElementTypeConfiguration containerType, ElementTypeConfiguration containedTypeConfiguration) {
        if (containedTypeConfiguration instanceof MetamodelTypeConfiguration) {
            return this._canContainType(containerType, (MetamodelTypeConfiguration)containedTypeConfiguration);
        }
        if (containedTypeConfiguration instanceof SpecializationTypeConfiguration) {
            return this._canContainType(containerType, (SpecializationTypeConfiguration)containedTypeConfiguration);
        }
        if (containedTypeConfiguration != null) {
            return this._canContainType(containerType, containedTypeConfiguration);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(containerType, containedTypeConfiguration).toString());
    }

    private EClass getMetaclass(Object elementType) {
        if (elementType instanceof MetamodelTypeConfiguration) {
            return this._getMetaclass((MetamodelTypeConfiguration)elementType);
        }
        if (elementType instanceof SpecializationTypeConfiguration) {
            return this._getMetaclass((SpecializationTypeConfiguration)elementType);
        }
        if (elementType instanceof ElementTypeConfiguration) {
            return this._getMetaclass((ElementTypeConfiguration)elementType);
        }
        if (elementType instanceof IMetamodelType) {
            return this._getMetaclass((IMetamodelType)elementType);
        }
        if (elementType instanceof ISpecializationType) {
            return this._getMetaclass((ISpecializationType)elementType);
        }
        if (elementType instanceof IElementType) {
            return this._getMetaclass((IElementType)elementType);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(elementType).toString());
    }

    public boolean canSourceToType(ElementTypeConfiguration sourceType, ElementTypeConfiguration relationshipTypeConfiguration) {
        if (relationshipTypeConfiguration instanceof MetamodelTypeConfiguration) {
            return this._canSourceToType(sourceType, (MetamodelTypeConfiguration)relationshipTypeConfiguration);
        }
        if (relationshipTypeConfiguration instanceof SpecializationTypeConfiguration) {
            return this._canSourceToType(sourceType, (SpecializationTypeConfiguration)relationshipTypeConfiguration);
        }
        if (relationshipTypeConfiguration != null) {
            return this._canSourceToType(sourceType, relationshipTypeConfiguration);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(sourceType, relationshipTypeConfiguration).toString());
    }

    public boolean canTargetFromType(ElementTypeConfiguration targetType, ElementTypeConfiguration relationshipTypeConfiguration) {
        if (relationshipTypeConfiguration instanceof MetamodelTypeConfiguration) {
            return this._canTargetFromType(targetType, (MetamodelTypeConfiguration)relationshipTypeConfiguration);
        }
        if (relationshipTypeConfiguration instanceof SpecializationTypeConfiguration) {
            return this._canTargetFromType(targetType, (SpecializationTypeConfiguration)relationshipTypeConfiguration);
        }
        if (relationshipTypeConfiguration != null) {
            return this._canTargetFromType(targetType, relationshipTypeConfiguration);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(targetType, relationshipTypeConfiguration).toString());
    }
}

