/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.apm.assurproj.assuranceproject.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.dawn.preferences.PreferenceConstants;
import org.eclipse.emf.cdo.dawn.ui.views.DawnExplorer;
import org.eclipse.emf.cdo.dawn.util.connection.CDOConnectionUtil;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.impl.DiagramImpl;
import org.eclipse.gmf.runtime.notation.impl.ShapeImpl;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.opencert.apm.assuranceassets.assuranceasset.AssuranceAssetEvent;
import org.eclipse.opencert.apm.assurproj.assuranceproject.AssetsPackage;
import org.eclipse.opencert.apm.assurproj.assuranceproject.AssuranceProject;
import org.eclipse.opencert.apm.assurproj.assuranceproject.AssuranceprojectFactory;
import org.eclipse.opencert.apm.assurproj.assuranceproject.AssuranceprojectPackage;
import org.eclipse.opencert.apm.assurproj.assuranceproject.BaselineConfig;
import org.eclipse.opencert.apm.assurproj.assuranceproject.utils.CheckboxTreeViewerExt;
import org.eclipse.opencert.apm.assurproj.assuranceproject.utils.DawnArgDiagramUtil;
import org.eclipse.opencert.apm.assurproj.assuranceproject.utils.ListAssuranceProject;
import org.eclipse.opencert.apm.baseline.baseline.BaseFramework;
import org.eclipse.opencert.evm.evidspec.evidence.ArtefactModel;
import org.eclipse.opencert.infra.mappings.mapping.MapGroup;
import org.eclipse.opencert.pam.procspec.process.ProcessModel;
import org.eclipse.opencert.sam.arg.arg.Case;
import org.eclipse.opencert.sam.arg.arg.ModelElement;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.PlatformUI;

public class CrossProjectUI
extends Dialog {
    private static final String EXTENSION_DIAGRAM = "_diagram";
    private Map<String, EObject> eIDToObjectMap = new HashMap<String, EObject>();
    protected ArrayList<String> sResult = null;
    private IEditorPart editor;
    private URI resourceURI;
    private CDOSession sessionCDO = null;
    private CDOResource resourceAPFrom = null;
    private AssuranceProject assuranceProjectFrom;
    private CDOResource resourceAPTarget = null;
    private AssuranceProject assuranceProjectTarget;
    private CDOResource artefactResource = null;
    private CDOView viewCDO = null;
    private CheckboxTreeViewerExt checktreeBaselineSource;
    private ResourceSet baselineSourceResourceSet;
    private ResourceSet evidenceSourceResourceSet;
    private CheckboxTreeViewerExt checktreeArgSource;
    private ResourceSet argSourceResourceSet;
    private CDOResource argResource = null;
    private CheckboxTreeViewerExt checktreeProcessSource;
    private ResourceSet processSourceResourceSet;
    private CDOResource processResource = null;
    private Text projectsourceText;
    private Label sourceLabel;
    private CheckboxTreeViewerExt checktreeEvidenceSource;
    private Label targetLabel;
    private Text projecttargetText;
    private Button checkBaseline;
    private Button checkArtefacts;
    private Button checkArguments;
    private Button checkProcess;
    private CDOTransaction transaction;
    private Map<EObject, EObject> map = new HashMap<EObject, EObject>();
    HashMap<Object, Object> options = new HashMap();
    private AssetsPackage targetAssetsPackage;
    protected AssuranceprojectPackage projectPackage = AssuranceprojectPackage.eINSTANCE;
    protected AssuranceprojectFactory projectFactory = this.projectPackage.getAssuranceprojectFactory();

    public CrossProjectUI(Shell parentShell) {
        super(parentShell);
        this.options.put("ENCODING", "UTF-8");
        this.editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        this.resourceURI = EditUIUtil.getURI((IEditorInput)this.editor.getEditorInput());
        CDOConnectionUtil.instance.init(PreferenceConstants.getRepositoryName(), PreferenceConstants.getProtocol(), PreferenceConstants.getServerName());
        this.sessionCDO = CDOConnectionUtil.instance.openSession();
        this.viewCDO = CDOConnectionUtil.instance.openView(this.sessionCDO);
        this.transaction = this.sessionCDO.openTransaction();
    }

    public CrossProjectUI(IShellProvider parentShell) {
        super(parentShell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button ok = this.getButton(0);
        ok.setText("Reuse");
        ok.setEnabled(false);
        this.setButtonLayoutData(ok);
        Button cancel = this.getButton(1);
        cancel.setText("Close");
        this.setButtonLayoutData(cancel);
    }

    protected Control createDialogArea(Composite parent) {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        Composite contents = (Composite)super.createDialogArea(parent);
        GridData contentsGridData = (GridData)contents.getLayoutData();
        contentsGridData.horizontalAlignment = 4;
        contentsGridData.verticalAlignment = 4;
        this.createSourceDialogArea(contents, adapterFactory);
        return contents;
    }

    protected void createSourceDialogArea(Composite contents, ComposedAdapterFactory adapterFactory) {
        Composite sourceComposite = new Composite(contents, 0);
        GridData data = new GridData(4, 4, false, true);
        data.horizontalAlignment = 0x1000008;
        data.horizontalAlignment = 4;
        sourceComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 10;
        sourceComposite.setLayout((Layout)layout);
        final Composite compositeSourceProject = new Composite(sourceComposite, 0);
        GridData dataNew = new GridData(4, 4, false, true);
        dataNew.horizontalAlignment = 0x1000008;
        compositeSourceProject.setLayoutData((Object)dataNew);
        GridLayout layoutNew = new GridLayout();
        dataNew.horizontalAlignment = 4;
        layoutNew.marginHeight = 0;
        layoutNew.marginWidth = 0;
        layoutNew.numColumns = 2;
        compositeSourceProject.setLayout((Layout)layoutNew);
        this.targetLabel = new Label(compositeSourceProject, 0);
        this.targetLabel.setText("Target Project:");
        GridData targetLabelGridData = new GridData();
        targetLabelGridData.horizontalAlignment = 4;
        targetLabelGridData.verticalAlignment = 4;
        this.targetLabel.setLayoutData((Object)targetLabelGridData);
        this.projecttargetText = new Text(compositeSourceProject, 0);
        GridData nameTextGridData = new GridData();
        nameTextGridData.grabExcessHorizontalSpace = true;
        nameTextGridData.minimumWidth = 50;
        nameTextGridData.horizontalAlignment = 4;
        nameTextGridData.verticalAlignment = 4;
        this.projecttargetText.setLayoutData((Object)nameTextGridData);
        String path = "";
        int i = 0;
        while (i < this.resourceURI.segmentCount()) {
            path = String.valueOf(path) + this.resourceURI.segment(i) + "/";
            ++i;
        }
        path = path.substring(0, path.length() - 1);
        this.projecttargetText.setText(path);
        this.projecttargetText.setEditable(false);
        this.sourceLabel = new Label(compositeSourceProject, 0);
        this.sourceLabel.setText("Source Project:");
        GridData sourceLabelGridData = new GridData();
        sourceLabelGridData.horizontalAlignment = 4;
        sourceLabelGridData.verticalAlignment = 4;
        this.sourceLabel.setLayoutData((Object)sourceLabelGridData);
        this.projectsourceText = new Text(compositeSourceProject, 0);
        this.projectsourceText.setLayoutData((Object)nameTextGridData);
        this.projectsourceText.setEditable(false);
        Button selectSourceProject = new Button(compositeSourceProject, 0);
        selectSourceProject.setText("Search...");
        GridData NewGroupMapGridData = new GridData();
        NewGroupMapGridData.verticalAlignment = 1;
        NewGroupMapGridData.horizontalAlignment = 4;
        selectSourceProject.setLayoutData((Object)NewGroupMapGridData);
        selectSourceProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListAssuranceProject listAssuranceProject = new ListAssuranceProject(compositeSourceProject.getShell(), CrossProjectUI.this.sessionCDO);
                if (listAssuranceProject.open() == 0) {
                    CrossProjectUI.this.sResult = new ArrayList();
                    CrossProjectUI.this.sResult.add(listAssuranceProject.getResult().get(0));
                    CrossProjectUI.this.sResult.add(listAssuranceProject.getResult().get(1));
                    CrossProjectUI.this.projectsourceText.setText(listAssuranceProject.getResult().get(1));
                    try {
                        CrossProjectUI.this.resourceAPFrom = CrossProjectUI.this.viewCDO.getResource(CrossProjectUI.this.sResult.get(1));
                        CrossProjectUI.this.resourceAPTarget = CrossProjectUI.this.transaction.getResource(CrossProjectUI.this.projecttargetText.getText());
                        CrossProjectUI.this.assuranceProjectFrom = (AssuranceProject)CrossProjectUI.this.resourceAPFrom.getContents().get(0);
                        CrossProjectUI.this.assuranceProjectTarget = (AssuranceProject)CrossProjectUI.this.resourceAPTarget.getContents().get(0);
                        EList lstBaselineConfig = CrossProjectUI.this.assuranceProjectFrom.getBaselineConfig();
                        Iterator baselineConfig = lstBaselineConfig.iterator();
                        CrossProjectUI.this.baselineSourceResourceSet = (ResourceSet)new ResourceSetImpl();
                        boolean bFind = false;
                        while (baselineConfig.hasNext() && !bFind) {
                            BaselineConfig bconfig = (BaselineConfig)baselineConfig.next();
                            if (!bconfig.isIsActive()) continue;
                            bFind = true;
                            EList lstBaseFramework = bconfig.getRefFramework();
                            for (BaseFramework baseFramework : lstBaseFramework) {
                                CrossProjectUI.this.baselineSourceResourceSet.getResources().add((Object)baseFramework.eResource());
                            }
                            CrossProjectUI.this.CreateModelFromResourceSet((TreeViewer)CrossProjectUI.this.checktreeBaselineSource, CrossProjectUI.this.baselineSourceResourceSet);
                            CrossProjectUI.this.checktreeBaselineSource.expandAll();
                        }
                        EList lstAssetsPackage = CrossProjectUI.this.assuranceProjectFrom.getAssetsPackage();
                        Iterator assetsPackage = lstAssetsPackage.iterator();
                        CrossProjectUI.this.evidenceSourceResourceSet = (ResourceSet)new ResourceSetImpl();
                        AssetsPackage aPackage = null;
                        bFind = false;
                        while (assetsPackage.hasNext() && !bFind) {
                            aPackage = (AssetsPackage)assetsPackage.next();
                            if (!aPackage.isIsActive()) continue;
                            bFind = true;
                            EList lstArtefactModel = aPackage.getArtefactsModel();
                            for (ArtefactModel artefact : lstArtefactModel) {
                                CrossProjectUI.this.artefactResource = CDOUtil.getCDOObject((EObject)artefact).cdoResource();
                                CrossProjectUI.this.evidenceSourceResourceSet.getResources().add((Object)CrossProjectUI.this.artefactResource);
                            }
                            CrossProjectUI.this.CreateModelFromResourceSet((TreeViewer)CrossProjectUI.this.checktreeEvidenceSource, CrossProjectUI.this.evidenceSourceResourceSet);
                            CrossProjectUI.this.checktreeEvidenceSource.expandAll();
                        }
                        CrossProjectUI.this.argSourceResourceSet = (ResourceSet)new ResourceSetImpl();
                        EList lstArgModel = aPackage.getArgumentationModel();
                        for (Case argRoot : lstArgModel) {
                            CrossProjectUI.this.argResource = CDOUtil.getCDOObject((EObject)argRoot).cdoResource();
                            CrossProjectUI.this.argSourceResourceSet.getResources().add((Object)CrossProjectUI.this.argResource);
                        }
                        CrossProjectUI.this.CreateModelFromResourceSet((TreeViewer)CrossProjectUI.this.checktreeArgSource, CrossProjectUI.this.argSourceResourceSet);
                        CrossProjectUI.this.checktreeArgSource.expandAll();
                        CrossProjectUI.this.processSourceResourceSet = (ResourceSet)new ResourceSetImpl();
                        EList lstProcessModel = aPackage.getProcessModel();
                        for (ProcessModel processRoot : lstProcessModel) {
                            CrossProjectUI.this.processResource = CDOUtil.getCDOObject((EObject)processRoot).cdoResource();
                            CrossProjectUI.this.processSourceResourceSet.getResources().add((Object)CrossProjectUI.this.processResource);
                        }
                        CrossProjectUI.this.CreateModelFromResourceSet((TreeViewer)CrossProjectUI.this.checktreeProcessSource, CrossProjectUI.this.processSourceResourceSet);
                        CrossProjectUI.this.checktreeProcessSource.expandAll();
                        CrossProjectUI.this.getButton(0).setEnabled(true);
                        CrossProjectUI.this.checkBaseline.setSelection(true);
                        CrossProjectUI.this.defaultSelection();
                    }
                    catch (CDOException cdoe) {
                        cdoe.printStackTrace();
                    }
                }
            }
        });
        Label dummy = new Label(compositeSourceProject, 0);
        dummy.setText("");
        this.checkBaseline = new Button(compositeSourceProject, 32);
        this.checkBaseline.setText("Copy Baseline models");
        this.checkBaseline.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Widget widget = e.widget;
                if (widget instanceof Button) {
                    Button button = (Button)widget;
                    if (button.getSelection()) {
                        CrossProjectUI.this.defaultSelection();
                    } else {
                        TreeItem root;
                        TreeItem[] treeItemArray = CrossProjectUI.this.checktreeBaselineSource.getTree().getItems();
                        int n = treeItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            root = treeItemArray[n2];
                            root.setChecked(false);
                            ++n2;
                        }
                        CrossProjectUI.this.checktreeBaselineSource.getTree().setEnabled(false);
                        CrossProjectUI.this.checkArtefacts.setSelection(true);
                        CrossProjectUI.this.checkArtefacts.setEnabled(true);
                        treeItemArray = CrossProjectUI.this.checktreeEvidenceSource.getTree().getItems();
                        n = treeItemArray.length;
                        n2 = 0;
                        while (n2 < n) {
                            root = treeItemArray[n2];
                            root.setChecked(true);
                            ++n2;
                        }
                        CrossProjectUI.this.checktreeEvidenceSource.getTree().setEnabled(true);
                        CrossProjectUI.this.checkArguments.setSelection(false);
                        CrossProjectUI.this.checkArguments.setEnabled(false);
                        treeItemArray = CrossProjectUI.this.checktreeArgSource.getTree().getItems();
                        n = treeItemArray.length;
                        n2 = 0;
                        while (n2 < n) {
                            root = treeItemArray[n2];
                            root.setChecked(false);
                            ++n2;
                        }
                        CrossProjectUI.this.checktreeArgSource.getTree().setEnabled(false);
                        CrossProjectUI.this.checkProcess.setSelection(false);
                        CrossProjectUI.this.checkProcess.setEnabled(false);
                        treeItemArray = CrossProjectUI.this.checktreeProcessSource.getTree().getItems();
                        n = treeItemArray.length;
                        n2 = 0;
                        while (n2 < n) {
                            root = treeItemArray[n2];
                            root.setChecked(false);
                            ++n2;
                        }
                        CrossProjectUI.this.checktreeProcessSource.getTree().setEnabled(false);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.checkBaseline.setEnabled(true);
        GridData modelViewerGridData = new GridData();
        modelViewerGridData.verticalAlignment = 4;
        modelViewerGridData.horizontalAlignment = 4;
        modelViewerGridData.widthHint = 400;
        modelViewerGridData.grabExcessHorizontalSpace = true;
        modelViewerGridData.grabExcessVerticalSpace = true;
        this.checktreeBaselineSource = new CheckboxTreeViewerExt(compositeSourceProject, 2816);
        this.checktreeBaselineSource.getTree().setLayoutData((Object)modelViewerGridData);
        this.checktreeBaselineSource.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        this.checktreeBaselineSource.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        this.checktreeBaselineSource.expandAll();
        this.checktreeBaselineSource.getTree().setEnabled(false);
        this.checkArtefacts = new Button(compositeSourceProject, 32);
        this.checkArtefacts.setText("Copy Evidence Models");
        this.checkArtefacts.setSelection(false);
        this.checkArtefacts.setEnabled(true);
        this.checktreeEvidenceSource = new CheckboxTreeViewerExt(compositeSourceProject, 2820);
        this.checktreeEvidenceSource.getTree().setLayoutData((Object)modelViewerGridData);
        this.checktreeEvidenceSource.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        this.checktreeEvidenceSource.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        this.checktreeEvidenceSource.getTree().setEnabled(false);
        this.checkArguments = new Button(compositeSourceProject, 32);
        this.checkArguments.setText("Copy Argumentation Models");
        this.checkArguments.setSelection(false);
        this.checkArguments.setEnabled(false);
        this.checktreeArgSource = new CheckboxTreeViewerExt(compositeSourceProject, 2820);
        this.checktreeArgSource.getTree().setLayoutData((Object)modelViewerGridData);
        this.checktreeArgSource.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        this.checktreeArgSource.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        this.checktreeArgSource.getTree().setEnabled(false);
        this.checkProcess = new Button(compositeSourceProject, 32);
        this.checkProcess.setText("Copy Process Models");
        this.checkProcess.setSelection(false);
        this.checkProcess.setEnabled(false);
        this.checktreeProcessSource = new CheckboxTreeViewerExt(compositeSourceProject, 2820);
        this.checktreeProcessSource.getTree().setLayoutData((Object)modelViewerGridData);
        this.checktreeProcessSource.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)adapterFactory));
        this.checktreeProcessSource.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory));
        this.checktreeProcessSource.getTree().setEnabled(false);
    }

    public void CreateModelFromResourceSet(TreeViewer tree, ResourceSet resourceSet) {
        try {
            tree.setInput((Object)resourceSet);
            ViewerFilter modelFilter = new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return element instanceof CDOResource;
                }
            };
            tree.addFilter(modelFilter);
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Not valid model file", (String)"The provided model file couldn't be parsed as an EMF resource");
            tree.setInput(null);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Cross Project");
    }

    protected void okPressed() {
        boolean allOK = true;
        if (this.projectsourceText.getText().length() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Selected Source Project", (String)"You must select the source project of the reuse.");
            return;
        }
        EList lstAssetsPackage = this.assuranceProjectTarget.getAssetsPackage();
        for (AssetsPackage this.targetAssetsPackage : lstAssetsPackage) {
            if (this.targetAssetsPackage.isIsActive()) break;
        }
        if (this.checkBaseline.getSelection()) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)"Changes to target Assurance Project", (String)"The model will be copied and related to a new Asset Package and Baseline Configuration that will be set up as the active ones.");
            AssetsPackage newAP = this.projectFactory.createAssetsPackage();
            newAP.setId("" + this.assuranceProjectTarget.getAssetsPackage().size());
            newAP.setName("AP_" + this.assuranceProjectTarget.getAssetsPackage().size());
            newAP.setDescription("Created automatically for Cross Project Reuse");
            newAP.setIsActive(true);
            this.assuranceProjectTarget.getAssetsPackage().add((Object)newAP);
            this.targetAssetsPackage.setIsActive(false);
            this.targetAssetsPackage = newAP;
            BaselineConfig newBC = this.projectFactory.createBaselineConfig();
            newBC.setId("" + this.assuranceProjectTarget.getBaselineConfig().size());
            newBC.setName("AP_" + this.assuranceProjectTarget.getBaselineConfig().size());
            newBC.setDescription("Created automatically for Cross Project Reuse");
            EList lstBC = this.assuranceProjectTarget.getBaselineConfig();
            for (BaselineConfig oneBC : lstBC) {
                if (!oneBC.isIsActive()) continue;
                oneBC.setIsActive(false);
            }
            newBC.setIsActive(true);
            this.assuranceProjectTarget.getBaselineConfig().add((Object)newBC);
            if (allOK) {
                allOK = this.copyEvidences();
            }
            if (allOK) {
                allOK = this.copyArgumentations();
            }
            if (allOK) {
                allOK = this.copyProcesses();
            }
            if (allOK) {
                allOK = this.copyMaps();
            }
            if (allOK) {
                allOK = this.copyBaselines(newBC);
            }
        } else {
            if (this.checktreeEvidenceSource.getTree().getItemCount() == 0) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Wrong Source Project", (String)"The selected source project doesn't have evidence model.");
                return;
            }
            allOK = this.copyEvidences();
        }
        if (allOK) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Reuse success", (String)"Selected models reused");
        }
    }

    private boolean copyMaps() {
        String sourcePath = this.projectsourceText.getText();
        String[] pathParts = sourcePath.split("/");
        String projectFolder = String.valueOf(pathParts[0]) + "/" + pathParts[1] + "/" + pathParts[2];
        CDOResourceFolder folder = this.transaction.getResourceFolder(projectFolder);
        EList contents = null;
        if (folder instanceof CDOResourceFolder) {
            contents = folder.getNodes();
        }
        int x = 0;
        while (x < contents.size()) {
            CDOResourceNode oneNode = (CDOResourceNode)contents.get(x);
            if (oneNode instanceof CDOResource && oneNode.getName().endsWith("mapping")) {
                CDOResource sourceResource = (CDOResource)oneNode;
                String projectPath = this.projecttargetText.getText();
                pathParts = projectPath.split("/");
                String targetPath = String.valueOf(pathParts[0]) + "/" + pathParts[1] + "/" + oneNode.getName();
                targetPath = this.createNotExistingName(targetPath);
                CDOResource targetResource = this.transaction.createResource(targetPath);
                this.initCopy(sourceResource, targetResource);
                try {
                    targetResource.save(this.options);
                }
                catch (Exception e) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"Mapping reuse failed", (String)("Error copying model " + targetPath));
                    e.printStackTrace();
                    this.transaction.rollback();
                    return false;
                }
            }
            ++x;
        }
        return true;
    }

    private boolean copyBaselines(BaselineConfig bconfigActive) {
        Object[] baselines = this.checktreeBaselineSource.getCheckedElements();
        String projectPath = this.projecttargetText.getText();
        String[] pathParts = projectPath.split("/");
        int x = 0;
        while (x < baselines.length) {
            CDOResource sourceResource = (CDOResource)baselines[x];
            String targetPath = String.valueOf(pathParts[0]) + "/" + pathParts[1] + "/" + sourceResource.getName();
            targetPath = this.createNotExistingName(targetPath);
            CDOResource targetResource = this.transaction.createResource(targetPath);
            this.initCopy(sourceResource, targetResource);
            try {
                targetResource.save(this.options);
                bconfigActive.getRefFramework().add((Object)((BaseFramework)targetResource.getContents().get(0)));
                this.resourceAPTarget.save(this.options);
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Baseline reuse failed", (String)("Error copying model " + targetPath));
                e.printStackTrace();
                this.transaction.rollback();
                return false;
            }
            ++x;
        }
        return true;
    }

    private boolean copyEvidences() {
        Object[] evidences = this.checktreeEvidenceSource.getCheckedElements();
        String projectPath = this.projecttargetText.getText();
        String[] pathParts = projectPath.split("/");
        int x = 0;
        while (x < evidences.length) {
            CDOResource sourceResource = (CDOResource)evidences[x];
            String targetPath = String.valueOf(pathParts[0]) + "/" + "EVIDENCE/" + sourceResource.getName();
            targetPath = this.createNotExistingName(targetPath);
            CDOResource targetResource = this.transaction.createResource(targetPath);
            this.initCopy(sourceResource, targetResource);
            try {
                targetResource.save(this.options);
                this.targetAssetsPackage.getArtefactsModel().add((Object)((ArtefactModel)targetResource.getContents().get(0)));
                this.resourceAPTarget.save(this.options);
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Evidence reuse failed", (String)("Error copying model " + targetPath));
                e.printStackTrace();
                this.transaction.rollback();
                return false;
            }
            ++x;
        }
        return true;
    }

    private String createNotExistingName(String targetPath) {
        if (this.viewCDO.hasResource(targetPath)) {
            String[] tokens = targetPath.split("/");
            String[] nameTokes = tokens[2].split("\\.");
            String modelName = nameTokes[0];
            String modelType = nameTokes[1];
            char lastchar = modelName.charAt(modelName.length() - 1);
            char prevlastchar = modelName.charAt(modelName.length() - 2);
            if (Character.isDigit(prevlastchar) && Character.isDigit(lastchar)) {
                int number = Integer.parseInt("" + prevlastchar + lastchar);
                modelName = String.valueOf(modelName.substring(0, modelName.length() - 2)) + ++number;
            } else if (Character.isDigit(lastchar)) {
                int number = Integer.parseInt("" + lastchar);
                modelName = String.valueOf(modelName.substring(0, modelName.length() - 1)) + ++number;
            } else {
                modelName = String.valueOf(modelName) + "1";
            }
            targetPath = String.valueOf(tokens[0]) + "/" + tokens[1] + "/" + modelName + "." + modelType;
            targetPath = this.createNotExistingName(targetPath);
        }
        return targetPath;
    }

    private List<CDOResource> getDiagramsFromModel(CDOResource modelCDO) {
        ArrayList<CDOResource> res = new ArrayList<CDOResource>();
        String temp = modelCDO.getPath();
        String sourceFolderPath = temp.substring(0, temp.lastIndexOf("/"));
        CDOResourceFolder argFolder = this.transaction.getResourceFolder(sourceFolderPath);
        EList listN = argFolder.getNodes();
        for (CDOResourceNode node : listN) {
            EObject model;
            CDOResource elem;
            if (node instanceof CDOResourceFolder) {
                System.out.println("getDiagramsFromModel: found subfolder =." + node.toString());
                List<CDOResource> res2 = this.getDiagramsFromModel((CDOResource)node);
                res.addAll(res2);
                continue;
            }
            if (!(node instanceof CDOResource) || !(elem = (CDOResource)node).getPath().contains(EXTENSION_DIAGRAM) || (model = ((DiagramImpl)elem.getContents().get(0)).basicGetElement()).eResource().getURI() != modelCDO.getURI()) continue;
            res.add((CDOResource)((EObject)elem.getContents().get(0)).eResource());
        }
        return res;
    }

    private boolean copyArgumentations() {
        Object[] argumentations = this.checktreeArgSource.getCheckedElements();
        String projectPath = this.projecttargetText.getText();
        String[] pathParts = projectPath.split("/");
        IProgressMonitor monitor = null;
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        if (argumentations.length > 0) {
            dialog.open();
            monitor = dialog.getProgressMonitor();
            String CREATE_ARG_DIAGRAM = "Create Cross Arg diagram";
            monitor.beginTask(CREATE_ARG_DIAGRAM, 20);
        }
        int x = 0;
        while (x < argumentations.length) {
            CDOResource sourceResource = (CDOResource)argumentations[x];
            String targetPath = String.valueOf(pathParts[0]) + "/" + "ARGUMENTATION/" + sourceResource.getName();
            String targetFolderPath = String.valueOf(pathParts[0]) + "/" + "ARGUMENTATION";
            targetPath = this.createNotExistingName(targetPath);
            CDOResource targetResource = this.transaction.createResource(targetPath);
            this.initCopy(sourceResource, targetResource);
            try {
                targetResource.save(this.options);
                List<CDOResource> listDiagrams = this.getDiagramsFromModel(sourceResource);
                for (CDOResource sourceDiagramResource : listDiagrams) {
                    EList listRootObjectsSource = ((Diagram)sourceDiagramResource.getContents().get(0)).getPersistedChildren();
                    ArrayList<EObject> listRootObjects = new ArrayList<EObject>();
                    for (EObject element : listRootObjectsSource) {
                        EObject objsource = ((ShapeImpl)element).getElement();
                        CDOID cdoID = CDOUtil.getCDOObject((EObject)objsource).cdoID();
                        new Long(cdoID.toURIFragment());
                        EObject obj = this.eIDToObjectMap.get(cdoID.toString());
                        listRootObjects.add(obj);
                    }
                    CDOResourceFolder argFolder = this.transaction.getResourceFolder(targetFolderPath);
                    String targetDiagram = String.valueOf(targetPath.substring(0, targetPath.lastIndexOf("/") + 1)) + sourceDiagramResource.getName();
                    targetDiagram = this.createNotExistingName(targetDiagram);
                    CDOResource targetDiagramResource = this.transaction.getOrCreateResource(targetDiagram);
                    DawnArgDiagramUtil myDiagram = new DawnArgDiagramUtil(sourceDiagramResource, listRootObjects, targetResource.getURI(), targetDiagramResource.getURI(), argFolder, this.transaction);
                    myDiagram.generateDiagram(monitor);
                }
                Set conf = this.transaction.getConflicts();
                for (CDOObject nextObject : conf) {
                    System.out.println("copyArgumentations: confict " + nextObject.toString());
                }
                this.transaction.commit();
                this.targetAssetsPackage.getArgumentationModel().add((Object)((Case)targetResource.getContents().get(0)));
                this.resourceAPTarget.save(this.options);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Argumentation reuse failed", (String)("Error copying model " + targetPath));
                e.printStackTrace();
                this.transaction.rollback();
                if (argumentations.length > 0) {
                    dialog.close();
                }
                return false;
            }
            ++x;
        }
        if (argumentations.length > 0) {
            dialog.close();
        }
        return true;
    }

    private boolean copyProcesses() {
        Object[] processes = this.checktreeProcessSource.getCheckedElements();
        String projectPath = this.projecttargetText.getText();
        String[] pathParts = projectPath.split("/");
        int x = 0;
        while (x < processes.length) {
            CDOResource sourceResource = (CDOResource)processes[x];
            String targetPath = String.valueOf(pathParts[0]) + "/" + "PROCESSES/" + sourceResource.getName();
            targetPath = this.createNotExistingName(targetPath);
            CDOResource targetResource = this.transaction.createResource(targetPath);
            this.initCopy(sourceResource, targetResource);
            try {
                targetResource.save(this.options);
                this.targetAssetsPackage.getProcessModel().add((Object)((ProcessModel)targetResource.getContents().get(0)));
                this.resourceAPTarget.save(this.options);
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Process reuse failed", (String)("Error copying model " + targetPath));
                e.printStackTrace();
                this.transaction.rollback();
                return false;
            }
            ++x;
        }
        return true;
    }

    private void initCopy(CDOResource sourceResource, CDOResource targetResource) {
        for (EObject aEObject : sourceResource.getContents()) {
            targetResource.getContents().add((Object)this.getCorrespondingEObject(aEObject));
        }
        TreeIterator iterator = sourceResource.getAllContents();
        while (iterator.hasNext()) {
            EObject aEObject = (EObject)iterator.next();
            if (aEObject instanceof AssuranceAssetEvent) continue;
            EObject bEObject = this.getCorrespondingEObject(aEObject);
            this.copyAEObjectToBEObject(aEObject, bEObject);
            if (!(aEObject instanceof ModelElement)) continue;
            CDOID cdoID = CDOUtil.getCDOObject((EObject)aEObject).cdoID();
            new Long(cdoID.toURIFragment());
            this.eIDToObjectMap.put(cdoID.toString(), bEObject);
        }
    }

    public boolean close() {
        DawnExplorer repoView = null;
        IViewReference[] viewReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getViewReferences();
        int i = 0;
        while (i < viewReferences.length) {
            if ("org.eclipse.emf.cdo.dawn.ui.views.DawnExplorer".equals(viewReferences[i].getId())) {
                repoView = (DawnExplorer)viewReferences[i].getView(false);
                repoView.refreshViewer(false);
                break;
            }
            ++i;
        }
        if (!this.transaction.isClosed()) {
            this.transaction.close();
        }
        return super.close();
    }

    private EObject getCorrespondingEObject(EObject aEObject) {
        EObject bEObject = this.map.get(aEObject);
        if (bEObject == null) {
            if (aEObject instanceof MapGroup) {
                for (EObject key : this.map.keySet()) {
                    if (!(key instanceof MapGroup) || CDOUtil.getCDOObject((EObject)key).cdoID() != CDOUtil.getCDOObject((EObject)aEObject).cdoID()) continue;
                    return this.map.get(key);
                }
            }
            EClass aEClass = aEObject.eClass();
            bEObject = EcoreUtil.create((EClass)aEClass);
            this.map.put(aEObject, bEObject);
        }
        return bEObject;
    }

    private void copyAEObjectToBEObject(EObject aEObject, EObject bEObject) {
        for (EStructuralFeature aFeature : aEObject.eClass().getEAllStructuralFeatures()) {
            EObject copy;
            EStructuralFeature bFeature;
            if (!aEObject.eIsSet(aFeature) || (bFeature = bEObject.eClass().getEStructuralFeature(aFeature.getName())) == null) continue;
            if (aFeature instanceof EAttribute) {
                bEObject.eSet(bFeature, aEObject.eGet(aFeature));
                continue;
            }
            if (aEObject.eClass().getName().equals("BaseEquivalenceMap") && aFeature.getName().equals("target")) {
                bEObject.eSet(bFeature, aEObject.eGet(aFeature));
                continue;
            }
            if (aFeature.getName().equals("refFramework") || aFeature.getName().equals("refAssurableElement")) {
                bEObject.eSet(bFeature, aEObject.eGet(aFeature));
                continue;
            }
            if (aFeature.getName().equals("mapGroup")) {
                if (aEObject.eClass().getName().equals("BaseComplianceMap")) {
                    copy = this.getCorrespondingEObject((EObject)aEObject.eGet(aFeature));
                    bEObject.eSet(bFeature, (Object)copy);
                    continue;
                }
                bEObject.eSet(bFeature, aEObject.eGet(aFeature));
                continue;
            }
            if (aFeature.getName().equals("lifecycleEvent")) continue;
            if (aEObject.eGet(aFeature) instanceof EList) {
                EList aList = (EList)aEObject.eGet(aFeature);
                BasicEList bList = new BasicEList();
                int i = 0;
                while (i < aList.size()) {
                    bList.add((Object)this.getCorrespondingEObject((EObject)aList.get(i)));
                    ++i;
                }
                bEObject.eSet(bFeature, (Object)bList);
                continue;
            }
            copy = this.getCorrespondingEObject((EObject)aEObject.eGet(aFeature));
            bEObject.eSet(bFeature, (Object)copy);
        }
    }

    private void defaultSelection() {
        TreeItem root;
        TreeItem[] treeItemArray = this.checktreeBaselineSource.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            root = treeItemArray[n2];
            root.setChecked(true);
            ++n2;
        }
        this.checktreeBaselineSource.getTree().setEnabled(false);
        this.checkArtefacts.setSelection(true);
        this.checkArtefacts.setEnabled(false);
        treeItemArray = this.checktreeEvidenceSource.getTree().getItems();
        n = treeItemArray.length;
        n2 = 0;
        while (n2 < n) {
            root = treeItemArray[n2];
            root.setChecked(true);
            ++n2;
        }
        this.checktreeEvidenceSource.getTree().setEnabled(false);
        this.checkArguments.setSelection(true);
        this.checkArguments.setEnabled(false);
        treeItemArray = this.checktreeArgSource.getTree().getItems();
        n = treeItemArray.length;
        n2 = 0;
        while (n2 < n) {
            root = treeItemArray[n2];
            root.setChecked(true);
            ++n2;
        }
        this.checktreeArgSource.getTree().setEnabled(false);
        this.checkProcess.setSelection(true);
        this.checkProcess.setEnabled(false);
        treeItemArray = this.checktreeProcessSource.getTree().getItems();
        n = treeItemArray.length;
        n2 = 0;
        while (n2 < n) {
            root = treeItemArray[n2];
            root.setChecked(true);
            ++n2;
        }
        this.checktreeProcessSource.getTree().setEnabled(false);
    }
}

