/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.storage.cdo.session;

import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.opencert.storage.cdo.StandaloneCDOAccessor;
import org.eclipse.opencert.storage.cdo.property.OpencertPropertiesReader;
import org.eclipse.opencert.storage.cdo.session.ICDOSessionProvider;

public class ThreadLocalCDOSessionProvider
implements ICDOSessionProvider {
    private static final ThreadLocal<CDOSession> threadLocalCDOSessionHolder = new ThreadLocal();

    @Override
    public CDOSession getActiveSession() {
        CDOSession cdoSession = threadLocalCDOSessionHolder.get();
        if (cdoSession == null) {
            StandaloneCDOAccessor standaloneCDOAccessor = StandaloneCDOAccessor.getStandaloneCDOAccessor(OpencertPropertiesReader.getInstance());
            cdoSession = standaloneCDOAccessor.openSession();
            System.out.println("CDOSession created: " + cdoSession.getSessionID());
            threadLocalCDOSessionHolder.set(cdoSession);
        }
        return cdoSession;
    }

    @Override
    public void close() {
        CDOSession cdoSession = threadLocalCDOSessionHolder.get();
        if (cdoSession != null) {
            System.out.println("CDOSession closed: " + cdoSession.getSessionID());
            cdoSession.close();
            threadLocalCDOSessionHolder.set(null);
        }
    }
}

