/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.opencert.infra.properties.property.components;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.eef.runtime.api.notify.EStructuralFeatureNotificationFilter;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionEvent;
import org.eclipse.emf.eef.runtime.api.notify.NotificationFilter;
import org.eclipse.emf.eef.runtime.context.PropertiesEditingContext;
import org.eclipse.emf.eef.runtime.impl.components.SinglePartPropertiesEditingComponent;
import org.eclipse.emf.eef.runtime.impl.utils.EEFConverterUtil;
import org.eclipse.emf.eef.runtime.impl.utils.EEFUtils;
import org.eclipse.opencert.infra.general.general.GeneralPackage;
import org.eclipse.opencert.infra.properties.property.DataTypeKind;
import org.eclipse.opencert.infra.properties.property.Property;
import org.eclipse.opencert.infra.properties.property.PropertyPackage;
import org.eclipse.opencert.infra.properties.property.parts.PropertyPropertiesEditionPart;
import org.eclipse.opencert.infra.properties.property.parts.PropertyViewsRepository;

public class PropertyPropertiesEditionComponent
extends SinglePartPropertiesEditingComponent {
    public static String BASE_PART = "Base";

    public PropertyPropertiesEditionComponent(PropertiesEditingContext editingContext, EObject property, String editing_mode) {
        super(editingContext, property, editing_mode);
        this.parts = new String[]{BASE_PART};
        this.repositoryKey = PropertyViewsRepository.class;
        this.partKey = PropertyViewsRepository.Property_.class;
    }

    public void initPart(Object key, int kind, EObject elt, ResourceSet allResource) {
        this.setInitializing(true);
        if (this.editingPart != null && key == this.partKey) {
            this.editingPart.setContext(elt, allResource);
            Property property = (Property)elt;
            PropertyPropertiesEditionPart basePart = (PropertyPropertiesEditionPart)this.editingPart;
            if (this.isAccessible(PropertyViewsRepository.Property_.Properties.id)) {
                basePart.setId(EEFConverterUtil.convertToString((EDataType)EcorePackage.Literals.ESTRING, (Object)property.getId()));
            }
            if (this.isAccessible(PropertyViewsRepository.Property_.Properties.name)) {
                basePart.setName(EEFConverterUtil.convertToString((EDataType)EcorePackage.Literals.ESTRING, (Object)property.getName()));
            }
            if (this.isAccessible(PropertyViewsRepository.Property_.Properties.datatype)) {
                basePart.initDatatype(EEFUtils.choiceOfValues((EObject)property, (EStructuralFeature)PropertyPackage.eINSTANCE.getProperty_Datatype()), (Enumerator)property.getDatatype());
            }
            if (this.isAccessible(PropertyViewsRepository.Property_.Properties.enumValues)) {
                basePart.setEnumValues(property.getEnumValues());
            }
            if (this.isAccessible(PropertyViewsRepository.Property_.Properties.unit)) {
                basePart.setUnit(EEFConverterUtil.convertToString((EDataType)EcorePackage.Literals.ESTRING, (Object)property.getUnit()));
            }
        }
        this.setInitializing(false);
    }

    public EStructuralFeature associatedFeature(Object editorKey) {
        if (editorKey == PropertyViewsRepository.Property_.Properties.id) {
            return GeneralPackage.eINSTANCE.getNamedElement_Id();
        }
        if (editorKey == PropertyViewsRepository.Property_.Properties.name) {
            return GeneralPackage.eINSTANCE.getNamedElement_Name();
        }
        if (editorKey == PropertyViewsRepository.Property_.Properties.datatype) {
            return PropertyPackage.eINSTANCE.getProperty_Datatype();
        }
        if (editorKey == PropertyViewsRepository.Property_.Properties.enumValues) {
            return PropertyPackage.eINSTANCE.getProperty_EnumValues();
        }
        if (editorKey == PropertyViewsRepository.Property_.Properties.unit) {
            return PropertyPackage.eINSTANCE.getProperty_Unit();
        }
        return super.associatedFeature(editorKey);
    }

    public void updateSemanticModel(IPropertiesEditionEvent event) {
        Property property = (Property)this.semanticObject;
        if (PropertyViewsRepository.Property_.Properties.id == event.getAffectedEditor()) {
            property.setId((String)EEFConverterUtil.createFromString((EDataType)EcorePackage.Literals.ESTRING, (String)((String)event.getNewValue())));
        }
        if (PropertyViewsRepository.Property_.Properties.name == event.getAffectedEditor()) {
            property.setName((String)EEFConverterUtil.createFromString((EDataType)EcorePackage.Literals.ESTRING, (String)((String)event.getNewValue())));
        }
        if (PropertyViewsRepository.Property_.Properties.datatype == event.getAffectedEditor()) {
            property.setDatatype((DataTypeKind)event.getNewValue());
        }
        if (PropertyViewsRepository.Property_.Properties.enumValues == event.getAffectedEditor() && event.getKind() == 1) {
            property.getEnumValues().clear();
            property.getEnumValues().addAll((Collection)((EList)event.getNewValue()));
        }
        if (PropertyViewsRepository.Property_.Properties.unit == event.getAffectedEditor()) {
            property.setUnit((String)EEFConverterUtil.createFromString((EDataType)EcorePackage.Literals.ESTRING, (String)((String)event.getNewValue())));
        }
    }

    public void updatePart(Notification msg) {
        super.updatePart(msg);
        if (this.editingPart.isVisible()) {
            PropertyPropertiesEditionPart basePart = (PropertyPropertiesEditionPart)this.editingPart;
            if (GeneralPackage.eINSTANCE.getNamedElement_Id().equals(msg.getFeature()) && msg.getNotifier().equals(this.semanticObject) && basePart != null && this.isAccessible(PropertyViewsRepository.Property_.Properties.id)) {
                if (msg.getNewValue() != null) {
                    basePart.setId(EcoreUtil.convertToString((EDataType)EcorePackage.Literals.ESTRING, (Object)msg.getNewValue()));
                } else {
                    basePart.setId("");
                }
            }
            if (GeneralPackage.eINSTANCE.getNamedElement_Name().equals(msg.getFeature()) && msg.getNotifier().equals(this.semanticObject) && basePart != null && this.isAccessible(PropertyViewsRepository.Property_.Properties.name)) {
                if (msg.getNewValue() != null) {
                    basePart.setName(EcoreUtil.convertToString((EDataType)EcorePackage.Literals.ESTRING, (Object)msg.getNewValue()));
                } else {
                    basePart.setName("");
                }
            }
            if (PropertyPackage.eINSTANCE.getProperty_Datatype().equals(msg.getFeature()) && msg.getNotifier().equals(this.semanticObject) && this.isAccessible(PropertyViewsRepository.Property_.Properties.datatype)) {
                basePart.setDatatype((Enumerator)((DataTypeKind)msg.getNewValue()));
            }
            if (PropertyPackage.eINSTANCE.getProperty_EnumValues().equals(msg.getFeature()) && msg.getNotifier().equals(this.semanticObject) && basePart != null && this.isAccessible(PropertyViewsRepository.Property_.Properties.enumValues)) {
                if (msg.getNewValue() instanceof EList) {
                    basePart.setEnumValues((EList)msg.getNewValue());
                } else if (msg.getNewValue() == null) {
                    basePart.setEnumValues((EList)new BasicEList());
                } else {
                    BasicEList newValueAsList = new BasicEList();
                    newValueAsList.add(msg.getNewValue());
                    basePart.setEnumValues((EList)newValueAsList);
                }
            }
            if (PropertyPackage.eINSTANCE.getProperty_Unit().equals(msg.getFeature()) && msg.getNotifier().equals(this.semanticObject) && basePart != null && this.isAccessible(PropertyViewsRepository.Property_.Properties.unit)) {
                if (msg.getNewValue() != null) {
                    basePart.setUnit(EcoreUtil.convertToString((EDataType)EcorePackage.Literals.ESTRING, (Object)msg.getNewValue()));
                } else {
                    basePart.setUnit("");
                }
            }
        }
    }

    protected NotificationFilter[] getNotificationFilters() {
        EStructuralFeatureNotificationFilter filter = new EStructuralFeatureNotificationFilter(new EStructuralFeature[]{GeneralPackage.eINSTANCE.getNamedElement_Id(), GeneralPackage.eINSTANCE.getNamedElement_Name(), PropertyPackage.eINSTANCE.getProperty_Datatype(), PropertyPackage.eINSTANCE.getProperty_EnumValues(), PropertyPackage.eINSTANCE.getProperty_Unit()});
        return new NotificationFilter[]{filter};
    }

    public Diagnostic validateValue(IPropertiesEditionEvent event) {
        Diagnostic ret = Diagnostic.OK_INSTANCE;
        if (event.getNewValue() != null) {
            try {
                Object newValue;
                if (PropertyViewsRepository.Property_.Properties.id == event.getAffectedEditor()) {
                    newValue = event.getNewValue();
                    if (newValue instanceof String) {
                        newValue = EEFConverterUtil.createFromString((EDataType)GeneralPackage.eINSTANCE.getNamedElement_Id().getEAttributeType(), (String)((String)newValue));
                    }
                    ret = Diagnostician.INSTANCE.validate(GeneralPackage.eINSTANCE.getNamedElement_Id().getEAttributeType(), newValue);
                }
                if (PropertyViewsRepository.Property_.Properties.name == event.getAffectedEditor()) {
                    newValue = event.getNewValue();
                    if (newValue instanceof String) {
                        newValue = EEFConverterUtil.createFromString((EDataType)GeneralPackage.eINSTANCE.getNamedElement_Name().getEAttributeType(), (String)((String)newValue));
                    }
                    ret = Diagnostician.INSTANCE.validate(GeneralPackage.eINSTANCE.getNamedElement_Name().getEAttributeType(), newValue);
                }
                if (PropertyViewsRepository.Property_.Properties.datatype == event.getAffectedEditor()) {
                    newValue = event.getNewValue();
                    if (newValue instanceof String) {
                        newValue = EEFConverterUtil.createFromString((EDataType)PropertyPackage.eINSTANCE.getProperty_Datatype().getEAttributeType(), (String)((String)newValue));
                    }
                    ret = Diagnostician.INSTANCE.validate(PropertyPackage.eINSTANCE.getProperty_Datatype().getEAttributeType(), newValue);
                }
                if (PropertyViewsRepository.Property_.Properties.enumValues == event.getAffectedEditor()) {
                    BasicDiagnostic chain = new BasicDiagnostic();
                    Iterator iterator = ((List)event.getNewValue()).iterator();
                    while (iterator.hasNext()) {
                        chain.add(Diagnostician.INSTANCE.validate(PropertyPackage.eINSTANCE.getProperty_EnumValues().getEAttributeType(), iterator.next()));
                    }
                    ret = chain;
                }
                if (PropertyViewsRepository.Property_.Properties.unit == event.getAffectedEditor()) {
                    newValue = event.getNewValue();
                    if (newValue instanceof String) {
                        newValue = EEFConverterUtil.createFromString((EDataType)PropertyPackage.eINSTANCE.getProperty_Unit().getEAttributeType(), (String)((String)newValue));
                    }
                    ret = Diagnostician.INSTANCE.validate(PropertyPackage.eINSTANCE.getProperty_Unit().getEAttributeType(), newValue);
                }
            }
            catch (IllegalArgumentException iae) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)iae);
            }
            catch (WrappedException we) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)we);
            }
        }
        return ret;
    }
}

