/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.manager.axis;

import ca.odell.glazedlists.EventList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.listener.UpdateTableContentListener;
import org.eclipse.papyrus.infra.nattable.manager.axis.AbstractAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.manager.axis.ICompositeAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.axis.IIdAxisManager;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.messages.Messages;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IdAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;
import org.eclipse.papyrus.infra.nattable.utils.AxisComparator;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;
import org.eclipse.papyrus.infra.nattable.utils.EventListHelper;
import org.eclipse.papyrus.infra.nattable.utils.FillingConfigurationUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.infra.widgets.providers.CompoundFilteredRestrictedContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IRestrictedContentProvider;

public class CompositeAxisManagerForEventList
extends AbstractAxisManagerForEventList
implements IAxisManagerForEventList,
ICompositeAxisManager {
    private static final String MANAGER_ID = "org.eclipse.papyrus.infra.nattable.composite.axis.manager.event.list";
    protected List<IAxisManagerForEventList> subManagers;
    protected Comparator<Object> axisComparator;
    private ResourceSetListener resourceSetListener;

    public CompositeAxisManagerForEventList(EventList<Object> eventList) {
        this.setEventList(eventList);
    }

    @Override
    protected void addListeners() {
        this.resourceSetListener = new UpdateTableContentListener(this.getTableManager(), this);
        if (this.getTableEditingDomain() != null) {
            this.getTableEditingDomain().addResourceSetListener(this.resourceSetListener);
        }
    }

    @Override
    public final void setSubAxisManager(List<IAxisManager> managers) {
        throw new UnsupportedOperationException("Use setSubAxisManagers(List<IAxisManagerForEventList> manager)");
    }

    @Override
    public void init(INattableModelManager manager, AxisManagerRepresentation rep, AbstractAxisProvider provider) {
        super.init(manager, rep, provider);
        for (IAxis current : this.getRepresentedContentProvider().getAxis()) {
            if (!(current instanceof ITreeItemAxis)) continue;
            EventListHelper.addToEventList((EventList<Object>)this.eventList, current);
        }
    }

    public void setSubManagers(List<IAxisManagerForEventList> subManagers) {
        this.subManagers = subManagers;
        for (IAxisManagerForEventList current : subManagers) {
            current.setEventList((EventList<Object>)this.eventList);
        }
    }

    @Override
    public void dispose() {
        for (IAxisManager iAxisManager : this.subManagers) {
            iAxisManager.dispose();
        }
        this.subManagers.clear();
        this.axisComparator = null;
        super.dispose();
    }

    @Override
    protected void removeListeners() {
        if (this.getTableEditingDomain() != null && this.resourceSetListener != null) {
            this.getTableEditingDomain().removeResourceSetListener(this.resourceSetListener);
        }
        this.resourceSetListener = null;
        super.removeListeners();
    }

    @Override
    public boolean canBeUsedAsRowManager() {
        boolean answer = true;
        Iterator<IAxisManagerForEventList> iter = this.subManagers.iterator();
        while (iter.hasNext() && answer) {
            answer = iter.next().canBeUsedAsRowManager();
        }
        return answer;
    }

    @Override
    public boolean canBeUsedAsColumnManager() {
        boolean answer = true;
        Iterator<IAxisManagerForEventList> iter = this.subManagers.iterator();
        while (iter.hasNext() && answer) {
            answer = iter.next().canBeUsedAsColumnManager();
        }
        return answer;
    }

    @Override
    public boolean canCreateAxisElement(String elementId) {
        boolean canCreateAxisElement = false;
        for (IAxisManager iAxisManager : this.subManagers) {
            canCreateAxisElement |= iAxisManager.canCreateAxisElement(elementId);
        }
        return canCreateAxisElement;
    }

    @Override
    public Command getAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd) {
        if (FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.tableManager.getTable(), 0)) {
            return null;
        }
        CompoundCommand cmd = new CompoundCommand(Messages.CompositeAxisManager_AddAxisCommand);
        for (IAxisManager iAxisManager : this.subManagers) {
            Command tmp = iAxisManager.getAddAxisCommand(domain, objectToAdd);
            if (tmp == null) continue;
            cmd.append(tmp);
        }
        if (cmd.isEmpty()) {
            return null;
        }
        return cmd;
    }

    @Override
    public Command getAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd, int index) {
        if (FillingConfigurationUtils.hasTreeFillingConfigurationForDepth(this.tableManager.getTable(), 0)) {
            return null;
        }
        CompoundCommand cmd = new CompoundCommand(Messages.CompositeAxisManager_AddAxisCommand);
        for (IAxisManager iAxisManager : this.subManagers) {
            Command tmp = iAxisManager.getAddAxisCommand(domain, objectToAdd, index);
            if (tmp == null) continue;
            cmd.append(tmp);
        }
        if (cmd.isEmpty()) {
            return null;
        }
        return cmd;
    }

    @Override
    protected void initializeManagedObjectList() {
    }

    @Override
    public Command getComplementaryAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd) {
        CompoundCommand cmd = new CompoundCommand(Messages.CompositeAxisManager_AddAxisCommand);
        for (IAxisManager iAxisManager : this.subManagers) {
            Command tmp = iAxisManager.getComplementaryAddAxisCommand(domain, objectToAdd);
            if (tmp == null) continue;
            cmd.append(tmp);
        }
        if (cmd.isEmpty()) {
            return null;
        }
        return cmd;
    }

    @Override
    public Command getComplementaryAddAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToAdd, int index) {
        CompoundCommand cmd = new CompoundCommand(Messages.CompositeAxisManager_AddAxisCommand);
        for (IAxisManager iAxisManager : this.subManagers) {
            Command tmp = iAxisManager.getComplementaryAddAxisCommand(domain, objectToAdd, index);
            if (tmp == null) continue;
            cmd.append(tmp);
        }
        if (cmd.isEmpty()) {
            return null;
        }
        return cmd;
    }

    @Override
    public boolean isAllowedContents(Object object) {
        for (IAxisManager iAxisManager : this.subManagers) {
            if (!iAxisManager.isAllowedContents(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canMoveAxis() {
        for (IAxisManager iAxisManager : this.subManagers) {
            if (iAxisManager.canMoveAxis() && !iAxisManager.isDynamic()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void sortAxisByName(boolean alphabeticOrder, IConfigRegistry configRegistry) {
        if (this.canMoveAxis()) {
            ArrayList axis = new ArrayList(this.getRepresentedContentProvider().getAxis());
            Collections.sort(axis, new AxisComparator(alphabeticOrder, configRegistry));
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)this.getRepresentedContentProvider());
            SetRequest request = new SetRequest(domain, (EObject)this.getRepresentedContentProvider(), (EStructuralFeature)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), axis);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)this.getRepresentedContentProvider());
            ICommand cmd = provider.getEditCommand((IEditCommandRequest)request);
            domain.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper(cmd));
        }
    }

    @Override
    public IRestrictedContentProvider createPossibleAxisContentProvider(boolean isRestricted) {
        CompoundFilteredRestrictedContentProvider compoundContentProvider = null;
        for (IAxisManager iAxisManager : this.subManagers) {
            IRestrictedContentProvider contentProvider = iAxisManager.createPossibleAxisContentProvider(isRestricted);
            if (contentProvider == null) continue;
            if (compoundContentProvider == null) {
                compoundContentProvider = new CompoundFilteredRestrictedContentProvider();
            }
            compoundContentProvider.add(contentProvider);
        }
        return compoundContentProvider;
    }

    @Override
    public Command getDestroyAxisCommand(TransactionalEditingDomain domain, Collection<Object> objectToDestroy) {
        CompoundCommand cmd = new CompoundCommand(Messages.CompositeAxisManager_DestroyAxisCommand);
        for (IAxisManager iAxisManager : this.subManagers) {
            Command tmp = iAxisManager.getDestroyAxisCommand(domain, objectToDestroy);
            if (tmp == null) continue;
            cmd.append(tmp);
        }
        if (cmd.isEmpty()) {
            return null;
        }
        return cmd;
    }

    @Override
    public boolean isSlave() {
        for (IAxisManager iAxisManager : this.subManagers) {
            if (!iAxisManager.isSlave()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDynamic() {
        for (IAxisManager iAxisManager : this.subManagers) {
            if (!iAxisManager.isDynamic()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canDropAxisElement(Collection<Object> objectsToAdd) {
        for (IAxisManager iAxisManager : this.subManagers) {
            if (!iAxisManager.canDropAxisElement(objectsToAdd)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void moveAxis(Object elementToMove, int newIndex) {
        if (!this.isDynamic() && elementToMove instanceof IAxis) {
            TransactionalEditingDomain domain = this.getTableEditingDomain();
            Command command = MoveCommand.create((EditingDomain)domain, (Object)this.getRepresentedContentProvider(), (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), (Object)elementToMove, (int)newIndex);
            domain.getCommandStack().execute(command);
        }
    }

    @Override
    public boolean canEditAxisHeader(NatEventData axisIndex) {
        return this.canEditAxisHeader();
    }

    @Override
    public boolean canEditAxisHeader() {
        for (IAxisManager iAxisManager : this.subManagers) {
            if (iAxisManager.canEditAxisHeader()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getElementAxisName(IAxis axis) {
        AxisManagerRepresentation manager = axis.getManager();
        for (IAxisManager iAxisManager : this.subManagers) {
            if (iAxisManager.getAxisManagerRepresentation() != manager) continue;
            return iAxisManager.getElementAxisName(axis);
        }
        if (this.canEditAxisHeader()) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected IAxisManager getAxisManager(IAxis axis) {
        AxisManagerRepresentation rep = axis.getManager();
        for (IAxisManager iAxisManager : this.subManagers) {
            if (iAxisManager.getAxisManagerRepresentation() != rep) continue;
            return iAxisManager;
        }
        return null;
    }

    @Override
    public IAxisManager getSubAxisManagerFor(IAxis axis) {
        AxisManagerRepresentation rep = axis.getManager();
        for (IAxisManager iAxisManager : this.subManagers) {
            if (iAxisManager.getAxisManagerRepresentation() != rep) continue;
            return iAxisManager;
        }
        return null;
    }

    @Override
    public boolean canDestroyAxis(Integer axisPosition) {
        List<Object> elements = this.getElements();
        Object element = elements.get(axisPosition);
        if (element instanceof IAxis) {
            return this.getSubAxisManagerFor((IAxis)element).canDestroyAxis(axisPosition);
        }
        return false;
    }

    @Override
    public boolean canDestroyAxisElement(Integer axisPosition) {
        List<Object> elements = this.getElements();
        Object element = elements.get(axisPosition);
        if (element instanceof IAxis) {
            return this.getSubAxisManagerFor((IAxis)element).canDestroyAxisElement(axisPosition);
        }
        if (this.subManagers.size() == 1) {
            return this.subManagers.get(0).canDestroyAxisElement(axisPosition);
        }
        return false;
    }

    @Override
    public Command getDestroyAxisElementCommand(TransactionalEditingDomain domain, Integer axisPosition) {
        List<Object> elements = this.getElements();
        Object element = elements.get(axisPosition);
        if (element instanceof IAxis) {
            return this.getSubAxisManagerFor((IAxis)element).getDestroyAxisElementCommand(domain, axisPosition);
        }
        if (this.subManagers.size() == 1) {
            return this.subManagers.get(0).getDestroyAxisElementCommand(domain, axisPosition);
        }
        return UnexecutableCommand.INSTANCE;
    }

    @Override
    public boolean canBeSavedAsConfig() {
        boolean canBeSavedAsConfig = true;
        for (IAxisManager iAxisManager : this.subManagers) {
            canBeSavedAsConfig &= iAxisManager.canBeSavedAsConfig();
        }
        return canBeSavedAsConfig;
    }

    @Override
    public Object getAdapter(Class adapter) {
        for (IAxisManager iAxisManager : this.subManagers) {
            if (iAxisManager.getClass() != adapter) continue;
            return iAxisManager;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public boolean isInSortedState() {
        return this.axisComparator != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAxisComparator(Comparator<Object> comp) {
        this.axisComparator = comp;
        if (this.axisComparator != null) {
            List<Object> displayedElement;
            List<Object> list = displayedElement = this.getElements();
            synchronized (list) {
                Collections.sort(displayedElement, comp);
                this.getTableManager().refreshNatTable();
            }
        } else {
            this.getTableManager().updateAxisContents(this.getRepresentedContentProvider());
        }
    }

    @Override
    public boolean isAlreadyManaged(Object object) {
        for (IAxisManager iAxisManager : this.subManagers) {
            if (!iAxisManager.isAlreadyManaged(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Command getSetNewAxisOrderCommand(final List<Object> newOrder) {
        if (this.canMoveAxis() && !this.isDynamic()) {
            return new RecordingCommand(this.getTableEditingDomain()){

                protected void doExecute() {
                    TreeMap<Integer, IAxis> order = new TreeMap<Integer, IAxis>();
                    AbstractAxisProvider provider = CompositeAxisManagerForEventList.this.getRepresentedContentProvider();
                    int i = 0;
                    while (i < provider.getAxis().size()) {
                        IAxis currentAxis = (IAxis)provider.getAxis().get(i);
                        int index = newOrder.indexOf(currentAxis);
                        if (index != -1) {
                            order.put(index, currentAxis);
                        } else {
                            Object resolvedObject = AxisUtils.getRepresentedElement(currentAxis);
                            if (currentAxis instanceof IdAxis) {
                                resolvedObject = CompositeAxisManagerForEventList.this.getResolvedPath((IdAxis)currentAxis);
                            }
                            if ((index = newOrder.indexOf(resolvedObject)) == -1) {
                                throw new IndexOutOfBoundsException("A reordered element can't be resolved");
                            }
                            order.put(index, currentAxis);
                        }
                        ++i;
                    }
                    ArrayList newValues = new ArrayList();
                    newValues.addAll(order.values());
                    SetCommand.create((EditingDomain)CompositeAxisManagerForEventList.this.getTableEditingDomain(), (Object)provider, (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), newValues).execute();
                }
            };
        }
        return null;
    }

    @Deprecated
    protected IAxisManager findAxisManager(IAxis axis) {
        String axisManagerId = axis.getManager().getAxisManagerId();
        for (IAxisManager iAxisManager : this.subManagers) {
            if (!iAxisManager.getAxisManagerRepresentation().getAxisManagerId().equals(axisManagerId)) continue;
            return iAxisManager;
        }
        return null;
    }

    protected Object getResolvedPath(IdAxis idAxis) {
        Object resolvedElement;
        String path = idAxis.getElement();
        IAxisManager manager = this.getSubAxisManagerFor((IAxis)idAxis);
        if (manager instanceof IIdAxisManager && (resolvedElement = ((IIdAxisManager)((Object)manager)).resolvedPath(path)) != null) {
            return resolvedElement;
        }
        return path;
    }

    @Override
    protected void manageSetNotification(Notification notification) {
        this.propagateEvent(notification);
    }

    @Override
    protected void manageUnsetNotification(Notification notification) {
        this.propagateEvent(notification);
    }

    @Override
    protected void manageAddNotification(Notification notification) {
        Object newValue = notification.getNewValue();
        if (newValue instanceof IAxis && ((IAxis)newValue).eContainer() == this.getRepresentedContentProvider()) {
            EventListHelper.addToEventList((EventList<Object>)this.eventList, newValue);
        }
        this.propagateEvent(notification);
    }

    @Override
    protected void manageAddManyNotification(Notification notification) {
        Object newValue = notification.getNewValue();
        if (newValue instanceof Collection) {
            for (Object current : (Collection)newValue) {
                if (!(current instanceof IAxis) || ((IAxis)current).eContainer() != this.getRepresentedContentProvider()) continue;
                EventListHelper.addToEventList((EventList<Object>)this.eventList, current);
            }
        }
        this.propagateEvent(notification);
    }

    @Override
    protected void manageMoveNotification(Notification notification) {
        this.propagateEvent(notification);
    }

    @Override
    protected void manageRemoveNotification(Notification notification) {
        Object oldValue = notification.getOldValue();
        this.propagateEvent(notification);
        if (oldValue instanceof IAxis) {
            EventListHelper.removeFromEventList((EventList<Object>)this.eventList, oldValue);
        }
    }

    @Override
    protected void manageRemoveManyNotification(Notification notification) {
        Object oldValue = notification.getNewValue();
        this.propagateEvent(notification);
        if (oldValue instanceof Collection) {
            for (Object current : (Collection)oldValue) {
                if (!(current instanceof IAxis)) continue;
                EventListHelper.removeFromEventList((EventList<Object>)this.eventList, current);
            }
        }
    }

    protected void propagateEvent(Notification notification) {
        for (IAxisManager iAxisManager : this.subManagers) {
            if (!(iAxisManager instanceof IAxisManagerForEventList)) continue;
            ((IAxisManagerForEventList)iAxisManager).manageEvent(notification);
        }
    }

    @Override
    @Deprecated
    public void updateAxisContents() {
    }

    @Override
    public void fillingConfigurationsHaveChanged() {
        for (IAxisManager iAxisManager : this.subManagers) {
            if (!(iAxisManager instanceof IAxisManagerForEventList)) continue;
            ((IAxisManagerForEventList)iAxisManager).fillingConfigurationsHaveChanged();
        }
        this.getTableManager().refreshNatTable();
    }
}

