/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.papyrus.uml.diagram.common.dialogs.IWizardModelElementProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.uml2.uml.NamedElement;

public class SelectModelElementsForDiagramDialog
extends WizardPage {
    private TreeViewer selectionTree = null;
    private Label rootElementLabel = null;
    private IWizardModelElementProvider elementProvider = null;
    private IBaseLabelProvider labelProvider = null;
    private IContentProvider contentProvider = null;
    private boolean wasShown = false;
    private boolean changing = false;

    public SelectModelElementsForDiagramDialog(IWizardModelElementProvider elementProvider, IContentProvider contentProvider, IBaseLabelProvider labelProvider) {
        super("Select model elements for diagram");
        this.setTitle("Model objects");
        this.setDescription("Select model objects that must appear in the diagram");
        this.elementProvider = elementProvider;
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            EObject input = this.elementProvider.getModelElement();
            this.selectionTree.setInput((Object)input);
            String label = "";
            label = String.valueOf(label) + "<" + input.eClass().getName() + "> ";
            if (input instanceof NamedElement) {
                label = String.valueOf(label) + ((NamedElement)input).getName() + " ";
            }
            label = String.valueOf(label) + " is the root element";
            this.rootElementLabel.setText(label);
            this.selectionTree.expandAll();
            this.selectAllSelected();
            this.wasShown = true;
        }
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        root.setLayout((Layout)gridLayout);
        Composite composite = new Composite(root, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        this.createDialogArea(composite);
        this.setControl((Control)root);
    }

    public List<EObject> getSelectedEObjects() {
        if (this.selectionTree == null) {
            return Collections.EMPTY_LIST;
        }
        if (!this.wasShown) {
            EObject input = this.elementProvider.getModelElement();
            this.selectionTree.setInput((Object)input);
            this.selectionTree.expandAll();
            this.selectAllSelected();
        }
        TreeItem[] items = this.selectionTree.getTree().getItems();
        ArrayList<EObject> selectedEObjects = new ArrayList<EObject>();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.addCheckedEObjectsToList(selectedEObjects, item);
            ++n2;
        }
        return selectedEObjects;
    }

    private void addCheckedEObjectsToList(List<EObject> list, TreeItem item) {
        Object data;
        if (item.getChecked() && (data = item.getData()) instanceof EObject) {
            list.add((EObject)data);
        }
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            this.addCheckedEObjectsToList(list, treeItem);
            ++n2;
        }
    }

    protected void createDialogArea(Composite parent) {
        this.createLabel(parent);
        this.createTreeSelector(parent);
        this.createButtons(parent);
    }

    private void createLabel(Composite parent) {
        this.rootElementLabel = new Label(parent, 0);
        GridData data = new GridData(32);
        this.rootElementLabel.setLayoutData((Object)data);
    }

    private void createTreeSelector(Composite parent) {
        Tree tree = new Tree(parent, 2852);
        TreeViewer treeViewer = new TreeViewer(tree);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 300;
        data.widthHint = 300;
        tree.setLayoutData((Object)data);
        this.selectionTree = treeViewer;
        treeViewer.setContentProvider(this.contentProvider);
        treeViewer.setLabelProvider(this.labelProvider);
        tree.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SelectModelElementsForDiagramDialog.this.treeSelectionChanged(e);
            }
        });
    }

    private void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(4, true));
        GridData gridData = new GridData(4, 0x1000008, true, false);
        composite.setLayoutData((Object)gridData);
        Button selectAllButton = new Button(composite, 8);
        selectAllButton.setText("Select All");
        GridData data = new GridData(4, 4, true, true);
        selectAllButton.setLayoutData((Object)data);
        selectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SelectModelElementsForDiagramDialog.this.selectAllSelected();
            }
        });
        Button deselectAllButton = new Button(composite, 8);
        deselectAllButton.setText("Deselect All");
        data = new GridData(4, 4, true, true);
        deselectAllButton.setLayoutData((Object)data);
        deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                SelectModelElementsForDiagramDialog.this.deselectAllSelected();
            }
        });
    }

    private void selectAllSelected() {
        TreeItem[] items;
        Tree tree = this.selectionTree.getTree();
        TreeItem[] treeItemArray = items = tree.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.setTreeItemSelection(item, true);
            ++n2;
        }
    }

    private void deselectAllSelected() {
        TreeItem[] items;
        Tree tree = this.selectionTree.getTree();
        TreeItem[] treeItemArray = items = tree.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.setTreeItemSelection(item, false);
            ++n2;
        }
    }

    private void treeSelectionChanged(SelectionEvent event) {
        Widget item = event.item;
        if (this.changing || !(item instanceof TreeItem)) {
            return;
        }
        this.changing = true;
        TreeItem treeItem = (TreeItem)item;
        this.setTreeItemSelection(treeItem, treeItem.getChecked());
        if (treeItem.getChecked() && treeItem.getParentItem() != null) {
            this.setTreeItemParentChecked(treeItem.getParentItem());
        }
        this.changing = false;
    }

    private void setTreeItemSelection(TreeItem item, boolean checked) {
        TreeItem[] items;
        item.setChecked(checked);
        TreeItem[] treeItemArray = items = item.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            this.setTreeItemSelection(ti, checked);
            ++n2;
        }
    }

    private void setTreeItemParentChecked(TreeItem parent) {
        parent.setChecked(true);
        if (parent.getParentItem() != null) {
            this.setTreeItemParentChecked(parent.getParentItem());
        }
    }
}

