/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.IMaskManagedLabelEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.StereotypedElementLabelHelper;
import org.eclipse.papyrus.uml.tools.utils.ICustomAppearance;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.State;

public class ActivityParameterNodeLabelHelper
extends StereotypedElementLabelHelper {
    private static final String SEPARATOR = ": ";
    private static final String STATE_SEPARATOR = ", ";
    private static final String START_STATE_SEQUENCE = "[";
    private static final String END_STATE_SEQUENCE = "]";
    private static ActivityParameterNodeLabelHelper labelHelper;
    protected final Map<String, String> masks = new HashMap<String, String>();

    public static ActivityParameterNodeLabelHelper getInstance() {
        if (labelHelper == null) {
            labelHelper = new ActivityParameterNodeLabelHelper();
        }
        return labelHelper;
    }

    protected ActivityParameterNodeLabelHelper() {
        this.masks.put("name", "Name");
        this.masks.put("parametersName", "Parameter Name");
        this.masks.put("type", "Type");
        this.masks.put("state", "States");
    }

    @Override
    protected String elementLabel(GraphicalEditPart editPart) {
        Collection displayValue = ICustomAppearance.DEFAULT_UML_ACTIVITYPARAMETERNODE;
        IMaskManagedLabelEditPolicy policy = (IMaskManagedLabelEditPolicy)editPart.getParent().getEditPolicy((Object)"MaskManagedLabelPolicy");
        if (policy != null) {
            displayValue = policy.getCurrentDisplayValue();
        }
        return this.parse(displayValue, this.getUMLElement(editPart));
    }

    public Map<String, String> getMasks() {
        return this.masks;
    }

    public ActivityParameterNode getUMLElement(GraphicalEditPart editPart) {
        return (ActivityParameterNode)((View)editPart.getModel()).getElement();
    }

    protected String parse(Collection<String> values, ActivityParameterNode node) {
        StringBuilder result = new StringBuilder();
        if (node == null) {
            return "";
        }
        if (values.contains("name")) {
            this.appendName(result, (NamedElement)node);
        }
        if (values.contains("parametersName") || result.length() == 0) {
            this.appendName(result, (NamedElement)node.getParameter());
        }
        if (values.contains("type")) {
            this.appendName(result, (NamedElement)node.getType());
        }
        if (values.contains("state")) {
            StringBuffer stateLabel = new StringBuffer();
            for (State state : node.getInStates()) {
                String stateName = state.getName();
                if (stateName == null || stateName.length() <= 0) continue;
                if (stateLabel.length() > 0) {
                    stateLabel.append(STATE_SEPARATOR);
                }
                stateLabel.append(stateName);
            }
            if (stateLabel.length() > 0) {
                if (result.length() > 0) {
                    result.append(System.getProperty("line.separator"));
                }
                result.append(START_STATE_SEQUENCE).append(stateLabel).append(END_STATE_SEQUENCE);
            }
        }
        return result.toString();
    }

    private void appendName(StringBuilder builder, NamedElement element) {
        if (element == null) {
            return;
        }
        String name = element.getName();
        if (name != null && name.length() > 0) {
            if (builder.length() > 0) {
                builder.append(SEPARATOR);
            }
            builder.append(name);
        }
    }
}

