/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.explorer;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EStructuralFeatureImpl;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.FeatureMapEntryWrapperItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.ui.internal.Tracing;
import org.eclipse.emf.transaction.ui.provider.TransactionalAdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.explorer.internal.messages.Messages;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public class BasicExplorerLabelProvider
extends BaseLabelProvider
implements ICommonLabelProvider,
IFontProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    protected Map<TransactionalEditingDomain, AdapterFactoryLabelProvider> modelLabelProviders = new WeakHashMap<TransactionalEditingDomain, AdapterFactoryLabelProvider>();
    protected ILabelProviderListener modelLabelProviderListener;

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void saveState(IMemento memento) {
    }

    public void restoreState(IMemento memento) {
    }

    protected AdapterFactoryLabelProvider getModelLabelProvider(Object element) {
        AdapterFactory adapterFactory;
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((Object)element);
        if (editingDomain != null) {
            AdapterFactoryLabelProvider modelLabelProvider = this.modelLabelProviders.get(editingDomain);
            if (modelLabelProvider == null) {
                modelLabelProvider = this.createModelLabelProvider(editingDomain);
                modelLabelProvider.addListener(this.getModelLabelProviderListener());
                this.modelLabelProviders.put(editingDomain, modelLabelProvider);
            }
            return modelLabelProvider;
        }
        if (element instanceof EObject && ((EObject)element).eIsProxy() && (adapterFactory = this.getAdapterFactory(editingDomain)) != null) {
            return new AdapterFactoryLabelProvider(adapterFactory);
        }
        return null;
    }

    protected AdapterFactoryLabelProvider createModelLabelProvider(final TransactionalEditingDomain editingDomain) {
        Assert.isNotNull((Object)editingDomain);
        AdapterFactory adapterFactory = this.getAdapterFactory(editingDomain);
        TransactionalAdapterFactoryLabelProvider labelProvider = new TransactionalAdapterFactoryLabelProvider(editingDomain, adapterFactory){

            protected <T> T run(RunnableWithResult<? extends T> run) {
                try {
                    return (T)TransactionUtil.runExclusive((TransactionalEditingDomain)editingDomain, run);
                }
                catch (Exception e) {
                    Tracing.catching(TransactionalAdapterFactoryLabelProvider.class, (String)"run", (Throwable)e);
                    Thread.currentThread().interrupt();
                    return null;
                }
            }
        };
        Font defaultFont = JFaceResources.getDefaultFont();
        labelProvider.setDefaultFont(defaultFont);
        return labelProvider;
    }

    protected AdapterFactory getAdapterFactory(TransactionalEditingDomain editingDomain) {
        AdapterFactory customAdapterFactory = this.getCustomAdapterFactory();
        if (customAdapterFactory != null) {
            return customAdapterFactory;
        }
        if (editingDomain != null) {
            return ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
        }
        return null;
    }

    protected AdapterFactory getCustomAdapterFactory() {
        return null;
    }

    public String getDescription(Object anElement) {
        if (!(anElement instanceof IFile)) {
            AdapterFactoryLabelProvider labelProvider = this.getModelLabelProvider(anElement);
            if (labelProvider != null) {
                FeatureMapEntryWrapperItemProvider provider;
                Object value;
                String text = labelProvider.getText(anElement);
                if (text != null && text.length() != 0) {
                    return text;
                }
                if (anElement instanceof FeatureMapEntryWrapperItemProvider && (value = (provider = (FeatureMapEntryWrapperItemProvider)anElement).getValue()) instanceof EStructuralFeatureImpl.BasicFeatureMapEntry) {
                    EStructuralFeatureImpl.BasicFeatureMapEntry featureMapEntry = (EStructuralFeatureImpl.BasicFeatureMapEntry)value;
                    String label = NLS.bind((String)Messages.label_EmptyFeatureMapEntryLabel, (Object[])new String[]{featureMapEntry.getEStructuralFeature().getName(), provider.getOwner().getClass().getSimpleName()});
                    return label.replaceFirst("Impl$", "");
                }
            }
            return " ";
        }
        return null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public String getText(Object element) {
        if (!(element instanceof IFile)) {
            AdapterFactoryLabelProvider labelProvider = this.getModelLabelProvider(element);
            if (labelProvider != null) {
                return labelProvider.getText(element);
            }
            return "";
        }
        return null;
    }

    public Image getImage(Object element) {
        AdapterFactoryLabelProvider labelProvider;
        if (!(element instanceof IFile) && (labelProvider = this.getModelLabelProvider(element)) != null) {
            return labelProvider.getImage(element);
        }
        return null;
    }

    public void dispose() {
        for (AdapterFactoryLabelProvider labelProvider : this.modelLabelProviders.values()) {
            labelProvider.removeListener(this.modelLabelProviderListener);
        }
        this.modelLabelProviders.clear();
        super.dispose();
    }

    protected ILabelProviderListener getModelLabelProviderListener() {
        if (this.modelLabelProviderListener == null) {
            this.modelLabelProviderListener = this.createModelLabelProviderListener();
            Assert.isNotNull((Object)this.modelLabelProviderListener);
        }
        return this.modelLabelProviderListener;
    }

    protected ILabelProviderListener createModelLabelProviderListener() {
        return new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                BasicExplorerLabelProvider.this.fireLabelProviderChanged(event);
            }
        };
    }

    public StyledString getStyledText(Object element) {
        block4: {
            if (!(element instanceof IFile)) {
                AdapterFactoryLabelProvider labelProvider = this.getModelLabelProvider(element);
                try {
                    if (labelProvider != null) {
                        return labelProvider.getStyledText(element);
                    }
                }
                catch (NoSuchMethodError ex) {
                    String text = labelProvider.getText(element);
                    if (text == null || text.length() <= 0) break block4;
                    return new StyledString(text);
                }
            }
        }
        return null;
    }

    public Font getFont(Object element) {
        AdapterFactoryLabelProvider labelProvider;
        if (!(element instanceof IFile) && (labelProvider = this.getModelLabelProvider(element)) != null) {
            return labelProvider.getFont(element);
        }
        return null;
    }
}

