/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.saving;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.model.IModelDescriptorChangeListener;
import org.eclipse.sphinx.emf.model.ModelDescriptorRegistry;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.workspace.saving.IModelSaveLifecycleListener;
import org.eclipse.sphinx.emf.workspace.saving.ModelSaveManager;
import org.eclipse.sphinx.emf.workspace.ui.saving.BasicModelSaveable;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.internal.SaveablesList;
import org.eclipse.ui.navigator.SaveablesProvider;

public class BasicModelSaveablesProvider
extends SaveablesProvider
implements IModelDescriptorChangeListener {
    protected static Map<IModelDescriptor, BasicModelSaveable> saveables = Collections.synchronizedMap(new HashMap());
    protected boolean disposed = false;
    private IModelSaveLifecycleListener modelDirtyChangeListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isDirty() {
        Map<IModelDescriptor, BasicModelSaveable> map = saveables;
        synchronized (map) {
            Saveable saveable;
            Iterator<BasicModelSaveable> iterator = saveables.values().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(saveable = (Saveable)iterator.next()).isDirty());
            return true;
        }
    }

    protected IModelSaveLifecycleListener createModelSaveLifecycleListener() {
        return new IModelSaveLifecycleListener(){

            public void handleDirtyChangedEvent(IModelDescriptor modelDescriptor) {
                Saveable saveable = BasicModelSaveablesProvider.this.getSaveable(modelDescriptor);
                if (saveable != null) {
                    BasicModelSaveablesProvider.this.fireSaveablesLifecycleEventUIThread(saveable, 4, true);
                }
            }

            public void handlePreSaveEvent(IModelDescriptor modelDescriptor) {
            }
        };
    }

    protected void doInit() {
        this.modelDirtyChangeListener = this.createModelSaveLifecycleListener();
        ModelSaveManager.INSTANCE.addModelDirtyChangedListener(this.modelDirtyChangeListener);
        ModelDescriptorRegistry.INSTANCE.addModelDescriptorChangeListener((IModelDescriptorChangeListener)this);
    }

    public void dispose() {
        this.disposed = true;
        ModelSaveManager.INSTANCE.removeModelDirtyChangedListener(this.modelDirtyChangeListener);
        ModelDescriptorRegistry.INSTANCE.removeModelDescriptorChangeListener((IModelDescriptorChangeListener)this);
        super.dispose();
    }

    public Object[] getElements(Saveable saveable) {
        if (saveable instanceof BasicModelSaveable) {
            IModelDescriptor modelDescriptor = ((BasicModelSaveable)saveable).getModelDescriptor();
            Collection filteredResources = EcorePlatformUtil.getResourcesInModel((IModelDescriptor)modelDescriptor, (boolean)true);
            return filteredResources.toArray(new Object[filteredResources.size()]);
        }
        return new Object[0];
    }

    protected BasicModelSaveable createModelSaveable(IModelDescriptor modelDescriptor) {
        return new BasicModelSaveable(modelDescriptor);
    }

    public Saveable getSaveable(Object element) {
        if (element instanceof IModelDescriptor) {
            return this.getSaveable((IModelDescriptor)element);
        }
        Resource resource = EcorePlatformUtil.getResource((Object)element);
        if (resource != null) {
            return this.getSaveable(ModelDescriptorRegistry.INSTANCE.getModel(resource));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Saveable getSaveable(IModelDescriptor modelDescriptor) {
        if (modelDescriptor != null) {
            Map<IModelDescriptor, BasicModelSaveable> map = saveables;
            synchronized (map) {
                BasicModelSaveable saveable = saveables.get(modelDescriptor);
                if (saveable == null) {
                    saveable = this.createModelSaveable(modelDescriptor);
                    saveables.put(modelDescriptor, saveable);
                    this.fireSaveablesLifecycleEventUIThread(saveable, 1, true);
                }
                return saveable;
            }
        }
        return null;
    }

    public Saveable[] getSaveables() {
        return saveables.values().toArray(new Saveable[saveables.values().size()]);
    }

    protected void fireSaveablesLifecycleEventUIThread(final Saveable saveable, final int SaveablesLifecycleEventType, boolean async) {
        if (this.disposed) {
            return;
        }
        Display display = ExtendedPlatformUI.getDisplay();
        if (display != null) {
            if (async) {
                display.asyncExec(new Runnable(){

                    public void run() {
                        BasicModelSaveablesProvider.this.doRun(saveable, SaveablesLifecycleEventType);
                    }
                });
            } else {
                display.syncExec(new Runnable(){

                    public void run() {
                        BasicModelSaveablesProvider.this.doRun(saveable, SaveablesLifecycleEventType);
                    }
                });
            }
        }
    }

    protected void doRun(Saveable saveable, int SaveablesLifecycleEventType) {
        if (this.disposed) {
            return;
        }
        switch (SaveablesLifecycleEventType) {
            case 4: {
                this.fireSaveablesDirtyChanged(new Saveable[]{saveable});
                break;
            }
            case 1: {
                this.fireSaveablesOpened(new Saveable[]{saveable});
                break;
            }
            case 3: {
                this.fireSaveablesClosed(new Saveable[]{saveable});
                break;
            }
            case 2: {
                this.fireSaveablesClosing(new Saveable[]{saveable}, true);
                break;
            }
        }
    }

    public void handleModelAdded(IModelDescriptor modelDescriptor) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleModelRemoved(IModelDescriptor modelDescriptor) {
        if (this.disposed) {
            return;
        }
        if (modelDescriptor != null) {
            Map<IModelDescriptor, BasicModelSaveable> map = saveables;
            synchronized (map) {
                BasicModelSaveable saveable = saveables.get(modelDescriptor);
                if (saveable != null) {
                    this.fireSaveablesLifecycleEventUIThread(saveable, 2, true);
                    saveables.remove(modelDescriptor);
                    this.fireSaveablesLifecycleEventUIThread(saveable, 3, true);
                }
            }
        }
    }

    public static class SiteNotifyingSaveablesLifecycleListener
    implements ISaveablesLifecycleListener {
        protected IWorkbenchPart workbenchPart;
        protected ISaveablesLifecycleListener siteSaveablesLifecycleListener;

        public SiteNotifyingSaveablesLifecycleListener(IWorkbenchPart workbenchPart) {
            Assert.isNotNull((Object)workbenchPart);
            this.workbenchPart = workbenchPart;
            this.siteSaveablesLifecycleListener = (ISaveablesLifecycleListener)workbenchPart.getSite().getService(ISaveablesLifecycleListener.class);
        }

        public void handleLifecycleEvent(SaveablesLifecycleEvent event) {
            ArrayList<Saveable> saveables = new ArrayList<Saveable>(Arrays.asList(event.getSaveables()));
            if (this.siteSaveablesLifecycleListener instanceof SaveablesList) {
                SaveablesList siteSaveablesList = (SaveablesList)this.siteSaveablesLifecycleListener;
                Iterator iter = saveables.iterator();
                while (iter.hasNext()) {
                    List<IWorkbenchPart> workbenchParts = Arrays.asList(siteSaveablesList.getPartsForSaveable((Saveable)iter.next()));
                    if (event.getEventType() == 1 && workbenchParts.contains(this.workbenchPart)) {
                        iter.remove();
                    }
                    if (event.getEventType() != 3 || workbenchParts.contains(this.workbenchPart)) continue;
                    iter.remove();
                }
            }
            if (!saveables.isEmpty()) {
                Saveable[] saveablesArray = saveables.toArray(new Saveable[saveables.size()]);
                event = new SaveablesLifecycleEvent((Object)this.workbenchPart, event.getEventType(), saveablesArray, event.isForce());
                this.siteSaveablesLifecycleListener.handleLifecycleEvent(event);
            }
        }
    }
}

