/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.validation.diagnostic.ExtendedDiagnostician;
import org.eclipse.sphinx.emf.validation.markers.ValidationMarkerManager;
import org.eclipse.sphinx.emf.validation.stats.ValidationPerformanceStats;
import org.eclipse.sphinx.emf.validation.ui.Activator;
import org.eclipse.sphinx.emf.validation.ui.util.DiagnosticUI;
import org.eclipse.sphinx.emf.validation.ui.util.Messages;
import org.eclipse.sphinx.platform.stats.IEventTypeEnumerator;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicValidateAction
extends BaseSelectionListenerAction {
    private boolean displayBriefReport = false;

    public BasicValidateAction() {
        super(Messages._UI_Validate_menu_item);
        this.setDescription(Messages._UI_Validate_simple_description);
    }

    public void run() {
        final List<EObject> selectedModelObjects = this.getSelectedModelObjects();
        final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(final IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    ValidationPerformanceStats.INSTANCE.openContext("Validation of " + selectedModelObjects.get(0));
                    final List<Diagnostic> diagnostics = BasicValidateAction.this.validateMulti(selectedModelObjects, progressMonitor);
                    shell.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (progressMonitor.isCanceled()) {
                                BasicValidateAction.this.handleDiagnostic(selectedModelObjects, Diagnostic.CANCEL_INSTANCE);
                            } else if (diagnostics != null) {
                                BasicValidateAction.this.handleDiagnosticMulti(selectedModelObjects, diagnostics, BasicValidateAction.this.displayBriefReport);
                            }
                            try {
                                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.sphinx.examples.validation.ui.views.validation");
                            }
                            catch (PartInitException partInitException) {}
                        }
                    });
                    ValidationPerformanceStats.INSTANCE.closeAndLogCurrentContext();
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(shell).run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(runnableWithProgress));
        }
        catch (Exception exception) {
            EMFEditUIPlugin.INSTANCE.log((Object)exception);
        }
    }

    protected void handleDiagnostic(List<EObject> selectedModelObjects, Diagnostic diagnostic) {
        this.handleDiagnosticMulti(selectedModelObjects, Collections.singletonList(diagnostic), this.displayBriefReport);
    }

    protected List<Diagnostic> validateMulti(List<EObject> selectedModelObjects, IProgressMonitor progressMonitor) {
        ArrayList<Diagnostic> result = new ArrayList<Diagnostic>();
        ExtendedDiagnostician diagnostician = new ExtendedDiagnostician();
        if (selectedModelObjects.size() == 1) {
            EObject eObject = selectedModelObjects.get(0);
            if (eObject != null) {
                int count = this.getNumberOfObject(eObject);
                progressMonitor.beginTask("", count);
                progressMonitor.setTaskName(EMFEditUIPlugin.INSTANCE.getString("_UI_Validating_message", new Object[]{diagnostician.getObjectLabel(eObject)}));
                ValidationPerformanceStats.INSTANCE.startNewEvent((IEventTypeEnumerator)ValidationPerformanceStats.ValidationEvent.EVENT_APPLY_CONSTRAINTS, (Object)eObject.toString());
                diagnostician.setProgressMonitor(progressMonitor);
                result.add(diagnostician.validate(eObject));
                ValidationPerformanceStats.INSTANCE.endEvent((IEventTypeEnumerator)ValidationPerformanceStats.ValidationEvent.EVENT_APPLY_CONSTRAINTS, (Object)eObject.toString());
                diagnostician.setProgressMonitor(null);
                progressMonitor.done();
            }
            return result;
        }
        if (selectedModelObjects.size() > 1) {
            int count = 0;
            int[] subCount = new int[selectedModelObjects.size()];
            int cptObject = 0;
            for (EObject object : selectedModelObjects) {
                subCount[cptObject] = this.getNumberOfObject(object);
                count += subCount[cptObject++];
            }
            progressMonitor.beginTask("", count);
            progressMonitor.setTaskName(Messages._UI_progressBar_InitialMsg);
            boolean isProgressMonitor = false;
            diagnostician.setProgressMonitor(progressMonitor);
            isProgressMonitor = true;
            Diagnostic diag = null;
            cptObject = 0;
            int[] nbE = new int[3];
            for (EObject current : selectedModelObjects) {
                if (progressMonitor.isCanceled()) break;
                SubProgressMonitor subMonitor = null;
                if (isProgressMonitor) {
                    subMonitor = new SubProgressMonitor(progressMonitor, subCount[cptObject++]);
                    subMonitor.subTask(NLS.bind((String)Messages._UI_subValidationMonitorIntro, (Object)EcorePlatformUtil.getFile((EObject)current).getName()));
                }
                ValidationPerformanceStats.INSTANCE.startNewEvent((IEventTypeEnumerator)ValidationPerformanceStats.ValidationEvent.EVENT_APPLY_CONSTRAINTS, (Object)current.toString());
                diag = diagnostician.validate(current);
                if (diag != null) {
                    result.add(diag);
                    for (Diagnostic c : diag.getChildren()) {
                        switch (c.getSeverity()) {
                            case 4: {
                                nbE[0] = nbE[0] + 1;
                                break;
                            }
                            case 2: {
                                nbE[1] = nbE[1] + 1;
                                break;
                            }
                            case 1: {
                                nbE[2] = nbE[2] + 1;
                            }
                        }
                    }
                }
                if (subMonitor != null) {
                    subMonitor.done();
                }
                ValidationPerformanceStats.INSTANCE.endEvent((IEventTypeEnumerator)ValidationPerformanceStats.ValidationEvent.EVENT_APPLY_CONSTRAINTS, (Object)current.toString());
                progressMonitor.setTaskName(NLS.bind((String)Messages._UI_progressBarMulti_ErrWarnInfo, (Object[])new Object[]{nbE[0], nbE[1], nbE[2]}));
            }
            diagnostician.setProgressMonitor(null);
            progressMonitor.done();
            return result;
        }
        PlatformLogUtil.logAsWarning((Plugin)Activator.getDefault(), (Object)new RuntimeException("Cannot perform validation on empty element selection."));
        return null;
    }

    protected void handleDiagnosticMulti(List<EObject> selectedModelObjects, final List<Diagnostic> diagnostics, boolean showBriefReport) {
        Assert.isNotNull(diagnostics);
        ValidationPerformanceStats.INSTANCE.startNewEvent((IEventTypeEnumerator)ValidationPerformanceStats.ValidationEvent.EVENT_UPDATE_PROBLEM_MARKERS, (Object)"UpdateMarkers");
        if (showBriefReport) {
            DiagnosticUI.showDiagnostic(diagnostics);
        }
        WorkspaceJob job = new WorkspaceJob(Messages._Job_HandleDiagnostic){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                for (Diagnostic diag : diagnostics) {
                    ValidationMarkerManager.getInstance().handleDiagnostic(diag);
                }
                return Status.OK_STATUS;
            }
        };
        ArrayList<ISchedulingRule> myRules = new ArrayList<ISchedulingRule>();
        for (EObject eObject : selectedModelObjects) {
            IFile r = EcorePlatformUtil.getFile((EObject)eObject);
            if (r == null) continue;
            IResourceRuleFactory ruleFactory = r.getWorkspace().getRuleFactory();
            myRules.add(ruleFactory.modifyRule((IResource)r));
            myRules.add(ruleFactory.createRule((IResource)r));
        }
        job.setRule((ISchedulingRule)new MultiRule(myRules.toArray(new ISchedulingRule[myRules.size()])));
        job.setPriority(40);
        job.schedule();
        ValidationPerformanceStats.INSTANCE.endEvent((IEventTypeEnumerator)ValidationPerformanceStats.ValidationEvent.EVENT_UPDATE_PROBLEM_MARKERS, (Object)"UpdateMarkers");
    }

    protected int getNumberOfObject(EObject eObject) {
        int count = 0;
        TreeIterator i = eObject.eAllContents();
        while (i.hasNext()) {
            ++count;
            i.next();
        }
        return count;
    }

    private List<EObject> getSelectedModelObjects() {
        IStructuredSelection selection = this.getStructuredSelection();
        ArrayList<EObject> result = new ArrayList<EObject>();
        ArrayList<IFile> files = new ArrayList<IFile>();
        for (Object selectedObject : selection.toList()) {
            Object object;
            if (selectedObject instanceof IProject) {
                IProject project = (IProject)selectedObject;
                if (!project.isAccessible()) continue;
                files.addAll(ExtendedPlatform.getAllFiles((IProject)((IProject)selectedObject), (boolean)true));
                continue;
            }
            if (selectedObject instanceof IFolder) {
                IFolder folder = (IFolder)selectedObject;
                if (!folder.isAccessible()) continue;
                files.addAll(ExtendedPlatform.getAllFiles((IFolder)((IFolder)selectedObject)));
                continue;
            }
            if (selectedObject instanceof IFile) {
                IFile file = (IFile)selectedObject;
                if (!file.isAccessible()) continue;
                files.add((IFile)selectedObject);
                continue;
            }
            if (selectedObject instanceof EObject) {
                result.add((EObject)selectedObject);
                continue;
            }
            if (!(selectedObject instanceof IWrapperItemProvider) || !((object = AdapterFactoryEditingDomain.unwrap(selectedObject)) instanceof EObject)) continue;
            result.add((EObject)object);
        }
        if (!files.isEmpty()) {
            for (IFile file : files) {
                EObject modelRoot = EcorePlatformUtil.getModelRoot((IFile)file);
                if (modelRoot == null) continue;
                result.add(modelRoot);
            }
        }
        return result;
    }
}

