/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ui.properties.filters;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.sphinx.emf.properties.PropertyFilter;
import org.eclipse.sphinx.emf.ui.internal.Activator;
import org.eclipse.sphinx.emf.ui.properties.filters.IPropertySourceFilter;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.sphinx.platform.util.ReflectUtil;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class BasicPropertySourceFilter
implements IPropertySourceFilter {
    protected PropertyFilter propertyFilter;

    public BasicPropertySourceFilter(PropertyFilter propertyFilter) {
        this.propertyFilter = propertyFilter;
    }

    @Override
    public void setPropertyFilter(PropertyFilter propertyFilter) {
        this.propertyFilter = propertyFilter;
    }

    @Override
    public boolean isFilterForObject(Object object) {
        return true;
    }

    @Override
    public IPropertyDescriptor[] getAcceptedPropertyDescriptors(IPropertySource propertySource) {
        ArrayList<IPropertyDescriptor> acceptedDescriptors = new ArrayList<IPropertyDescriptor>();
        if (propertySource != null) {
            IPropertyDescriptor[] allDescriptors = propertySource.getPropertyDescriptors();
            Object owner = propertySource.getEditableValue();
            if (allDescriptors != null) {
                IPropertyDescriptor[] iPropertyDescriptorArray = allDescriptors;
                int n = allDescriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    IPropertyDescriptor descriptor = iPropertyDescriptorArray[n2];
                    if (this.accept(owner, descriptor)) {
                        acceptedDescriptors.add(descriptor);
                    }
                    ++n2;
                }
            }
        }
        return acceptedDescriptors.toArray(new IPropertyDescriptor[acceptedDescriptors.size()]);
    }

    @Override
    public boolean accept(Object owner, IPropertyDescriptor propertyDescriptor) {
        Assert.isTrue((this.propertyFilter != null ? 1 : 0) != 0);
        if (propertyDescriptor instanceof PropertyDescriptor) {
            try {
                IItemPropertyDescriptor itemPropertyDescriptor = (IItemPropertyDescriptor)ReflectUtil.getInvisibleFieldValue((Object)propertyDescriptor, (String)"itemPropertyDescriptor");
                Object feature = itemPropertyDescriptor.getFeature(owner);
                return feature instanceof EStructuralFeature && this.propertyFilter.accept(owner, (EStructuralFeature)feature);
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)ex);
            }
        }
        return true;
    }
}

