/**
 * <copyright>
 * 
 * Copyright (c) 2014-2016 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 *     itemis - [503063] Provide launching support for Sphinx Workflows
 * 
 * </copyright>
 */
package org.eclipse.sphinx.examples.workflows.model;

import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.sphinx.emf.mwe.dynamic.components.AbstractModelWorkflowComponent;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.examples.workflows.lib.ModelWorkflowExtensions;
import org.eclipse.xtext.xbase.lib.InputOutput;

@SuppressWarnings("all")
public class PrintModelContentWorkflowComponent extends AbstractModelWorkflowComponent {
  protected void invokeInternal(final WorkflowContext ctx, final ProgressMonitor monitor, final Issues issues) {
    InputOutput.<String>println("Executing Print Model Content workflow component");
    final List<EObject> modelObjects = ModelWorkflowExtensions.getModelSlot(ctx);
    for (final EObject modelObject : modelObjects) {
      {
        String _label = ModelWorkflowExtensions.getLabel(modelObject);
        String _plus = ("=> " + _label);
        String _plus_1 = (_plus + " [");
        URI _uRI = EcoreResourceUtil.getURI(modelObject);
        String _plus_2 = (_plus_1 + _uRI);
        String _plus_3 = (_plus_2 + "]");
        InputOutput.<String>println(_plus_3);
        final TreeIterator<EObject> eAllContents = modelObject.eAllContents();
        while (eAllContents.hasNext()) {
          {
            final EObject element = eAllContents.next();
            String _label_1 = ModelWorkflowExtensions.getLabel(element);
            String _plus_4 = ("=> " + _label_1);
            String _plus_5 = (_plus_4 + " [");
            URI _uRI_1 = EcoreResourceUtil.getURI(element);
            String _plus_6 = (_plus_5 + _uRI_1);
            String _plus_7 = (_plus_6 + "]");
            InputOutput.<String>println(_plus_7);
          }
        }
      }
    }
    InputOutput.<String>println("Done!");
  }
}
