/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.stem.model.codegen.ModelGeneratorDescriptors;
import org.eclipse.stem.model.codegen.descriptor.ModelGeneratorDescriptor;
import org.eclipse.stem.model.metamodel.Compartment;
import org.eclipse.stem.model.metamodel.CompartmentGroup;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.metamodel.ModelParam;
import org.eclipse.stem.model.metamodel.ModelParamConstraint;
import org.eclipse.stem.model.metamodel.ModelType;
import org.eclipse.stem.model.metamodel.Package;
import org.eclipse.stem.model.transform.EPackageManager;
import org.eclipse.stem.model.transform.MetamodelPackageManager;
import org.eclipse.stem.model.ui.Constants;
import org.eclipse.stem.model.ui.MetamodelEditorPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class WizardHelper {
    private static Map<ModelType, List<Model>> modelsByType;

    public static Set<EClass> getEClassesForSuperType(EClass superType) {
        HashSet<EClass> matches = new HashSet<EClass>();
        for (Map.Entry entry : EPackage.Registry.INSTANCE.entrySet()) {
            if (!(entry.getValue() instanceof EPackage)) continue;
            WizardHelper.getClassesFromEPackageForSuperType((EPackage)entry.getValue(), superType, matches);
        }
        for (Map.Entry entry : EPackageManager.getInstance().getLoadedPackages().entrySet()) {
            WizardHelper.getClassesFromEPackageForSuperType((EPackage)entry.getValue(), superType, matches);
        }
        return matches;
    }

    public static String[] getModelTypes() {
        ArrayList<String> values = new ArrayList<String>();
        for (ModelGeneratorDescriptor desc : ModelGeneratorDescriptors.getInstance().getDescriptors()) {
            values.add(desc.getModelType());
        }
        return values.toArray(new String[values.size()]);
    }

    private static Map<ModelType, List<Model>> getAllModelsByModelType(IProgressMonitor monitor) {
        monitor.beginTask("", 100);
        MetamodelPackageManager mgr = MetamodelPackageManager.getInstance();
        if (!mgr.isInitialized()) {
            mgr.loadAll((IProgressMonitor)new SubProgressMonitor(monitor, 99));
        }
        HashMap<ModelType, List<Model>> modelsByType = new HashMap<ModelType, List<Model>>();
        for (Package pkg : MetamodelPackageManager.getInstance().getLoadedPackages().values()) {
            for (Model model : pkg.getModels()) {
                ArrayList<Model> typeModels = (ArrayList<Model>)modelsByType.get(model.getModelType());
                if (typeModels == null) {
                    typeModels = new ArrayList<Model>();
                    modelsByType.put(model.getModelType(), typeModels);
                }
                typeModels.add(model);
            }
        }
        monitor.worked(1);
        monitor.done();
        return modelsByType;
    }

    public static ModelGeneratorDescriptor getDescriptorForModelType(ModelType type) {
        return null;
    }

    public static List<ModelGeneratorDescriptor> getModelGeneratorDescriptors() {
        return ModelGeneratorDescriptors.getInstance().getDescriptors();
    }

    public static ModelType getModelTypeForDescriptor(ModelGeneratorDescriptor descriptor) {
        return ModelType.get((String)descriptor.getModelType());
    }

    public static List<Model> getModelsForModelDescriptor(ModelGeneratorDescriptor descriptor, boolean reload, IProgressMonitor monitor) {
        if (reload || modelsByType == null) {
            modelsByType = WizardHelper.getAllModelsByModelType(monitor);
        }
        return modelsByType.get(WizardHelper.getModelTypeForDescriptor(descriptor));
    }

    public static List<Model> getModelsForModelType(ModelType modelType, boolean reload, IProgressMonitor monitor) {
        monitor.beginTask("Loading Metamodels", 1);
        if (reload || modelsByType == null) {
            modelsByType = WizardHelper.getAllModelsByModelType((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        monitor.done();
        return modelsByType.get(modelType);
    }

    public static List<CompartmentGroup> getCompartmentGroupsForModelType(ModelType modelType, boolean reload, IProgressMonitor monitor) {
        ArrayList<CompartmentGroup> compartmentGroups = new ArrayList<CompartmentGroup>();
        List<Model> models = WizardHelper.getModelsForModelType(modelType, reload, monitor);
        for (Model model : models) {
            EList pkgCgs = model.getContainerPackage().getCompartmentGroups();
            for (CompartmentGroup cg : pkgCgs) {
                if (compartmentGroups.contains(cg)) continue;
                compartmentGroups.add(cg);
            }
        }
        return compartmentGroups;
    }

    private static boolean isChildOf(EClass subclass, EClass superClass) {
        boolean retVal = subclass.getEAllSuperTypes().contains((Object)superClass);
        if (!retVal) {
            for (EClass cls : subclass.getEAllSuperTypes()) {
                boolean bl = retVal = superClass.getName().equals(cls.getName()) && superClass.getEPackage().getNsURI().equals(cls.getEPackage().getNsURI());
                if (retVal) break;
            }
        }
        return retVal;
    }

    public static void getClassesFromEPackageForSuperType(EPackage pkg, EClass superType, Set<EClass> matches) {
        for (EPackage subPackage : pkg.getESubpackages()) {
            WizardHelper.getClassesFromEPackageForSuperType(subPackage, superType, matches);
        }
        for (EClassifier classifier : pkg.getEClassifiers()) {
            if (!(classifier instanceof EClass) || !WizardHelper.isChildOf((EClass)classifier, superType)) continue;
            matches.add((EClass)classifier);
        }
    }

    private static String getLabelOperationForModelType(ModelType modelType) {
        return "create" + modelType.getLiteral() + "Label";
    }

    public static EClass getLabelForModel(ModelType type, EClass model) {
        EClass retValue = null;
        try {
            EObject obj = EcoreUtil.create((EClass)model);
            if (obj != null) {
                Method invoker = obj.getClass().getMethod(WizardHelper.getLabelOperationForModelType(type), String.class);
                Object invokeResponse = invoker.invoke((Object)obj, new Object[1]);
                if (invokeResponse instanceof EObject) {
                    retValue = ((EObject)invokeResponse).eClass();
                }
            } else {
                System.err.println("No instance class for " + model.getClass());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return retValue;
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.isEmpty();
    }

    public static EDataType[] getDefaultCompartmentDataTypes() {
        return Constants.DEFAULT_COMPARTMENT_DATA_TYPES;
    }

    public static EClassifier[] getDefaultModelParamDataTypes() {
        return Constants.DEFAULT_PARAM_DATA_TYPES;
    }

    public static String getDefaultValueForDataType(EClassifier type) {
        if (type == EcorePackage.Literals.EDOUBLE || type == EcorePackage.Literals.EFLOAT) {
            return "0.0";
        }
        if (type == EcorePackage.Literals.EINT || type == EcorePackage.Literals.ESHORT || type == EcorePackage.Literals.ELONG) {
            return "0";
        }
        if (type == EcorePackage.Literals.EBOOLEAN) {
            return "true";
        }
        return "";
    }

    public static String[] getAvailableConstraints(ModelParam param, ModelParamConstraint existingConstraint) {
        return Constants.DEFAULT_PARAM_CONSTRAINTS;
    }

    public static String safeGet(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public static String safeGet(Text field) {
        if ("".equals(field.getText().trim())) {
            return null;
        }
        return field.getText();
    }

    public static Package loadPackageFromUri(URI uri) throws Exception {
        Resource resource = new ResourceSetImpl().createResource(uri);
        resource.load(null);
        Package pkg = (Package)resource.getContents().get(0);
        return pkg;
    }

    public static void loadMetamodels(boolean reload, IRunnableContext ctx) {
        if (reload || !MetamodelPackageManager.getInstance().isInitialized()) {
            try {
                ctx.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        MetamodelPackageManager.getInstance().loadAll(monitor);
                    }
                });
            }
            catch (Exception e) {
                MetamodelEditorPlugin.log((IStatus)new Status(2, "org.eclipse.stem.model.ui", e.getMessage(), (Throwable)e));
            }
        }
    }

    public static void displayEcoreProjectSelectorDialog(Shell shell, IRunnableContext runContext) {
        final ArrayList projects = new ArrayList();
        try {
            runContext.run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    projects.addAll(EPackageManager.getInstance().findECoresInWorkspace(monitor).keySet());
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(projects, new Comparator<IProject>(){

            @Override
            public int compare(IProject o1, IProject o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        final ListSelectionDialog dialog = new ListSelectionDialog(shell, projects, (IStructuredContentProvider)new WorkbenchContentProvider(){

            public Object[] getChildren(Object element) {
                if (element instanceof Collection) {
                    return ((Collection)element).toArray();
                }
                return new Object[0];
            }
        }, (ILabelProvider)new WorkbenchLabelProvider(), "Select the existing packages to load");
        dialog.setTitle("Open Resource");
        if (dialog.open() == 0) {
            try {
                runContext.run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        EPackageManager.getInstance().loadECoresFromProjects(WizardHelper.getProjectsFromResult(dialog.getResult()), monitor);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static List<IProject> getProjectsFromResult(Object[] results) {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        if (results != null && results.length > 0) {
            Object[] objectArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                Object result = objectArray[n2];
                if (result instanceof IProject) {
                    projects.add((IProject)result);
                }
                ++n2;
            }
        }
        return projects;
    }

    public static List<ModelParam> getAllParametersForModel(Model model) {
        ArrayList<ModelParam> params = new ArrayList<ModelParam>();
        if (model != null) {
            params.addAll(WizardHelper.getAllParametersForModel(model.getParentModel()));
            params.addAll((Collection<ModelParam>)model.getParameters());
        }
        return params;
    }

    public static List<Compartment> getAllCompartmentsForGroup(CompartmentGroup cg) {
        ArrayList<Compartment> compartments = new ArrayList<Compartment>();
        if (cg != null) {
            compartments.addAll(WizardHelper.getAllCompartmentsForGroup(cg.getParentGroup()));
            compartments.addAll((Collection<Compartment>)cg.getCompartments());
        }
        return compartments;
    }

    public static List<Compartment> getAllCompartmentsForModel(Model model) {
        return WizardHelper.getAllCompartmentsForGroup(model.getCompartments());
    }

    public static String formatToCapWords(String str) {
        StringBuilder sb = new StringBuilder();
        if (str.length() > 0) {
            sb.appendCodePoint(Character.toUpperCase(str.codePointAt(0)));
            int idx = 1;
            while (idx < str.length()) {
                int cp = str.codePointAt(idx);
                if (Character.isUpperCase(cp) && (Character.isLowerCase(str.codePointAt(idx - 1)) || str.length() > idx + 1 && Character.isLowerCase(str.codePointAt(idx + 1)))) {
                    sb.append(' ');
                }
                sb.appendCodePoint(cp);
                ++idx;
            }
        }
        return sb.toString();
    }

    public static String formatToCamelCase(String str) {
        StringBuilder sb = new StringBuilder();
        if (str.length() > 0) {
            boolean nextIsLC = true;
            boolean nextIsUC = false;
            int idx = 0;
            while (idx < str.length()) {
                int cp = str.codePointAt(idx);
                if (Character.isJavaIdentifierPart(cp)) {
                    if (nextIsLC) {
                        sb.appendCodePoint(Character.toLowerCase(cp));
                        nextIsLC = false;
                    } else if (nextIsUC) {
                        sb.appendCodePoint(Character.toUpperCase(cp));
                        nextIsUC = false;
                    } else {
                        sb.appendCodePoint(cp);
                    }
                } else if (!nextIsLC) {
                    nextIsUC = true;
                }
                ++idx;
            }
        }
        return sb.toString();
    }

    public static String formatToUpperCaseWordsNoSpaces(String str) {
        str = WizardHelper.formatToCamelCase(str);
        StringBuilder sb = new StringBuilder();
        if (str.length() > 0) {
            sb.appendCodePoint(Character.toUpperCase(str.codePointAt(0)));
            sb.append(str.substring(1));
        }
        return sb.toString();
    }

    public static String formatToJavaPackageName(String str) {
        boolean firstWhiteSpace = true;
        str = str.trim();
        StringBuilder sb = new StringBuilder();
        if (str != null) {
            int idx = 0;
            while (idx < str.length()) {
                int c = str.codePointAt(idx);
                if (Character.isWhitespace(c)) {
                    if (firstWhiteSpace) {
                        sb.append('.');
                        firstWhiteSpace = false;
                    }
                } else if (c == 46 || Character.isJavaIdentifierPart(c)) {
                    sb.appendCodePoint(c);
                    firstWhiteSpace = true;
                }
                ++idx;
            }
        }
        return sb.toString().toLowerCase();
    }

    public static boolean isValidJavaPackageName(String str) {
        boolean valid = false;
        String[] stringArray = str.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (!WizardHelper.isValidJavaName(token)) {
                valid = false;
                break;
            }
            valid = true;
            ++n2;
        }
        return valid;
    }

    public static boolean isValidJavaName(String str) {
        boolean valid = false;
        if (str.length() > 0) {
            valid = Character.isJavaIdentifierStart(str.codePointAt(0));
            int idx = 1;
            while (valid && idx < str.length()) {
                valid = Character.isJavaIdentifierPart(str.codePointAt(idx));
                if (!valid) break;
                ++idx;
            }
        }
        return valid;
    }

    public static String getFirstMatchingModelName(Package pkg) {
        ArrayList<String> modelNames = new ArrayList<String>();
        for (Model m : pkg.getModels()) {
            String name = m.getName();
            if (modelNames.contains(name)) {
                return name;
            }
            modelNames.add(name);
        }
        return null;
    }
}

