/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.common.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.stem.core.common.CommonPackage;
import org.eclipse.stem.core.common.DublinCore;

public class DublinCoreImpl
extends EObjectImpl
implements DublinCore {
    protected static final String TITLE_EDEFAULT = null;
    protected String title = TITLE_EDEFAULT;
    protected static final String IDENTIFIER_EDEFAULT = null;
    protected String identifier = IDENTIFIER_EDEFAULT;
    protected static final String DESCRIPTION_EDEFAULT = null;
    protected String description = DESCRIPTION_EDEFAULT;
    protected static final String CREATOR_EDEFAULT = null;
    protected String creator = CREATOR_EDEFAULT;
    protected static final String DATE_EDEFAULT = null;
    protected String date = DATE_EDEFAULT;
    protected static final String FORMAT_EDEFAULT = null;
    protected String format = FORMAT_EDEFAULT;
    protected static final String PUBLISHER_EDEFAULT = null;
    protected String publisher = PUBLISHER_EDEFAULT;
    protected static final String COVERAGE_EDEFAULT = null;
    protected String coverage = COVERAGE_EDEFAULT;
    protected static final String CONTRIBUTOR_EDEFAULT = null;
    protected String contributor = CONTRIBUTOR_EDEFAULT;
    protected static final String RELATION_EDEFAULT = null;
    protected String relation = RELATION_EDEFAULT;
    protected static final String RIGHTS_EDEFAULT = null;
    protected String rights = RIGHTS_EDEFAULT;
    protected static final String SOURCE_EDEFAULT = null;
    protected String source = SOURCE_EDEFAULT;
    protected static final String SUBJECT_EDEFAULT = null;
    protected String subject = SUBJECT_EDEFAULT;
    protected static final String TYPE_EDEFAULT = null;
    protected String type = TYPE_EDEFAULT;
    protected static final String LANGUAGE_EDEFAULT = null;
    protected String language = LANGUAGE_EDEFAULT;
    protected static final String BIBLIOGRAPHIC_CITATION_EDEFAULT = null;
    protected String bibliographicCitation = BIBLIOGRAPHIC_CITATION_EDEFAULT;
    protected static final String CREATED_EDEFAULT = null;
    protected String created = CREATED_EDEFAULT;
    protected static final String LICENSE_EDEFAULT = null;
    protected String license = LICENSE_EDEFAULT;
    protected static final String REQUIRED_EDEFAULT = null;
    protected String required = REQUIRED_EDEFAULT;
    protected static final String SPATIAL_EDEFAULT = null;
    protected String spatial = SPATIAL_EDEFAULT;
    protected static final String VALID_EDEFAULT = null;
    public static final String START = "start=";
    public static final String END = "end=";
    protected String valid = VALID_EDEFAULT;

    protected DublinCoreImpl() {
    }

    public DublinCoreImpl(IConfigurationElement configElement) {
        this.setTitle(configElement.getAttribute("title"));
        this.setCreator(configElement.getAttribute("creator"));
        this.setSubject(configElement.getAttribute("subject"));
        this.setDescription(configElement.getAttribute("description"));
        this.setPublisher(configElement.getAttribute("publisher"));
        this.setContributor(configElement.getAttribute("contributor"));
        this.setDate(configElement.getAttribute("date"));
        this.setType(configElement.getAttribute("type"));
        this.setFormat(configElement.getAttribute("format"));
        this.setIdentifier(configElement.getAttribute("identifier"));
        this.setSource(configElement.getAttribute("source"));
        this.setLanguage(configElement.getAttribute("language"));
        this.setRelation(configElement.getAttribute("relation"));
        this.setCoverage(configElement.getAttribute("coverage"));
        this.setBibliographicCitation(configElement.getAttribute("bibliographicCitation"));
        this.setCreated(configElement.getAttribute("created"));
        this.setLicense(configElement.getAttribute("license"));
        this.setRequired(configElement.getAttribute("required"));
        this.setSpatial(configElement.getAttribute("spatial"));
        this.setValid(configElement.getAttribute("valid"));
    }

    protected EClass eStaticClass() {
        return CommonPackage.Literals.DUBLIN_CORE;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String newTitle) {
        String oldTitle = this.title;
        this.title = newTitle;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldTitle, (Object)this.title));
        }
    }

    @Override
    public String getCreator() {
        return this.creator;
    }

    @Override
    public void setCreator(String newCreator) {
        String oldCreator = this.creator;
        this.creator = newCreator;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldCreator, (Object)this.creator));
        }
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public void setSubject(String newSubject) {
        String oldSubject = this.subject;
        this.subject = newSubject;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldSubject, (Object)this.subject));
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String newDescription) {
        String oldDescription = this.description;
        this.description = newDescription;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldDescription, (Object)this.description));
        }
    }

    @Override
    public String getPublisher() {
        return this.publisher;
    }

    @Override
    public void setPublisher(String newPublisher) {
        String oldPublisher = this.publisher;
        this.publisher = newPublisher;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldPublisher, (Object)this.publisher));
        }
    }

    @Override
    public String getContributor() {
        return this.contributor;
    }

    @Override
    public void setContributor(String newContributor) {
        String oldContributor = this.contributor;
        this.contributor = newContributor;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldContributor, (Object)this.contributor));
        }
    }

    @Override
    public String getDate() {
        return this.date;
    }

    @Override
    public void setDate(String newDate) {
        String oldDate = this.date;
        this.date = newDate;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldDate, (Object)this.date));
        }
    }

    @Override
    public void setDate(Date date) {
        this.setDate(DublinCoreImpl.createISO8601DateString(date));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String newType) {
        String oldType = this.type;
        this.type = newType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldType, (Object)this.type));
        }
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(String newFormat) {
        String oldFormat = this.format;
        this.format = newFormat;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldFormat, (Object)this.format));
        }
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public EStructuralFeature getFeature(String featureName) {
        EList featureList = this.eClass().getEStructuralFeatures();
        int i = 0;
        while (i < featureList.size()) {
            if (((EStructuralFeature)featureList.get(i)).getName().equalsIgnoreCase(featureName)) {
                return (EStructuralFeature)featureList.get(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public void setIdentifier(String newIdentifier) {
        String oldIdentifier = this.identifier;
        this.identifier = newIdentifier;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldIdentifier, (Object)this.identifier));
        }
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void setSource(String newSource) {
        String oldSource = this.source;
        this.source = newSource;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldSource, (Object)this.source));
        }
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public void setLanguage(String newLanguage) {
        String oldLanguage = this.language;
        this.language = newLanguage;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, (Object)oldLanguage, (Object)this.language));
        }
    }

    @Override
    public String getRelation() {
        return this.relation;
    }

    @Override
    public void setRelation(String newRelation) {
        String oldRelation = this.relation;
        this.relation = newRelation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldRelation, (Object)this.relation));
        }
    }

    @Override
    public String getCoverage() {
        return this.coverage;
    }

    @Override
    public void setCoverage(String newCoverage) {
        String oldCoverage = this.coverage;
        this.coverage = newCoverage;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldCoverage, (Object)this.coverage));
        }
    }

    @Override
    public String getRights() {
        return this.rights;
    }

    @Override
    public void setRights(String newRights) {
        String oldRights = this.rights;
        this.rights = newRights;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldRights, (Object)this.rights));
        }
    }

    @Override
    public String getBibliographicCitation() {
        return this.bibliographicCitation;
    }

    @Override
    public void setBibliographicCitation(String newBibliographicCitation) {
        String oldBibliographicCitation = this.bibliographicCitation;
        this.bibliographicCitation = newBibliographicCitation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)oldBibliographicCitation, (Object)this.bibliographicCitation));
        }
    }

    @Override
    public String getCreated() {
        return this.created;
    }

    @Override
    public void setCreated(String newCreated) {
        String oldCreated = this.created;
        this.created = newCreated;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, (Object)oldCreated, (Object)this.created));
        }
    }

    @Override
    public void setCreated(Date date) {
        this.setCreated(DublinCoreImpl.createISO8601DateString(date));
    }

    @Override
    public String getLicense() {
        return this.license;
    }

    @Override
    public void setLicense(String newLicense) {
        String oldLicense = this.license;
        this.license = newLicense;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 17, (Object)oldLicense, (Object)this.license));
        }
    }

    @Override
    public String getRequired() {
        return this.required;
    }

    @Override
    public void setRequired(String newRequired) {
        String oldRequired = this.required;
        this.required = newRequired;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 18, (Object)oldRequired, (Object)this.required));
        }
    }

    @Override
    public String getSpatial() {
        return this.spatial;
    }

    @Override
    public void setSpatial(String newSpatial) {
        String oldSpatial = this.spatial;
        this.spatial = newSpatial;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 19, (Object)oldSpatial, (Object)this.spatial));
        }
    }

    @Override
    public String getValid() {
        return this.valid;
    }

    @Override
    public Date getValidEndDate() {
        return DublinCoreImpl.getValidEndDate(this.getValid());
    }

    public static Date getValidEndDate(String validValue) {
        int dateIndex;
        Date retValue = null;
        if (validValue != null && (dateIndex = validValue.indexOf(END)) >= 0) {
            try {
                retValue = DublinCoreImpl.createDateFromISO8601DateString(validValue.substring(dateIndex + END.length()));
            }
            catch (ParseException parseException) {
                retValue = null;
            }
        }
        return retValue;
    }

    @Override
    public boolean isValidBefore(DublinCore dublinCore) {
        Date ourStartDate = this.getValidStartDate();
        Date otherStartDate = dublinCore != null ? dublinCore.getValidStartDate() : null;
        boolean retValue = dublinCore == null || otherStartDate == null;
        retValue = retValue || ourStartDate != null && otherStartDate.after(ourStartDate);
        return retValue;
    }

    @Override
    public Date[] computeValidDateRangeOverlap(DublinCore dublinCore) {
        Date[] retValue = null;
        Date ourStartDate = this.getValidStartDate();
        Date ourEndDate = this.getValidEndDate();
        Date otherStartDate = dublinCore.getValidStartDate();
        Date otherEndDate = dublinCore.getValidEndDate();
        Date newStartDate = ourStartDate;
        Date newEndDate = ourEndDate;
        if (ourStartDate != null) {
            if (otherStartDate != null && otherStartDate.after(ourStartDate)) {
                newStartDate = otherStartDate;
            }
        } else {
            newStartDate = otherStartDate;
        }
        if (ourEndDate != null) {
            if (otherEndDate != null && otherEndDate.before(ourEndDate)) {
                newEndDate = otherEndDate;
            }
        } else {
            newEndDate = otherEndDate;
        }
        if (newStartDate != null && newEndDate != null && newStartDate.before(newEndDate)) {
            retValue = new Date[]{newStartDate, newEndDate};
        }
        return retValue;
    }

    public static boolean isValidEndDateValid(String validValue) {
        boolean retValue = true;
        if (validValue != null) {
            int dateIndex;
            String endPart;
            block11: {
                block10: {
                    block9: {
                        endPart = validValue.substring("start=yyyy-DD-mm;".length()).trim();
                        dateIndex = endPart.indexOf(END);
                        if (!endPart.equals("")) break block9;
                        return true;
                    }
                    if (endPart.endsWith(";")) break block10;
                    return false;
                }
                if (endPart.length() == END.length() + "yyyy-dd-mm;".length()) break block11;
                return false;
            }
            try {
                if (dateIndex == 0) {
                    DublinCoreImpl.createDateFromISO8601DateString(endPart.substring(END.length()));
                    retValue = true;
                } else {
                    retValue = false;
                }
            }
            catch (ParseException parseException) {
                retValue = false;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                retValue = false;
            }
        }
        return retValue;
    }

    @Override
    public Date getValidStartDate() {
        return DublinCoreImpl.getValidStartDate(this.getValid());
    }

    public static Date getValidStartDate(String validValue) {
        Date retValue = null;
        if (validValue != null) {
            int dateIndex = validValue.indexOf(START) + START.length();
            try {
                retValue = DublinCoreImpl.createDateFromISO8601DateString(validValue.substring(dateIndex));
            }
            catch (ParseException parseException) {
                retValue = null;
            }
        }
        return retValue;
    }

    public static boolean isValidStartDateValid(String validValue) {
        boolean retValue = false;
        if (validValue != null) {
            String extractedDate;
            block5: {
                String trimedValidValue = validValue.trim();
                int dateIndex = validValue.indexOf(START) + START.length();
                extractedDate = trimedValidValue.substring(dateIndex, "start=YYYY-DD-MM;".length());
                if (extractedDate.endsWith(";")) break block5;
                return false;
            }
            try {
                DublinCoreImpl.createDateFromISO8601DateString(extractedDate);
                retValue = true;
            }
            catch (ParseException parseException) {
                retValue = false;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                retValue = false;
            }
        }
        return retValue;
    }

    @Override
    public void setValid(String newValid) {
        String oldValid = this.valid;
        this.valid = newValid;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 20, (Object)oldValid, (Object)this.valid));
        }
    }

    @Override
    public DublinCore populate() {
        this.setCreated(Calendar.getInstance().getTime());
        this.setCreator(System.getProperty("user.name"));
        return this;
    }

    @Override
    public void setValid(Date startDate, Date endDate) {
        StringBuilder sb = new StringBuilder(START);
        sb.append(DublinCoreImpl.createISO8601DateString(startDate));
        sb.append("; ");
        sb.append(END);
        sb.append(DublinCoreImpl.createISO8601DateString(endDate));
        sb.append(";");
        this.setValid(sb.toString());
    }

    @Override
    public void setValid(Date startDate) {
        StringBuilder sb = new StringBuilder(START);
        sb.append(DublinCoreImpl.createISO8601DateString(startDate));
        sb.append(";");
        this.setValid(sb.toString());
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getTitle();
            }
            case 1: {
                return this.getIdentifier();
            }
            case 2: {
                return this.getDescription();
            }
            case 3: {
                return this.getCreator();
            }
            case 4: {
                return this.getDate();
            }
            case 5: {
                return this.getFormat();
            }
            case 6: {
                return this.getPublisher();
            }
            case 7: {
                return this.getCoverage();
            }
            case 8: {
                return this.getContributor();
            }
            case 9: {
                return this.getRelation();
            }
            case 10: {
                return this.getRights();
            }
            case 11: {
                return this.getSource();
            }
            case 12: {
                return this.getSubject();
            }
            case 13: {
                return this.getType();
            }
            case 14: {
                return this.getLanguage();
            }
            case 15: {
                return this.getBibliographicCitation();
            }
            case 16: {
                return this.getCreated();
            }
            case 17: {
                return this.getLicense();
            }
            case 18: {
                return this.getRequired();
            }
            case 19: {
                return this.getSpatial();
            }
            case 20: {
                return this.getValid();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setTitle((String)newValue);
                return;
            }
            case 1: {
                this.setIdentifier((String)newValue);
                return;
            }
            case 2: {
                this.setDescription((String)newValue);
                return;
            }
            case 3: {
                this.setCreator((String)newValue);
                return;
            }
            case 4: {
                this.setDate((String)newValue);
                return;
            }
            case 5: {
                this.setFormat((String)newValue);
                return;
            }
            case 6: {
                this.setPublisher((String)newValue);
                return;
            }
            case 7: {
                this.setCoverage((String)newValue);
                return;
            }
            case 8: {
                this.setContributor((String)newValue);
                return;
            }
            case 9: {
                this.setRelation((String)newValue);
                return;
            }
            case 10: {
                this.setRights((String)newValue);
                return;
            }
            case 11: {
                this.setSource((String)newValue);
                return;
            }
            case 12: {
                this.setSubject((String)newValue);
                return;
            }
            case 13: {
                this.setType((String)newValue);
                return;
            }
            case 14: {
                this.setLanguage((String)newValue);
                return;
            }
            case 15: {
                this.setBibliographicCitation((String)newValue);
                return;
            }
            case 16: {
                this.setCreated((String)newValue);
                return;
            }
            case 17: {
                this.setLicense((String)newValue);
                return;
            }
            case 18: {
                this.setRequired((String)newValue);
                return;
            }
            case 19: {
                this.setSpatial((String)newValue);
                return;
            }
            case 20: {
                this.setValid((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setTitle(TITLE_EDEFAULT);
                return;
            }
            case 1: {
                this.setIdentifier(IDENTIFIER_EDEFAULT);
                return;
            }
            case 2: {
                this.setDescription(DESCRIPTION_EDEFAULT);
                return;
            }
            case 3: {
                this.setCreator(CREATOR_EDEFAULT);
                return;
            }
            case 4: {
                this.setDate(DATE_EDEFAULT);
                return;
            }
            case 5: {
                this.setFormat(FORMAT_EDEFAULT);
                return;
            }
            case 6: {
                this.setPublisher(PUBLISHER_EDEFAULT);
                return;
            }
            case 7: {
                this.setCoverage(COVERAGE_EDEFAULT);
                return;
            }
            case 8: {
                this.setContributor(CONTRIBUTOR_EDEFAULT);
                return;
            }
            case 9: {
                this.setRelation(RELATION_EDEFAULT);
                return;
            }
            case 10: {
                this.setRights(RIGHTS_EDEFAULT);
                return;
            }
            case 11: {
                this.setSource(SOURCE_EDEFAULT);
                return;
            }
            case 12: {
                this.setSubject(SUBJECT_EDEFAULT);
                return;
            }
            case 13: {
                this.setType(TYPE_EDEFAULT);
                return;
            }
            case 14: {
                this.setLanguage(LANGUAGE_EDEFAULT);
                return;
            }
            case 15: {
                this.setBibliographicCitation(BIBLIOGRAPHIC_CITATION_EDEFAULT);
                return;
            }
            case 16: {
                this.setCreated(CREATED_EDEFAULT);
                return;
            }
            case 17: {
                this.setLicense(LICENSE_EDEFAULT);
                return;
            }
            case 18: {
                this.setRequired(REQUIRED_EDEFAULT);
                return;
            }
            case 19: {
                this.setSpatial(SPATIAL_EDEFAULT);
                return;
            }
            case 20: {
                this.setValid(VALID_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return TITLE_EDEFAULT == null ? this.title != null : !TITLE_EDEFAULT.equals(this.title);
            }
            case 1: {
                return IDENTIFIER_EDEFAULT == null ? this.identifier != null : !IDENTIFIER_EDEFAULT.equals(this.identifier);
            }
            case 2: {
                return DESCRIPTION_EDEFAULT == null ? this.description != null : !DESCRIPTION_EDEFAULT.equals(this.description);
            }
            case 3: {
                return CREATOR_EDEFAULT == null ? this.creator != null : !CREATOR_EDEFAULT.equals(this.creator);
            }
            case 4: {
                return DATE_EDEFAULT == null ? this.date != null : !DATE_EDEFAULT.equals(this.date);
            }
            case 5: {
                return FORMAT_EDEFAULT == null ? this.format != null : !FORMAT_EDEFAULT.equals(this.format);
            }
            case 6: {
                return PUBLISHER_EDEFAULT == null ? this.publisher != null : !PUBLISHER_EDEFAULT.equals(this.publisher);
            }
            case 7: {
                return COVERAGE_EDEFAULT == null ? this.coverage != null : !COVERAGE_EDEFAULT.equals(this.coverage);
            }
            case 8: {
                return CONTRIBUTOR_EDEFAULT == null ? this.contributor != null : !CONTRIBUTOR_EDEFAULT.equals(this.contributor);
            }
            case 9: {
                return RELATION_EDEFAULT == null ? this.relation != null : !RELATION_EDEFAULT.equals(this.relation);
            }
            case 10: {
                return RIGHTS_EDEFAULT == null ? this.rights != null : !RIGHTS_EDEFAULT.equals(this.rights);
            }
            case 11: {
                return SOURCE_EDEFAULT == null ? this.source != null : !SOURCE_EDEFAULT.equals(this.source);
            }
            case 12: {
                return SUBJECT_EDEFAULT == null ? this.subject != null : !SUBJECT_EDEFAULT.equals(this.subject);
            }
            case 13: {
                return TYPE_EDEFAULT == null ? this.type != null : !TYPE_EDEFAULT.equals(this.type);
            }
            case 14: {
                return LANGUAGE_EDEFAULT == null ? this.language != null : !LANGUAGE_EDEFAULT.equals(this.language);
            }
            case 15: {
                return BIBLIOGRAPHIC_CITATION_EDEFAULT == null ? this.bibliographicCitation != null : !BIBLIOGRAPHIC_CITATION_EDEFAULT.equals(this.bibliographicCitation);
            }
            case 16: {
                return CREATED_EDEFAULT == null ? this.created != null : !CREATED_EDEFAULT.equals(this.created);
            }
            case 17: {
                return LICENSE_EDEFAULT == null ? this.license != null : !LICENSE_EDEFAULT.equals(this.license);
            }
            case 18: {
                return REQUIRED_EDEFAULT == null ? this.required != null : !REQUIRED_EDEFAULT.equals(this.required);
            }
            case 19: {
                return SPATIAL_EDEFAULT == null ? this.spatial != null : !SPATIAL_EDEFAULT.equals(this.spatial);
            }
            case 20: {
                return VALID_EDEFAULT == null ? this.valid != null : !VALID_EDEFAULT.equals(this.valid);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder();
        if (this.getIdentifier() != null && !this.getIdentifier().equals("")) {
            result.append("identifier=\"");
            result.append(this.getIdentifier().trim());
            result.append("\" ");
        }
        if (this.getType() != null && !this.getType().equals("")) {
            result.append("type=\"");
            result.append(this.getType().trim());
            result.append("\" ");
        }
        if (this.getTitle() != null && !this.getTitle().equals("")) {
            result.append("title=\"");
            result.append(this.getTitle().trim());
            result.append("\" ");
        }
        if (this.getCreator() != null && !this.getCreator().equals("")) {
            result.append("creator=\"");
            result.append(this.getCreator().trim());
            result.append("\" ");
        }
        if (this.getSubject() != null && !this.getSubject().equals("")) {
            result.append("subject=\"");
            result.append(this.getSubject().trim());
            result.append("\" ");
        }
        if (this.getDescription() != null && !this.getDescription().equals("")) {
            result.append("description=\"");
            result.append(this.getDescription().trim());
            result.append("\" ");
        }
        if (this.getPublisher() != null && !this.getPublisher().equals("")) {
            result.append("publisher=\"");
            result.append(this.getPublisher().trim());
            result.append("\" ");
        }
        if (this.getContributor() != null && !this.getContributor().equals("")) {
            result.append("contributor=\"");
            result.append(this.getContributor().trim());
            result.append("\" ");
        }
        if (this.getDate() != null && !this.getDate().equals("")) {
            result.append("date=\"");
            result.append(this.getDate().trim());
            result.append("\" ");
        }
        if (this.getFormat() != null && !this.getFormat().equals("")) {
            result.append("format=\"");
            result.append(this.getFormat().trim());
            result.append("\" ");
        }
        if (this.getSource() != null && !this.getSource().equals("")) {
            result.append("source=\"");
            result.append(this.getSource().trim());
            result.append("\" ");
        }
        if (this.getLanguage() != null && !this.getLanguage().equals("")) {
            result.append("language=\"");
            result.append(this.getLanguage().trim());
            result.append("\" ");
        }
        if (this.getRelation() != null && !this.getRelation().equals("")) {
            result.append("relation=\"");
            result.append(this.getRelation().trim());
            result.append("\" ");
        }
        if (this.getCoverage() != null && !this.getCoverage().equals("")) {
            result.append("coverage=\"");
            result.append(this.getCoverage().trim());
            result.append("\" ");
        }
        if (this.getRights() != null && !this.getRights().equals("")) {
            result.append("rights=\"");
            result.append(this.getRights().trim());
            result.append("\" ");
        }
        if (this.getBibliographicCitation() != null && !this.getBibliographicCitation().equals("")) {
            result.append("bibliographicCitation=\"");
            result.append(this.getBibliographicCitation().trim());
            result.append("\" ");
        }
        if (this.getCreated() != null && !this.getCreated().equals("")) {
            result.append("created=\"");
            result.append(this.getCreated().trim());
            result.append("\" ");
        }
        if (this.getLicense() != null && !this.getLicense().equals("")) {
            result.append("license=\"");
            result.append(this.getLicense().trim());
            result.append("\" ");
        }
        if (this.getRequired() != null && !this.getRequired().equals("")) {
            result.append("required=\"");
            result.append(this.getRequired().trim());
            result.append("\" ");
        }
        if (this.getSpatial() != null && !this.getSpatial().equals("")) {
            result.append("spatial=\"");
            result.append(this.getSpatial().trim());
            result.append("\" ");
        }
        if (this.getValid() != null && !this.getValid().equals("")) {
            result.append("valid=\"");
            result.append(this.getValid().trim());
            result.append("\" ");
        }
        return result.toString();
    }

    public static String createISO8601DateString(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    public static Date createDateFromISO8601DateString(String iso8601DateString) throws ParseException {
        Date result = null;
        try {
            result = new SimpleDateFormat("yyyy-MM-dd").parse(iso8601DateString);
        }
        catch (Exception exception) {
            result = new SimpleDateFormat("yyyy").parse(iso8601DateString);
        }
        return result;
    }
}

