/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.core.graph.impl;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.stem.core.CorePlugin;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.IdentifiableFilter;
import org.eclipse.stem.core.common.impl.IdentifiableFilterImpl;
import org.eclipse.stem.core.common.impl.IdentifiableImpl;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.GraphPackage;
import org.eclipse.stem.core.graph.Label;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.graph.UnresolvedIdentifiable;
import org.eclipse.stem.core.graph.impl.URIToEdgeMapEntryImpl;
import org.eclipse.stem.core.graph.impl.URIToLabelMapEntryImpl;
import org.eclipse.stem.core.graph.impl.URIToNodeLabelMapEntryImpl;
import org.eclipse.stem.core.graph.impl.URIToNodeMapEntryImpl;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.core.model.STEMTime;

public class GraphImpl
extends IdentifiableImpl
implements Graph {
    protected EMap<URI, Edge> edges;
    protected EMap<URI, Node> nodes;
    protected EMap<URI, Label> graphLabels;
    protected EMap<URI, NodeLabel> nodeLabels;
    protected EList<DynamicLabel> dynamicLabels;
    protected static final int NUM_EDGES_EDEFAULT = 0;
    protected static final int NUM_NODES_EDEFAULT = 0;
    protected static final int NUM_GRAPH_LABELS_EDEFAULT = 0;
    protected static final int NUM_NODE_LABELS_EDEFAULT = 0;
    protected static final int NUM_DYNAMIC_LABELS_EDEFAULT = 0;
    protected EList<UnresolvedIdentifiable> unresolvedIdentifiables;
    protected EList<Decorator> decorators;
    protected STEMTime time;

    protected GraphImpl() {
        this.setURI(STEMURI.createURI("graph/" + STEMURI.generateUniquePart()));
        this.setTypeURI(STEMURI.GRAPH_TYPE_URI);
    }

    @Override
    protected EClass eStaticClass() {
        return GraphPackage.Literals.GRAPH;
    }

    @Override
    public void setURI(URI newURI) {
        super.setURI(newURI);
        for (Label label : this.getGraphLabels().values()) {
            label.setURIOfIdentifiableToBeLabeled(newURI);
        }
    }

    @Override
    public EMap<URI, Edge> getEdges() {
        if (this.edges == null) {
            this.edges = new EcoreEMap(GraphPackage.Literals.URI_TO_EDGE_MAP_ENTRY, URIToEdgeMapEntryImpl.class, (InternalEObject)this, 3);
        }
        return this.edges;
    }

    @Override
    public EMap<URI, Node> getNodes() {
        if (this.nodes == null) {
            this.nodes = new EcoreEMap(GraphPackage.Literals.URI_TO_NODE_MAP_ENTRY, URIToNodeMapEntryImpl.class, (InternalEObject)this, 4);
        }
        return this.nodes;
    }

    @Override
    public EList<DynamicLabel> getDynamicLabels() {
        if (this.dynamicLabels == null) {
            this.dynamicLabels = new EObjectResolvingEList(DynamicLabel.class, (InternalEObject)this, 7);
        }
        return this.dynamicLabels;
    }

    @Override
    public EMap<URI, Label> getGraphLabels() {
        if (this.graphLabels == null) {
            this.graphLabels = new EcoreEMap(GraphPackage.Literals.URI_TO_LABEL_MAP_ENTRY, URIToLabelMapEntryImpl.class, (InternalEObject)this, 5);
        }
        return this.graphLabels;
    }

    @Override
    public EList<UnresolvedIdentifiable> getUnresolvedIdentifiables() {
        if (this.unresolvedIdentifiables == null) {
            this.unresolvedIdentifiables = new EObjectContainmentEList(UnresolvedIdentifiable.class, (InternalEObject)this, 13);
        }
        return this.unresolvedIdentifiables;
    }

    @Override
    public EList<Decorator> getDecorators() {
        if (this.decorators == null) {
            this.decorators = new EObjectContainmentWithInverseEList(Decorator.class, (InternalEObject)this, 14, 4);
        }
        return this.decorators;
    }

    @Override
    public STEMTime getTime() {
        return this.time;
    }

    public NotificationChain basicSetTime(STEMTime newTime, NotificationChain msgs) {
        STEMTime oldTime = this.time;
        this.time = newTime;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 15, (Object)oldTime, (Object)newTime);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setTime(STEMTime newTime) {
        if (newTime != this.time) {
            NotificationChain msgs = null;
            if (this.time != null) {
                msgs = ((InternalEObject)this.time).eInverseRemove((InternalEObject)this, -16, null, msgs);
            }
            if (newTime != null) {
                msgs = ((InternalEObject)newTime).eInverseAdd((InternalEObject)this, -16, null, msgs);
            }
            if ((msgs = this.basicSetTime(newTime, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)newTime, (Object)newTime));
        }
    }

    @Override
    public EList<NodeLabel> getNodeLabelsByTypeURI(URI typeURI) {
        BasicEList retValue = new BasicEList();
        for (NodeLabel nodeLabel : this.getNodeLabels().values()) {
            if (!nodeLabel.getTypeURI().equals((Object)typeURI)) continue;
            retValue.add((Object)nodeLabel);
        }
        ECollections.sort((EList)retValue, (Comparator)new Comparator<NodeLabel>(){

            @Override
            public int compare(NodeLabel arg0, NodeLabel arg1) {
                Node n1 = arg0.getNode();
                Node n2 = arg1.getNode();
                if (n1 == null) {
                    CorePlugin.logError("Label " + arg0.getClass() + " " + arg0 + " uri:" + arg0.getURI() + " node is null", new Exception());
                    return 0;
                }
                if (n2 == null) {
                    CorePlugin.logError("Label " + arg1.getClass() + " " + arg1 + " uri:" + arg1.getURI() + " node is null", new Exception());
                    return 0;
                }
                URI u1 = n1.getURI();
                URI u2 = n2.getURI();
                if (u1 == null) {
                    CorePlugin.logError("Node " + n1 + " missing URI", new Exception());
                    return 0;
                }
                if (u2 == null) {
                    CorePlugin.logError("Node " + n2 + " missing URI", new Exception());
                    return 0;
                }
                return u1.toString().compareTo(u2.toString());
            }
        });
        return retValue;
    }

    @Override
    public EMap<URI, NodeLabel> getNodeLabels() {
        if (this.nodeLabels == null) {
            this.nodeLabels = new EcoreEMap(GraphPackage.Literals.URI_TO_NODE_LABEL_MAP_ENTRY, URIToNodeLabelMapEntryImpl.class, (InternalEObject)this, 6);
        }
        return this.nodeLabels;
    }

    @Override
    public int getNumEdges() {
        return this.getEdges() == null ? 0 : this.getEdges().size();
    }

    @Override
    public int getNumNodes() {
        return this.getNodes() == null ? 0 : this.getNodes().size();
    }

    @Override
    public int getNumGraphLabels() {
        return this.getGraphLabels() == null ? 0 : this.getGraphLabels().size();
    }

    @Override
    public int getNumNodeLabels() {
        return this.getNodeLabels() == null ? 0 : this.getNodeLabels().size();
    }

    @Override
    public int getNumDynamicLabels() {
        return this.getDynamicLabels() == null ? 0 : this.getDynamicLabels().size();
    }

    @Override
    public void addGraph(Graph graph, IdentifiableFilter filter) {
        IdentifiableFilterImpl _filter = (IdentifiableFilterImpl)filter;
        EMap<URI, Edge> edges = graph.getEdges();
        EMap<URI, Node> nodes = graph.getNodes();
        EMap<URI, NodeLabel> nodeLabels = graph.getNodeLabels();
        EMap<URI, Label> graphLabels = graph.getGraphLabels();
        if (filter != null) {
            _filter.filterEdges(edges);
            _filter.filterNodes(nodes);
            _filter.filterNodeLabels(nodeLabels);
            _filter.filterLabels(graphLabels);
        }
        this.getEdges().addAll(edges);
        this.getNodes().addAll(nodes);
        this.getNodeLabels().addAll(nodeLabels);
        this.getDecorators().addAll(graph.getDecorators());
        for (Label graphLabel : graphLabels.values()) {
            graphLabel.setURIOfIdentifiableToBeLabeled(this.getURI());
            this.putGraphLabel(graphLabel);
        }
        this.getDynamicLabels().addAll(graph.getDynamicLabels());
        this.getUnresolvedIdentifiables().addAll(graph.getUnresolvedIdentifiables());
    }

    @Override
    public void putEdge(Edge edge) {
        this.getEdges().put((Object)edge.getURI(), (Object)edge);
        EdgeLabel edgeLabel = edge.getLabel();
        if (edgeLabel instanceof DynamicLabel) {
            this.addDynamicLabel((DynamicLabel)((Object)edgeLabel));
        }
    }

    @Override
    public Edge getEdge(URI uri) {
        return (Edge)this.getEdges().get((Object)uri);
    }

    @Override
    public void putNode(Node node) {
        this.getNodes().put((Object)node.getURI(), (Object)node);
        for (NodeLabel nodeLabel : node.getLabels()) {
            this.putNodeLabel(nodeLabel);
        }
    }

    @Override
    public Node getNode(URI uri) {
        return (Node)this.getNodes().get((Object)uri);
    }

    @Override
    public void putNodeLabel(NodeLabel label) {
        this.getNodeLabels().put((Object)label.getURI(), (Object)label);
        if (label instanceof DynamicLabel) {
            this.addDynamicLabel((DynamicLabel)((Object)label));
        }
    }

    @Override
    public NodeLabel getNodeLabel(URI uri) {
        return (NodeLabel)this.getNodeLabels().get((Object)uri);
    }

    @Override
    public void putGraphLabel(Label label) {
        this.getGraphLabels().put((Object)label.getURI(), (Object)label);
        if (label instanceof DynamicLabel) {
            this.addDynamicLabel((DynamicLabel)label);
        }
    }

    @Override
    public Label getGraphLabel(URI uri) {
        return (Label)this.getGraphLabels().get((Object)uri);
    }

    @Override
    public void addDynamicLabel(DynamicLabel dynamiclabel) {
        this.getDynamicLabels().add((Object)dynamiclabel);
    }

    @Override
    public void switchToNextValue(STEMTime currentTime) {
        for (DynamicLabel dynamicLabel : this.getDynamicLabels()) {
            dynamicLabel.switchToNextValue();
        }
        this.setTime((STEMTime)EcoreUtil.copy((EObject)currentTime));
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 14: {
                return ((InternalEList)this.getDecorators()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("\"" + this.getDublinCore().getTitle() + "\",\n");
        sb.append(this.getNumNodes() > 0 ? String.valueOf(this.getNumNodes()) + " Nodes\n" : "");
        sb.append(this.getNumEdges() > 0 ? String.valueOf(this.getNumEdges()) + " Edges\n" : "");
        sb.append(this.getNumNodeLabels() > 0 ? String.valueOf(this.getNumNodeLabels()) + " Node Labels " : "");
        sb.append(this.getNumGraphLabels() > 0 ? String.valueOf(this.getNumGraphLabels()) + " Graph Labels\n" : "");
        sb.append(this.getNumDynamicLabels() > 0 ? String.valueOf(this.getNumDynamicLabels()) + " Dynamic Labels\n" : "");
        sb.append("URI: " + this.getURI() + "\n");
        return sb.toString();
    }

    @Override
    public boolean sane() {
        boolean retValue = super.sane();
        int dynamicLabelCount = 0;
        if (this.getNodes() != null) {
            Iterator nodeIter = this.getNodes().values().iterator();
            while (nodeIter.hasNext() && retValue) {
                Node node = (Node)nodeIter.next();
                boolean bl = retValue = retValue && node.sane();
                assert (retValue);
                node.getLabels().size();
                for (Label label : node.getLabels()) {
                    if (label instanceof DynamicLabel) {
                        ++dynamicLabelCount;
                        retValue = false;
                        for (DynamicLabel dl : this.getDynamicLabels()) {
                            if (dl != label) continue;
                            retValue = true;
                            break;
                        }
                        assert (retValue);
                    }
                    boolean bl2 = retValue = retValue && this.getNodeLabels().containsKey((Object)label.getURI());
                    assert (retValue);
                }
            }
        }
        if (this.getEdges() != null) {
            Iterator edgeIter = this.getEdges().values().iterator();
            while (edgeIter.hasNext() && retValue) {
                Edge edge = (Edge)edgeIter.next();
                boolean bl = retValue = retValue && edge.sane();
                assert (retValue);
                if (!(edge.getLabel() instanceof DynamicLabel)) continue;
                ++dynamicLabelCount;
            }
        }
        if (this.getNodeLabels() != null) {
            Iterator labelIter = this.getNodeLabels().values().iterator();
            while (labelIter.hasNext() && retValue) {
                NodeLabel nodeLabel = (NodeLabel)labelIter.next();
                boolean bl = retValue = retValue && nodeLabel.sane();
                assert (retValue);
            }
        }
        if (this.getGraphLabels() != null) {
            for (Label graphLabel : this.getGraphLabels().values()) {
                boolean bl = retValue = retValue && graphLabel.sane();
                assert (retValue);
                if (!(graphLabel instanceof DynamicLabel)) continue;
                ++dynamicLabelCount;
            }
        }
        if (this.getDynamicLabels() != null) {
            boolean bl = retValue = dynamicLabelCount == this.getNumDynamicLabels();
            assert (retValue);
            Iterator dynamiclIter = this.getDynamicLabels().iterator();
            while (dynamiclIter.hasNext() && retValue) {
                DynamicLabel dynamicLabel = (DynamicLabel)dynamiclIter.next();
                boolean bl3 = retValue = retValue && dynamicLabel.sane();
                assert (retValue);
            }
        }
        return retValue;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return ((InternalEList)this.getEdges()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getNodes()).basicRemove((Object)otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getGraphLabels()).basicRemove((Object)otherEnd, msgs);
            }
            case 6: {
                return ((InternalEList)this.getNodeLabels()).basicRemove((Object)otherEnd, msgs);
            }
            case 13: {
                return ((InternalEList)this.getUnresolvedIdentifiables()).basicRemove((Object)otherEnd, msgs);
            }
            case 14: {
                return ((InternalEList)this.getDecorators()).basicRemove((Object)otherEnd, msgs);
            }
            case 15: {
                return this.basicSetTime(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 3: {
                if (coreType) {
                    return this.getEdges();
                }
                return this.getEdges().map();
            }
            case 4: {
                if (coreType) {
                    return this.getNodes();
                }
                return this.getNodes().map();
            }
            case 5: {
                if (coreType) {
                    return this.getGraphLabels();
                }
                return this.getGraphLabels().map();
            }
            case 6: {
                if (coreType) {
                    return this.getNodeLabels();
                }
                return this.getNodeLabels().map();
            }
            case 7: {
                return this.getDynamicLabels();
            }
            case 8: {
                return this.getNumEdges();
            }
            case 9: {
                return this.getNumNodes();
            }
            case 10: {
                return this.getNumGraphLabels();
            }
            case 11: {
                return this.getNumNodeLabels();
            }
            case 12: {
                return this.getNumDynamicLabels();
            }
            case 13: {
                return this.getUnresolvedIdentifiables();
            }
            case 14: {
                return this.getDecorators();
            }
            case 15: {
                return this.getTime();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 3: {
                ((EStructuralFeature.Setting)this.getEdges()).set(newValue);
                return;
            }
            case 4: {
                ((EStructuralFeature.Setting)this.getNodes()).set(newValue);
                return;
            }
            case 5: {
                ((EStructuralFeature.Setting)this.getGraphLabels()).set(newValue);
                return;
            }
            case 6: {
                ((EStructuralFeature.Setting)this.getNodeLabels()).set(newValue);
                return;
            }
            case 7: {
                this.getDynamicLabels().clear();
                this.getDynamicLabels().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.getUnresolvedIdentifiables().clear();
                this.getUnresolvedIdentifiables().addAll((Collection)newValue);
                return;
            }
            case 14: {
                this.getDecorators().clear();
                this.getDecorators().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.setTime((STEMTime)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 3: {
                this.getEdges().clear();
                return;
            }
            case 4: {
                this.getNodes().clear();
                return;
            }
            case 5: {
                this.getGraphLabels().clear();
                return;
            }
            case 6: {
                this.getNodeLabels().clear();
                return;
            }
            case 7: {
                this.getDynamicLabels().clear();
                return;
            }
            case 13: {
                this.getUnresolvedIdentifiables().clear();
                return;
            }
            case 14: {
                this.getDecorators().clear();
                return;
            }
            case 15: {
                this.setTime(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 3: {
                return this.edges != null && !this.edges.isEmpty();
            }
            case 4: {
                return this.nodes != null && !this.nodes.isEmpty();
            }
            case 5: {
                return this.graphLabels != null && !this.graphLabels.isEmpty();
            }
            case 6: {
                return this.nodeLabels != null && !this.nodeLabels.isEmpty();
            }
            case 7: {
                return this.dynamicLabels != null && !this.dynamicLabels.isEmpty();
            }
            case 8: {
                return this.getNumEdges() != 0;
            }
            case 9: {
                return this.getNumNodes() != 0;
            }
            case 10: {
                return this.getNumGraphLabels() != 0;
            }
            case 11: {
                return this.getNumNodeLabels() != 0;
            }
            case 12: {
                return this.getNumDynamicLabels() != 0;
            }
            case 13: {
                return this.unresolvedIdentifiables != null && !this.unresolvedIdentifiables.isEmpty();
            }
            case 14: {
                return this.decorators != null && !this.decorators.isEmpty();
            }
            case 15: {
                return this.time != null;
            }
        }
        return super.eIsSet(featureID);
    }
}

