/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.ui.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.DefaultTextHover;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.editor.assist.AnchorCompletionProcessor;
import org.eclipse.mylyn.internal.wikitext.ui.editor.assist.MarkupTemplateCompletionProcessor;
import org.eclipse.mylyn.internal.wikitext.ui.editor.assist.MultiplexingContentAssistProcessor;
import org.eclipse.mylyn.internal.wikitext.ui.editor.outline.QuickOutlinePopupDialog;
import org.eclipse.mylyn.internal.wikitext.ui.editor.reconciler.MarkupMonoReconciler;
import org.eclipse.mylyn.internal.wikitext.ui.editor.reconciler.MarkupValidationReconcilingStrategy;
import org.eclipse.mylyn.internal.wikitext.ui.editor.reconciler.MultiReconcilingStrategy;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.FastMarkupPartitioner;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.FileRefHyperlinkDetector;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.MarkupDamagerRepairer;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.MarkupHyperlinkDetector;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.MarkupTokenScanner;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.parser.outline.OutlineParser;
import org.eclipse.mylyn.wikitext.ui.viewer.AbstractTextSourceViewerConfiguration;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.texteditor.HippieProposalProcessor;
import org.eclipse.ui.themes.IThemeManager;

public class MarkupSourceViewerConfiguration
extends AbstractTextSourceViewerConfiguration {
    private MarkupTokenScanner scanner;
    private MarkupTemplateCompletionProcessor completionProcessor;
    private AnchorCompletionProcessor anchorCompletionProcessor;
    private MarkupLanguage markupLanguage;
    private MarkupValidationReconcilingStrategy markupValidationReconcilingStrategy;
    private IFile file;
    private ITextHover textHover;
    private OutlineItem outline;
    private Font defaultFont;
    private Font defaultMonospaceFont;
    private InformationPresenter informationPresenter;
    private IShowInTarget showInTarget;
    private String fontPreference;
    private String monospaceFontPreference;
    private MarkupHyperlinkDetector markupHyperlinkDetector;
    private FileRefHyperlinkDetector fileRefHyperlinkDetector;
    private boolean enableHippieContentAssist = true;
    private boolean enableSelfContainedIncrementalFind = false;

    public MarkupSourceViewerConfiguration(IPreferenceStore preferenceStore, String textFontPreference, String monospaceFontPreference) {
        super(preferenceStore);
        this.fontPreference = textFontPreference;
        this.monospaceFontPreference = monospaceFontPreference;
        this.initializeDefaultFonts();
    }

    public MarkupSourceViewerConfiguration(IPreferenceStore preferenceStore) {
        this(preferenceStore, "org.eclipse.mylyn.wikitext.ui.presentation.textFont", "org.eclipse.mylyn.wikitext.ui.presentation.monospaceFont");
    }

    @Override
    protected List<IHyperlinkDetector> createCustomHyperlinkDetectors(ISourceViewer sourceViewer) {
        ArrayList<IHyperlinkDetector> detectors = new ArrayList<IHyperlinkDetector>();
        if (this.markupHyperlinkDetector == null) {
            this.markupHyperlinkDetector = new MarkupHyperlinkDetector();
            this.markupHyperlinkDetector.setMarkupLanguage(this.markupLanguage);
            this.markupHyperlinkDetector.setFile(this.file);
        }
        if (this.fileRefHyperlinkDetector == null && this.file != null) {
            Map<String, List<String>> hyperlinkDectectorFileRefRegexes = WikiTextUiPlugin.getDefault().getHyperlinkDectectorFileRefRegexes();
            List<String> fileRefHyperlinkRegexes = hyperlinkDectectorFileRefRegexes.getOrDefault(this.markupLanguage.getName(), List.of());
            this.fileRefHyperlinkDetector = new FileRefHyperlinkDetector(this.file.getParent(), fileRefHyperlinkRegexes);
        }
        detectors.add(this.markupHyperlinkDetector);
        detectors.add(this.fileRefHyperlinkDetector);
        detectors.add(this.markupHyperlinkDetector);
        detectors.addAll(super.createCustomHyperlinkDetectors(sourceViewer));
        return detectors;
    }

    public void initializeDefaultFonts() {
        Font defaultFont = null;
        Font defaultMonospaceFont = null;
        if (WikiTextUiPlugin.getDefault() != null) {
            IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
            FontRegistry fontRegistry = themeManager.getCurrentTheme().getFontRegistry();
            defaultFont = fontRegistry.get(this.fontPreference);
            defaultMonospaceFont = fontRegistry.get(this.monospaceFontPreference);
        }
        if (defaultFont == null) {
            defaultFont = JFaceResources.getDefaultFont();
        }
        if (this.defaultFont != defaultFont || this.defaultMonospaceFont != defaultMonospaceFont) {
            this.defaultFont = defaultFont;
            this.defaultMonospaceFont = defaultMonospaceFont;
            if (this.scanner != null) {
                this.scanner.resetFonts(defaultFont, defaultMonospaceFont);
            }
        }
    }

    public String getFontPreference() {
        return this.fontPreference;
    }

    public void setFontPreference(String textFontPreference) {
        this.fontPreference = textFontPreference;
    }

    public String getMonospaceFontPreference() {
        return this.monospaceFontPreference;
    }

    public void setMonospaceFontPreference(String monospaceFontPreference) {
        this.monospaceFontPreference = monospaceFontPreference;
    }

    public ITokenScanner getMarkupScanner() {
        if (this.scanner == null) {
            this.scanner = new MarkupTokenScanner(this.defaultFont, this.defaultMonospaceFont);
        }
        return this.scanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        MarkupDamagerRepairer damagerRepairer = new MarkupDamagerRepairer(this.getMarkupScanner());
        String[] stringArray = FastMarkupPartitioner.ALL_CONTENT_TYPES;
        int n = FastMarkupPartitioner.ALL_CONTENT_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String partitionType = stringArray[n2];
            reconciler.setDamager((IPresentationDamager)damagerRepairer, partitionType);
            reconciler.setRepairer((IPresentationRepairer)damagerRepairer, partitionType);
            ++n2;
        }
        reconciler.setDamager((IPresentationDamager)damagerRepairer, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)damagerRepairer, "__dftl_partition_content_type");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        int n;
        IContentAssistProcessor[] processors;
        if (this.completionProcessor == null) {
            this.completionProcessor = new MarkupTemplateCompletionProcessor();
            this.completionProcessor.setMarkupLanguage(this.markupLanguage);
        }
        if (this.anchorCompletionProcessor == null && this.outline != null) {
            this.anchorCompletionProcessor = new AnchorCompletionProcessor();
            this.anchorCompletionProcessor.setOutline(this.outline);
        }
        MultiplexingContentAssistProcessor processor = new MultiplexingContentAssistProcessor();
        if (this.anchorCompletionProcessor != null) {
            processor.addDelegate(this.anchorCompletionProcessor);
        }
        processor.addDelegate((IContentAssistProcessor)this.completionProcessor);
        if (this.enableHippieContentAssist) {
            HippieProposalProcessor hippieProcessor = new HippieProposalProcessor();
            processor.addDelegate((IContentAssistProcessor)hippieProcessor);
        }
        if ((processors = this.createContentAssistProcessors()) != null) {
            IContentAssistProcessor[] iContentAssistProcessorArray = processors;
            n = processors.length;
            int n2 = 0;
            while (n2 < n) {
                IContentAssistProcessor cap = iContentAssistProcessorArray[n2];
                processor.addDelegate(cap);
                ++n2;
            }
        }
        ContentAssistant assistant = new ContentAssistant();
        assistant.enableAutoActivation(true);
        assistant.enableAutoInsert(true);
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "__dftl_partition_content_type");
        String[] stringArray = FastMarkupPartitioner.ALL_CONTENT_TYPES;
        int n3 = FastMarkupPartitioner.ALL_CONTENT_TYPES.length;
        n = 0;
        while (n < n3) {
            String partitionType = stringArray[n];
            assistant.setContentAssistProcessor((IContentAssistProcessor)processor, partitionType);
            ++n;
        }
        return assistant;
    }

    protected IContentAssistProcessor[] createContentAssistProcessors() {
        return null;
    }

    public void setMarkupLanguage(MarkupLanguage markupLanguage) {
        this.markupLanguage = markupLanguage;
        if (this.completionProcessor != null) {
            this.completionProcessor.setMarkupLanguage(markupLanguage);
        }
        if (this.markupValidationReconcilingStrategy != null) {
            this.markupValidationReconcilingStrategy.setMarkupLanguage(markupLanguage);
        }
        if (this.markupHyperlinkDetector != null) {
            this.markupHyperlinkDetector.setMarkupLanguage(markupLanguage);
        }
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        Object strategy;
        Object reconciler;
        if (this.markupValidationReconcilingStrategy == null) {
            this.markupValidationReconcilingStrategy = new MarkupValidationReconcilingStrategy(sourceViewer);
            this.markupValidationReconcilingStrategy.setMarkupLanguage(this.markupLanguage);
            this.markupValidationReconcilingStrategy.setResource((IResource)this.file);
        }
        if ((reconciler = super.getReconciler(sourceViewer)) != null) {
            MultiReconcilingStrategy multiStrategy = new MultiReconcilingStrategy();
            String[] stringArray = FastMarkupPartitioner.ALL_CONTENT_TYPES;
            int n = FastMarkupPartitioner.ALL_CONTENT_TYPES.length;
            int n2 = 0;
            while (n2 < n) {
                String contentType = stringArray[n2];
                this.maybeAddReconcilingStrategyForContentType(multiStrategy, (IReconciler)reconciler, contentType);
                ++n2;
            }
            this.maybeAddReconcilingStrategyForContentType(multiStrategy, (IReconciler)reconciler, "__dftl_partition_content_type");
            multiStrategy.add(this.markupValidationReconcilingStrategy);
            strategy = multiStrategy;
        } else {
            strategy = this.markupValidationReconcilingStrategy;
        }
        reconciler = new MarkupMonoReconciler((IReconcilingStrategy)strategy, false);
        reconciler.setIsIncrementalReconciler(false);
        reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
        reconciler.setDelay(500);
        return reconciler;
    }

    private void maybeAddReconcilingStrategyForContentType(MultiReconcilingStrategy multiStrategy, IReconciler reconciler, String contentType) {
        IReconcilingStrategy reconcilingStrategy = reconciler.getReconcilingStrategy(contentType);
        if (reconcilingStrategy != null && !multiStrategy.contains(reconcilingStrategy)) {
            multiStrategy.add(reconcilingStrategy);
        }
    }

    public void setFile(IFile file) {
        this.file = file;
        if (this.markupValidationReconcilingStrategy != null) {
            this.markupValidationReconcilingStrategy.setResource((IResource)file);
        }
        if (this.markupHyperlinkDetector != null) {
            this.markupHyperlinkDetector.setFile(file);
        }
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        if (this.textHover == null) {
            this.textHover = new DefaultTextHover(sourceViewer);
        }
        return this.textHover;
    }

    public IInformationPresenter getOutlineInformationPresenter(ISourceViewer sourceViewer) {
        if (this.informationPresenter == null) {
            String[] contentTypes;
            IInformationControlCreator controlCreator = this.getOutlineInformationControlCreator();
            this.informationPresenter = new InformationPresenter(controlCreator);
            this.informationPresenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            InformationProvider provider = new InformationProvider(controlCreator);
            String[] stringArray = contentTypes = this.getConfiguredContentTypes(sourceViewer);
            int n = contentTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String contentType = stringArray[n2];
                this.informationPresenter.setInformationProvider((IInformationProvider)provider, contentType);
                ++n2;
            }
            this.informationPresenter.setSizeConstraints(60, 20, true, true);
        }
        return this.informationPresenter;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        ArrayList<String> contentTypes = new ArrayList<String>(3);
        contentTypes.addAll(Arrays.asList(FastMarkupPartitioner.ALL_CONTENT_TYPES));
        contentTypes.add("__dftl_partition_content_type");
        return contentTypes.toArray(new String[contentTypes.size()]);
    }

    protected IInformationControlCreator getOutlineInformationControlCreator() {
        return parent -> new QuickOutlinePopupDialog(parent, this.showInTarget);
    }

    public void setOutline(OutlineItem outlineModel) {
        this.outline = outlineModel;
        if (this.anchorCompletionProcessor != null) {
            this.anchorCompletionProcessor.setOutline(this.outline);
        }
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(Font defaultFont) {
        if (defaultFont == null) {
            throw new IllegalArgumentException();
        }
        if (defaultFont != this.defaultFont) {
            this.defaultFont = defaultFont;
            if (this.scanner != null) {
                this.scanner.resetFonts(defaultFont, this.defaultMonospaceFont);
            }
        }
    }

    public Font getDefaultMonospaceFont() {
        return this.defaultMonospaceFont;
    }

    public void setDefaultMonospaceFont(Font defaultMonospaceFont) {
        if (this.defaultMonospaceFont != defaultMonospaceFont) {
            this.defaultMonospaceFont = defaultMonospaceFont;
            if (this.scanner != null) {
                this.scanner.resetFonts(this.defaultFont, defaultMonospaceFont);
            }
        }
    }

    public IShowInTarget getShowInTarget() {
        return this.showInTarget;
    }

    public void setShowInTarget(IShowInTarget showInTarget) {
        this.showInTarget = showInTarget;
    }

    public boolean isEnableHippieContentAssist() {
        return this.enableHippieContentAssist;
    }

    public void setEnableHippieContentAssist(boolean enableHippieContentAssist) {
        this.enableHippieContentAssist = enableHippieContentAssist;
    }

    public boolean isEnableSelfContainedIncrementalFind() {
        return this.enableSelfContainedIncrementalFind;
    }

    public void setEnableSelfContainedIncrementalFind(boolean enableSelfContainedIncrementalFind) {
        this.enableSelfContainedIncrementalFind = enableSelfContainedIncrementalFind;
    }

    private class InformationProvider
    implements IInformationProvider,
    IInformationProviderExtension,
    IInformationProviderExtension2 {
        private final IInformationControlCreator controlCreator;

        public InformationProvider(IInformationControlCreator controlCreator) {
            this.controlCreator = controlCreator;
        }

        @Deprecated
        public String getInformation(ITextViewer textViewer, IRegion subject) {
            return this.getInformation2(textViewer, subject).toString();
        }

        public Object getInformation2(ITextViewer textViewer, IRegion subject) {
            IDocument document;
            if (MarkupSourceViewerConfiguration.this.outline == null && MarkupSourceViewerConfiguration.this.markupLanguage != null && (document = textViewer.getDocument()) != null && document.getLength() > 0) {
                MarkupLanguage language = MarkupSourceViewerConfiguration.this.markupLanguage.clone();
                OutlineParser outlineParser = new OutlineParser();
                outlineParser.setMarkupLanguage(language.clone());
                String markup = document.get();
                OutlineItem outline = outlineParser.parse(markup);
                if (MarkupSourceViewerConfiguration.this.file != null) {
                    outline.setResourcePath(MarkupSourceViewerConfiguration.this.file.getFullPath().toString());
                }
                return outline;
            }
            return MarkupSourceViewerConfiguration.this.outline;
        }

        public IRegion getSubject(ITextViewer textViewer, int offset) {
            return new Region(offset, 0);
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return this.controlCreator;
        }
    }
}

