/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.codeassist.impl;

import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;

public class AssistOptions {
    public static final String OPTION_PerformVisibilityCheck = "org.eclipse.jdt.core.codeComplete.visibilityCheck";
    public static final String OPTION_PerformDeprecationCheck = "org.eclipse.jdt.core.codeComplete.deprecationCheck";
    public static final String OPTION_ForceImplicitQualification = "org.eclipse.jdt.core.codeComplete.forceImplicitQualification";
    public static final String OPTION_FieldPrefixes = "org.eclipse.jdt.core.codeComplete.fieldPrefixes";
    public static final String OPTION_StaticFieldPrefixes = "org.eclipse.jdt.core.codeComplete.staticFieldPrefixes";
    public static final String OPTION_StaticFinalFieldPrefixes = "org.eclipse.jdt.core.codeComplete.staticFinalFieldPrefixes";
    public static final String OPTION_LocalPrefixes = "org.eclipse.jdt.core.codeComplete.localPrefixes";
    public static final String OPTION_ArgumentPrefixes = "org.eclipse.jdt.core.codeComplete.argumentPrefixes";
    public static final String OPTION_FieldSuffixes = "org.eclipse.jdt.core.codeComplete.fieldSuffixes";
    public static final String OPTION_StaticFieldSuffixes = "org.eclipse.jdt.core.codeComplete.staticFieldSuffixes";
    public static final String OPTION_StaticFinalFieldSuffixes = "org.eclipse.jdt.core.codeComplete.staticFinalFieldSuffixes";
    public static final String OPTION_LocalSuffixes = "org.eclipse.jdt.core.codeComplete.localSuffixes";
    public static final String OPTION_ArgumentSuffixes = "org.eclipse.jdt.core.codeComplete.argumentSuffixes";
    public static final String OPTION_PerformForbiddenReferenceCheck = "org.eclipse.jdt.core.codeComplete.forbiddenReferenceCheck";
    public static final String OPTION_PerformDiscouragedReferenceCheck = "org.eclipse.jdt.core.codeComplete.discouragedReferenceCheck";
    public static final String OPTION_CamelCaseMatch = "org.eclipse.jdt.core.codeComplete.camelCaseMatch";
    public static final String OPTION_SubwordMatch = "org.eclipse.jdt.core.codeComplete.subwordMatch";
    public static final String OPTION_SuggestStaticImports = "org.eclipse.jdt.core.codeComplete.suggestStaticImports";
    public static final String PROPERTY_SubstringMatch = "jdt.codeCompleteSubstringMatch";
    public static final String ENABLED = "enabled";
    public static final String DISABLED = "disabled";
    public boolean checkVisibility = false;
    public boolean checkDeprecation = false;
    public boolean checkForbiddenReference = false;
    public boolean checkDiscouragedReference = false;
    public boolean forceImplicitQualification = false;
    public boolean camelCaseMatch = true;
    public boolean substringMatch = true;
    public boolean subwordMatch = true;
    public boolean suggestStaticImport = true;
    public char[][] fieldPrefixes = null;
    public char[][] staticFieldPrefixes = null;
    public char[][] staticFinalFieldPrefixes = null;
    public char[][] localPrefixes = null;
    public char[][] argumentPrefixes = null;
    public char[][] fieldSuffixes = null;
    public char[][] staticFieldSuffixes = null;
    public char[][] staticFinalFieldSuffixes = null;
    public char[][] localSuffixes = null;
    public char[][] argumentSuffixes = null;

    public AssistOptions() {
    }

    public AssistOptions(Map<String, String> settings) {
        if (settings == null) {
            return;
        }
        this.set(settings);
    }

    public void set(Map<String, String> optionsMap) {
        String value = optionsMap.get(OPTION_PerformVisibilityCheck);
        if (value != null) {
            if (ENABLED.equals(value)) {
                this.checkVisibility = true;
            } else if (DISABLED.equals(value)) {
                this.checkVisibility = false;
            }
        }
        if ((value = optionsMap.get(OPTION_ForceImplicitQualification)) != null) {
            if (ENABLED.equals(value)) {
                this.forceImplicitQualification = true;
            } else if (DISABLED.equals(value)) {
                this.forceImplicitQualification = false;
            }
        }
        if ((value = optionsMap.get(OPTION_FieldPrefixes)) != null) {
            this.fieldPrefixes = (char[][])(value.length() > 0 ? this.splitAndTrimOn(',', value.toCharArray()) : null);
        }
        if ((value = optionsMap.get(OPTION_StaticFieldPrefixes)) != null) {
            this.staticFieldPrefixes = (char[][])(value.length() > 0 ? this.splitAndTrimOn(',', value.toCharArray()) : null);
        }
        if ((value = optionsMap.get(OPTION_StaticFinalFieldPrefixes)) != null) {
            this.staticFinalFieldPrefixes = (char[][])(value.length() > 0 ? this.splitAndTrimOn(',', value.toCharArray()) : null);
        }
        if ((value = optionsMap.get(OPTION_LocalPrefixes)) != null) {
            this.localPrefixes = (char[][])(value.length() > 0 ? this.splitAndTrimOn(',', value.toCharArray()) : null);
        }
        if ((value = optionsMap.get(OPTION_ArgumentPrefixes)) != null) {
            this.argumentPrefixes = (char[][])(value.length() > 0 ? this.splitAndTrimOn(',', value.toCharArray()) : null);
        }
        if ((value = optionsMap.get(OPTION_FieldSuffixes)) != null) {
            this.fieldSuffixes = (char[][])(value.length() > 0 ? this.splitAndTrimOn(',', value.toCharArray()) : null);
        }
        if ((value = optionsMap.get(OPTION_StaticFieldSuffixes)) != null) {
            this.staticFieldSuffixes = (char[][])(value.length() > 0 ? this.splitAndTrimOn(',', value.toCharArray()) : null);
        }
        if ((value = optionsMap.get(OPTION_StaticFinalFieldSuffixes)) != null) {
            this.staticFinalFieldSuffixes = (char[][])(value.length() > 0 ? this.splitAndTrimOn(',', value.toCharArray()) : null);
        }
        if ((value = optionsMap.get(OPTION_LocalSuffixes)) != null) {
            this.localSuffixes = (char[][])(value.length() > 0 ? this.splitAndTrimOn(',', value.toCharArray()) : null);
        }
        if ((value = optionsMap.get(OPTION_ArgumentSuffixes)) != null) {
            this.argumentSuffixes = (char[][])(value.length() > 0 ? this.splitAndTrimOn(',', value.toCharArray()) : null);
        }
        if ((value = optionsMap.get(OPTION_PerformForbiddenReferenceCheck)) != null) {
            if (ENABLED.equals(value)) {
                this.checkForbiddenReference = true;
            } else if (DISABLED.equals(value)) {
                this.checkForbiddenReference = false;
            }
        }
        if ((value = optionsMap.get(OPTION_PerformDiscouragedReferenceCheck)) != null) {
            if (ENABLED.equals(value)) {
                this.checkDiscouragedReference = true;
            } else if (DISABLED.equals(value)) {
                this.checkDiscouragedReference = false;
            }
        }
        if ((value = optionsMap.get(OPTION_CamelCaseMatch)) != null) {
            if (ENABLED.equals(value)) {
                this.camelCaseMatch = true;
            } else if (DISABLED.equals(value)) {
                this.camelCaseMatch = false;
            }
        }
        if ("false".equals(System.getProperty(PROPERTY_SubstringMatch))) {
            this.substringMatch = false;
        }
        if ((value = optionsMap.get(OPTION_SubwordMatch)) != null) {
            if (ENABLED.equals(value)) {
                this.subwordMatch = true;
            } else if (DISABLED.equals(value)) {
                this.subwordMatch = false;
            }
        }
        if ((value = optionsMap.get(OPTION_PerformDeprecationCheck)) != null) {
            if (ENABLED.equals(value)) {
                this.checkDeprecation = true;
            } else if (DISABLED.equals(value)) {
                this.checkDeprecation = false;
            }
        }
        if ((value = optionsMap.get(OPTION_SuggestStaticImports)) != null) {
            if (ENABLED.equals(value)) {
                this.suggestStaticImport = true;
            } else if (DISABLED.equals(value)) {
                this.suggestStaticImport = false;
            }
        }
    }

    private char[][] splitAndTrimOn(char divider, char[] arrayToSplit) {
        Object result = CharOperation.splitAndTrimOn((char)',', (char[])arrayToSplit);
        int length = ((char[][])result).length;
        int resultCount = 0;
        int i = 0;
        while (i < length) {
            if (result[i].length != 0) {
                result[resultCount++] = result[i];
            }
            ++i;
        }
        if (resultCount != length) {
            char[][] cArray = result;
            char[][] cArrayArray = new char[resultCount][];
            result = cArrayArray;
            System.arraycopy(cArray, 0, cArrayArray, 0, resultCount);
        }
        return result;
    }
}

