/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.util.Map;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.product.AbstractProductContentSection;
import org.eclipse.pde.internal.ui.editor.product.FeatureSection;
import org.eclipse.pde.internal.ui.editor.product.MixedSection;
import org.eclipse.pde.internal.ui.editor.product.PluginSection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class DependenciesPage
extends PDEFormPage {
    static final String PLUGIN_ID = "plugin-dependencies";
    static final String FEATURE_ID = "feature-dependencies";
    static final String MIXED_ID = "mixed-dependencies";
    static final Map<IProduct.ProductType, String> TYPE_2_ID = Map.of(IProduct.ProductType.BUNDLES, "plugin-dependencies", IProduct.ProductType.FEATURES, "feature-dependencies", IProduct.ProductType.MIXED, "mixed-dependencies");
    private final IProduct.ProductType fProductType;
    private PluginSection fPluginSection = null;

    public DependenciesPage(FormEditor editor, IProduct.ProductType productType) {
        super(editor, TYPE_2_ID.get(productType), PDEUIMessages.Product_DependenciesPage_title);
        this.fProductType = productType;
    }

    @Override
    protected String getHelpResource() {
        return "org.eclipse.pde.doc.user.configuration_page";
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        form.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_REQ_PLUGINS_OBJ));
        form.setText(PDEUIMessages.Product_DependenciesPage_title);
        this.fillBody(managedForm);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.configuration_page");
    }

    private void fillBody(IManagedForm managedForm) {
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)FormLayoutFactory.createFormGridLayout(false, 1));
        this.fPluginSection = null;
        AbstractProductContentSection section = switch (this.fProductType) {
            case IProduct.ProductType.BUNDLES -> {
                this.fPluginSection = new PluginSection(this, body);
                yield this.fPluginSection;
            }
            case IProduct.ProductType.FEATURES -> new FeatureSection(this, body);
            case IProduct.ProductType.MIXED -> new MixedSection(this, body);
            default -> throw new IncompatibleClassChangeError();
        };
        managedForm.addPart((IFormPart)section);
    }

    public boolean includeOptionalDependencies() {
        return this.fPluginSection != null && this.fPluginSection.includeOptionalDependencies();
    }
}

