"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.collectExtractProps = collectExtractProps;
exports.getImportPathForFile = getImportPathForFile;
exports.getPropertiesAtLocation = getPropertiesAtLocation;
exports.getQuickInfoAtPosition = getQuickInfoAtPosition;
exports.getComponentProps = getComponentProps;
exports.getComponentEvents = getComponentEvents;
exports.getTemplateContextProps = getTemplateContextProps;
exports.getComponentNames = getComponentNames;
exports.getElementAttrs = getElementAttrs;
const utils_1 = require("./utils");
function collectExtractProps(...args) {
    return sendRequest({
        type: 'collectExtractProps',
        args,
    });
}
async function getImportPathForFile(...args) {
    return await sendRequest({
        type: 'getImportPathForFile',
        args,
    });
}
async function getPropertiesAtLocation(...args) {
    return await sendRequest({
        type: 'getPropertiesAtLocation',
        args,
    });
}
function getQuickInfoAtPosition(...args) {
    return sendRequest({
        type: 'getQuickInfoAtPosition',
        args,
    });
}
// Component Infos
function getComponentProps(...args) {
    return sendRequest({
        type: 'getComponentProps',
        args,
    });
}
function getComponentEvents(...args) {
    return sendRequest({
        type: 'getComponentEvents',
        args,
    });
}
function getTemplateContextProps(...args) {
    return sendRequest({
        type: 'getTemplateContextProps',
        args,
    });
}
function getComponentNames(...args) {
    return sendRequest({
        type: 'getComponentNames',
        args,
    });
}
function getElementAttrs(...args) {
    return sendRequest({
        type: 'getElementAttrs',
        args,
    });
}
async function sendRequest(request) {
    const server = (await (0, utils_1.searchNamedPipeServerForFile)(request.args[0]))?.server;
    if (!server) {
        console.warn('[Vue Named Pipe Client] No server found for', request.args[0]);
        return;
    }
    const client = await (0, utils_1.connect)(server.path);
    if (!client) {
        console.warn('[Vue Named Pipe Client] Failed to connect to', server.path);
        return;
    }
    return await (0, utils_1.sendRequestWorker)(request, client);
}
//# sourceMappingURL=client.js.map