/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.console;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.eclipse.dltk.mod.console.IScriptConsoleIO;
import org.eclipse.dltk.mod.console.InterpreterResponse;
import org.eclipse.dltk.mod.console.ScriptConsoleIO;
import org.eclipse.dltk.mod.console.ShellResponse;

public class SocketScriptConsoleIO
implements IScriptConsoleIO {
    private final Socket socket;
    private final IScriptConsoleIO io;

    public SocketScriptConsoleIO(Socket socket) throws IOException {
        this.socket = socket;
        BufferedOutputStream output = new BufferedOutputStream(socket.getOutputStream());
        this.io = new ScriptConsoleIO(socket.getInputStream(), output);
    }

    @Override
    public String getId() {
        return this.io.getId();
    }

    @Override
    public InterpreterResponse execInterpreter(String command) throws IOException {
        return this.io.execInterpreter(command);
    }

    @Override
    public ShellResponse execShell(String command, String[] args) throws IOException {
        return this.io.execShell(command, args);
    }

    @Override
    public void close() throws IOException {
        this.io.close();
        this.socket.close();
    }

    @Override
    public InputStream getInitialResponseStream() {
        return this.io.getInitialResponseStream();
    }
}

