/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.mod.ast.ASTNode;
import org.eclipse.dltk.mod.ast.ASTVisitor;
import org.eclipse.dltk.mod.utils.CorePrinter;

public class ASTListNode
extends ASTNode {
    private final List nodes;

    public ASTListNode(int start, int end, List nodes) {
        super(start, end);
        this.nodes = nodes;
    }

    public ASTListNode(int start, int end) {
        super(start, end);
        this.nodes = new ArrayList();
    }

    public ASTListNode() {
        super(0, -1);
        this.nodes = new ArrayList();
    }

    public void addNode(ASTNode s) {
        if (s != null) {
            this.nodes.add(s);
        }
    }

    @Override
    public List getChilds() {
        return this.nodes;
    }

    public List getExpressions() {
        return this.nodes;
    }

    public List getStatements() {
        return this.nodes;
    }

    public void setChilds(List l) {
        this.nodes.clear();
        this.nodes.addAll(l);
    }

    public int getKind() {
        return 0;
    }

    @Override
    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit(this)) {
            if (this.nodes != null) {
                for (ASTNode s : this.nodes) {
                    s.traverse(visitor);
                }
            }
            visitor.endvisit(this);
        }
    }

    @Override
    public void printNode(CorePrinter output) {
        if (this.nodes != null) {
            output.print('[');
            for (ASTNode s : this.nodes) {
                s.printNode(output);
            }
            output.print(']');
        }
    }
}

