/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.compiler.CharOperation;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.ArchiveFolder;
import org.eclipse.dltk.mod.internal.core.ArchiveFolderInfo;
import org.eclipse.dltk.mod.internal.core.ArchiveProjectFragmentInfo;
import org.eclipse.dltk.mod.internal.core.Model;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.OpenableElementInfo;
import org.eclipse.dltk.mod.internal.core.ProjectFragment;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.internal.core.util.HashtableOfArrayToObject;
import org.eclipse.dltk.mod.internal.core.util.Util;

public class ArchiveProjectFragment
extends ProjectFragment {
    public static final ArrayList EMPTY_LIST = new ArrayList();
    protected final IPath zipPath;
    protected final IResource zipResource;

    protected ArchiveProjectFragment(IResource resource, ScriptProject project) {
        super(resource, project);
        this.zipPath = resource.getFullPath();
        this.zipResource = resource;
    }

    protected ArchiveProjectFragment(IPath path, ScriptProject project) {
        super(null, project);
        this.zipPath = path;
        this.zipResource = null;
    }

    @Override
    protected boolean computeChildren(OpenableElementInfo info, Map newElements) throws ModelException {
        ArrayList<ArchiveFolder> vChildren = new ArrayList<ArchiveFolder>();
        ZipFile archive = null;
        try {
            try {
                archive = ModelManager.getModelManager().getZipFile(this.getPath());
                HashtableOfArrayToObject packageFragToTypes = new HashtableOfArrayToObject();
                packageFragToTypes.put(CharOperation.NO_STRINGS, new ArrayList[]{EMPTY_LIST, EMPTY_LIST});
                Enumeration<? extends ZipEntry> e = archive.entries();
                while (e.hasMoreElements()) {
                    ZipEntry member = e.nextElement();
                    this.initPackageFragToTypes(packageFragToTypes, member.getName(), member.isDirectory());
                }
                int i = 0;
                int length = packageFragToTypes.keyTable.length;
                while (i < length) {
                    Object[] pkgName = (String[])packageFragToTypes.keyTable[i];
                    if (pkgName != null) {
                        ArrayList[] entries = (ArrayList[])packageFragToTypes.get(pkgName);
                        Object path = "";
                        if (pkgName.length >= 1) {
                            path = pkgName[0];
                            int e2 = 1;
                            while (e2 < pkgName.length) {
                                path = String.valueOf(path) + '/' + (String)pkgName[e2];
                                ++e2;
                            }
                        }
                        ArchiveFolder packFrag = (ArchiveFolder)this.getScriptFolder((IPath)new Path((String)path));
                        ArchiveFolderInfo fragInfo = new ArchiveFolderInfo();
                        int resLength = entries[1].size();
                        if (resLength == 0) {
                            packFrag.computeForeignResources(CharOperation.NO_STRINGS, fragInfo, archive.getName());
                        } else {
                            String[] resNames = new String[resLength];
                            entries[1].toArray(resNames);
                            packFrag.computeForeignResources(resNames, fragInfo, archive.getName());
                        }
                        packFrag.computeChildren(fragInfo, entries[0]);
                        newElements.put(packFrag, fragInfo);
                        vChildren.add(packFrag);
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                if (e instanceof ModelException) {
                    throw (ModelException)e;
                }
                throw new ModelException(e);
            }
        }
        catch (Throwable throwable) {
            ModelManager.getModelManager().closeZipFile(archive);
            throw throwable;
        }
        ModelManager.getModelManager().closeZipFile(archive);
        IModelElement[] children = new IModelElement[vChildren.size()];
        vChildren.toArray(children);
        info.setChildren(children);
        return true;
    }

    @Override
    public IScriptFolder getScriptFolder(IPath path) {
        return new ArchiveFolder(this, path);
    }

    public String getZipName() {
        return this.zipPath.toOSString();
    }

    private void initPackageFragToTypes(HashtableOfArrayToObject packageFragToTypes, String entryName, boolean isDirectory) {
        int length;
        int lastSeparator = isDirectory ? entryName.length() - 1 : entryName.lastIndexOf(47);
        Object[] pkgName = Util.splitOn('/', entryName, 0, lastSeparator);
        Object[] existing = null;
        int existingLength = length = pkgName.length;
        while (existingLength >= 0) {
            existing = (String[])packageFragToTypes.getKey(pkgName, existingLength);
            if (existing != null) break;
            --existingLength;
        }
        ModelManager manager = ModelManager.getModelManager();
        int i = existingLength;
        while (i < length) {
            if (!Util.isValidFolderNameForPackage((String)pkgName[i])) {
                if (!isDirectory) {
                    ArrayList[] children = (ArrayList[])packageFragToTypes.get(existing);
                    if (children[1] == EMPTY_LIST) {
                        children[1] = new ArrayList();
                    }
                    children[1].add(entryName);
                }
                return;
            }
            Object[] objectArray = existing;
            existing = new String[i + 1];
            System.arraycopy(objectArray, 0, existing, 0, i);
            existing[i] = manager.intern((String)pkgName[i]);
            packageFragToTypes.put(existing, new ArrayList[]{EMPTY_LIST, EMPTY_LIST});
            ++i;
        }
        if (isDirectory) {
            return;
        }
        ArrayList[] children = (ArrayList[])packageFragToTypes.get(pkgName);
        if (Util.isValidSourceModuleName(this.getScriptProject(), entryName)) {
            if (children[0] == EMPTY_LIST) {
                children[0] = new ArrayList();
            }
            String fileName = entryName.substring(lastSeparator + 1);
            children[0].add(fileName);
        } else {
            if (children[1] == EMPTY_LIST) {
                children[1] = new ArrayList();
            }
            children[1].add(entryName);
        }
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    protected Object createElementInfo() {
        return new ArchiveProjectFragmentInfo();
    }

    @Override
    public boolean isArchive() {
        return true;
    }

    @Override
    public boolean isExternal() {
        return this.getResource() == null;
    }

    @Override
    public IResource getUnderlyingResource() throws ModelException {
        if (this.isExternal()) {
            if (!this.exists()) {
                throw this.newNotPresentException();
            }
            return null;
        }
        return super.getUnderlyingResource();
    }

    @Override
    public int hashCode() {
        return this.zipPath.hashCode();
    }

    @Override
    public IPath getPath() {
        return this.zipPath;
    }

    @Override
    public IResource getResource() {
        if (this.resource == null) {
            this.resource = Model.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.zipPath, false);
        }
        if (this.resource instanceof IResource) {
            return super.getResource();
        }
        return null;
    }

    @Override
    protected boolean resourceExists() {
        if (this.isExternal()) {
            return Model.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.getPath(), true) != null;
        }
        return super.resourceExists();
    }

    @Override
    protected void toStringAncestors(StringBuffer buffer) {
        if (this.isExternal()) {
            return;
        }
        super.toStringAncestors(buffer);
    }

    @Override
    public int getKind() {
        return 1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ArchiveProjectFragment) {
            ArchiveProjectFragment other = (ArchiveProjectFragment)o;
            return this.zipPath.equals((Object)other.zipPath);
        }
        return false;
    }

    @Override
    public String getElementName() {
        return this.zipPath.lastSegment();
    }

    @Override
    protected void getHandleMemento(StringBuffer buff) {
        ((ModelElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        this.escapeMementoName(buff, this.getElementName());
    }
}

