/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core.mixin;

import org.eclipse.dltk.mod.core.mixin.IMixinElement;
import org.eclipse.dltk.mod.internal.core.OverflowingLRUCache;
import org.eclipse.dltk.mod.internal.core.mixin.IInternalMixinElement;
import org.eclipse.dltk.mod.internal.core.util.LRUCache;

public class MixinCache
extends OverflowingLRUCache {
    IMixinElement spaceLimitParent = null;

    public MixinCache(int size) {
        super(size);
        this.fLoadFactor = 0.9;
    }

    public MixinCache(int size, int overflow) {
        super(size, overflow);
    }

    @Override
    protected boolean close(LRUCache.LRUCacheEntry entry) {
        IMixinElement element = (IMixinElement)entry._fValue;
        if (element instanceof IInternalMixinElement) {
            ((IInternalMixinElement)((Object)element)).close();
        }
        return true;
    }

    public void ensureSpaceLimit(int childrenSize, IMixinElement parent) {
        int spaceNeeded = 1 + (int)((1.0 + this.fLoadFactor) * (double)(childrenSize + this.fOverflow));
        if (this.fSpaceLimit < spaceNeeded) {
            this.shrink();
            this.setSpaceLimit(spaceNeeded);
            this.spaceLimitParent = parent;
        }
    }

    @Override
    protected LRUCache newInstance(int size, int overflow) {
        return new MixinCache(size, overflow);
    }

    public void resetSpaceLimit(int defaultLimit, IMixinElement parent) {
        if (parent.equals(this.spaceLimitParent)) {
            this.setSpaceLimit(defaultLimit);
            this.spaceLimitParent = null;
        }
    }
}

