/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core.search;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IModelElementDelta;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ITypeHierarchy;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.ArchiveProjectFragment;
import org.eclipse.dltk.mod.internal.core.Model;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.internal.core.SuffixConstants;
import org.eclipse.dltk.mod.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.dltk.mod.internal.core.search.AbstractSearchScope;
import org.eclipse.vjet.eclipse.core.IJSType;

public class HierarchyScope2
extends AbstractSearchScope
implements SuffixConstants {
    protected int m_elementCount;
    protected IResource[] m_elements;
    private IPath[] m_enclosingProjectsAndJars;
    private String m_focusPath;
    public IJSType m_focusType;
    private ITypeHierarchy m_hierarchy;
    public boolean m_needsRefresh;
    private WorkingCopyOwner m_owner;
    private HashSet<String> m_resourcePaths;
    private IJSType[] m_types;

    public HierarchyScope2(IType type, WorkingCopyOwner owner) throws ModelException {
        this.m_focusType = (IJSType)type;
        this.m_owner = owner;
        this.m_enclosingProjectsAndJars = this.computeProjectsAndJars(type);
        IProjectFragment root = (IProjectFragment)((IJSType)type).getProjectFragment().getParent();
        if (root.isArchive()) {
            String zipFileName;
            IPath jarPath = root.getPath();
            Object target = Model.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), jarPath, true);
            if (target instanceof IFile) {
                zipFileName = jarPath.toString();
            } else if (target instanceof File) {
                zipFileName = ((File)target).getPath();
            } else {
                return;
            }
            this.m_focusPath = String.valueOf(zipFileName) + "|" + type.getFullyQualifiedName().replace('.', '/') + ".js" + ".vjo";
        } else {
            this.m_focusPath = type.getPath().toString();
        }
        this.m_needsRefresh = true;
    }

    public void add(IResource element) {
        if (this.m_elementCount == this.m_elements.length) {
            this.m_elements = new IResource[this.m_elementCount * 2];
            System.arraycopy(this.m_elements, 0, this.m_elements, 0, this.m_elementCount);
        }
        this.m_elements[this.m_elementCount++] = element;
    }

    private void buildResourceVector() {
        HashMap<IResource, IResource> resources = new HashMap<IResource, IResource>();
        HashMap<IPath, IJSType> paths = new HashMap<IPath, IJSType>();
        this.m_types = (IJSType[])this.m_hierarchy.getAllTypes();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        while (i < this.m_types.length) {
            block8: {
                IJSType type;
                block5: {
                    String zipFileName;
                    IPath jarPath;
                    block7: {
                        Object target;
                        block6: {
                            IProjectFragment root;
                            type = this.m_types[i];
                            IResource resource = type.getResource();
                            if (resource != null && resources.get(resource) == null) {
                                resources.put(resource, resource);
                                this.add(resource);
                            }
                            if (!((root = (IProjectFragment)type.getProjectFragment().getParent()) instanceof ArchiveProjectFragment)) break block5;
                            ArchiveProjectFragment jar = (ArchiveProjectFragment)root;
                            jarPath = jar.getPath();
                            target = Model.getTarget((IContainer)workspaceRoot, jarPath, true);
                            if (!(target instanceof IFile)) break block6;
                            zipFileName = jarPath.toString();
                            break block7;
                        }
                        if (!(target instanceof File)) break block8;
                        zipFileName = ((File)target).getPath();
                    }
                    String resourcePath = String.valueOf(zipFileName) + "|" + type.getFullyQualifiedName().replace('.', '/') + ".vjo";
                    this.m_resourcePaths.add(resourcePath);
                    paths.put(jarPath, type);
                    break block8;
                }
                paths.put(type.getScriptProject().getProject().getFullPath(), type);
            }
            ++i;
        }
        this.m_enclosingProjectsAndJars = new IPath[paths.size()];
        i = 0;
        Iterator iter = paths.keySet().iterator();
        while (iter.hasNext()) {
            this.m_enclosingProjectsAndJars[i++] = (IPath)iter.next();
        }
    }

    private void computeDependents(IScriptProject project, HashSet set, HashSet visited) {
        if (visited.contains(project)) {
            return;
        }
        visited.add(project);
        IProject[] dependents = project.getProject().getReferencingProjects();
        int i = 0;
        while (i < dependents.length) {
            try {
                IScriptProject dependent = DLTKCore.create(dependents[i]);
                IProjectFragment[] roots = dependent.getProjectFragments();
                set.add(dependent.getPath());
                int j = 0;
                while (j < roots.length) {
                    IProjectFragment pkgFragmentRoot = roots[j];
                    if (pkgFragmentRoot.isArchive()) {
                        set.add(pkgFragmentRoot.getPath());
                    }
                    ++j;
                }
                this.computeDependents(dependent, set, visited);
            }
            catch (ModelException modelException) {}
            ++i;
        }
    }

    private IPath[] computeProjectsAndJars(IType type) throws ModelException {
        HashSet<IPath> set = new HashSet<IPath>();
        IProjectFragment root = (IProjectFragment)((IJSType)type).getProjectFragment().getParent();
        if (root.isArchive()) {
            set.add(root.getPath());
            IPath rootPath = root.getPath();
            Model model = ModelManager.getModelManager().getModel();
            IScriptProject[] projects = model.getScriptProjects();
            HashSet visited = new HashSet();
            int i = 0;
            while (i < projects.length) {
                ScriptProject project = (ScriptProject)projects[i];
                IBuildpathEntry[] classpath = project.getResolvedBuildpath(true, false, false);
                int j = 0;
                while (j < classpath.length) {
                    if (rootPath.equals((Object)classpath[j].getPath())) {
                        IProjectFragment[] roots = project.getAllProjectFragments();
                        set.add(project.getPath());
                        int k = 0;
                        while (k < roots.length) {
                            IProjectFragment pkgFragmentRoot = roots[k];
                            if (pkgFragmentRoot.getKind() == 3) {
                                set.add(pkgFragmentRoot.getPath());
                            }
                            ++k;
                        }
                        this.computeDependents(project, set, visited);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        } else {
            ScriptProject project = (ScriptProject)root.getParent();
            IProjectFragment[] roots = project.getAllProjectFragments();
            int i = 0;
            while (i < roots.length) {
                IProjectFragment pkgFragmentRoot = roots[i];
                if (pkgFragmentRoot.getKind() == 3) {
                    set.add(pkgFragmentRoot.getPath());
                } else {
                    set.add(pkgFragmentRoot.getParent().getPath());
                }
                ++i;
            }
            this.computeDependents(project, set, new HashSet());
        }
        IPath[] result = new IPath[set.size()];
        set.toArray(result);
        return result;
    }

    @Override
    public boolean encloses(IModelElement element) {
        if (this.m_hierarchy == null) {
            if (this.m_focusType.equals(element.getAncestor(7))) {
                return true;
            }
            if (this.m_needsRefresh) {
                try {
                    this.initialize();
                }
                catch (ModelException modelException) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (this.m_needsRefresh) {
            try {
                this.refresh();
            }
            catch (ModelException modelException) {
                return false;
            }
        }
        IType type = null;
        if (element instanceof IType) {
            type = (IType)element;
        } else if (element instanceof IMember) {
            type = ((IMember)element).getDeclaringType();
        }
        return type != null && this.m_hierarchy.contains(type);
    }

    @Override
    public boolean encloses(String resourcePath) {
        int separatorIndex;
        if (this.m_hierarchy == null) {
            if (resourcePath.equals(this.m_focusPath)) {
                return true;
            }
            if (this.m_needsRefresh) {
                try {
                    this.initialize();
                }
                catch (ModelException modelException) {
                    return false;
                }
            } else {
                return true;
            }
        }
        if (this.m_needsRefresh) {
            try {
                this.refresh();
            }
            catch (ModelException modelException) {
                return false;
            }
        }
        if ((separatorIndex = resourcePath.indexOf("|")) != -1) {
            return this.m_resourcePaths.contains(resourcePath);
        }
        int i = 0;
        while (i < this.m_elementCount) {
            if (resourcePath.startsWith(this.m_elements[i].getFullPath().toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public IPath[] enclosingProjectsAndZips() {
        if (this.m_needsRefresh) {
            try {
                this.refresh();
            }
            catch (ModelException modelException) {
                return new IPath[0];
            }
        }
        return this.m_enclosingProjectsAndJars;
    }

    @Override
    public IDLTKLanguageToolkit getLanguageToolkit() {
        return null;
    }

    protected void initialize() throws ModelException {
        this.m_resourcePaths = new HashSet();
        this.m_elements = new IResource[5];
        this.m_elementCount = 0;
        this.m_needsRefresh = false;
        if (this.m_hierarchy == null) {
            this.m_hierarchy = this.m_focusType.newTypeHierarchy(this.m_owner, null);
        } else {
            this.m_hierarchy.refresh(null);
        }
        this.buildResourceVector();
    }

    @Override
    public void processDelta(IModelElementDelta delta) {
        if (this.m_needsRefresh) {
            return;
        }
        this.m_needsRefresh = this.m_hierarchy == null ? false : ((TypeHierarchy)this.m_hierarchy).isAffected(delta);
    }

    protected void refresh() throws ModelException {
        if (this.m_hierarchy != null) {
            this.initialize();
        }
    }

    public String toString() {
        return "HierarchyScope on " + ((ModelElement)((Object)this.m_focusType)).toStringWithAncestors();
    }
}

