/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.cml.vjetv.core.impl;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.core.IHeadLessLauncher;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.core.LauncherFactory;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.model.impl.VjetvHeadlessConfigure;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.util.ClassLoaderUtil;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.util.FileOperator;

public class EVHeadleassTask
extends Task {
    private static final String PATHSEPARATORCHAR = String.valueOf(File.pathSeparatorChar);
    private String m_validateProjectName;
    private String[] m_dynamicClassPath = new String[0];
    private String m_classPath;
    private String m_sourceLocation;
    private boolean m_isVerbose;
    HashSet<String> m_classPathSet = new HashSet();
    LinkedHashSet<File> m_jsFiles = new LinkedHashSet();

    private static boolean isAbsolutePath(String tcDir) {
        return new File(tcDir).isAbsolute();
    }

    private static File isPathValid(String path) {
        if (path == null) {
            return null;
        }
        File file = new File(path = path.trim());
        if (file.exists() && file.canRead()) {
            return file;
        }
        return null;
    }

    public static void main(String[] args) {
        EVHeadleassTask task = new EVHeadleassTask();
        task.m_validateProjectName = args[0];
        task.m_sourceLocation = args[1];
        task.m_classPath = args[2];
        task.execute();
    }

    private void addSourcePath(String[] bins) {
        StringBuffer sb = new StringBuffer();
        if (System.getProperty("java.source.path") != null) {
            sb.append(System.getProperty("java.source.path"));
        }
        int i = 0;
        while (i < bins.length) {
            sb.append(String.valueOf(File.pathSeparatorChar) + bins[i]);
            ++i;
        }
        System.setProperty("java.source.path", sb.toString());
    }

    private HashSet<String> calculateSourceFolderPath() {
        HashSet<String> sourceFolders = new HashSet<String>();
        if (this.m_sourceLocation != null) {
            String[] sourceLocations = this.m_sourceLocation.split(PATHSEPARATORCHAR);
            String userDir = System.getProperty("user.dir");
            int i = 0;
            while (i < sourceLocations.length) {
                String sourceFolder = sourceLocations[i].trim();
                if (!sourceFolder.equals("")) {
                    sourceFolders.add(String.valueOf(userDir) + File.separatorChar + sourceFolder);
                }
                ++i;
            }
        }
        return sourceFolders;
    }

    private VjetvHeadlessConfigure convertProperties() {
        HashSet<String> sourceFolders = this.calculateSourceFolderPath();
        if (this.m_classPath != null) {
            this.m_dynamicClassPath = this.m_classPath.split(PATHSEPARATORCHAR);
        }
        this.m_classPathSet.clear();
        this.m_classPathSet.addAll(Arrays.asList(this.m_dynamicClassPath));
        this.m_classPathSet.addAll(sourceFolders);
        int i = 0;
        while (i < this.m_dynamicClassPath.length) {
            if (!EVHeadleassTask.isAbsolutePath(this.m_dynamicClassPath[i])) {
                System.out.println(this.m_dynamicClassPath[i]);
            }
            ++i;
        }
        this.m_jsFiles.clear();
        File sourceFolderFile = null;
        Iterator<String> iterator = sourceFolders.iterator();
        while (iterator.hasNext()) {
            sourceFolderFile = EVHeadleassTask.isPathValid(iterator.next());
            if (sourceFolderFile == null) continue;
            FileOperator.getAllJSFiles(sourceFolderFile, this.m_jsFiles, null);
        }
        VjetvHeadlessConfigure conf = new VjetvHeadlessConfigure();
        conf.setReportLevel("ALL");
        conf.setReportType("txt");
        conf.setValidatedJSFiles(this.m_jsFiles);
        conf.setReportPath(null);
        conf.setFailBuild(true);
        conf.setVerbose(this.m_isVerbose);
        return conf;
    }

    public void execute() throws BuildException {
        VjetvHeadlessConfigure conf = this.convertProperties();
        this.initEnv();
        IHeadLessLauncher launcher = LauncherFactory.getVjetValidationLauncher();
        launcher.launch(conf);
    }

    public String getClassPath() {
        return this.m_classPath;
    }

    public String getValidateProjectName() {
        return this.m_validateProjectName;
    }

    private void initEnv() {
        ClassLoader o = EVHeadleassTask.class.getClassLoader();
        String classPath2 = null;
        for (String classPath2 : this.m_classPathSet) {
            try {
                if (o instanceof AntClassLoader) {
                    ((AntClassLoader)o).addPathElement(classPath2);
                    continue;
                }
                ClassLoaderUtil.addClassPath2ClassLoader(EVHeadleassTask.class.getClassLoader(), classPath2);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.addSourcePath(this.m_classPathSet.toArray(new String[0]));
    }

    public void setClassPath(String classPath) {
        this.m_classPath = classPath;
    }

    public void setSourceLocation(String sourceLocation) {
        this.m_sourceLocation = sourceLocation;
    }

    public void setValidateProjectName(String validateProjectName) {
        this.m_validateProjectName = validateProjectName;
    }

    public void setVerbose(boolean isVerbose) {
        this.m_isVerbose = isVerbose;
    }
}

