/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.cml.vjetv.util;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;

public class ClassLoaderUtil {
    private static Field classes;
    private static Method addURL;
    private static URLClassLoader system;
    private static URLClassLoader ext;

    static {
        try {
            classes = ClassLoader.class.getDeclaredField("parent");
            addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        classes.setAccessible(true);
        addURL.setAccessible(true);
        system = (URLClassLoader)ClassLoaderUtil.getSystemClassLoader();
        ext = (URLClassLoader)ClassLoaderUtil.getExtClassLoader();
    }

    public static ClassLoader getSystemClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    public static ClassLoader getExtClassLoader() {
        return ClassLoaderUtil.getSystemClassLoader().getParent();
    }

    public static List getClassesLoadedBySystemClassLoader() {
        return ClassLoaderUtil.getClassesLoadedByClassLoader(ClassLoaderUtil.getSystemClassLoader());
    }

    public static List getClassesLoadedByExtClassLoader() {
        return ClassLoaderUtil.getClassesLoadedByClassLoader(ClassLoaderUtil.getExtClassLoader());
    }

    public static List getClassesLoadedByClassLoader(ClassLoader cl) {
        try {
            return (List)classes.get(cl);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static URL[] getSystemURLs() {
        return system.getURLs();
    }

    public static URL[] getExtURLs() {
        return ext.getURLs();
    }

    private static void list(PrintStream ps, URL[] classPath) {
        int i = 0;
        while (i < classPath.length) {
            ps.println(classPath[i]);
            ++i;
        }
    }

    public static void listSystemClassPath() {
        ClassLoaderUtil.listSystemClassPath(System.out);
    }

    public static void listSystemClassPath(PrintStream ps) {
        ps.println("SystemClassPath:");
        ClassLoaderUtil.list(ps, ClassLoaderUtil.getSystemClassPath());
    }

    public static void listExtClassPath() {
        ClassLoaderUtil.listExtClassPath(System.out);
    }

    public static void listExtClassPath(PrintStream ps) {
        ps.println("ExtClassPath:");
        ClassLoaderUtil.list(ps, ClassLoaderUtil.getExtClassPath());
    }

    public static URL[] getSystemClassPath() {
        return ClassLoaderUtil.getSystemURLs();
    }

    public static URL[] getExtClassPath() {
        return ClassLoaderUtil.getExtURLs();
    }

    public static void addURL2SystemClassLoader(URL url) {
        try {
            addURL.invoke((Object)system, url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addURL2ExtClassLoader(URL url) {
        try {
            addURL.invoke((Object)ext, url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addClassPath(String path) {
        ClassLoaderUtil.addClassPath(new File(path));
    }

    public static void addExtClassPath(String path) {
        ClassLoaderUtil.addExtClassPath(new File(path));
    }

    public static void addClassPath(File dirOrJar) {
        try {
            ClassLoaderUtil.addURL2SystemClassLoader(dirOrJar.toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static void addExtClassPath(File dirOrJar) {
        try {
            ClassLoaderUtil.addURL2ExtClassLoader(dirOrJar.toURL());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static void addClassPath2ClassLoader(ClassLoader cl, String path) {
        try {
            addURL.invoke((Object)cl, new File(path).toURL());
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void addClassPath2ClassLoader(ClassLoader cl, URL path) {
        try {
            addURL.invoke((Object)cl, path);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

