/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.semantic.rules.util.TypeCheckUtil;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IInferred;
import org.eclipse.vjet.dsf.jst.IJstGlobalFunc;
import org.eclipse.vjet.dsf.jst.IJstGlobalProp;
import org.eclipse.vjet.dsf.jst.IJstGlobalVar;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstOType;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstRefType;
import org.eclipse.vjet.dsf.jst.IJstResultTypeModifier;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstArray;
import org.eclipse.vjet.dsf.jst.declaration.JstAttributedType;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstDeferredType;
import org.eclipse.vjet.dsf.jst.declaration.JstFuncType;
import org.eclipse.vjet.dsf.jst.declaration.JstFunctionRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstInferredRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstInferredType;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstMixedType;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.declaration.JstPotentialAttributedMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstPotentialOtypeMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstSynthesizedMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeReference;
import org.eclipse.vjet.dsf.jst.declaration.JstVar;
import org.eclipse.vjet.dsf.jst.declaration.JstVariantType;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.declaration.SynthOlType;
import org.eclipse.vjet.dsf.jst.declaration.TopLevelVarTable;
import org.eclipse.vjet.dsf.jst.declaration.VarTable;
import org.eclipse.vjet.dsf.jst.expr.ArrayAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.expr.BoolExpr;
import org.eclipse.vjet.dsf.jst.expr.CastExpr;
import org.eclipse.vjet.dsf.jst.expr.ConditionalExpr;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.FuncExpr;
import org.eclipse.vjet.dsf.jst.expr.InfixExpr;
import org.eclipse.vjet.dsf.jst.expr.JstArrayInitializer;
import org.eclipse.vjet.dsf.jst.expr.JstInitializer;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.expr.ObjCreationExpr;
import org.eclipse.vjet.dsf.jst.expr.PostfixExpr;
import org.eclipse.vjet.dsf.jst.expr.PrefixExpr;
import org.eclipse.vjet.dsf.jst.meta.BaseJsCommentMetaNode;
import org.eclipse.vjet.dsf.jst.meta.IJsCommentMeta;
import org.eclipse.vjet.dsf.jst.meta.JsCommentMetaNode;
import org.eclipse.vjet.dsf.jst.meta.JsType;
import org.eclipse.vjet.dsf.jst.meta.JsTypingMeta;
import org.eclipse.vjet.dsf.jst.stmt.CatchStmt;
import org.eclipse.vjet.dsf.jst.stmt.ExprStmt;
import org.eclipse.vjet.dsf.jst.stmt.ForInStmt;
import org.eclipse.vjet.dsf.jst.stmt.RtnStmt;
import org.eclipse.vjet.dsf.jst.stmt.WithStmt;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.JstLiteral;
import org.eclipse.vjet.dsf.jst.term.JstProxyIdentifier;
import org.eclipse.vjet.dsf.jst.term.NV;
import org.eclipse.vjet.dsf.jst.term.ObjLiteral;
import org.eclipse.vjet.dsf.jst.term.SimpleLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.traversal.IJstVisitor;
import org.eclipse.vjet.dsf.jst.ts.JstTypeSpaceMgr;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;
import org.eclipse.vjet.dsf.jstojava.controller.GroupInfo;
import org.eclipse.vjet.dsf.jstojava.controller.JstExpressionBindingResolver;
import org.eclipse.vjet.dsf.jstojava.controller.JstExpressionTypeLinkerHelper;
import org.eclipse.vjet.dsf.jstojava.controller.JstExpressionTypeLinkerTraversal;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsAttributed;
import org.eclipse.vjet.dsf.jstojava.parser.comments.JsVariantType;
import org.eclipse.vjet.dsf.jstojava.resolver.OTypeResolverRegistry;
import org.eclipse.vjet.dsf.jstojava.resolver.ThisObjScopeResolverRegistry;
import org.eclipse.vjet.dsf.jstojava.resolver.ThisScopeContext;
import org.eclipse.vjet.dsf.jstojava.resolver.TypeConstructContext;
import org.eclipse.vjet.dsf.jstojava.resolver.TypeConstructorRegistry;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.ts.group.IGroup;

class JstExpressionTypeLinker
implements IJstVisitor {
    private static final String THIS = "this";
    public static final String WINDOW = "Window";
    public static final String GLOBAL = "Global";
    public static final String WINDOW_VAR = "window";
    private final JstExpressionBindingResolver m_resolver;
    private final JstExpressionTypeLinkerHelper.GlobalNativeTypeInfoProvider m_provider;
    private IJstType m_currentType;
    private Stack<ScopeFrame> m_scopeStack = new Stack();
    private HierarcheQualifierSearcher m_searcher = new HierarcheQualifierSearcher();
    private GroupInfo m_groupInfo = null;
    private boolean m_typeConstructedDuringLink;
    private final boolean m_hasObjectLiteralResolvers = OTypeResolverRegistry.getInstance().hasResolvers();

    JstExpressionTypeLinker(JstExpressionBindingResolver resolver) {
        this.m_resolver = resolver;
        this.m_provider = new JstExpressionTypeLinkerHelper.GlobalNativeTypeInfoProvider(){

            @Override
            public LinkerSymbolInfo findTypeInSymbolMap(String name, List<VarTable> varTablesBottomUp) {
                return JstExpressionTypeLinker.this.findTypeInSymbolMap(name, varTablesBottomUp);
            }
        };
    }

    public IJstType getType() {
        return this.m_currentType;
    }

    public void setCurrentType(IJstType currentType) {
        this.m_currentType = currentType;
    }

    void setGroupName(String groupName) {
        List groupDependency;
        ArrayList<String> dependentGroups = null;
        JstTypeSpaceMgr tsMgr = this.m_resolver.getController().getJstTypeSpaceMgr();
        IGroup currentGroup = tsMgr.getTypeSpace().getGroup(groupName);
        if (currentGroup != null && (groupDependency = currentGroup.getGroupDependency()) != null && !groupDependency.isEmpty()) {
            dependentGroups = new ArrayList<String>(groupDependency.size());
            for (IGroup group : groupDependency) {
                dependentGroups.add(group.getName());
            }
        }
        this.m_groupInfo = new GroupInfo(groupName, dependentGroups);
    }

    private ScopeFrame getCurrentScopeFrame() {
        if (this.m_scopeStack.empty()) {
            return new ScopeFrame(this.m_currentType, false);
        }
        return this.m_scopeStack.peek();
    }

    public JstExpressionBindingResolver resolver() {
        return this.m_resolver;
    }

    public void preVisit(IJstNode node) {
        IJstType type;
        JstType object = JstCache.getInstance().getType("Object");
        if (this.m_currentType == null) {
            this.m_scopeStack.push(new ScopeFrame((IJstType)object, false));
            return;
        }
        if (node instanceof IJstType && !(type = (IJstType)node).isEmbededType()) {
            this.m_scopeStack.clear();
        }
        if (node instanceof IJstType && node != this.m_currentType) {
            this.setCurrentType((IJstType)node);
        }
        if (node instanceof IJstMethod) {
            IJstMethod mtd = (IJstMethod)node;
            if (mtd.getParentNode() != this.m_currentType) {
                this.m_scopeStack.push(new ScopeFrame((IJstType)object, false));
            } else if (this.m_currentType != null && this.m_currentType.isFType() && mtd.getName() != null && "_invoke_".equals(mtd.getName().getName())) {
                this.m_scopeStack.push(new ScopeFrame((IJstType)object, false));
            } else {
                IJstType ownerType = mtd.getOwnerType();
                if (mtd.isStatic()) {
                    this.m_scopeStack.push(new ScopeFrame((IJstType)JstTypeHelper.getJstTypeRefType((IJstType)ownerType), true, (IJstNode)mtd));
                } else {
                    this.m_scopeStack.push(new ScopeFrame(ownerType, false, (IJstNode)mtd));
                }
            }
        } else if (node instanceof JstBlock && node.getParentNode() == this.m_currentType) {
            this.m_scopeStack.push(new ScopeFrame((IJstType)JstTypeHelper.getJstTypeRefType((IJstType)this.m_currentType), true));
        } else if (node instanceof WithStmt) {
            this.m_scopeStack.push(new ScopeFrame((IJstType)object, false));
        } else if (node instanceof CatchStmt) {
            this.getCurrentScopeFrame().pushCatchVar(((CatchStmt)node).getException());
        }
    }

    public boolean visit(IJstNode node) {
        if (node == null) {
            return false;
        }
        if (node instanceof JstTypeReference) {
            return true;
        }
        if (node instanceof JstType) {
            this.visitJstType((JstType)node);
        } else {
            if (node instanceof JstVar) {
                this.visitJstVar((JstVar)node);
                return false;
            }
            if (node instanceof JstIdentifier) {
                this.visitIdentifier((JstIdentifier)node);
                return node instanceof JstProxyIdentifier;
            }
            if (node instanceof JstVars) {
                this.visitJstVars((JstVars)node);
            } else if (node instanceof JstProperty) {
                this.visitJstProperty((JstProperty)node);
            } else if (node instanceof JstMethod) {
                this.visitJstMethod((JstMethod)node);
            } else if (node instanceof FuncExpr) {
                this.visitFuncExpr((FuncExpr)node);
            } else if (node instanceof ForInStmt) {
                this.visitForInStmt((ForInStmt)node);
            } else if (node instanceof JstBlock) {
                this.visitJstBlock((JstBlock)node);
            } else if (node instanceof ObjLiteral) {
                this.visitObjLiteral((ObjLiteral)node);
            } else if (node instanceof NV) {
                this.visitNV((NV)node);
            } else if (node instanceof SimpleLiteral) {
                this.visitSimpleLiteral((SimpleLiteral)node);
            } else if (node instanceof ArrayAccessExpr) {
                this.visitArrayAccessExpr((ArrayAccessExpr)node);
            }
        }
        return true;
    }

    private void visitObjLiteral(ObjLiteral node) {
        if (!this.m_hasObjectLiteralResolvers) {
            return;
        }
        if (node.getResultType() instanceof SynthOlType) {
            JstExpressionTypeLinkerHelper.doObjLiteralAndOTypeBindings(node, (SynthOlType)node.getResultType(), null, this, null);
        }
    }

    private void visitJstMethod(JstMethod method) {
    }

    private void visitSimpleLiteral(SimpleLiteral literal) {
        IJstType literalType = literal.getResultType();
        IJstType extendedType = JstExpressionTypeLinkerHelper.getExtendedType(literalType, this.m_groupInfo);
        if (extendedType != literalType) {
            literal.setResultType(extendedType);
        }
    }

    private void visitArrayAccessExpr(ArrayAccessExpr node) {
        IJstType componentType = node.getResultType();
        if (componentType instanceof JstType && !((JstType)componentType).getStatus().isValid()) {
            IJstType potentialOtypeMemberType = componentType;
            IJstOType resolvedOtype = JstExpressionTypeLinkerHelper.getOtype(potentialOtypeMemberType.getName());
            if (resolvedOtype == null) {
                resolvedOtype = JstExpressionTypeLinkerHelper.getOtype(JstExpressionTypeLinkerHelper.getFullNameIfShortName4InnerType(this.getType(), potentialOtypeMemberType));
            }
            if (resolvedOtype != null) {
                node.setType((IJstType)resolvedOtype);
            }
        }
    }

    private void visitFuncExpr(FuncExpr funcExpr) {
        JstMethod function = funcExpr.getFunc();
        JstExpressionTypeLinkerHelper.fixMethodTypeRef(this.m_resolver, function, this.getType(), this.m_groupInfo);
    }

    private void visitJstProperty(JstProperty property) {
        JstExpressionTypeLinkerHelper.fixPropertyTypeRef(this.m_resolver, this, property, this.m_groupInfo);
    }

    private void visitJstType(JstType node) {
        for (IJstMethod staticMtd : node.getMethods(true, false)) {
            if (!(staticMtd instanceof JstMethod)) continue;
            JstExpressionTypeLinkerHelper.fixMethodTypeRef(this.m_resolver, (JstMethod)staticMtd, this.getType(), this.m_groupInfo);
        }
        for (IJstMethod instanceMtd : node.getMethods(false, false)) {
            if (!(instanceMtd instanceof JstMethod)) continue;
            JstExpressionTypeLinkerHelper.fixMethodTypeRef(this.m_resolver, (JstMethod)instanceMtd, this.getType(), this.m_groupInfo);
        }
        if (node.getConstructor() != null) {
            JstExpressionTypeLinkerHelper.fixMethodTypeRef(this.m_resolver, node.getConstructor(), this.getType(), this.m_groupInfo);
        }
    }

    private void visitJstBlock(JstBlock jstBlock) {
        if (jstBlock == null) {
            return;
        }
        for (IStmt stmt : jstBlock.getStmts()) {
            IExpr expr;
            if (!(stmt instanceof ExprStmt) || !((expr = ((ExprStmt)stmt).getExpr()) instanceof FuncExpr)) continue;
            FuncExpr funcExpr = (FuncExpr)expr;
            JstMethod mtd = funcExpr.getFunc();
            VarTable varTable = JstExpressionTypeLinkerHelper.getVarTable((IJstNode)stmt);
            String varName = mtd.getName().getName();
            if (varTable == null || varTable.getVarNode(varName) != null) continue;
            varTable.addVarNode(varName, (IJstNode)mtd);
        }
    }

    private void visitNV(NV node) {
        ObjLiteral rhsObjLiteral;
        IJstType rhsType;
        IJstNode bound;
        JstIdentifier identifier = node.getIdentifier();
        IJstType type = identifier.getType();
        if (type == null) {
            type = node.getValue().getResultType();
        }
        if ((bound = JstExpressionTypeLinkerHelper.look4ActualBinding(this.m_resolver, type, this.m_groupInfo)) != null) {
            identifier.setJstBinding(bound);
            if (bound instanceof TranslateHelper.RenameableSynthJstProxyProp) {
                ((TranslateHelper.RenameableSynthJstProxyProp)bound).setName(identifier.getName());
            } else if (bound instanceof TranslateHelper.RenameableSynthJstProxyMethod) {
                ((TranslateHelper.RenameableSynthJstProxyMethod)bound).setName(identifier.getName());
            }
            IJstType resolvedType = type;
            if (type instanceof JstAttributedType) {
                resolvedType = JstExpressionTypeLinkerHelper.getResolvedAttributedType(this.m_resolver, identifier, (JstAttributedType)type, bound);
            }
            JstExpressionTypeLinkerHelper.doExprTypeUpdate(this.m_resolver, this, (IExpr)identifier, resolvedType, this.m_groupInfo);
        }
        if (type instanceof JstObjectLiteralType && node.getValue() != null && node.getValue() instanceof ObjLiteral && (rhsType = (rhsObjLiteral = (ObjLiteral)node.getValue()).getResultType()) instanceof SynthOlType) {
            ((SynthOlType)rhsType).addResolvedOType(type);
        }
    }

    private void visitJstVars(JstVars vars) {
        JstInitializer initializer;
        IJstNode varBinding;
        JstExpressionTypeLinkerHelper.fixVarsTypeRef(this.m_resolver, vars, this.m_groupInfo);
        IJstType varType = vars.getType();
        if (varType instanceof JstType && !((JstType)varType).getStatus().isValid()) {
            IJstType potentialOtypeMemberType = varType;
            IJstOType resolvedOtype = JstExpressionTypeLinkerHelper.getOtype(potentialOtypeMemberType.getName());
            if (resolvedOtype == null) {
                resolvedOtype = JstExpressionTypeLinkerHelper.getOtype(JstExpressionTypeLinkerHelper.getFullNameIfShortName4InnerType(this.getType(), potentialOtypeMemberType));
            }
            if (resolvedOtype != null) {
                vars.setType((IJstType)resolvedOtype);
            }
        } else if (varType instanceof JstAttributedType && (varBinding = JstExpressionTypeLinkerHelper.look4ActualBinding(this.m_resolver, varType, this.m_groupInfo)) instanceof IJstOType && varBinding != varType) {
            varType = (IJstOType)varBinding;
            vars.setType((IJstType)((IJstOType)varBinding));
        }
        if ((initializer = vars.getInitializer()) != null) {
            List list = initializer.getAssignments();
            for (AssignExpr assignExpr : list) {
                JstIdentifier identifier;
                VarTable varTable;
                ILHS lhs = assignExpr.getLHS();
                if (!(lhs instanceof JstIdentifier) || (varTable = JstExpressionTypeLinkerHelper.getVarTable((IJstNode)(identifier = (JstIdentifier)lhs))) == null) continue;
                if (varTable.getVarNode(identifier.getName()) == null) {
                    varTable.addVarNode(identifier.getName(), (IJstNode)lhs);
                }
                varTable.addVarType(identifier.getName(), varType);
            }
        }
    }

    private void visitJstVar(JstVar var) {
        VarTable varTable;
        IJstNode varBinding;
        IJstType varType = var.getType();
        if (varType instanceof JstType && !((JstType)varType).getStatus().isValid()) {
            IJstType potentialOtypeMemberType = varType;
            IJstOType resolvedOtype = JstExpressionTypeLinkerHelper.getOtype(potentialOtypeMemberType.getName());
            if (resolvedOtype == null) {
                resolvedOtype = JstExpressionTypeLinkerHelper.getOtype(JstExpressionTypeLinkerHelper.getFullNameIfShortName4InnerType(this.getType(), potentialOtypeMemberType));
            }
            if (resolvedOtype != null) {
                var.setType((IJstType)resolvedOtype);
            }
        } else if (varType instanceof JstAttributedType && (varBinding = JstExpressionTypeLinkerHelper.look4ActualBinding(this.m_resolver, varType, this.m_groupInfo)) instanceof IJstOType && varBinding != varType) {
            varType = (IJstOType)varBinding;
            var.setType((IJstType)((IJstOType)varBinding));
        }
        if ((varTable = JstExpressionTypeLinkerHelper.getVarTable((IJstNode)var)) != null) {
            if (varTable.getVarNode(var.getName()) == null) {
                varTable.addVarNode(var.getName(), (IJstNode)var);
            }
            varTable.addVarType(var.getName(), varType);
        }
    }

    private void visitIdentifier(JstIdentifier identifier) {
        BaseJstNode parent = identifier.getParentNode();
        if (JstExpressionTypeLinkerHelper.isJstIdentifierVisitExcluded(identifier, (IJstNode)parent)) {
            return;
        }
        this.visitIdentifierCommon(identifier, (IJstNode)parent);
        if (JstExpressionTypeLinkerHelper.isResolveExcluded(identifier, (IJstNode)parent)) {
            return;
        }
        this.visitIdentifierAndUpdateBindings(identifier);
    }

    private void visitIdentifierAndUpdateBindings(JstIdentifier identifier) {
        String identifierName = identifier.getName();
        LinkerSymbolInfo info = this.findTypeInSymbolMap(identifierName, JstExpressionTypeLinkerHelper.getVarTablesBottomUp((IJstNode)identifier));
        if (info != null) {
            IJstType knownType = info.getType();
            IJstNode knownBinding = info.getBinding();
            IJstNode actualBinding = JstExpressionTypeLinkerHelper.look4ActualBinding(this.m_resolver, knownType, this.m_groupInfo);
            if (actualBinding != null && actualBinding != knownBinding) {
                identifier.setJstBinding(actualBinding);
                info.setBinding(actualBinding);
                if (actualBinding instanceof IJstType && actualBinding != knownType) {
                    IJstType actualType = (IJstType)actualBinding;
                    identifier.setType(actualType);
                    info.setType(actualType);
                } else if (actualBinding instanceof IJstProperty) {
                    IJstType actualType = ((IJstProperty)actualBinding).getType();
                    identifier.setType(actualType);
                    info.setType(actualType);
                } else if (actualBinding instanceof IJstMethod) {
                    JstFuncType actualType = new JstFuncType((IJstMethod)actualBinding);
                    identifier.setType((IJstType)actualType);
                    info.setType((IJstType)actualType);
                }
            }
        }
    }

    private void visitIdentifierCommon(JstIdentifier identifier, IJstNode parent) {
        String name = identifier.toExprText();
        LinkerSymbolInfo info = this.findTypeInSymbolMap(name, JstExpressionTypeLinkerHelper.getVarTablesBottomUp((IJstNode)identifier));
        if (info != null) {
            IJstNode varBinding = info.getBinding();
            if (varBinding != null && varBinding != identifier) {
                IJstType varType = JstExpressionTypeLinkerHelper.getVarType(this.m_resolver, varBinding);
                if (varType == null) {
                    varType = info.getType();
                }
                if (varType instanceof JstFuncType) {
                    JstExpressionTypeLinkerHelper.updateFunctionType((JstFuncType)varType, this.m_groupInfo);
                }
                identifier.setJstBinding(varBinding);
                identifier.setType(varType);
                JstExpressionTypeLinkerHelper.look4ActualBinding(this.m_resolver, varType, this.m_groupInfo);
                if (varType != null && varType instanceof JstInferredType && ((JstInferredType)varType).modified()) {
                    JstInferredType inferredType = (JstInferredType)varType;
                    HashSet<ScopeFrame> scopes = new HashSet<ScopeFrame>();
                    scopes.addAll(this.m_scopeStack);
                    Object currentType = inferredType.getCurrentType(identifier.getSource().getStartOffSet(), scopes);
                    if (!JstExpressionTypeLinker.isSameType(currentType, inferredType.getType())) {
                        if (!(currentType instanceof IInferred)) {
                            currentType = currentType instanceof IJstRefType ? new JstInferredRefType((IJstRefType)currentType) : new JstInferredType(currentType);
                        }
                        JstExpressionTypeLinkerHelper.doExprTypeUpdate(this.m_resolver, this, (IExpr)identifier, currentType, this.m_groupInfo);
                    } else {
                        JstExpressionTypeLinkerHelper.doExprTypeUpdate(this.m_resolver, this, (IExpr)identifier, varType, this.m_groupInfo);
                    }
                } else {
                    JstExpressionTypeLinkerHelper.doExprTypeUpdate(this.m_resolver, this, (IExpr)identifier, varType, this.m_groupInfo);
                }
                if (varType != info.getType()) {
                    info.setBinding(varBinding);
                    info.setType(varType);
                }
            } else {
                identifier.setJstBinding(info.getBinding());
                JstExpressionTypeLinkerHelper.doExprTypeUpdate(this.m_resolver, this, (IExpr)identifier, info.getType(), this.m_groupInfo);
            }
        } else if (name.equals(THIS)) {
            this.resolveThisIdentifier(identifier);
        } else if (!JstExpressionTypeLinkerHelper.getFromWithVarName(this.m_resolver, this.getCurrentScopeFrame(), identifier, this.m_groupInfo) && !JstExpressionTypeLinkerHelper.getFromGlobalTypeName(this.m_resolver, this.getCurrentScopeFrame(), identifier, this.m_groupInfo)) {
            JstExpressionTypeLinkerHelper.getFromGlobalVarName(this.m_resolver, this.getCurrentScopeFrame(), identifier, this.m_groupInfo);
        }
    }

    private IJstType resolveThisIdentifier(JstIdentifier identifier) {
        IJstType currentType = this.getCurrentScopeFrame().getCurrentType();
        if (this.getCurrentScopeFrame().getNode() != null && this.getCurrentScopeFrame().getNode() instanceof IJstMethod) {
            IJstMethod mtd = (IJstMethod)this.getCurrentScopeFrame().getNode();
            String mtdKey = this.createMtdKey(mtd);
            ThisObjScopeResolverRegistry registry = ThisObjScopeResolverRegistry.getInstance();
            ThisScopeContext context = new ThisScopeContext(currentType, mtd);
            registry.resolve(mtdKey, context);
            IJstType newType = context.getThisType();
            if (newType != null) {
                currentType = newType;
            }
        }
        identifier.setJstBinding((IJstNode)currentType);
        identifier.setType(currentType);
        return currentType;
    }

    private void visitForInStmt(ForInStmt forStmt) {
        ILHS var = forStmt.getVar();
        IJstType objType = forStmt.getExpr().getResultType();
        JstType array = JstCache.getInstance().getType("Array");
        JstType integer = JstCache.getInstance().getType("int");
        JstType string = JstCache.getInstance().getType("String");
        if (var instanceof JstVar) {
            JstVar jstVar = (JstVar)var;
            if (objType != null && !(objType instanceof JstInferredType) && (objType == array || JstTypeHelper.isTypeOf((IJstType)objType, (IJstType)array))) {
                jstVar.setType((IJstType)integer);
            } else {
                jstVar.setType((IJstType)string);
            }
            String varName = jstVar.getName();
            LinkerSymbolInfo info = this.findTypeInSymbolMap(varName, JstExpressionTypeLinkerHelper.getVarTablesBottomUp((IJstNode)jstVar));
            if (info != null) {
                info.setBinding((IJstNode)jstVar);
                info.setType(jstVar.getType());
            }
        } else if (var instanceof JstIdentifier) {
            LinkerSymbolInfo info;
            JstIdentifier jstIdentifier = (JstIdentifier)var;
            if (jstIdentifier.getJstBinding() == jstIdentifier) {
                jstIdentifier.setJstBinding(null);
            }
            if (jstIdentifier.getJstBinding() == null) {
                if (objType != null && (objType == array || JstTypeHelper.isTypeOf((IJstType)objType, (IJstType)array))) {
                    jstIdentifier.setType((IJstType)integer);
                } else {
                    jstIdentifier.setType((IJstType)string);
                }
            }
            if ((info = this.findTypeInSymbolMap(jstIdentifier.toExprText(), JstExpressionTypeLinkerHelper.getVarTablesBottomUp((IJstNode)jstIdentifier))) != null) {
                info.setType(jstIdentifier.getType());
            }
        }
    }

    public void endVisit(IJstNode node) {
    }

    public void postVisit(IJstNode node) {
        if (node instanceof IJstType && node == this.m_currentType) {
            this.postVisitCurrentType();
        } else if (node instanceof JstVars) {
            this.postVisitJstVars((JstVars)node);
        } else if (node instanceof JstVar) {
            this.postVisitJstVar((JstVar)node);
        } else if (node instanceof JstArg) {
            this.postVisitJstArg((JstArg)node);
        } else if (node instanceof MtdInvocationExpr) {
            this.postVisitMtdInvocationExpr((MtdInvocationExpr)node);
        } else if (node instanceof ObjCreationExpr) {
            this.postVisitObjCreationExpr((ObjCreationExpr)node);
        } else if (node instanceof FieldAccessExpr) {
            this.postVisitFieldAccessExpr((FieldAccessExpr)node);
        } else if (node instanceof ArrayAccessExpr) {
            this.postVisitArrayAccessExpr((ArrayAccessExpr)node);
        } else if (node instanceof AssignExpr) {
            this.postVisitAssignExpr((AssignExpr)node);
        } else if (node instanceof JstProxyIdentifier) {
            this.postVisitJstProxyIdentifier((JstProxyIdentifier)node);
        } else if (node instanceof IJstMethod || node instanceof WithStmt || node instanceof JstBlock && node.getParentNode() == this.m_currentType) {
            if (!this.m_scopeStack.isEmpty()) {
                this.m_scopeStack.pop();
            }
            if (node instanceof WithStmt) {
                this.postVisitWithStmt((WithStmt)node);
            } else if (node instanceof JstPotentialOtypeMethod) {
                this.postVisitJstPotentialOtypeMethod((JstPotentialOtypeMethod)node);
            } else if (node instanceof JstPotentialAttributedMethod) {
                this.postVisitJstPotentialAttributedMethod((JstPotentialAttributedMethod)node);
            }
        } else if (node instanceof CatchStmt) {
            this.getCurrentScopeFrame().popCatchVar();
        } else if (node instanceof JstProperty) {
            this.postVisitJstProperty((JstProperty)node);
        } else if (node instanceof PrefixExpr) {
            this.postVisitPrefixExpr((PrefixExpr)node);
        } else if (node instanceof PostfixExpr) {
            this.postVisitPostfixExpr((PostfixExpr)node);
        } else if (node instanceof InfixExpr) {
            this.postVisitInfixExpr((InfixExpr)node);
        } else if (node instanceof JstArrayInitializer) {
            this.postVisitJstArrayInitializer((JstArrayInitializer)node);
        } else if (node instanceof RtnStmt) {
            this.postVisitRtnStmt((RtnStmt)node);
        } else if (node instanceof FuncExpr) {
            this.postVisitFuncExpr((FuncExpr)node);
        } else if (node instanceof ExprStmt) {
            this.postVisitExprStmt((ExprStmt)node);
        } else if (node instanceof ConditionalExpr) {
            this.postVisitConditionalExpr((ConditionalExpr)node);
        } else if (node instanceof BaseJsCommentMetaNode) {
            ((BaseJsCommentMetaNode)node).getParentNode().removeChild(node);
            node = null;
        }
    }

    private void postVisitCurrentType() {
        IJstType outerType = this.m_currentType.getOuterType();
        if (outerType != null && outerType != this.m_currentType) {
            this.setCurrentType(outerType);
        } else if (this.m_currentType.getParentNode() instanceof IJstType) {
            this.setCurrentType((IJstType)this.m_currentType.getParentNode());
        }
    }

    private void postVisitConditionalExpr(ConditionalExpr condExpr) {
        IExpr ifValExpr = condExpr.getThenExpr();
        IExpr elseValExpr = condExpr.getElseExpr();
        if (ifValExpr != null && elseValExpr != null && ifValExpr.getResultType() != null && elseValExpr.getResultType() != null && ifValExpr.getResultType() != elseValExpr.getResultType()) {
            condExpr.setResultType((IJstType)new JstVariantType(Arrays.asList(ifValExpr.getResultType(), elseValExpr.getResultType())));
        }
    }

    private void postVisitJstPotentialOtypeMethod(JstPotentialOtypeMethod method) {
        IJstOType resolvedOtype;
        IJstType potentialOtypeJstFunctionRefType;
        if (method.getResolvedOtypeMethod() == null && (potentialOtypeJstFunctionRefType = method.getPotentialOtypeJstFunctionRefType()) != null && (resolvedOtype = JstExpressionTypeLinkerHelper.getOtype(potentialOtypeJstFunctionRefType.getName())) instanceof JstFunctionRefType) {
            method.setResolvedOtypeMethod(((JstFunctionRefType)resolvedOtype).getMethodRef());
            JstExpressionTypeLinkerTraversal.accept((IJstNode)method, this);
        }
    }

    private void postVisitJstPotentialAttributedMethod(JstPotentialAttributedMethod method) {
        JstAttributedType attributedType;
        IJstMethod attributedMethod;
        IJstType potentialJstAttributedType;
        if (method.getResolvedAttributedMethod() == null && (potentialJstAttributedType = method.getPotentialJstAttributedType()) instanceof JstAttributedType && (attributedMethod = (attributedType = (JstAttributedType)potentialJstAttributedType).getAttributorType().getMethod(attributedType.getAttributeName() != null ? attributedType.getAttributeName() : "", attributedType.isStaticAttribute())) != null) {
            method.setResolvedAttributedMethod(attributedMethod);
            JstExpressionTypeLinkerTraversal.accept((IJstNode)method, this);
        }
    }

    private void postVisitRtnStmt(RtnStmt rtnStmt) {
        IExpr rtnExpr = rtnStmt.getExpression();
        IJstMethod enclosingMtd = JstExpressionTypeLinkerHelper.look4EnclosingMethod((IJstNode)rtnStmt);
        if (JstExpressionTypeLinkerHelper.doesExprRequireResolve(rtnExpr) && enclosingMtd != null && enclosingMtd.getRtnType() != null) {
            JstExpressionTypeLinkerHelper.doExprTypeResolve(this.m_resolver, (IJstVisitor)this, rtnExpr, enclosingMtd.getRtnType());
        }
        JstExpressionTypeLinkerHelper.tryDerivingAnonymousFunctionsFromReturn(rtnStmt, (IJstNode)enclosingMtd, this);
        if (enclosingMtd != null) {
            this.inferRtnType(rtnExpr, enclosingMtd);
        }
    }

    private void inferRtnType(IExpr rtnExpr, IJstMethod enclosingMtd) {
        if (rtnExpr == null) {
            return;
        }
        IJstType inferType = rtnExpr.getResultType();
        JstMethod jstMethod = (JstMethod)enclosingMtd;
        if (enclosingMtd.getRtnType() == null) {
            if (inferType != null && !(inferType instanceof JstInferredType)) {
                jstMethod.setReturnOptional(true);
                jstMethod.setRtnType((IJstType)new JstInferredType(inferType));
            } else if (inferType != null) {
                jstMethod.setReturnOptional(true);
                jstMethod.setRtnType((IJstType)new JstInferredType(inferType));
            }
        } else if (enclosingMtd.getRtnType() instanceof JstInferredType) {
            JstInferredType inferredType = (JstInferredType)enclosingMtd.getRtnType();
            IJstType originalType = inferredType.getType();
            if (inferType != null && originalType instanceof JstMixedType) {
                jstMethod.setReturnOptional(true);
                JstMixedType mixedTypes = (JstMixedType)originalType;
                mixedTypes.getMixedTypes().add(inferType);
            } else if (inferType != null && inferType != originalType) {
                jstMethod.setReturnOptional(true);
                LinkedHashMap types = new LinkedHashMap();
                types.put(originalType, null);
                types.put(inferType, null);
                ArrayList list = new ArrayList();
                list.addAll(types.keySet());
                JstMixedType mixed = new JstMixedType(list);
                jstMethod.setRtnType((IJstType)new JstInferredType((IJstType)mixed));
            }
        }
    }

    private void postVisitJstArrayInitializer(JstArrayInitializer array) {
        IJstType objectType = JstExpressionTypeLinkerHelper.getNativeObjectJstType(this.m_resolver);
        IJstType arrType = array.getResultType();
        if (array.getResultType() == null) {
            IJstType candidateComponentType = null;
            if (array.getExprs() != null) {
                for (IExpr component : array.getExprs()) {
                    if (component == null) continue;
                    if (candidateComponentType == null) {
                        candidateComponentType = component.getResultType();
                        continue;
                    }
                    if (candidateComponentType == component.getResultType()) continue;
                    candidateComponentType = objectType;
                    break;
                }
            }
            JstArray arrayType = new JstArray(candidateComponentType != null ? candidateComponentType : objectType);
            JstExpressionTypeLinkerHelper.updateArrayType(arrayType, this.m_groupInfo);
            JstExpressionTypeLinkerHelper.updateResultType((IJstResultTypeModifier)array, (IJstType)arrayType);
        } else if (arrType instanceof JstArray) {
            JstExpressionTypeLinkerHelper.updateArrayType((JstArray)arrType, this.m_groupInfo);
        }
    }

    private void postVisitInfixExpr(InfixExpr expr) {
        InfixExpr.Operator op = expr.getOperator();
        if (InfixExpr.Operator.PLUS.equals(op)) {
            IJstType rightType;
            IJstType stringType = JstExpressionTypeLinkerHelper.getNativeStringJstType(this.m_resolver);
            IJstType numType = JstExpressionTypeLinkerHelper.getNativeNumberJstType(this.m_resolver);
            IJstType objectType = JstExpressionTypeLinkerHelper.getNativeObjectJstType(this.m_resolver);
            IJstType leftType = expr.getLeft() != null ? expr.getLeft().getResultType() : null;
            IJstType iJstType = rightType = expr.getRight() != null ? expr.getRight().getResultType() : null;
            if (numType != null && leftType != null && numType.getSimpleName().equals(leftType.getSimpleName()) && rightType != null && numType.getSimpleName().equals(rightType.getSimpleName())) {
                JstExpressionTypeLinkerHelper.updateResultType((IJstResultTypeModifier)expr, numType);
            } else if (stringType != null && (leftType != null && stringType.getSimpleName().equals(leftType.getSimpleName()) || rightType != null && stringType.getSimpleName().equals(rightType.getSimpleName()))) {
                JstExpressionTypeLinkerHelper.updateResultType((IJstResultTypeModifier)expr, stringType);
            } else if (objectType != null && (leftType != null && objectType.getSimpleName().equals(leftType.getSimpleName()) || rightType != null && objectType.getSimpleName().equals(rightType.getSimpleName()))) {
                JstExpressionTypeLinkerHelper.updateResultType((IJstResultTypeModifier)expr, objectType);
            }
        } else if (InfixExpr.Operator.CONDITIONAL_OR.equals(expr.getOperator())) {
            IExpr left = expr.getLeft();
            IExpr right = expr.getRight();
            if (left != null && right != null) {
                IJstType inferredResultType = expr.getResultType();
                JstDeferredType deferredType = new JstDeferredType(inferredResultType != null ? inferredResultType : JstExpressionTypeLinkerHelper.getNativeObjectJstType(this.m_resolver));
                deferredType.addCandidateType(left.getResultType());
                deferredType.addCandidateType(right.getResultType());
                JstExpressionTypeLinkerHelper.updateResultType((IJstResultTypeModifier)expr, (IJstType)deferredType);
            }
        } else {
            IJstType numType = JstExpressionTypeLinkerHelper.getNativeNumberJstType(this.m_resolver);
            JstExpressionTypeLinkerHelper.updateResultType((IJstResultTypeModifier)expr, numType);
        }
    }

    private void postVisitPostfixExpr(PostfixExpr expr) {
        IJstType numType = JstExpressionTypeLinkerHelper.getNativeNumberJstType(this.m_resolver);
        JstExpressionTypeLinkerHelper.updateResultType((IJstResultTypeModifier)expr, numType);
    }

    private void postVisitPrefixExpr(PrefixExpr expr) {
        IJstType type = expr.getResultType();
        if (PrefixExpr.Operator.TYPEOF.equals(expr.getOperator())) {
            IJstType stringType = JstExpressionTypeLinkerHelper.getNativeStringJstType(this.m_resolver);
            if (!TypeCheckUtil.isAssignable((IJstType)stringType, (IJstType)type)) {
                JstExpressionTypeLinkerHelper.updateResultType((IJstResultTypeModifier)expr, stringType);
            }
        } else if (PrefixExpr.Operator.DELETE.equals(expr.getOperator())) {
            IJstType objectType = JstExpressionTypeLinkerHelper.getNativeObjectJstType(this.m_resolver);
            JstExpressionTypeLinkerHelper.updateResultType((IJstResultTypeModifier)expr, objectType);
        } else if (PrefixExpr.Operator.NOT.equals(expr.getOperator())) {
            JstType boolType = JstCache.getInstance().getType("boolean");
            if (!TypeCheckUtil.isAssignable((IJstType)boolType, (IJstType)type)) {
                JstExpressionTypeLinkerHelper.updateResultType((IJstResultTypeModifier)expr, (IJstType)boolType);
            }
        } else if (PrefixExpr.Operator.VOID.equals(expr.getOperator())) {
            IJstType voidType = JstExpressionTypeLinkerHelper.getNativeVoidJstType(this.m_resolver);
            JstExpressionTypeLinkerHelper.updateResultType((IJstResultTypeModifier)expr, voidType);
        } else {
            IJstType numType = JstExpressionTypeLinkerHelper.getNativeNumberJstType(this.m_resolver);
            if (!TypeCheckUtil.isAssignable((IJstType)numType, (IJstType)type)) {
                JstExpressionTypeLinkerHelper.updateResultType((IJstResultTypeModifier)expr, numType);
            }
        }
    }

    private void postVisitJstProperty(JstProperty pty) {
        JstInferredType type;
        if (pty.getType() instanceof JstInferredType && "Object".equals((type = (JstInferredType)pty.getType()).getType().getName())) {
            JstLiteral val;
            if (pty.getInitializer() != null) {
                IExpr initializer = pty.getInitializer();
                if (initializer.getResultType() != null) {
                    pty.setType((IJstType)new JstInferredType(initializer.getResultType()));
                }
            } else if (pty.getValue() != null && pty.getValue() instanceof JstLiteral && (val = (JstLiteral)pty.getValue()).getResultType() != null) {
                pty.setType((IJstType)new JstInferredType(val.getResultType()));
            }
        }
    }

    private void postVisitArrayAccessExpr(ArrayAccessExpr aae) {
        IJstType qualifierType = JstExpressionTypeLinkerHelper.getQualifierType(this.m_resolver, (IExpr)aae);
        if (qualifierType != null) {
            SimpleLiteral indexLiteral;
            if (qualifierType instanceof JstArray) {
                JstExpressionTypeLinkerHelper.doExprTypeUpdate(this.m_resolver, this, (IExpr)aae, ((JstArray)qualifierType).getComponentType(), this.m_groupInfo);
            } else if (qualifierType instanceof JstVariantType) {
                JstVariantType variantQualifierType = (JstVariantType)qualifierType;
                List variantTypes = variantQualifierType.getVariantTypes();
                ArrayList<JstArray> arrayTypes = new ArrayList<JstArray>(variantTypes.size());
                for (IJstType variantType : variantTypes) {
                    if (!(variantType instanceof JstArray)) continue;
                    arrayTypes.add((JstArray)variantType);
                }
                if (arrayTypes.size() == 1) {
                    JstExpressionTypeLinkerHelper.doExprTypeUpdate(this.m_resolver, this, (IExpr)aae, ((JstArray)arrayTypes.get(0)).getComponentType(), this.m_groupInfo);
                } else if (arrayTypes.size() > 1) {
                    ArrayList<IJstType> componentTypes = new ArrayList<IJstType>(arrayTypes.size());
                    for (JstArray arrayType : arrayTypes) {
                        componentTypes.add(arrayType.getComponentType());
                    }
                    JstVariantType variantComponentType = new JstVariantType(componentTypes);
                    JstExpressionTypeLinkerHelper.doExprTypeUpdate(this.m_resolver, this, (IExpr)aae, (IJstType)variantComponentType, this.m_groupInfo);
                }
            }
            IExpr indexExpr = aae.getIndex();
            if (indexExpr instanceof SimpleLiteral && "String".equals((indexLiteral = (SimpleLiteral)indexExpr).getResultType().getName())) {
                boolean isStatic;
                String indexValue = indexLiteral.getValue();
                IJstProperty pty = JstExpressionTypeLinkerHelper.getProperty(qualifierType, indexValue, isStatic = JstExpressionTypeLinkerHelper.isStaticRef(qualifierType));
                if (pty == null) {
                    pty = JstExpressionTypeLinkerHelper.getProperty(qualifierType, String.valueOf('\"') + indexValue + '\"', isStatic);
                }
                if (pty == null) {
                    pty = JstExpressionTypeLinkerHelper.getProperty(qualifierType, "'" + indexValue + "'", isStatic);
                }
                if (pty != null) {
                    aae.setType(pty.getType());
                }
            }
        }
    }

    private void postVisitJstProxyIdentifier(JstProxyIdentifier id) {
        this.postVisit((IJstNode)id.getActualExpr());
        IExpr actualExpr = id.getActualExpr();
        if (actualExpr != null) {
            ObjCreationExpr objCreateExpr;
            IJstType resultType;
            if (actualExpr.getResultType() instanceof JstFuncType) {
                JstFuncType funcType = (JstFuncType)actualExpr.getResultType();
                if (funcType != null) {
                    id.setJstBinding((IJstNode)funcType.getFunction());
                }
            } else if (actualExpr.getResultType() instanceof JstAttributedType) {
                IJstNode attributedBinding;
                JstAttributedType attributedType = (JstAttributedType)actualExpr.getResultType();
                if (attributedType != null && (attributedBinding = attributedType.getJstBinding()) != null && attributedBinding instanceof IJstMethod) {
                    id.setJstBinding(attributedBinding);
                }
            } else if (actualExpr instanceof FuncExpr) {
                FuncExpr funcExpr = (FuncExpr)actualExpr;
                id.setJstBinding((IJstNode)funcExpr.getFunc());
            } else if (actualExpr instanceof ObjCreationExpr && (resultType = (objCreateExpr = (ObjCreationExpr)actualExpr).getResultType()) != null && "Function".equals(resultType.getSimpleName())) {
                JstSynthesizedMethod flexMtd = JstExpressionTypeLinkerHelper.createFlexMethod(this.m_resolver, null);
                id.setJstBinding((IJstNode)flexMtd);
            }
            id.setType(actualExpr.getResultType());
        }
    }

    private void postVisitMtdInvocationExpr(MtdInvocationExpr mie) {
        IJstType fullNamedType;
        if (JstExpressionTypeLinkerHelper.bindThisMtdInvocationInConstructs(this.m_resolver, this, mie, this.getCurrentScopeFrame().getCurrentType(), this.m_groupInfo)) {
            return;
        }
        JstIdentifier methodId = JstExpressionTypeLinkerHelper.getName((IExpr)mie);
        if (JstExpressionTypeLinkerHelper.isEmptyExpr((IExpr)methodId)) {
            return;
        }
        IJstType qualifierType = JstExpressionTypeLinkerHelper.getQualifierType(this.m_resolver, (IExpr)mie);
        IJstType mtdBindingType = methodId.getType();
        String methodName = methodId.getName();
        IJstType vjoSyntacticType = JstExpressionTypeLinkerHelper.processSyntacticCalls(mie, methodName, this.m_provider);
        if (mtdBindingType != null && JstExpressionTypeLinkerHelper.checkConstructorCalls(this.m_resolver, this, mie, methodId, mtdBindingType)) {
            return;
        }
        IJstNode mtdBinding = null;
        if (qualifierType != null) {
            IJstType declaringType;
            boolean isStatic = JstExpressionTypeLinkerHelper.isStaticRef(qualifierType);
            mtdBinding = JstExpressionTypeLinkerHelper.getCorrectMethod(this.m_resolver, qualifierType, methodName, isStatic);
            if (mtdBinding != null) {
                JstExpressionTypeLinkerHelper.bindMtdInvocationExpr(this.m_resolver, this, mtdBinding, qualifierType, mie, this.m_groupInfo);
                if (vjoSyntacticType != null) {
                    mie.setResultType(vjoSyntacticType);
                }
                JstExpressionTypeLinkerHelper.tryDerivingAnonymousFunctionsFromParam(mie, mtdBinding, this, this.m_groupInfo);
                if (mtdBinding instanceof JstMethod) {
                    JstMethod mtd = (JstMethod)mtdBinding;
                    String mtdKey = this.createMtdKey((IJstMethod)mtd);
                    this.constructType(mie, null, mtdKey, MtdInvocationExpr.class);
                }
                return;
            }
            if (mie.getQualifyExpr() != null && mie.getQualifyExpr() instanceof JstIdentifier) {
                IJstGlobalVar extVar;
                JstIdentifier qualifier = (JstIdentifier)mie.getQualifyExpr();
                IJstNode qualifierBinding = qualifier.getJstBinding();
                String globalVarName = null;
                if (qualifierBinding != null) {
                    globalVarName = JstExpressionTypeLinkerHelper.getGlobalVarNameFromBinding(qualifierBinding);
                }
                if (globalVarName != null && JstExpressionTypeLinkerHelper.isGlobalVarExtended(this.m_resolver, globalVarName) && (extVar = JstExpressionTypeLinkerHelper.getGlobalVarExtensionByName(this.m_resolver, methodName, globalVarName)) != null) {
                    mtdBinding = JstExpressionTypeLinkerHelper.look4ActualGlobalVarBinding(this.m_resolver, extVar, this.m_groupInfo);
                    JstExpressionTypeLinkerHelper.doMethodBinding(this.m_resolver, mie, methodId, mtdBinding);
                }
            }
            if ((declaringType = this.m_searcher.searchType(qualifierType, methodName, 0, isStatic)) != null) {
                mtdBinding = JstExpressionTypeLinkerHelper.getDeclaredMethod(declaringType, methodName, isStatic);
                if (mtdBinding == null) {
                    mtdBinding = JstExpressionTypeLinkerHelper.getConstructs(declaringType, methodName);
                }
                if (mtdBinding == null && qualifierType instanceof IJstRefType) {
                    declaringType = JstExpressionTypeLinkerHelper.getNativeFunctionJstType(this.m_resolver);
                    mtdBinding = JstExpressionTypeLinkerHelper.getDeclaredMethod(declaringType, methodName, isStatic);
                }
                if (mtdBinding != null) {
                    JstExpressionTypeLinkerHelper.bindMtdInvocationExpr(this.m_resolver, this, mtdBinding, qualifierType, mie, this.m_groupInfo);
                    JstExpressionTypeLinkerHelper.tryDerivingAnonymousFunctionsFromParam(mie, mtdBinding, this, this.m_groupInfo);
                    return;
                }
            }
        } else {
            mtdBinding = methodId.getJstBinding();
            if (mtdBinding != null) {
                JstFuncType funcType;
                if (mtdBindingType instanceof JstInferredType) {
                    mtdBindingType = ((JstInferredType)mtdBindingType).getType();
                }
                if (mtdBindingType instanceof JstFuncType) {
                    funcType = (JstFuncType)mtdBindingType;
                    mtdBinding = funcType.getFunction();
                }
                if (mtdBindingType instanceof JstAttributedType) {
                    mtdBinding = JstExpressionTypeLinkerHelper.look4ActualBinding(this.m_resolver, mtdBindingType, this.m_groupInfo);
                }
                if (mtdBindingType instanceof JstFunctionRefType) {
                    funcType = (JstFunctionRefType)mtdBindingType;
                    mtdBinding = funcType.getMethodRef();
                }
                if (mtdBindingType != null && mtdBindingType.isFType()) {
                    mtdBinding = JstExpressionTypeLinkerHelper.getFTypeInvokeMethod(this.m_resolver, mtdBindingType);
                }
                if (mtdBinding instanceof IJstGlobalProp) {
                    mtdBinding = JstExpressionTypeLinkerHelper.getFurtherGlobalVarBinding(this.m_resolver, (IJstGlobalProp)mtdBinding, this.m_groupInfo);
                }
                if (mtdBinding instanceof IJstGlobalFunc) {
                    mtdBinding = JstExpressionTypeLinkerHelper.getFurtherGlobalVarBinding(this.m_resolver, (IJstGlobalFunc)mtdBinding, this.m_groupInfo);
                }
                if (mtdBinding instanceof IJstMethod) {
                    IJstMethod mtd = (IJstMethod)mtdBinding;
                    IJstType rtnType = null;
                    if (mtd.isTypeFactoryEnabled()) {
                        rtnType = JstExpressionTypeLinkerHelper.getReturnTypeFormFactoryEnabled(mie, mtd);
                    }
                    if (rtnType == null) {
                        rtnType = JstExpressionTypeLinkerHelper.getBestRtnTypeFromAllOverloadMtds(mie, mtd);
                    }
                    mie.setResultType(rtnType);
                    JstExpressionTypeLinkerHelper.tryDerivingAnonymousFunctionsFromParam(mie, mtdBinding, this, this.m_groupInfo);
                    JstExpressionTypeLinkerHelper.bindMtdInvocations(this.m_resolver, this, mie, mtdBinding, this.m_groupInfo);
                    return;
                }
            }
        }
        if ((fullNamedType = this.checkFullyQualifierTypeInvocation(mie)) == null) {
            JstSource source = JstExpressionTypeLinkerHelper.createSourceRef((IExpr)mie);
            this.resolver().error("Cant find " + methodName + " method in " + JstExpressionTypeLinkerHelper.getTypeName(qualifierType) + " type.", JstExpressionTypeLinkerHelper.getTypeName(qualifierType), source.getStartOffSet(), source.getEndOffSet(), source.getRow(), source.getColumn());
        } else {
            IJstType currentType = this.getType();
            if (currentType != null && currentType instanceof JstType) {
                ((JstType)currentType).addFullyQualifiedImport(fullNamedType);
            }
            mie.addChild((IJstNode)new JstTypeReference(currentType));
        }
    }

    private String createMtdKey(IJstMethod mtd) {
        if (mtd == null) {
            return "";
        }
        String mtdKey = mtd.getOwnerType().getName();
        mtdKey = String.valueOf(mtdKey) + (mtd.isStatic() ? "::" : ":");
        mtdKey = String.valueOf(mtdKey) + mtd.getName().getName();
        return mtdKey;
    }

    private void constructType(MtdInvocationExpr mie, IExpr lhs, String mtdKey, Class<? extends IExpr> class1) {
        if (this.m_currentType == null) {
            return;
        }
        TypeConstructorRegistry tcr = TypeConstructorRegistry.getInstance();
        if (tcr.hasResolver(mtdKey)) {
            List exprs = mie.getArgs();
            TypeConstructContext constrCtx = new TypeConstructContext((IExpr)mie, lhs, exprs, null, class1, this.m_groupInfo.getGroupName(), this.m_currentType.getSource(), this.m_currentType.getName());
            tcr.resolve(mtdKey, constrCtx);
            if (constrCtx.getTypes().size() > 0) {
                this.setCurrentType(constrCtx.getTypes().get(0));
                this.setTypeConstructedDuringLink(true);
            }
        }
    }

    private void setTypeConstructedDuringLink(boolean b) {
        this.m_typeConstructedDuringLink = b;
    }

    public boolean getTypeConstructedDuringLink() {
        return this.m_typeConstructedDuringLink;
    }

    private void postVisitObjCreationExpr(ObjCreationExpr objCreationExpr) {
        JsCommentMetaNode metaNode = JstExpressionTypeLinkerHelper.getJsCommentMetaNode((IJstNode)objCreationExpr);
        IJstType metaType = metaNode != null ? metaNode.getResultType() : null;
        IExpr mtdInvocationExpr = objCreationExpr.getExpression();
        if (mtdInvocationExpr != null) {
            IJstType prevType = mtdInvocationExpr.getResultType();
            if (metaType != null && metaType != prevType && mtdInvocationExpr instanceof MtdInvocationExpr) {
                ((MtdInvocationExpr)mtdInvocationExpr).setResultType(metaType);
            }
        }
    }

    private void postVisitExprStmt(ExprStmt stmt) {
        IExpr expr = stmt.getExpr();
        if (expr instanceof JstIdentifier) {
            JstIdentifier id = (JstIdentifier)expr;
            this.handleGlobalVarBinding(id, (BaseJstNode)stmt, (IJstNode)id, true);
        } else if (expr instanceof FuncExpr) {
            FuncExpr funcExpr = (FuncExpr)expr;
            JstMethod mtd = funcExpr.getFunc();
            VarTable varTable = JstExpressionTypeLinkerHelper.getVarTable((IJstNode)stmt);
            if (varTable != null && varTable.getVarNode(mtd.getName().getName()) != null) {
                varTable.addVarType(mtd.getName().getName(), funcExpr.getResultType());
            }
        }
    }

    private void handleGlobalVarBinding(JstIdentifier id, BaseJstNode parentNode, IJstNode parentNodeForMeta, boolean setBinding) {
        VarTable varTable;
        if (id.getJstBinding() != null || parentNode instanceof AssignExpr && parentNode.getParentNode() instanceof JstVars && ((AssignExpr)parentNode).getLHS() == id) {
            return;
        }
        List<IJsCommentMeta> metaList = JstExpressionTypeLinkerHelper.getJsCommentMeta(parentNodeForMeta);
        if (metaList != null && metaList.size() > 0) {
            IJsCommentMeta meta = metaList.get(0);
            JsTypingMeta jsTypingMeta = meta.getTyping();
            IJstType jstType = null;
            if (jsTypingMeta instanceof JsType) {
                jstType = JstExpressionTypeLinkerHelper.findType((JsType)jsTypingMeta);
            } else if (jsTypingMeta instanceof JsAttributed) {
                JsAttributed jsAttributed = (JsAttributed)jsTypingMeta;
                JsType attributor = jsAttributed.getAttributor();
                IJstType attributorType = attributor == null ? TranslateHelper.getGlobalType() : JstExpressionTypeLinkerHelper.findType(attributor);
                String attributeName = jsAttributed.getName();
                boolean isStatic = !jsAttributed.isInstance();
                jstType = new JstAttributedType(attributorType, attributeName, isStatic);
            } else if (jsTypingMeta instanceof JsVariantType) {
                jstType = JstExpressionTypeLinkerHelper.findType((JsVariantType)jsTypingMeta);
            }
            if (jstType != null) {
                id.setType(jstType);
                JstExpressionTypeLinkerHelper.look4ActualBinding(this.m_resolver, id.getType(), this.m_groupInfo);
                JstExpressionTypeLinkerHelper.doExprTypeUpdate(this.m_resolver, this, (IExpr)id, id.getType(), this.m_groupInfo);
                if (setBinding) {
                    id.setJstBinding((IJstNode)jstType);
                } else {
                    id.setJstBinding(null);
                }
                JstTypeReference ref = new JstTypeReference(jstType);
                TranslateHelper.setTypeRefSource((BaseJstNode)ref, meta);
                parentNode.addChild((IJstNode)ref);
            }
        }
        if ((varTable = JstExpressionTypeLinkerHelper.getVarTable((IJstNode)id)) != null) {
            if (varTable.getVarNode(id.getName()) == null) {
                varTable.addVarNode(id.getName(), (IJstNode)id);
            }
            varTable.addVarType(id.getName(), id.getType());
        }
    }

    private void postVisitFieldAccessExpr(FieldAccessExpr fae) {
        IJstNode qualifierBinding;
        JstIdentifier fieldId = fae.getName();
        if (JstExpressionTypeLinkerHelper.isEmptyExpr((IExpr)fieldId)) {
            return;
        }
        IJstType qualifierType = JstExpressionTypeLinkerHelper.getQualifierType(this.m_resolver, (IExpr)fae);
        String fieldName = "";
        if (qualifierType != null) {
            boolean isStatic = JstExpressionTypeLinkerHelper.isStaticRef(qualifierType);
            fieldName = fieldId.getName();
            IJstProperty pty = JstExpressionTypeLinkerHelper.getProperty(qualifierType, fieldName, isStatic);
            if (pty != null) {
                JstExpressionTypeLinkerHelper.bindFieldAccessExpr(this.m_resolver, pty, qualifierType, fae, this.m_groupInfo);
                return;
            }
            IJstType declaringType = this.m_searcher.searchPropertyType(qualifierType, fieldName, 0, isStatic);
            if (declaringType != null && (pty = declaringType.getProperty(fieldName, isStatic)) != null) {
                JstExpressionTypeLinkerHelper.bindFieldAccessExpr(this.m_resolver, pty, qualifierType, fae, this.m_groupInfo);
                return;
            }
        }
        IJstType fullNamedType = this.checkFullyQualifierTypeAccess(fae);
        IExpr qualifier = fae.getExpr();
        JstIdentifier identifier = fae.getName();
        if (qualifier instanceof JstIdentifier && identifier != null && identifier.getName() != null && (qualifierBinding = ((JstIdentifier)qualifier).getJstBinding()) != null) {
            String globalVarName = null;
            if (qualifierBinding instanceof IJstGlobalProp) {
                globalVarName = ((IJstGlobalProp)qualifierBinding).getName().getName();
            } else if (qualifierBinding instanceof IJstGlobalFunc) {
                globalVarName = ((IJstGlobalFunc)qualifierBinding).getName().getName();
            }
            if (globalVarName != null) {
                String identifierName = identifier.getName();
                List extensions = this.m_resolver.getController().getJstTypeSpaceMgr().getQueryExecutor().getGlobalExtensions(globalVarName);
                for (IJstNode ext : extensions) {
                    IJstGlobalVar extVar;
                    if (!(ext instanceof IJstGlobalVar) || !identifierName.equals((extVar = (IJstGlobalVar)ext).getName().getName())) continue;
                    IJstNode identifierBinding = JstExpressionTypeLinkerHelper.findGlobalVarBinding(this.m_resolver, (IJstNode)extVar, this.m_groupInfo);
                    if (identifierBinding == null) break;
                    identifier.setJstBinding(identifierBinding);
                    break;
                }
            }
        }
        if (fullNamedType == null) {
            if (qualifierType != null && !this.checkMethodReferenceByFieldAccess(fae, qualifierType, fieldId)) {
                JstSource source = JstExpressionTypeLinkerHelper.createSourceRef((IExpr)fae);
                this.resolver().error("Cant find " + fieldName + " field in " + JstExpressionTypeLinkerHelper.getTypeName(qualifierType) + " type. with source = " + fae.getSource(), JstExpressionTypeLinkerHelper.getTypeName(qualifierType), source.getStartOffSet(), source.getEndOffSet(), source.getRow(), source.getColumn());
            }
        } else {
            IJstType currentType = this.getType();
            if (currentType != null && currentType instanceof JstType) {
                ((JstType)currentType).addFullyQualifiedImport(fullNamedType);
            }
            fae.addChild((IJstNode)new JstTypeReference(currentType));
        }
    }

    private boolean checkMethodReferenceByFieldAccess(FieldAccessExpr fae, IJstType qualifierType, JstIdentifier fieldId) {
        String fieldName = fieldId.getName();
        boolean isStatic = qualifierType instanceof IJstRefType;
        boolean isMethodReference = false;
        IJstMethod mtd = qualifierType.getMethod(fieldName, isStatic);
        if (mtd != null) {
            isMethodReference = true;
        } else {
            IJstType declaringType = this.m_searcher.searchType(qualifierType, fieldName, 0, isStatic);
            if (declaringType != null && (mtd = declaringType.getMethod(fieldName, isStatic)) != null) {
                isMethodReference = true;
            }
        }
        if (isMethodReference) {
            fieldId.setJstBinding((IJstNode)mtd);
            JstFuncType funcType = new JstFuncType(mtd);
            fieldId.setType((IJstType)funcType);
            fae.setType((IJstType)funcType);
        }
        return isMethodReference;
    }

    private void postVisitFuncExpr(FuncExpr funcExpr) {
        IJstType funcType = funcExpr.getResultType();
        if (!(funcType instanceof JstFuncType)) {
            if (funcType instanceof JstAttributedType) {
                JstAttributedType attributedType = (JstAttributedType)funcType;
                IJstMethod attributedFunc = attributedType.getAttributorType().getMethod(attributedType.getAttributeName(), attributedType.isStaticAttribute(), true);
                if (attributedFunc != null) {
                    JstExpressionTypeLinkerHelper.tryDerivingAnonymousFunctionsFromAssignment(funcExpr, attributedFunc, false, this);
                    funcType = new JstFuncType(attributedFunc);
                } else {
                    funcType = new JstFuncType((IJstMethod)funcExpr.getFunc());
                }
                funcExpr.setType(funcType);
            } else if (funcType instanceof JstFunctionRefType) {
                JstFunctionRefType otypeFuncType = (JstFunctionRefType)funcType;
                IJstMethod otypeFunc = otypeFuncType.getMethodRef();
                if (otypeFunc != null) {
                    JstExpressionTypeLinkerHelper.tryDerivingAnonymousFunctionsFromAssignment(funcExpr, otypeFunc, false, this);
                    funcType = new JstFuncType(otypeFunc);
                } else {
                    funcType = new JstFuncType((IJstMethod)funcExpr.getFunc());
                }
                funcExpr.setType(funcType);
            }
        }
        if (funcType instanceof JstFuncType) {
            JstExpressionTypeLinkerHelper.updateFunctionType((JstFuncType)funcType, this.m_groupInfo);
        }
    }

    private void postVisitAssignExpr(AssignExpr assignExpr) {
        IExpr rhsExpr;
        LinkerSymbolInfo info;
        ILHS lhs = assignExpr.getLHS();
        JstIdentifier identifier = null;
        if (lhs instanceof JstIdentifier && (info = this.findTypeInSymbolMap((identifier = (JstIdentifier)lhs).toExprText(), JstExpressionTypeLinkerHelper.getVarTablesBottomUp((IJstNode)assignExpr))) == null) {
            rhsExpr = assignExpr.getExpr();
            if (rhsExpr instanceof CastExpr) {
                identifier.setType(rhsExpr.getResultType());
            }
            this.handleGlobalVarBinding(identifier, (BaseJstNode)assignExpr, (IJstNode)rhsExpr, false);
            if (identifier.getType() == null) {
                identifier.setType((IJstType)JstCache.getInstance().getType("Object"));
            }
        }
        IJstType lhsType = lhs.getType();
        rhsExpr = assignExpr.getExpr();
        boolean rhsResolveNeeded = JstExpressionTypeLinkerHelper.doesExprRequireResolve(rhsExpr);
        if (lhsType != null && !(lhsType instanceof IInferred) && rhsResolveNeeded) {
            JstExpressionTypeLinkerHelper.doExprTypeResolve(this.m_resolver, (IJstVisitor)this, rhsExpr, lhsType);
        } else if (lhsType instanceof IInferred && !rhsResolveNeeded && identifier != null && rhsExpr != null) {
            IJstType rhsType = rhsExpr.getResultType();
            if (rhsType == null) {
                rhsType = new JstInferredType((IJstType)JstCache.getInstance().getType("Object"));
            } else if (rhsType instanceof JstInferredType) {
                rhsType = ((JstInferredType)rhsType).getType();
            }
            if (!JstExpressionTypeLinker.isSameType(lhsType, rhsType)) {
                IJstNode binding = identifier.getJstBinding();
                IJstType originalType = null;
                if (binding instanceof JstIdentifier) {
                    originalType = ((JstIdentifier)binding).getType();
                }
                if (originalType instanceof JstInferredType) {
                    int pos = lhs.getSource().getStartOffSet();
                    ((JstInferredType)originalType).setCurrentType(rhsType, pos, (Object)this.m_scopeStack.peek());
                }
            }
        } else if (lhsType == null && lhs instanceof FieldAccessExpr && rhsExpr != null) {
            IExpr qualifier;
            MtdInvocationExpr mtdInv;
            if (rhsExpr instanceof MtdInvocationExpr && (mtdInv = (MtdInvocationExpr)rhsExpr).getMethod() instanceof JstMethod && ((JstMethod)mtdInv.getMethod()).isTypeFactoryEnabled()) {
                this.constructForAssigment(lhs, rhsExpr);
            }
            if ((qualifier = ((FieldAccessExpr)lhs).getExpr()) instanceof JstIdentifier) {
                IJstType rhsType;
                IJstNode binding = ((JstIdentifier)qualifier).getJstBinding();
                IJstType qualifierType = null;
                if (binding instanceof JstIdentifier) {
                    qualifierType = ((JstIdentifier)binding).getType();
                }
                if (qualifierType instanceof JstInferredType) {
                    rhsType = rhsExpr.getResultType();
                    if (rhsType == null) {
                        rhsType = new JstInferredType((IJstType)JstCache.getInstance().getType("Object"));
                    }
                    int pos = lhs.getSource().getStartOffSet();
                    HashSet<ScopeFrame> scopes = new HashSet<ScopeFrame>();
                    scopes.addAll(this.m_scopeStack);
                    ((JstInferredType)qualifierType).addNewProperty(((FieldAccessExpr)lhs).getName().getName(), rhsType, pos, scopes);
                }
                if (rhsResolveNeeded && rhsExpr instanceof ObjLiteral) {
                    rhsType = rhsExpr.getResultType();
                    if (rhsType == null) {
                        rhsType = new JstInferredType((IJstType)JstCache.getInstance().getType("Object"));
                    }
                    JstExpressionTypeLinkerHelper.doObjLiteralAndOTypeBindings((ObjLiteral)rhsExpr, (SynthOlType)rhsExpr.getResultType(), rhsType, this, null);
                }
            }
        } else if ((lhs instanceof JstIdentifier || lhs instanceof FieldAccessExpr) && rhsExpr != null && rhsExpr instanceof MtdInvocationExpr) {
            this.constructForAssigment(lhs, rhsExpr);
        }
    }

    private void constructForAssigment(ILHS lhs, IExpr rhsExpr) {
        if (!(rhsExpr instanceof MtdInvocationExpr)) {
            return;
        }
        MtdInvocationExpr mie = (MtdInvocationExpr)rhsExpr;
        JstMethod mtd = this.bindMethod(mie);
        String mtdKey = this.createMtdKey((IJstMethod)mtd);
        this.constructType(mie, (IExpr)lhs, mtdKey, AssignExpr.class);
    }

    private JstMethod bindMethod(MtdInvocationExpr mie) {
        boolean isStatic;
        JstIdentifier methodId = JstExpressionTypeLinkerHelper.getName((IExpr)mie);
        if (JstExpressionTypeLinkerHelper.isEmptyExpr((IExpr)methodId)) {
            return null;
        }
        IJstType qualifierType = JstExpressionTypeLinkerHelper.getQualifierType(this.m_resolver, (IExpr)mie);
        String methodName = methodId.getName();
        IJstNode mtdBinding = null;
        if (qualifierType != null && (mtdBinding = JstExpressionTypeLinkerHelper.getCorrectMethod(this.m_resolver, qualifierType, methodName, isStatic = JstExpressionTypeLinkerHelper.isStaticRef(qualifierType))) != null) {
            JstExpressionTypeLinkerHelper.bindMtdInvocationExpr(this.m_resolver, this, mtdBinding, qualifierType, mie, this.m_groupInfo);
            JstExpressionTypeLinkerHelper.tryDerivingAnonymousFunctionsFromParam(mie, mtdBinding, this, this.m_groupInfo);
            if (mtdBinding instanceof JstMethod) {
                return (JstMethod)mtdBinding;
            }
        }
        return null;
    }

    private static boolean isSameType(IJstType t1, IJstType t2) {
        return t1.getName().equals(t2.getName());
    }

    private void postVisitJstVars(JstVars vars) {
        IJstType varType = vars.getType();
        JstExpressionTypeLinkerHelper.look4ActualBinding(this.m_resolver, varType, this.m_groupInfo);
        boolean isInferred = varType instanceof IInferred;
        JstInitializer initializer = vars.getInitializer();
        if (initializer != null) {
            List list = initializer.getAssignments();
            boolean varsSet = false;
            for (AssignExpr assignExpr : list) {
                ILHS lhs = assignExpr.getLHS();
                IExpr rhsExpr = assignExpr.getExpr();
                if (!isInferred) {
                    JstExpressionTypeLinkerHelper.doJsCommentMetaUpdate(varType, (IJstNode)rhsExpr);
                    if (JstExpressionTypeLinkerHelper.doesExprRequireResolve(rhsExpr)) {
                        JstExpressionTypeLinkerHelper.doExprTypeResolve(this.m_resolver, (IJstVisitor)this, rhsExpr, varType);
                    }
                }
                if (!(lhs instanceof JstIdentifier)) continue;
                JstIdentifier identifier = (JstIdentifier)lhs;
                if (rhsExpr instanceof CastExpr) {
                    varsSet = this.whenRhsExprIsCast(vars, varsSet, rhsExpr, identifier);
                } else if (isInferred && rhsExpr != null) {
                    this.whenRhsExprCanInfer(vars, varType, list, rhsExpr, identifier);
                } else {
                    identifier.setJstBinding((IJstNode)varType);
                    if (varType instanceof IInferred) {
                        IJstType cloneInferredType = (IJstType)JstExpressionTypeLinkerHelper.cloneInferredType((IInferred)varType);
                        identifier.setType(cloneInferredType);
                    } else {
                        identifier.setType(varType);
                    }
                }
                VarTable varTable = JstExpressionTypeLinkerHelper.getVarTable((IJstNode)identifier);
                if (varTable == null) continue;
                if (varTable.getVarNode(identifier.getName()) == null) {
                    varTable.addVarNode(identifier.getName(), (IJstNode)lhs);
                }
                varTable.addVarType(identifier.getName(), varType);
            }
        }
    }

    private void whenRhsExprCanInfer(JstVars vars, IJstType varType, List<AssignExpr> list, IExpr rhsExpr, JstIdentifier identifier) {
        Object inferredType = varType;
        IJstType inferingType = rhsExpr.getResultType();
        if (inferingType != null) {
            if (inferingType instanceof JstFuncType) {
                inferredType = new JstInferredType(inferingType);
                IJstMethod jstBinding = ((JstFuncType)inferingType).getFunction();
                identifier.setJstBinding((IJstNode)jstBinding);
            } else {
                inferredType = inferingType instanceof IJstRefType ? new JstInferredRefType((IJstRefType)inferingType) : new JstInferredType(inferingType);
                identifier.setJstBinding((IJstNode)inferredType);
            }
        }
        identifier.setType(inferredType);
        LinkerSymbolInfo info = this.findTypeInSymbolMap(identifier.toExprText(), JstExpressionTypeLinkerHelper.getVarTablesBottomUp((IJstNode)identifier));
        if (info != null && info.getBinding() == vars) {
            info.setType((IJstType)inferredType);
        }
        if (list.size() == 1) {
            vars.setType(inferredType);
        }
    }

    private boolean whenRhsExprIsCast(JstVars vars, boolean varsSet, IExpr rhsExpr, JstIdentifier identifier) {
        LinkerSymbolInfo info;
        IExpr cast = rhsExpr;
        IJstMethod castBinding = null;
        IJstType castType = cast.getResultType();
        identifier.setType(castType);
        if (castType instanceof JstFuncType) {
            castBinding = ((JstFuncType)castType).getFunction();
            identifier.setJstBinding((IJstNode)castBinding);
        }
        if ((info = this.findTypeInSymbolMap(identifier.toExprText(), JstExpressionTypeLinkerHelper.getVarTablesBottomUp((IJstNode)identifier))) != null && info.getBinding() == vars) {
            info.setType(castType);
            if (castBinding != null) {
                info.setBinding((IJstNode)castBinding);
            }
        }
        if (!varsSet) {
            vars.setType(castType);
        }
        varsSet = true;
        return varsSet;
    }

    private void postVisitJstVar(JstVar var) {
        VarTable varTable = JstExpressionTypeLinkerHelper.getVarTable((IJstNode)var);
        if (varTable != null) {
            if (varTable.getVarNode(var.getName()) == null) {
                varTable.addVarNode(var.getName(), (IJstNode)var);
            }
            varTable.addVarType(var.getName(), var.getType());
        }
    }

    private void postVisitJstArg(JstArg parameter) {
        VarTable varTable = JstExpressionTypeLinkerHelper.getVarTable((IJstNode)parameter);
        if (varTable != null) {
            if (varTable.getVarNode(parameter.getName()) == null) {
                varTable.addVarNode(parameter.getName(), (IJstNode)parameter);
            }
            varTable.addVarType(parameter.getName(), parameter.getType());
        }
    }

    private void postVisitWithStmt(WithStmt with) {
        BoolExpr condition = with.getCondition();
        IExpr scope = condition.getLeft();
        IJstType scopeType = scope.getResultType();
        if (scopeType != null) {
            String varName;
            VarTable varTable = JstExpressionTypeLinkerHelper.getVarTable((IJstNode)with);
            for (IJstProperty pty : scopeType.getAllPossibleProperties(JstExpressionTypeLinkerHelper.isStaticRef(scopeType), true)) {
                String string = varName = pty != null && pty.getName() != null ? pty.getName().getName() : null;
                if (varTable == null || varName == null || varTable.getVarNode(varName) != null) continue;
                varTable.addVarNode(varName, (IJstNode)pty);
            }
            for (IJstMethod mtd : scopeType.getMethods(JstExpressionTypeLinkerHelper.isStaticRef(scopeType), true)) {
                varName = mtd.getName().getName();
                if (varTable == null || varName == null || varTable.getVarNode(varName) != null) continue;
                varTable.addVarNode(varName, (IJstNode)mtd);
            }
        }
    }

    private IJstType checkFullyQualifierTypeAccess(FieldAccessExpr fieldAccessExpr) {
        String fullName = fieldAccessExpr.toExprText();
        IJstType type = JstExpressionTypeLinkerHelper.findFullQualifiedType(this.m_resolver, fullName, this.m_groupInfo);
        if (type != null) {
            if (type.isSingleton()) {
                JstInferredType infferedType = new JstInferredType(type);
                fieldAccessExpr.getName().setJstBinding((IJstNode)infferedType);
                JstExpressionTypeLinkerHelper.doExprTypeUpdate(this.m_resolver, this, (IExpr)fieldAccessExpr, (IJstType)infferedType, this.m_groupInfo);
                JstExpressionTypeLinkerHelper.setPackageBindingForQualifier(fieldAccessExpr.getExpr());
                return infferedType;
            }
            JstTypeRefType typeRef = new JstTypeRefType(type);
            fieldAccessExpr.getName().setJstBinding((IJstNode)typeRef);
            JstExpressionTypeLinkerHelper.doExprTypeUpdate(this.m_resolver, this, (IExpr)fieldAccessExpr, (IJstType)typeRef, this.m_groupInfo);
            JstExpressionTypeLinkerHelper.setPackageBindingForQualifier(fieldAccessExpr.getExpr());
            return typeRef;
        }
        return null;
    }

    private IJstType checkFullyQualifierTypeInvocation(MtdInvocationExpr mtdInvocationExpr) {
        String fullName = JstExpressionTypeLinkerHelper.getFullName(mtdInvocationExpr);
        IJstType type = JstExpressionTypeLinkerHelper.findFullQualifiedType(this.m_resolver, fullName, this.m_groupInfo);
        if (type != null) {
            JstExpressionTypeLinkerHelper.bindMtdInvocations(this.m_resolver, this, mtdInvocationExpr, (IJstNode)type.getConstructor(), this.m_groupInfo);
            JstExpressionTypeLinkerHelper.doExprTypeUpdate(this.m_resolver, this, (IExpr)mtdInvocationExpr, type, this.m_groupInfo);
            JstExpressionTypeLinkerHelper.setPackageBindingForQualifier(mtdInvocationExpr.getQualifyExpr());
            return type;
        }
        return null;
    }

    private LinkerSymbolInfo findTypeInSymbolMap(String symbolName, List<VarTable> varTablesBottomUp) {
        ScopeFrame frame;
        Object info;
        ScopeFrame[] frames = this.m_scopeStack.toArray(new ScopeFrame[this.m_scopeStack.size()]);
        if (frames.length > 0 && (info = (frame = frames[frames.length - 1]).getSymbolBinding(symbolName)) != null) {
            return info;
        }
        if (varTablesBottomUp != null) {
            for (VarTable varTable : varTablesBottomUp) {
                IJstNode var;
                IJstNode iJstNode = var = varTable instanceof TopLevelVarTable ? ((TopLevelVarTable)varTable).getSelfVarNode(symbolName) : varTable.getVarNode(symbolName);
                if (var == null) continue;
                LinkerSymbolInfo lazy = new LinkerSymbolInfo(symbolName, varTable.getVarType(symbolName), var, varTable);
                this.getCurrentScopeFrame().addSymbolBinding(symbolName, lazy);
                return lazy;
            }
        }
        int i = frames.length - 1;
        while (i >= 0) {
            ScopeFrame frame2 = frames[i];
            LinkerSymbolInfo info2 = frame2.getSymbolBinding(symbolName);
            if (info2 != null) {
                return info2;
            }
            --i;
        }
        return null;
    }

    static class HierarcheQualifierSearcher {
        HierarcheQualifierSearcher() {
        }

        public IJstType searchType(IJstType type, String methodName, int inDepth, boolean isStatic) {
            HierarchyDepth depth = new HierarchyDepth(inDepth);
            return this.searchType(type, methodName, depth, isStatic);
        }

        public IJstType searchType(IJstType type, String methodName, HierarchyDepth depth, boolean isStatic) {
            if (type == null || methodName == null) {
                return null;
            }
            if (depth.getStartDepth() == 1) {
                type = type.getExtend();
                depth.previousLevel();
            }
            IJstType resultType = type;
            IJstMethod jstMethod = null;
            if (resultType != null && (jstMethod = resultType.getMethod(methodName, isStatic)) == null) {
                jstMethod = JstExpressionTypeLinkerHelper.getConstructs(resultType, methodName);
            }
            if (jstMethod == null && type != null) {
                IJstType extendType = type.getExtend();
                if (extendType != null && extendType != type && (resultType = this.searchType(extendType, methodName, depth, isStatic)) != null) {
                    return resultType;
                }
                List mixinTypes = type.getMixinsRef();
                for (IJstTypeReference mixinType : mixinTypes) {
                    if (mixinType.getReferencedType() == type || (resultType = this.searchType(mixinType.getReferencedType(), methodName, depth, isStatic)) == null) continue;
                    return resultType;
                }
                List expectTypes = type.getExpectsRef();
                for (IJstTypeReference expectType : expectTypes) {
                    if (expectType.getReferencedType() == type || (resultType = this.searchType(expectType.getReferencedType(), methodName, depth, isStatic)) == null) continue;
                    return resultType;
                }
            }
            return JstExpressionTypeLinkerHelper.getTargetJstType(resultType);
        }

        public IJstType searchReturnType(IJstType type, String methodName) {
            IJstType resultType = null;
            IJstMethod jstMethod = type.getMethod(methodName);
            if (jstMethod == null) {
                IJstType jstType = type.getExtend();
                if (jstType != null && jstType != type && (resultType = this.searchReturnType(jstType, methodName)) != null) {
                    return resultType;
                }
                List mixinTypes = type.getMixinsRef();
                for (IJstTypeReference mixinType : mixinTypes) {
                    if (mixinType.getReferencedType() == type || (resultType = this.searchReturnType(mixinType.getReferencedType(), methodName)) == null) continue;
                    return resultType;
                }
            } else {
                resultType = jstMethod.getRtnType();
            }
            return JstExpressionTypeLinkerHelper.getTargetJstType(resultType);
        }

        public IJstType searchPropertyType(IJstType type, String propertyName, int inDepth, boolean isStatic) {
            if (type == null || propertyName == null) {
                return null;
            }
            HierarchyDepth depth = new HierarchyDepth(inDepth);
            return this.searchPropertyType(type, propertyName, depth, isStatic);
        }

        public IJstType searchPropertyType(IJstType type, String propertyName, HierarchyDepth depth, boolean isStatic) {
            if (depth.getStartDepth() == 1) {
                type = type.getExtend();
                depth.previousLevel();
            }
            if (type == null || propertyName == null) {
                return null;
            }
            IJstType resultType = type;
            IJstProperty jstProperty = null;
            if (resultType != null) {
                jstProperty = type.getProperty(propertyName, isStatic);
            }
            if (jstProperty == null) {
                IJstType jstType = type.getExtend();
                if (jstType != null && jstType != type && (resultType = this.searchPropertyType(jstType, propertyName, depth, isStatic)) != null) {
                    return resultType;
                }
                List mixinTypes = type.getMixinsRef();
                for (IJstTypeReference mixinType : mixinTypes) {
                    if (mixinType.getReferencedType() == type || (resultType = this.searchPropertyType(mixinType.getReferencedType(), propertyName, depth, isStatic)) == null) continue;
                    return resultType;
                }
                List expectTypes = type.getExpectsRef();
                for (IJstTypeReference expectType : expectTypes) {
                    if (expectType.getReferencedType() == type || (resultType = this.searchPropertyType(expectType.getReferencedType(), propertyName, depth, isStatic)) == null) continue;
                    return resultType;
                }
            }
            return JstExpressionTypeLinkerHelper.getTargetJstType(resultType);
        }
    }

    static class HierarchyDepth {
        public static final int BASE = 1;
        public static final int THIS = 0;
        private int startDepth = 0;

        public HierarchyDepth(int startDepth) {
            this.startDepth = startDepth;
        }

        public void nextlevel() {
            ++this.startDepth;
        }

        public int getStartDepth() {
            return this.startDepth;
        }

        public void previousLevel() {
            --this.startDepth;
        }
    }

    static class LinkerSymbolInfo {
        private final String m_name;
        private final VarTable m_varTable;
        private IJstType m_type;
        private IJstNode m_binding;

        public LinkerSymbolInfo(String name, IJstType type, IJstNode binding, VarTable varTable) {
            this.m_name = name;
            this.m_type = type;
            this.m_binding = binding;
            this.m_varTable = varTable;
        }

        public IJstType getType() {
            return this.m_type;
        }

        public void setType(IJstType type) {
            this.m_type = type;
            if (this.m_varTable != null) {
                this.m_varTable.addVarType(this.m_name, this.m_type);
            }
        }

        public IJstNode getBinding() {
            return this.m_binding;
        }

        public void setBinding(IJstNode binding) {
            this.m_binding = binding;
            if (this.m_varTable != null) {
                this.m_varTable.addVarNode(this.m_name, this.m_binding);
            }
        }

        public VarTable getVarTable() {
            return this.m_varTable;
        }
    }

    static class ScopeFrame {
        private IJstType m_currentType;
        private boolean m_isStatic;
        private HashMap<String, LinkerSymbolInfo> m_SymbolMap = new HashMap();
        private Stack<JstVar> m_catchVarStack = new Stack();
        private String m_name;
        private IJstNode m_node;

        ScopeFrame(IJstType type, boolean isStatic) {
            this.m_currentType = type;
            this.m_isStatic = isStatic;
            this.m_name = type == null ? null : type.getName();
        }

        ScopeFrame(IJstType type, boolean isStatic, IJstNode currentNode) {
            this.m_currentType = type;
            this.m_isStatic = isStatic;
            this.m_name = type == null ? null : type.getName();
            this.m_node = currentNode;
        }

        public IJstNode getNode() {
            return this.m_node;
        }

        void addSymbolBinding(String symbolName, LinkerSymbolInfo nodeBinding) {
            this.m_SymbolMap.put(symbolName, nodeBinding);
        }

        LinkerSymbolInfo getSymbolBinding(String symbolName) {
            return this.m_SymbolMap.get(symbolName);
        }

        IJstType getCurrentType() {
            return this.m_currentType;
        }

        boolean isStatic() {
            return this.m_isStatic;
        }

        String getName() {
            return this.m_name;
        }

        void pushCatchVar(JstVar var) {
            this.m_catchVarStack.push(var);
        }

        void popCatchVar() {
            if (!this.m_catchVarStack.isEmpty()) {
                this.m_catchVarStack.pop();
            }
        }
    }
}

