/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.parser.bootstrap;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.List;
import org.eclipse.vjet.dsf.jsgen.shared.generate.IJsrTypeProvider;
import org.eclipse.vjet.dsf.jsgen.shared.generate.JsrGenerator;
import org.eclipse.vjet.dsf.jsgen.shared.generate.JsrTypeProvider;
import org.eclipse.vjet.dsf.jst.IJstLib;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstName;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jstojava.parser.bootstrap.Utils;
import org.eclipse.vjet.vjo.lib.LibManager;

public class GenJsBrowserJsr {
    private static final String JSNATIVE_JSR = "org.eclipse.vjet.vsf.jsbrowser.jsr";

    public static void main(String[] args) throws FileNotFoundException {
        String outputDir = args[0];
        IJstLib globals = LibManager.getInstance().getJsNativeGlobalLib();
        IJstLib lib = LibManager.getInstance().getBrowserTypesLib();
        List types = lib.getAllTypes(true);
        JstCache.getInstance().addLib(globals);
        JstCache.getInstance().addLib(lib);
        for (IJstType type : types) {
            try {
                JstPackage package1 = type.getPackage();
                if (package1 != null) continue;
                package1 = new JstPackage(JSNATIVE_JSR);
                IJstType type2 = type;
                JstType type3 = null;
                if (type2 instanceof JstType) {
                    type3 = (JstType)type2;
                    type3.setImpliedImport(true);
                    type3.clearMixins();
                    GenJsBrowserJsr.clearSatisfies(type3);
                }
                File jsrFile = GenJsBrowserJsr.createJsrFile(outputDir, package1, type.getSimpleName());
                System.out.println("writing:" + jsrFile);
                PrintWriter pw2 = new PrintWriter(jsrFile);
                pw2.append("package " + package1.getName() + ";");
                JsrGenerator gen2 = Utils.createGenerator(pw2);
                JsrTypeProvider jsrTypeProvider = new JsrTypeProvider();
                jsrTypeProvider.setEnableTypeMapping(false);
                gen2.setJsToJavaMapper((IJsrTypeProvider)jsrTypeProvider);
                gen2.writeJsr((IJstType)type3);
                pw2.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void clearSatisfies(JstType type3) {
        if (type3.isMixin()) {
            type3.clearSatisfies();
        }
    }

    private static void addUnderBar(IJstProperty property) {
        if (property instanceof JstProperty) {
            JstProperty p = (JstProperty)property;
            p.setName(new JstName("_" + property.getName().getName()));
        }
    }

    private static void addUnderBar(IJstMethod mtd) {
        if (mtd instanceof JstMethod) {
            JstMethod m = (JstMethod)mtd;
            m.setName(new JstName("_" + mtd.getName().getName()));
        }
    }

    private static boolean isBrowserType(IJstType type) {
        return type.getPackage() != null && type.getPackage().getGroupName().contains("JsNative");
    }

    private static File createJsrFile(String outputDir, JstPackage package1, String simpleName) {
        File dir;
        String packageURI = "";
        if (package1 != null) {
            packageURI = package1.getName().replace('.', File.separatorChar);
        }
        if (!(dir = new File(String.valueOf(outputDir) + File.separatorChar + packageURI + File.separatorChar)).exists()) {
            dir.mkdirs();
        }
        File file = new File(dir, String.valueOf(simpleName) + "Jsr.java");
        return file;
    }

    private static File createFile(String outputDir, JstPackage package1, String simpleName) {
        File dir;
        String packageURI = "";
        if (package1 != null) {
            packageURI = package1.getName().replace('.', File.separatorChar);
        }
        if (!(dir = new File(String.valueOf(outputDir) + File.separatorChar + packageURI + File.separatorChar)).exists()) {
            dir.mkdirs();
        }
        File file = new File(dir, String.valueOf(simpleName) + ".js");
        return file;
    }
}

