/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.vjet.dsf.jstojava.translator.BaseTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.DefsTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.GlobalsTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.InitsTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.OptionsTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.PropsTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.ProtosTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateCtx;
import org.eclipse.vjet.dsf.jstojava.translator.TypeTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.ValuesTranslator;

public class TranslatorProvider {
    private Map<Class<?>, BaseTranslator> m_translators = new HashMap();

    public TranslatorProvider(TranslateCtx ctx) {
        assert (ctx != null) : "ctx cannot be null";
        this.m_translators.put(TypeTranslator.class, new TypeTranslator(ctx));
        this.m_translators.put(ProtosTranslator.class, new ProtosTranslator(ctx));
        this.m_translators.put(PropsTranslator.class, new PropsTranslator(ctx));
        this.m_translators.put(GlobalsTranslator.class, new GlobalsTranslator(ctx));
        this.m_translators.put(ValuesTranslator.class, new ValuesTranslator(ctx));
        this.m_translators.put(InitsTranslator.class, new InitsTranslator(ctx));
        this.m_translators.put(DefsTranslator.class, new DefsTranslator(ctx));
        this.m_translators.put(OptionsTranslator.class, new OptionsTranslator(ctx));
    }

    public <T extends BaseTranslator> T getTranslator(Class<T> srcType) {
        assert (srcType != null) : "srcType cannot be null";
        return (T)this.m_translators.get(srcType);
    }

    public TypeTranslator getTypeTranslator() {
        return this.getTranslator(TypeTranslator.class);
    }

    public ProtosTranslator getProtosTranslator() {
        return this.getTranslator(ProtosTranslator.class);
    }

    public PropsTranslator getPropsTranslator() {
        return this.getTranslator(PropsTranslator.class);
    }

    public GlobalsTranslator getGlobalsTranslator() {
        return this.getTranslator(GlobalsTranslator.class);
    }

    public DefsTranslator getDefsTranslator() {
        return this.getTranslator(DefsTranslator.class);
    }

    public ValuesTranslator getValuesTranslator() {
        return this.getTranslator(ValuesTranslator.class);
    }

    public InitsTranslator getInitsTranslator() {
        return this.getTranslator(InitsTranslator.class);
    }

    public OptionsTranslator getOptionsTranslator() {
        return this.getTranslator(OptionsTranslator.class);
    }
}

