/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mod.wst.jsdt.core.ast.IASTNode;
import org.eclipse.mod.wst.jsdt.core.ast.IAbstractVariableDeclaration;
import org.eclipse.mod.wst.jsdt.core.ast.IStatement;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.vjet.dsf.jsgen.shared.validation.vjo.util.JstBindingUtil;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstFactory;
import org.eclipse.vjet.dsf.jst.declaration.JstFuncType;
import org.eclipse.vjet.dsf.jst.declaration.JstInferredType;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.meta.IJsCommentMeta;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jstojava.parser.comments.CommentCollector;
import org.eclipse.vjet.dsf.jstojava.translator.IFindTypeSupport;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.jstojava.translator.robust.JstSourceUtil;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.BaseAst2JstTranslator;

public class LocalDeclarationTranslator
extends BaseAst2JstTranslator<LocalDeclaration, JstVars> {
    @Override
    protected JstVars doTranslate(LocalDeclaration statement) {
        ArrayList<AssignExpr> list = new ArrayList<AssignExpr>();
        LocalDeclaration origStatement = statement;
        IJstType jstType = null;
        IJsCommentMeta meta = null;
        CommentCollector commentCollector = this.m_ctx.getCommentCollector();
        do {
            BaseJstNode initBaseNode;
            int exprEndOffset;
            int exprStartOffset;
            String name = String.valueOf(statement.getName());
            JstIdentifier jstIdentifier = new JstIdentifier(name);
            JstSource source = TranslateHelper.getIdentifierSource((IAbstractVariableDeclaration)statement, this.m_ctx.getSourceUtil());
            jstIdentifier.setSource(source);
            IExpr init = null;
            List<IJsCommentMeta> metaList = null;
            if (statement.initialization != null) {
                init = (IExpr)this.getTranslatorAndTranslate((IASTNode)statement.initialization);
                BaseJstNode initBaseNode2 = (BaseJstNode)init;
                if (init != null && init instanceof BaseJstNode) {
                    metaList = TranslateHelper.findMetaFromExpr(initBaseNode2);
                }
                init = metaList != null ? TranslateHelper.getCastable(init, metaList, this.m_ctx) : TranslateHelper.getCastable(init, (IStatement)statement, this.m_ctx);
            }
            if ((metaList = commentCollector.getCommentMeta(exprStartOffset = statement.declarationSourceStart, exprEndOffset = LocalDeclarationTranslator.findSourceEnd(statement), this.m_ctx.getPreviousNodeSourceEnd(), this.m_ctx.getNextNodeSourceStart())) != null && metaList.size() > 0) {
                meta = metaList.get(0);
            } else if (init != null && init instanceof BaseJstNode && (metaList = TranslateHelper.findMetaFromExpr(initBaseNode = (BaseJstNode)init)) != null && metaList.size() > 0) {
                meta = metaList.iterator().next();
            }
            if (meta != null) {
                if (meta.isCast() && init != null) {
                    jstType = init.getResultType();
                } else if (meta.getTyping() != null && (jstType = TranslateHelper.findType(this.m_ctx, meta.getTyping(), meta)) instanceof JstFuncType) {
                    IJstMethod replacement = null;
                    boolean rhsMethodFound = false;
                    if (init != null) {
                        IJstNode initBinding = JstBindingUtil.getJstBinding((IJstNode)init);
                        boolean bl = rhsMethodFound = initBinding != null && initBinding instanceof JstMethod;
                        if (rhsMethodFound) {
                            replacement = (IJstMethod)initBinding;
                            jstIdentifier.setJstBinding(initBinding);
                            IJstType iJstType = jstType = init.getResultType() != null ? init.getResultType() : jstType;
                        }
                    }
                    if (!rhsMethodFound) {
                        replacement = TranslateHelper.MethodTranslateHelper.createJstSynthesizedMethod(metaList, (IFindTypeSupport)this.m_ctx, "");
                        jstType = TranslateHelper.replaceSynthesizedMethodBinding(jstIdentifier, replacement);
                    }
                }
            }
            AssignExpr assignExpr = new AssignExpr((ILHS)jstIdentifier, init);
            assignExpr.setSource(TranslateHelper.getSource((IAbstractVariableDeclaration)statement, (IFindTypeSupport.ILineInfoProvider)this.m_ctx.getSourceUtil()));
            list.add(assignExpr);
        } while ((statement = (LocalDeclaration)statement.nextLocal) != null);
        boolean typeFound = true;
        if (jstType == null) {
            typeFound = false;
            jstType = JstCache.getInstance().getType("Object");
            if (jstType == null) {
                jstType = JstFactory.getInstance().createJstType("Object", true);
            }
            jstType = new JstInferredType(jstType);
        }
        JstVars vars = new JstVars(jstType);
        if (meta != null && meta.getModifiers().isFinal()) {
            vars.setIsFinal(true);
        }
        if (origStatement != null) {
            vars.setSource(LocalDeclarationTranslator.getStatementSource(origStatement, this.m_ctx.getSourceUtil()));
        }
        for (AssignExpr assignExpr : list) {
            vars.addAssignment(assignExpr);
        }
        if (meta != null && typeFound) {
            IJstTypeReference typeRef = vars.getTypeRef();
            TranslateHelper.setTypeRefSource((BaseJstNode)typeRef, meta);
        }
        return vars;
    }

    private static int findSourceEnd(LocalDeclaration statement) {
        return statement.declarationSourceEnd;
    }

    private static JstSource getStatementSource(LocalDeclaration statement, JstSourceUtil util) {
        JstSourceUtil.LineInfo info = util.lineInfo(statement.declarationSourceStart);
        return new JstSource(2, info.line(), info.colStart(), LocalDeclarationTranslator.findSourceEnd(statement) - statement.declarationSourceStart + 1, statement.declarationSourceStart, LocalDeclarationTranslator.findSourceEnd(statement));
    }
}

