/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst;

import org.eclipse.mod.wst.jsdt.core.ast.IASTNode;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.util.JstTypeHelper;
import org.eclipse.vjet.dsf.jstojava.translator.IFindTypeSupport;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.jstojava.translator.robust.ast2jst.BaseAst2JstTranslator;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletionOnSingleNameReference;
import org.eclipse.vjet.vjo.meta.VjoConvention;

public class SingleNameReferenceTranslator
extends BaseAst2JstTranslator<SingleNameReference, JstIdentifier> {
    private JstIdentifier _jstIdentifier;

    @Override
    protected JstIdentifier doTranslate(SingleNameReference expr) {
        this._jstIdentifier = null;
        String identifier = String.valueOf(expr.getToken());
        JstIdentifier jstIdentifier = new JstIdentifier(identifier);
        if (VjoConvention.getVjoNS().equals(identifier)) {
            JstType type = JstCache.getInstance().getType(VjoConvention.getVjoNS());
            if (type != null) {
                type = JstTypeHelper.getJstTypeRefType((IJstType)type);
            }
            jstIdentifier.setType((IJstType)type);
        }
        JstSource source = TranslateHelper.getSource((IASTNode)expr, (IFindTypeSupport.ILineInfoProvider)this.m_ctx.getSourceUtil());
        jstIdentifier.setSource(source);
        this._jstIdentifier = jstIdentifier;
        return jstIdentifier;
    }

    @Override
    protected JstCompletion createCompletion(SingleNameReference astNode, boolean isAfterSource) {
        JstIdentifier node;
        JstCompletionOnSingleNameReference completion = null;
        String identifier = String.valueOf(astNode.getToken());
        Object object = node = this._jstIdentifier != null ? this._jstIdentifier : this.m_ctx.getCurrentType();
        if (!this.isMessageCallBlock() || !this.isMissing(identifier)) {
            completion = new JstCompletionOnSingleNameReference((BaseJstNode)node);
            if (!identifier.equals("$missing$")) {
                int tempInt = this.m_ctx.getCompletionPos() - astNode.sourceStart;
                if (tempInt > identifier.length() || tempInt < 0) {
                    return null;
                }
                identifier = identifier.substring(0, this.m_ctx.getCompletionPos() - astNode.sourceStart);
                completion.setToken(identifier);
                this.m_ctx.setCreatedCompletion(true);
            } else {
                completion.setToken("");
                return null;
            }
        }
        return completion;
    }

    private boolean isMessageCallBlock() {
        return this.m_ctx.getCurrentScope() == ScopeIds.METHOD_CALL;
    }

    private boolean isMissing(String identifier) {
        return "$missing$".equals(identifier);
    }

    @Override
    protected int getSourceEnd(SingleNameReference astNode) {
        int realSourceEnd;
        int sourceEnd = astNode.sourceEnd();
        if (sourceEnd < (realSourceEnd = astNode.sourceStart() + astNode.toString().length() - 1)) {
            sourceEnd = realSourceEnd;
        }
        return sourceEnd;
    }
}

