/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator.robust.completion;

import java.util.Stack;
import org.eclipse.vjet.dsf.jsgen.shared.validation.common.ScopeId;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.IJstCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstSyntaxError;

public abstract class JstCompletion
extends JstSyntaxError
implements IJstCompletion {
    protected String[] completions;
    protected Stack<ScopeId> blockStack = new Stack();
    private IJstNode realParent;

    public abstract String getIncompletePart();

    public JstCompletion(BaseJstNode parent, String[] completions) {
        super(parent);
        this.completions = completions;
        this.realParent = parent;
    }

    public void setRealParent(IJstNode realParent) {
        this.realParent = realParent;
    }

    @Override
    public String[] getCompletion() {
        return this.completions;
    }

    public Stack<ScopeId> getScopeStack() {
        return this.blockStack;
    }

    public void setScopeStack(Stack<? extends ScopeId> scopeStack) {
        this.blockStack.clear();
        this.blockStack.addAll(scopeStack);
    }

    public void pushScope(ScopeId identifier) {
        this.blockStack.push(identifier);
    }

    public boolean inScope(ScopeId method) {
        return this.blockStack.contains(method);
    }

    public boolean isEmptyStack() {
        return this.blockStack.isEmpty();
    }

    public IJstNode getRealParent() {
        return this.realParent;
    }

    public IJstType getOwnerType() {
        return this.realParent == null ? null : this.realParent.getOwnerType();
    }
}

