/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.compiler.problem.IProblemReporter;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IModelStatus;
import org.eclipse.dltk.mod.core.ISourceElementParser;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.SourceParserUtil;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.AccumulatingProblemReporter;
import org.eclipse.dltk.mod.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.JSSourceModuleElementInfo;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.ModelStatus;
import org.eclipse.dltk.mod.internal.core.OpenableElementInfo;
import org.eclipse.dltk.mod.internal.core.ScriptFolder;
import org.eclipse.dltk.mod.internal.core.StructureBuilder;
import org.eclipse.dltk.mod.internal.core.VjoSourceModule;
import org.eclipse.dltk.mod.internal.core.VjoSourceModuleStructureRequestor;
import org.eclipse.dltk.mod.utils.CorePrinter;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.eclipse.internal.compiler.VjoSourceElementParser;
import org.eclipse.vjet.vjo.tool.typespace.SourceTypeName;

public class NativeVjoSourceModule
extends VjoSourceModule {
    private String group;
    private static final char[] EMPTY_CHAR = new char[0];

    public NativeVjoSourceModule(ScriptFolder folder, String group, String name) {
        super(folder, name, (WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
        this.group = group;
    }

    public char[] getContentsAsCharArray() {
        return EMPTY_CHAR;
    }

    @Override
    public SourceTypeName getTypeName() {
        return new SourceTypeName(this.group, this.getElementName());
    }

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor progressMonitor, Map newElements, IResource underlyingResource) throws ModelException {
        try {
            JSSourceModuleElementInfo moduleInfo = (JSSourceModuleElementInfo)info;
            this.build(newElements, moduleInfo);
            if (DLTKCore.DEBUG_PRINT_MODEL) {
                System.out.println("Source Module Debug print:");
                CorePrinter printer = new CorePrinter((OutputStream)System.out);
                this.printNode(printer);
                printer.flush();
            }
            return moduleInfo.isStructureKnown();
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    protected boolean hasBuffer() {
        return false;
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    private void build(Map newElements, JSSourceModuleElementInfo moduleInfo) throws CoreException, ModelException {
        VjoSourceModuleStructureRequestor requestor = new VjoSourceModuleStructureRequestor(this, moduleInfo, newElements);
        if ("org.eclipse.vjet.core.nature" == null) {
            throw new ModelException((IModelStatus)new ModelStatus(983));
        }
        VjoSourceElementParser parser = (VjoSourceElementParser)this.getSourceElementParser("org.eclipse.vjet.core.nature");
        if (!this.isReadOnly()) {
            parser.setScriptProject(this.getScriptProject());
        }
        parser.setRequestor(requestor);
        AccumulatingProblemReporter problemReporter = this.getAccumulatingProblemReporter();
        parser.setReporter((IProblemReporter)problemReporter);
        SourceParserUtil.parseSourceModule((ISourceModule)this, (ISourceElementParser)parser);
        if (problemReporter != null) {
            if (!problemReporter.hasErrors()) {
                StructureBuilder.build((String)"org.eclipse.vjet.core.nature", (ISourceModule)this, (AccumulatingProblemReporter)problemReporter);
            }
            problemReporter.reportToRequestor();
        }
    }

    public void build() throws ModelException {
        try {
            this.build(Collections.emptyMap(), (JSSourceModuleElementInfo)this.createElementInfo());
        }
        catch (CoreException e) {
            throw new ModelException(e);
        }
    }

    public char[] getFileName() {
        return super.getElementName().toCharArray();
    }

    public IResource getResource() {
        if (this.jstType == null) {
            return null;
        }
        String groupName = this.jstType.getPackage().getGroupName();
        URI path = null;
        String filePath = null;
        try {
            filePath = String.valueOf(this.jstType.getName().replace(".", "/")) + ".js";
            path = new URI("typespace://" + groupName + ":0/" + filePath + "?group=" + groupName);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject externalProject = ResourcesPlugin.getWorkspace().getRoot().getProject(".org.eclipse.dltk.mod.core.external.folders");
        IPath suffix = new Path(groupName).append(path.getPath());
        IFile f = externalProject.getFile(suffix);
        if (f.exists()) {
            return f;
        }
        IFile[] files = root.findFilesForLocationURI(path, 8);
        if (files.length > 0) {
            return files[0];
        }
        return this.getScriptProject().getProject().getFile(String.valueOf(this.jstType.getName().replace(".", "/")) + ".js");
    }

    public char[] getSourceAsCharArray() throws ModelException {
        return null;
    }

    public IType getVjoType() {
        try {
            IType[] types = this.getTypes();
            if (types.length > 0) {
                return types[0];
            }
            return null;
        }
        catch (ModelException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean exists() {
        return true;
    }

    public boolean isReadOnly() {
        return true;
    }

    private void innerRefresh() {
        try {
            ModelManager manager = ModelManager.getModelManager();
            String natureId = this.getNatureId();
            VjoSourceElementParser parser = (VjoSourceElementParser)this.getSourceElementParser(natureId);
            HashMap newElements = new HashMap();
            JSSourceModuleElementInfo info = (JSSourceModuleElementInfo)this.createElementInfo();
            VjoSourceModuleStructureRequestor requestor = new VjoSourceModuleStructureRequestor(this, info, newElements);
            if (!this.isReadOnly()) {
                parser.setScriptProject(this.getScriptProject());
            }
            parser.setRequestor(requestor);
            AccumulatingProblemReporter problemReporter = this.getAccumulatingProblemReporter();
            parser.setReporter((IProblemReporter)problemReporter);
            SourceParserUtil.parseSourceModule((ISourceModule)this, (ISourceElementParser)parser);
            manager.putInfos((IModelElement)this, newElements);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void setJstType(IJstType jtype) {
        if (jtype != this.jstType) {
            this.jstType = jtype;
            if (this.jstType != null) {
                this.innerRefresh();
            }
        }
    }
}

