/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.codeassist;

import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.mod.core.CompletionProposal;
import org.eclipse.dltk.mod.core.DLTKCore;
import org.eclipse.dltk.mod.core.Flags;
import org.eclipse.dltk.mod.core.IBuildpathEntry;
import org.eclipse.dltk.mod.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.mod.core.IField;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IParent;
import org.eclipse.dltk.mod.core.IScriptFolder;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.dltk.mod.internal.core.ExternalScriptFolder;
import org.eclipse.dltk.mod.internal.core.IModelElementRequestor;
import org.eclipse.dltk.mod.internal.core.ImportContainer;
import org.eclipse.dltk.mod.internal.core.InternalDLTKLanguageManager;
import org.eclipse.dltk.mod.internal.core.JSPackageDeclaration;
import org.eclipse.dltk.mod.internal.core.JSSourceField;
import org.eclipse.dltk.mod.internal.core.JSSourceFieldElementInfo;
import org.eclipse.dltk.mod.internal.core.JSSourceMethod;
import org.eclipse.dltk.mod.internal.core.JSSourceModule;
import org.eclipse.dltk.mod.internal.core.JSSourceType;
import org.eclipse.dltk.mod.internal.core.Model;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.dltk.mod.internal.core.ModelElementRequestor;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.NameLookup;
import org.eclipse.dltk.mod.internal.core.NativeVjoSourceModule;
import org.eclipse.dltk.mod.internal.core.OpenableElementInfo;
import org.eclipse.dltk.mod.internal.core.ScriptFolder;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.internal.core.SourceModule;
import org.eclipse.dltk.mod.internal.core.VjoLocalVariable;
import org.eclipse.dltk.mod.internal.core.VjoSourceModule;
import org.eclipse.dltk.mod.internal.core.VjoSourceType;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstConstructor;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstObjectLiteralType;
import org.eclipse.vjet.dsf.jst.declaration.JstPackage;
import org.eclipse.vjet.dsf.jst.declaration.JstProperty;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyMethod;
import org.eclipse.vjet.dsf.jst.declaration.JstProxyType;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstTypeRefType;
import org.eclipse.vjet.dsf.jst.declaration.JstVar;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.reserved.JsCoreKeywords;
import org.eclipse.vjet.dsf.jst.stmt.RtnStmt;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.term.NV;
import org.eclipse.vjet.dsf.jst.term.ObjLiteral;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.ts.JstQueryExecutor;
import org.eclipse.vjet.dsf.ts.ITypeSpace;
import org.eclipse.vjet.dsf.ts.TypeSpace;
import org.eclipse.vjet.dsf.ts.group.IGroup;
import org.eclipse.vjet.dsf.ts.type.TypeName;
import org.eclipse.vjet.eclipse.codeassist.keywords.CompletionContext;
import org.eclipse.vjet.eclipse.core.IJSMethod;
import org.eclipse.vjet.eclipse.core.IJSType;
import org.eclipse.vjet.eclipse.core.IVjoSourceModule;
import org.eclipse.vjet.eclipse.internal.codeassist.select.JstNodeDLTKElementResolver;
import org.eclipse.vjet.vjo.lib.TsLibLoader;
import org.eclipse.vjet.vjo.tool.codecompletion.CodeCompletionUtils;
import org.eclipse.vjet.vjo.tool.codecompletion.StringUtils;
import org.eclipse.vjet.vjo.tool.typespace.SourceTypeName;
import org.eclipse.vjet.vjo.tool.typespace.TypeSpaceMgr;

public class CodeassistUtils {
    private static final String OBJECT_TYPE = "Object";
    public static final String THIS_VJO_STATIC = "this.vj$.";
    public static final String THIS_STATIC = "this.";
    public static final String DOT = ".";
    private static Map<String, IBuildpathEntry[]> buildPathMap = new HashMap<String, IBuildpathEntry[]>();
    private static final String SUFFIX_ZIP = ".zip";
    private static final String SUFFIX_JAR = ".jar";
    private static final String SUFFIX_VJO = ".js";
    private static Map<String, String> nativeTypeGroupMap = new HashMap<String, String>();
    private static Map<String, NativeVjoSourceModule> nativeModuleMap = new HashMap<String, NativeVjoSourceModule>();
    private static Map<String, ScriptFolder> defaultNativeScriptFolderMap = new HashMap<String, ScriptFolder>();

    public static IType getType(org.eclipse.dltk.mod.compiler.env.ISourceModule module, String name) {
        ISourceModule sm = (ISourceModule)module;
        try {
            IType[] types = sm.getTypes();
            if (types != null) {
                IType[] iTypeArray = types;
                int n = types.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    if (name == null || type.getElementName().equals(name)) {
                        return type;
                    }
                    ++n2;
                }
            }
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
        return null;
    }

    public static IType findType(ScriptProject scriptProject, IJstType jstType) {
        String typeName;
        IJstType outerType = CodeCompletionUtils.getOuterJstType((IJstType)jstType);
        if (outerType == jstType) {
            IType type = CodeassistUtils.findType(scriptProject, jstType.getName());
            if (type != null) {
                return type;
            }
            String alias = jstType.getAlias();
            return CodeassistUtils.findType(scriptProject, alias);
        }
        String packageName = "";
        if (outerType.getPackage() != null) {
            packageName = outerType.getPackage().getName();
        }
        if ((typeName = jstType.getName()).contains(packageName)) {
            if (StringUtils.isBlankOrEmpty((String)packageName)) {
                packageName = "";
            } else {
                typeName = typeName.substring(packageName.length() + 1);
            }
            return CodeassistUtils.findType(scriptProject, typeName, packageName);
        }
        return CodeassistUtils.findType(scriptProject, jstType.getName());
    }

    public static IType findType(ScriptProject scriptProject, String typeName, String packageName) {
        NameLookup.Answer answer;
        if (scriptProject == null || typeName == null || packageName == null) {
            return null;
        }
        IType type = null;
        NameLookup lookup = null;
        try {
            lookup = scriptProject.newNameLookup((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
        }
        catch (ModelException modelException) {
            return null;
        }
        if (lookup != null && (answer = lookup.findType(typeName, packageName, false, 0, true, true, false, null)) != null) {
            type = answer.type;
        }
        if (type == null) {
            try {
                type = CodeassistUtils.findInDependsProjects(typeName, packageName, (IScriptProject)scriptProject);
            }
            catch (ModelException e) {
                DLTKCore.error((String)e.toString(), (Throwable)e);
            }
        }
        return type;
    }

    public static IType findType(ScriptProject scriptProject, String name) {
        if (scriptProject == null || name == null) {
            return null;
        }
        IType type = null;
        if (scriptProject == null || !scriptProject.exists()) {
            return null;
        }
        try {
            NameLookup lookup = scriptProject.newNameLookup((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
            if (lookup != null) {
                type = lookup.findType(name, false, 0);
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        if (type == null) {
            try {
                type = CodeassistUtils.findInDependsProjects(name, (IScriptProject)scriptProject);
            }
            catch (ModelException e) {
                DLTKCore.error((String)e.toString(), (Throwable)e);
            }
        }
        return type;
    }

    public static void findTypes(SourceModule sourceModule, String word, ModelElementRequestor requestor) {
        ScriptProject project = (ScriptProject)sourceModule.getModelElement().getAncestor(2);
        NameLookup lookup = null;
        try {
            lookup = project.newNameLookup((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
        lookup.seekTypes(word, (IScriptFolder)sourceModule.getScriptFolder(), true, 0, (IModelElementRequestor)requestor);
        CodeassistUtils.findNativeTypes(sourceModule, word, requestor);
    }

    private static void findNativeTypes(SourceModule sourceModule, String word, ModelElementRequestor requestor) {
        TypeName global = new TypeName("JsNativeLib", "Global");
        IJstType jsttype = TypeSpaceMgr.getInstance().getController().getJstTypeSpaceMgr().getQueryExecutor().findType(global);
        for (IJstMethod m : jsttype.getMethods()) {
            if (!m.getName().getName().startsWith(word)) continue;
            IType type = CodeassistUtils.createNativeType((org.eclipse.dltk.mod.compiler.env.ISourceModule)sourceModule);
            requestor.acceptType(type);
            return;
        }
        for (IJstProperty m : jsttype.getProperties()) {
            if (!m.getName().getName().startsWith(word)) continue;
            IType type = CodeassistUtils.createNativeType((org.eclipse.dltk.mod.compiler.env.ISourceModule)sourceModule);
            requestor.acceptType(type);
            return;
        }
        IGroup nativeTypes = TypeSpaceMgr.getInstance().getController().getJstTypeSpaceMgr().getTypeSpace().getGroup("JsNativeLib");
        for (IJstType jsttype2 : nativeTypes.getEntities().values()) {
            String typeName = jsttype2.getName();
            if (!typeName.startsWith(word)) continue;
            IType type = CodeassistUtils.findNativeSourceType((org.eclipse.dltk.mod.compiler.env.ISourceModule)sourceModule, typeName);
            requestor.acceptType(type);
        }
    }

    public static IType findResourceType(org.eclipse.dltk.mod.compiler.env.ISourceModule sourceModule, String name) {
        IType type = null;
        IScriptProject project = (IScriptProject)sourceModule.getModelElement().getAncestor(2);
        if (project.getProject() == null) {
            return null;
        }
        try {
            NameLookup lookup = ((ScriptProject)project).newNameLookup((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
            if (name.indexOf(46) > 0) {
                type = lookup.findType(name, false, 0);
            } else if (sourceModule.getModelElement() instanceof SourceModule) {
                IModelElement[] children = ((SourceModule)sourceModule).getChildren();
                ImportContainer importContainer = null;
                int j = 0;
                while (j < children.length) {
                    if (children[j] instanceof ImportContainer) {
                        importContainer = (ImportContainer)children[j];
                        break;
                    }
                    ++j;
                }
                if (importContainer != null) {
                    IModelElement[] importDeclaration = importContainer.getChildren();
                    int j2 = 0;
                    while (j2 < importDeclaration.length) {
                        if (importDeclaration[j2].getElementName().contains(".*")) {
                            String imp = importDeclaration[j2].getElementName().replace(".*", "");
                            type = lookup.findType(imp.concat(DOT).concat(name), false, 0);
                            if (type != null) {
                                return type;
                            }
                        } else if (importDeclaration[j2].getElementName().endsWith(DOT + name)) {
                            return lookup.findType(importDeclaration[j2].getElementName(), false, 0);
                        }
                        ++j2;
                    }
                }
                j = 0;
                while (j < children.length) {
                    if (children[j] instanceof JSPackageDeclaration) {
                        type = lookup.findType(((JSPackageDeclaration)children[j]).getElementName().concat(DOT).concat(name), false, 0);
                        break;
                    }
                    ++j;
                }
            }
            if (type == null) {
                type = CodeassistUtils.findInDependsProjects(name, project);
            }
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
        return type;
    }

    private static IType findInDependsProjects(String typeName, String packageName, IScriptProject project) throws ModelException {
        IScriptProject[] prjs;
        IType type = null;
        ModelManager manager = ModelManager.getModelManager();
        Model model = manager.getModel();
        IScriptProject[] iScriptProjectArray = prjs = model.getScriptProjects("org.eclipse.vjet.core.nature");
        int n = prjs.length;
        int n2 = 0;
        while (n2 < n) {
            IScriptProject prj = iScriptProjectArray[n2];
            type = CodeassistUtils.findInDependsProjects(typeName, packageName, project, prj);
            if (type != null) break;
            ++n2;
        }
        return type;
    }

    private static IType findInDependsProjects(String name, IScriptProject project) throws ModelException {
        IScriptProject[] prjs;
        IType type = null;
        ModelManager manager = ModelManager.getModelManager();
        Model model = manager.getModel();
        IScriptProject[] iScriptProjectArray = prjs = model.getScriptProjects("org.eclipse.vjet.core.nature");
        int n = prjs.length;
        int n2 = 0;
        while (n2 < n) {
            IScriptProject prj = iScriptProjectArray[n2];
            type = CodeassistUtils.findInDependsProjects(name, project, prj);
            if (type != null) break;
            ++n2;
        }
        return type;
    }

    private static IType findInDependsProjects(String typeName, String packageName, IScriptProject project, IScriptProject dependentProject) throws ModelException {
        IBuildpathEntry[] entries;
        IType type = null;
        IBuildpathEntry[] iBuildpathEntryArray = entries = dependentProject.getResolvedBuildpath(true);
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildpathEntry entry = iBuildpathEntryArray[n2];
            if (entry.getEntryKind() == 2) {
                String prjName = entry.getPath().segment(0);
                if (project.getElementName().equals(prjName)) {
                    NameLookup lookup = ((ScriptProject)dependentProject).newNameLookup((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
                    NameLookup.Answer answer = lookup.findType(typeName, packageName, false, 0, true, true, false, null);
                    if (answer != null) {
                        type = answer.type;
                    }
                    if (type != null) break;
                }
            }
            ++n2;
        }
        return type;
    }

    private static IType findInDependsProjects(String name, IScriptProject project, IScriptProject dependentProject) throws ModelException {
        IBuildpathEntry[] entries;
        IType type = null;
        IBuildpathEntry[] iBuildpathEntryArray = entries = dependentProject.getResolvedBuildpath(true);
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildpathEntry entry = iBuildpathEntryArray[n2];
            if (entry.getEntryKind() == 2) {
                NameLookup lookup;
                String prjName = entry.getPath().segment(0);
                if (project.getElementName().equals(prjName) && (type = (lookup = ((ScriptProject)dependentProject).newNameLookup((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY)).findType(name, false, 0)) != null) break;
            }
            ++n2;
        }
        return type;
    }

    public static IModelElement findLocalElement(ISourceModule module, int pos) {
        IModelElement res = null;
        try {
            res = module.getElementAt(pos);
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
        return res;
    }

    public static IScriptFolder[] findScriptFolder(org.eclipse.dltk.mod.compiler.env.ISourceModule sourceModule, String name) {
        IScriptProject project = (IScriptProject)sourceModule.getModelElement().getAncestor(2);
        try {
            NameLookup lookup = ((ScriptProject)project).newNameLookup((WorkingCopyOwner)DefaultWorkingCopyOwner.PRIMARY);
            return lookup.findScriptFolders(name, false);
        }
        catch (Exception e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
            return null;
        }
    }

    public static IScriptFolder getScriptFolder(IScriptProject project, String folderName) throws ModelException {
        IScriptFolder[] folders;
        IScriptFolder[] iScriptFolderArray = folders = project.getScriptFolders();
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            IScriptFolder folder = iScriptFolderArray[n2];
            if (folder.getElementName().equals(folderName)) {
                return folder;
            }
            ++n2;
        }
        return null;
    }

    public static IField getField(org.eclipse.dltk.mod.compiler.env.ISourceModule sourceModule, String fieldName, FieldSearchType fieldSearch) {
        IField result = null;
        try {
            IType type = CodeassistUtils.getType(sourceModule, null);
            if (type != null) {
                IType superType;
                IField[] fields;
                IField[] iFieldArray = fields = type.getFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    IField field = iFieldArray[n2];
                    if (field.getElementName().equals(fieldName) && (fieldSearch == null || !(fieldSearch == FieldSearchType.STATIC ^ Flags.isStatic((int)field.getFlags())))) {
                        return field;
                    }
                    ++n2;
                }
                String[] superClassNames = type.getSuperClasses();
                if (superClassNames != null && superClassNames.length > 0 && (superType = CodeassistUtils.findResourceType(sourceModule, superClassNames[0])) != null) {
                    result = CodeassistUtils.getField((org.eclipse.dltk.mod.compiler.env.ISourceModule)((SourceModule)superType.getParent()), fieldName, fieldSearch);
                }
            }
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
        return result;
    }

    public static void getQualifiersAsList(Object qualifier, List<IExpr> list) {
        if (qualifier == null) {
            return;
        }
        IExpr expression = null;
        if (qualifier instanceof FieldAccessExpr) {
            expression = ((FieldAccessExpr)qualifier).getExpr();
        } else if (qualifier instanceof MtdInvocationExpr) {
            expression = ((MtdInvocationExpr)qualifier).getQualifyExpr();
        } else if (qualifier instanceof JstIdentifier) {
            expression = ((JstIdentifier)qualifier).getQualifier();
        }
        if (expression != null) {
            list.add(expression);
            CodeassistUtils.getQualifiersAsList(expression, list);
        }
    }

    public static org.eclipse.dltk.mod.compiler.env.ISourceModule getElementSourceModule(IModelElement element, org.eclipse.dltk.mod.compiler.env.ISourceModule module) {
        org.eclipse.dltk.mod.compiler.env.ISourceModule sourceModule = null;
        String typeName = null;
        try {
            if (element instanceof JSSourceField) {
                JSSourceFieldElementInfo info = (JSSourceFieldElementInfo)((JSSourceField)element).getElementInfo();
                typeName = info.getType();
            } else if (element instanceof JSSourceMethod) {
                typeName = ((JSSourceMethod)element).getReturnType();
            } else if (element instanceof JSSourceType) {
                return (org.eclipse.dltk.mod.compiler.env.ISourceModule)element.getParent();
            }
            IType t = null;
            t = typeName.equals(element.getParent().getElementName()) ? ((JSSourceModule)module).getType(typeName) : CodeassistUtils.findResourceType(module, typeName);
            if (t != null) {
                sourceModule = (org.eclipse.dltk.mod.compiler.env.ISourceModule)t.getParent();
            }
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
        return sourceModule;
    }

    public static IModelElement[] getMethod(org.eclipse.dltk.mod.compiler.env.ISourceModule module, JstMethod selection) {
        try {
            IType type = CodeassistUtils.getType(module, null);
            if (type != null) {
                return CodeassistUtils.getMethod(type, (IJstMethod)selection);
            }
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.toString(), (Throwable)e);
        }
        return null;
    }

    public static IJstMethod getJstMethod(IJstType jstType, IMethod dltkMethod) {
        if (jstType != null && dltkMethod != null) {
            List jstMethods = jstType.getMethods();
            for (IJstMethod jstMethod : jstMethods) {
                List args;
                String[] paramsTypes;
                if (!jstMethod.getName().getName().equals(dltkMethod.getElementName()) || (paramsTypes = ((IJSMethod)dltkMethod).getParameterTypes()).length != (args = jstMethod.getArgs()).size()) continue;
                boolean paramsOK = true;
                int i = 0;
                while (i < paramsTypes.length) {
                    JstArg arg = (JstArg)args.get(i);
                    IJstType argType = arg.getType();
                    String argTypeName = argType != null ? argType.getName() : OBJECT_TYPE;
                    if (!paramsTypes[i].equals(argTypeName)) {
                        paramsOK = false;
                        break;
                    }
                    ++i;
                }
                if (!paramsOK) continue;
                return jstMethod;
            }
        }
        return null;
    }

    public static IMethod[] findMethodBySignature2(String methodName, List<String> args, IType declareType) throws ModelException {
        IMethod[] methods;
        ArrayList<IMethod> mtds = new ArrayList<IMethod>();
        IMethod[] iMethodArray = methods = declareType.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.getElementName().equals(methodName)) {
                mtds.add(method);
            }
            ++n2;
        }
        return mtds.toArray(new IMethod[0]);
    }

    public static IMethod findMethodBySignature(String methodName, List<String> args, IType declareType) throws ModelException {
        IMethod[] methods;
        IMethod[] iMethodArray = methods = declareType.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method = iMethodArray[n2];
            if (method.getElementName().equals(methodName)) {
                IJSMethod jsMethod = (IJSMethod)method;
                return jsMethod;
            }
            ++n2;
        }
        return null;
    }

    public static IMethod[] getMethod(IType type, IJstMethod jstMethod) throws ModelException {
        Assert.isNotNull((Object)type);
        Assert.isNotNull((Object)jstMethod);
        String selectedMethodName = jstMethod.getName().getName();
        List args = jstMethod.getArgs();
        ArrayList<String> paramList = new ArrayList<String>();
        for (JstArg jstArg : args) {
            IJstType argType = jstArg.getType();
            String argTypeName = argType != null ? argType.getName() : OBJECT_TYPE;
            paramList.add(argTypeName);
        }
        return CodeassistUtils.findMethodBySignature2(selectedMethodName, paramList, type);
    }

    public static IModelElement[] getLocalVar(org.eclipse.dltk.mod.compiler.env.ISourceModule module, String name, String type, JstSource source) {
        IModelElement[] iModelElementArray;
        IModelElement element = CodeassistUtils.findLocalElement((ISourceModule)module, source.getStartOffSet());
        if (element != null && element.getElementType() == 8) {
            element = element.getParent();
        }
        VjoLocalVariable localVar = null;
        if (element != null) {
            IJstType jstType;
            IModelElement child = CodeassistUtils.findChild(name, element);
            if (child != null) {
                return new IModelElement[]{child};
            }
            if (JsCoreKeywords.THIS.equals(name)) {
                IType currentType = (IType)element.getAncestor(7);
                type = currentType.getFullyQualifiedName().replace('/', '.');
            } else if (OBJECT_TYPE.equals(type) && (jstType = CodeassistUtils.findNativeJstType(name)) != null) {
                IModelElement[] iModelElementArray2;
                IVjoSourceModule sourceModule = (IVjoSourceModule)module;
                ScriptFolder folder = (ScriptFolder)sourceModule.getParent();
                NativeVjoSourceModule m = CodeassistUtils.createNativeModule(folder, jstType.getName());
                if (m != null) {
                    IModelElement[] iModelElementArray3 = new IModelElement[1];
                    iModelElementArray2 = iModelElementArray3;
                    iModelElementArray3[0] = m;
                } else {
                    iModelElementArray2 = new IModelElement[]{};
                }
                return iModelElementArray2;
            }
            localVar = new VjoLocalVariable((ModelElement)element, name, source.getStartOffSet(), source.getEndOffSet(), source.getStartOffSet(), source.getEndOffSet(), type);
        }
        if (localVar != null) {
            IModelElement[] iModelElementArray4 = new IModelElement[1];
            iModelElementArray = iModelElementArray4;
            iModelElementArray4[0] = localVar;
        } else {
            iModelElementArray = new IModelElement[]{};
        }
        return iModelElementArray;
    }

    public static IModelElement findChild(String name, IModelElement parent) {
        IModelElement element;
        block4: {
            element = null;
            try {
                IModelElement[] children = ((ModelElement)parent).getChildren();
                if (children == null || children.length <= 0) break block4;
                IModelElement[] iModelElementArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IModelElement child = iModelElementArray[n2];
                    if (child.getElementType() == 8 && child.getElementName().equals(name)) {
                        element = child;
                        break;
                    }
                    ++n2;
                }
            }
            catch (ModelException e) {
                DLTKCore.error((String)e.toString(), (Throwable)e);
            }
        }
        return element;
    }

    public static List<IModelElement> resolveQualifiers(Object expression, org.eclipse.dltk.mod.compiler.env.ISourceModule module) {
        ArrayList<IModelElement> modelElement = new ArrayList<IModelElement>();
        if (expression != null) {
            if (expression instanceof IJstType) {
                IJstType jstType = (IJstType)expression;
                modelElement.add((IModelElement)CodeassistUtils.getType(module, jstType.getSimpleName()));
            } else if (expression instanceof IJstTypeReference) {
                IJstType jstType = ((IJstTypeReference)expression).getReferencedType();
                if (CodeassistUtils.isEmpty(jstType)) {
                    return Collections.emptyList();
                }
                if (CodeassistUtils.isNativeType(jstType) || CodeassistUtils.isBinaryType(jstType)) {
                    modelElement.add((IModelElement)CodeassistUtils.findNativeSourceType(jstType));
                } else {
                    modelElement.add((IModelElement)CodeassistUtils.findResourceType(module, jstType.getName()));
                }
            } else if (expression instanceof JstIdentifier) {
                JstIdentifier identifier = (JstIdentifier)expression;
                if (modelElement == null) {
                    modelElement.addAll(Arrays.asList(CodeassistUtils.getLocalVar(module, identifier.getName(), OBJECT_TYPE, identifier.getSource())));
                }
                if (modelElement == null) {
                    String nativeTypeName = "vjo";
                    TypeSpaceMgr.getInstance().getController().getJstTypeSpaceMgr().getQueryExecutor().findType(new TypeName("VjoBaseLib", nativeTypeName));
                }
            } else if (expression instanceof JstProperty) {
                modelElement.add((IModelElement)CodeassistUtils.getField(module, ((JstProperty)expression).getName().getName(), null));
            } else if (expression instanceof JstVar) {
                JstVar jstVar = (JstVar)expression;
                IJstType type = jstVar.getType();
                String typeName = OBJECT_TYPE;
                if (type != null) {
                    typeName = type.getName();
                }
                modelElement.addAll(Arrays.asList(CodeassistUtils.getLocalVar(module, jstVar.getName(), typeName, jstVar.getSource())));
            } else if (expression instanceof JstMethod) {
                modelElement.addAll(Arrays.asList(CodeassistUtils.getMethod(module, (JstMethod)expression)));
            } else if (expression instanceof JstArg) {
                JstArg arg = (JstArg)expression;
                IJstType type = arg.getType();
                String typeName = OBJECT_TYPE;
                if (type != null) {
                    typeName = type.getName();
                }
                modelElement.addAll(Arrays.asList(CodeassistUtils.getLocalVar(module, arg.getName(), typeName, arg.getSource())));
            } else if (expression instanceof FieldAccessExpr) {
                FieldAccessExpr fieldAccExpr = (FieldAccessExpr)expression;
                IExpr qualifier = fieldAccExpr.getExpr();
                IJstType qualifierType = qualifier.getResultType();
                if (qualifierType != null && "Vj$Type".equals(qualifierType.getName())) {
                    IJstType fieldType = fieldAccExpr.getResultType();
                    if (fieldType == null) {
                        return null;
                    }
                    if (fieldType instanceof JstTypeRefType) {
                        fieldType = ((JstTypeRefType)fieldType).getType();
                    }
                    modelElement.add((IModelElement)CodeassistUtils.findResourceType(module, fieldType.getName()));
                } else {
                    modelElement.add(CodeassistUtils.getModelElementByFieldAccessExpr(fieldAccExpr, module));
                }
            } else if (expression instanceof MtdInvocationExpr) {
                modelElement.addAll(Arrays.asList(CodeassistUtils.getModelElementByMtdInvoExpr((MtdInvocationExpr)expression, module)));
            }
        }
        return modelElement;
    }

    public static IModelElement getModelElementByFieldAccessExpr(FieldAccessExpr expression, org.eclipse.dltk.mod.compiler.env.ISourceModule module) {
        JstType type;
        IJstType baseType;
        IType modelElement = null;
        IJstNode binding = expression.getName().getJstBinding();
        if (binding == null) {
            List children = expression.getChildren();
            for (Object obj : children) {
                String nativeTypeName;
                if (!(obj instanceof JstIdentifier) || CodeassistUtils.findNativeSourceType(module, nativeTypeName = ((JstIdentifier)obj).getName()) == null) continue;
                modelElement = CodeassistUtils.findNativeSourceType(module, nativeTypeName);
            }
        }
        if (binding instanceof JstProperty) {
            IJstType type2;
            JstType ownerType = ((JstProperty)binding).getOwnerType();
            IType resultType = CodeassistUtils.findResultType(module, (IJstType)ownerType, type2 = ((JstProperty)binding).getType());
            if (resultType != null && resultType.getParent() instanceof NativeVjoSourceModule) {
                modelElement = resultType;
            } else if (resultType != null) {
                modelElement = resultType.getField(expression.getName().getName());
            }
        } else if (binding instanceof IJstType) {
            IJstType jstType = (IJstType)binding;
            modelElement = CodeassistUtils.findType(jstType);
            if (modelElement == null && jstType instanceof JstTypeRefType) {
                JstPackage pack = jstType.getPackage();
                String groupName = null;
                if (pack == null) {
                    return null;
                }
                groupName = pack.getGroupName();
                String typeName = ((JstTypeRefType)jstType).getReferencedNode().getName();
                IType type3 = CodeassistUtils.findType(CodeassistUtils.getScriptProject(groupName), typeName);
                if (type3 != null) {
                    return type3;
                }
                return CodeassistUtils.findNativeSourceType(groupName, typeName, jstType);
            }
        } else if (CodeassistUtils.isBase(expression) && (baseType = (type = expression.getOwnerType()).getExtend()) != null && !baseType.getName().equals("vjo.Object")) {
            modelElement = CodeassistUtils.findType(baseType);
        }
        return modelElement;
    }

    public static IModelElement[] getModelElementByMtdInvoExpr(MtdInvocationExpr expr, org.eclipse.dltk.mod.compiler.env.ISourceModule module) {
        ArrayList<IMethod> methodElement;
        block16: {
            IJstNode binding = CodeassistUtils.getBinding(expr);
            methodElement = new ArrayList<IMethod>();
            IType declareType = null;
            if (binding instanceof JstMethod) {
                JstType ownerType = ((JstMethod)binding).getOwnerType();
                if (CodeassistUtils.isNativeType((IJstType)ownerType)) {
                    return null;
                }
                declareType = CodeassistUtils.findType((IJstType)ownerType);
                if (declareType == null) {
                    declareType = CodeassistUtils.findNativeSourceType((IJstType)ownerType);
                }
                if (declareType != null) {
                    try {
                        String funcName = CodeassistUtils.getFunctionName(expr);
                        String[] paramTypes = CodeassistUtils.getParameterTypes(expr);
                        if (declareType instanceof IJSType) {
                            methodElement.addAll(Arrays.asList(CodeassistUtils.getMethod(declareType, (IJstMethod)((JstMethod)binding))));
                            if (!CodeassistUtils.isNativeObject((IMember)methodElement.get(0)) && !((IMethod)methodElement.get(0)).exists()) {
                                methodElement.add(CodeassistUtils.findMostMatchingMethod(declareType, funcName, paramTypes));
                            }
                            break block16;
                        }
                        methodElement.add(declareType.getMethod(funcName));
                    }
                    catch (Exception exception) {}
                }
            } else {
                IJstType jstType;
                IExpr methodIdentifier = expr.getMethodIdentifier();
                if (methodIdentifier instanceof FieldAccessExpr && (jstType = expr.getResultType()) != null && jstType.getPackage() != null) {
                    IType itype;
                    FieldAccessExpr fae = (FieldAccessExpr)expr.getMethodIdentifier();
                    IJstNode type = fae.getName().getJstBinding();
                    declareType = CodeassistUtils.findType(jstType);
                    if (type instanceof JstConstructor && (itype = CodeassistUtils.findType(jstType)) != null) {
                        methodElement.add(itype.getMethod(itype.getElementName()));
                    }
                }
                if (methodIdentifier instanceof JstIdentifier) {
                    expr.getArgs();
                    IExpr qualify = expr.getQualifyExpr();
                    try {
                        if (qualify != null) {
                            declareType = CodeassistUtils.findTypeByQualify(module, qualify);
                        }
                        if (declareType != null) {
                            String[] paramTypes = CodeassistUtils.getParameterTypes(expr);
                            methodElement.add(CodeassistUtils.findMethodBySignature(methodIdentifier.toString(), Arrays.asList(paramTypes), declareType));
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return methodElement.toArray(new IModelElement[0]);
    }

    private static IJstNode getBinding(MtdInvocationExpr expr) {
        IJstNode node = expr.getMethod();
        if (node == null) {
            if (expr.getMethodIdentifier() instanceof FieldAccessExpr) {
                FieldAccessExpr accessExpr = (FieldAccessExpr)expr.getMethodIdentifier();
                node = accessExpr.getName().getJstBinding();
            } else if (expr.getMethodIdentifier() instanceof JstIdentifier) {
                node = ((JstIdentifier)expr.getMethodIdentifier()).getJstBinding();
            }
        }
        return node;
    }

    private static String getFunctionName(MtdInvocationExpr expr) {
        String name = null;
        if (expr.getMethodIdentifier() instanceof JstIdentifier) {
            JstIdentifier identifier = (JstIdentifier)expr.getMethodIdentifier();
            name = identifier.getName();
        }
        if (expr.getMethodIdentifier() instanceof FieldAccessExpr) {
            FieldAccessExpr accessExpr = (FieldAccessExpr)expr.getMethodIdentifier();
            JstIdentifier identifier = accessExpr.getName();
            name = identifier.getName();
        }
        return name;
    }

    private static String[] getParameterTypes(MtdInvocationExpr expr) {
        List params = expr.getArgs();
        ArrayList<String> args = new ArrayList<String>();
        for (IExpr param : params) {
            if (param == null) continue;
            if (param.getResultType() == null) {
                args.add(OBJECT_TYPE);
                continue;
            }
            args.add(param.getResultType().getName());
        }
        return args.toArray(new String[args.size()]);
    }

    private static IMethod findMostMatchingMethod(IType resultType, String funcName, String[] paramTypes) {
        IMethod mostMatchMethod = null;
        float mostMatchRatio = 0.0f;
        try {
            IMethod[] methods;
            IMethod[] iMethodArray = methods = resultType.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (method.getElementName().equals(funcName)) {
                    int matchCount = 0;
                    String[] params = ((JSSourceMethod)method).getParameterTypes();
                    int min = Math.min(paramTypes.length, params.length);
                    if (min != 0) {
                        int i = 0;
                        while (i < params.length) {
                            String param = params[i];
                            if (i < min && paramTypes[i].equals(param)) {
                                ++matchCount;
                            }
                            ++i;
                        }
                        float matchRatio = matchCount / paramTypes.length + min;
                        if (matchRatio > mostMatchRatio) {
                            mostMatchMethod = method;
                            mostMatchRatio = matchRatio;
                        }
                    }
                }
                ++n2;
            }
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        return mostMatchMethod;
    }

    public static IType findType(IJstType jstType) {
        if (CodeassistUtils.isNativeType(jstType)) {
            return null;
        }
        JstPackage pack = jstType.getPackage();
        String groupName = null;
        if (pack == null) {
            return null;
        }
        groupName = pack.getGroupName();
        return CodeassistUtils.findType(CodeassistUtils.getScriptProject(groupName), jstType.getName());
    }

    private static boolean isBase(Object expression) {
        FieldAccessExpr expr = (FieldAccessExpr)expression;
        return expr.toExprText().equals("this.base");
    }

    private static IType findResultType(org.eclipse.dltk.mod.compiler.env.ISourceModule module, IJstType ownerType, IJstType rtnType) {
        IType type = null;
        if (ownerType != null && ownerType.getPackage() != null) {
            type = CodeassistUtils.findType(CodeassistUtils.getScriptProject(ownerType.getPackage().getGroupName()), ownerType.getName());
        }
        if (type == null && ownerType != null) {
            type = CodeassistUtils.findNativeSourceType(rtnType);
        }
        if (type == null && rtnType != null) {
            type = CodeassistUtils.findNativeSourceType(module, rtnType.getName());
        }
        return type;
    }

    public static ScriptProject getScriptProject(String groupName) {
        IScriptProject project;
        if (groupName == null || groupName.length() == 0) {
            return null;
        }
        Model model = ModelManager.getModelManager().getModel();
        if (!CodeassistUtils.isNativeGroup(groupName) && (project = model.getScriptProject(groupName)) instanceof ScriptProject) {
            return (ScriptProject)project;
        }
        return null;
    }

    public static IModelElement[] resolveQualifiedNameReference(Object expression, org.eclipse.dltk.mod.compiler.env.ISourceModule module) {
        List<IModelElement> elements = null;
        try {
            elements = CodeassistUtils.resolveQualifiers(expression, module);
        }
        catch (Exception e) {
            DLTKCore.error((String)"resolving selection node to IModelElement failed", (Throwable)e);
        }
        if (elements != null && elements.size() > 0) {
            return new IModelElement[]{elements.get(elements.size() - 1)};
        }
        return null;
    }

    public static String getClassName(IFile file) {
        Path path = (Path)file.getProjectRelativePath();
        String group = file.getProject().getName();
        List<IPath> sourceFolders = CodeassistUtils.getSourceFolders(group);
        return CodeassistUtils.getClassName(sourceFolders, (IPath)path);
    }

    private static List<IPath> getSourceFolders(String group) {
        ArrayList<IPath> sourceFolders;
        block2: {
            Model model = ModelManager.getModelManager().getModel();
            IScriptProject project = model.getScriptProject(group);
            sourceFolders = new ArrayList<IPath>();
            try {
                IBuildpathEntry[] entries = project.getResolvedBuildpath(true);
                CodeassistUtils.createSourceFolder(sourceFolders, entries);
                buildPathMap.put(group, entries);
            }
            catch (ModelException modelException) {
                IBuildpathEntry[] entries = buildPathMap.get(group);
                if (entries == null) break block2;
                CodeassistUtils.createSourceFolder(sourceFolders, entries);
            }
        }
        return sourceFolders;
    }

    private static void createSourceFolder(List<IPath> sourceFolders, IBuildpathEntry[] entries) {
        IBuildpathEntry[] iBuildpathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildpathEntry buildpathEntry = iBuildpathEntryArray[n2];
            if (buildpathEntry.getEntryKind() == 3) {
                sourceFolders.add(buildpathEntry.getPath().removeFirstSegments(1));
            }
            ++n2;
        }
    }

    private static String getClassName(List<IPath> sourceFolders, IPath path) {
        StringBuffer buffer = new StringBuffer();
        for (IPath path2 : sourceFolders) {
            if (path2.toString().length() <= 0 || !path2.isPrefixOf(path)) continue;
            path = path.removeFirstSegments(path2.segmentCount());
            break;
        }
        String[] segmStrings = path.segments();
        int i = 0;
        while (i < segmStrings.length) {
            String name = segmStrings[i];
            int dotIndex = name.lastIndexOf(DOT);
            if (dotIndex != -1) {
                name = name.substring(0, dotIndex);
            }
            buffer.append(name);
            if (i + 1 != segmStrings.length) {
                buffer.append(DOT);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static SourceTypeName getTypeName(IResource resource) {
        URI locationURI = resource.getLocationURI();
        if (locationURI != null && locationURI.getScheme().equals("typespace")) {
            String groupName = locationURI.getHost();
            String typeName = locationURI.getPath();
            typeName = typeName.replace("/", DOT);
            typeName = typeName.substring(1, typeName.length());
            typeName = typeName.substring(0, typeName.indexOf(SUFFIX_VJO));
            return new SourceTypeName(groupName, typeName);
        }
        String project = resource.getProject().getName();
        List<IPath> sourceFolders = CodeassistUtils.getSourceFolders(project);
        String className = CodeassistUtils.getClassName(sourceFolders, resource.getProjectRelativePath());
        SourceTypeName name = new SourceTypeName(project, className);
        name.setAction(4);
        return name;
    }

    public static SourceTypeName getNativeTypeName(IJstType jstType) {
        String className = jstType.getName();
        String groupName = CodeassistUtils.getNativeGroupName(className);
        SourceTypeName name = new SourceTypeName(groupName, className);
        name.setAction(4);
        return name;
    }

    public static char[] getCompletionToken(IMember element, ISourceModule module) {
        String typeName;
        StringBuffer buffer = new StringBuffer();
        String typeMemberName = element.getParent().getElementName();
        if (module == null) {
            module = element.getSourceModule();
        }
        if ((typeName = module.getElementName().replaceAll(SUFFIX_VJO, "")) == null || typeMemberName == null) {
            return null;
        }
        boolean isNative = element.getAncestor(5) instanceof NativeVjoSourceModule;
        if (!isNative && !CompletionContext.isCompletedContext()) {
            if (typeName.equals(typeMemberName) && CompletionContext.isStaticContext()) {
                if (!CompletionContext.isThisWithinStaticContext()) {
                    buffer.append(THIS_STATIC);
                }
            } else if (!CompletionContext.isVariableContext()) {
                buffer.append(THIS_VJO_STATIC);
                buffer.append(String.valueOf(typeMemberName) + '.');
            }
        }
        char[] token = buffer.toString().toCharArray();
        return token;
    }

    public static char[] getTypeCompletionToken(IType type) {
        StringBuffer buffer = new StringBuffer();
        String typeName = type.getElementName().replaceAll(SUFFIX_VJO, "");
        if (typeName == null) {
            return null;
        }
        if (!(type.getAncestor(5) instanceof NativeVjoSourceModule)) {
            buffer.append(THIS_VJO_STATIC);
        }
        buffer.append(typeName);
        char[] token = buffer.toString().toCharArray();
        return token;
    }

    public static String autoCreateTypeNameFor(org.eclipse.dltk.mod.compiler.env.ISourceModule sourceModule) {
        IPath path = sourceModule.getModelElement().getPath().removeFirstSegments(1);
        if (sourceModule instanceof JSSourceModule) {
            IScriptProject project = ((JSSourceModule)sourceModule).getModelElement().getScriptProject();
            List<IPath> sourceFolders = CodeassistUtils.getSourceFolders(project.getElementName());
            return CodeassistUtils.getClassName(sourceFolders, path);
        }
        return null;
    }

    private static IModelElement findNativeModule(org.eclipse.dltk.mod.compiler.env.ISourceModule module, String name) {
        SourceModule sourceModule = (SourceModule)module;
        ScriptFolder project = (ScriptFolder)sourceModule.getParent();
        IModelElement element = CodeassistUtils.findNativeElement(name, project);
        return element;
    }

    public static IType findNativeSourceType(org.eclipse.dltk.mod.compiler.env.ISourceModule module, String name) {
        IType type = null;
        NativeVjoSourceModule sourceModule = (NativeVjoSourceModule)CodeassistUtils.findNativeModule(module, name);
        if (sourceModule != null) {
            type = sourceModule.getVjoType();
        }
        return type;
    }

    private static IModelElement findNativeElement(String name, ScriptFolder folder) {
        NativeVjoSourceModule element = null;
        TypeSpaceMgr mgr = TypeSpaceMgr.getInstance();
        int i = 0;
        while (i < TsLibLoader.getDefaultLibNames().length) {
            String groupName = TsLibLoader.getDefaultLibNames()[i];
            if (mgr.existType(groupName, name)) {
                element = new NativeVjoSourceModule(folder, groupName, name);
                break;
            }
            ++i;
        }
        return element;
    }

    public static IJstType findNativeJstType(String name) {
        TypeSpaceMgr mgr = TypeSpaceMgr.getInstance();
        int i = 0;
        while (i < TsLibLoader.getDefaultLibNames().length) {
            String groupName = TsLibLoader.getDefaultLibNames()[i];
            if (mgr.existType(groupName, name)) {
                IJstType jtype = mgr.findType(new TypeName(groupName, name));
                nativeTypeGroupMap.put(name, groupName);
                return jtype;
            }
            ++i;
        }
        IJstType windowType = mgr.findType(new TypeName("JsBrowserLib", "Window"));
        IJstType type = CodeassistUtils.findMemberType(windowType, name);
        if (type == null) {
            IJstType globalType = mgr.findType(new TypeName("JsNativeLib", "Global"));
            type = CodeassistUtils.findMemberType(globalType, name);
        }
        return type;
    }

    public static IJstType findJstType(String groupName, String name) {
        TypeSpaceMgr mgr = TypeSpaceMgr.getInstance();
        return mgr.findType(new TypeName(groupName, name));
    }

    private static boolean isEmpty(IJstType jstType) {
        return jstType == null || jstType.getName() == null;
    }

    private static IJstType findMemberType(IJstType type, String memberName) {
        IJstProperty prop = type.getProperty(memberName);
        if (prop != null) {
            return prop.getType();
        }
        IJstMethod method = type.getMethod(memberName);
        if (method != null) {
            return method.getRtnType();
        }
        return null;
    }

    public static NativeVjoSourceModule createNativeModule(ScriptFolder folder, String name) {
        return new NativeVjoSourceModule(folder, "JsNativeLib", name);
    }

    public static IType findType(org.eclipse.dltk.mod.compiler.env.ISourceModule sm, String typeName) {
        IType type = null;
        if (sm instanceof NativeVjoSourceModule) {
            NativeVjoSourceModule module = (NativeVjoSourceModule)sm;
            type = module.getVjoType();
        } else {
            type = CodeassistUtils.findResourceType(sm, typeName);
        }
        return type;
    }

    public static NativeVjoSourceModule createNativeModule(org.eclipse.dltk.mod.compiler.env.ISourceModule module) {
        IVjoSourceModule sourceModule = (IVjoSourceModule)module;
        ScriptFolder folder = (ScriptFolder)sourceModule.getParent();
        return CodeassistUtils.createNativeModule(folder, sourceModule.getElementName());
    }

    public static NativeVjoSourceModule createNativeModule(org.eclipse.dltk.mod.compiler.env.ISourceModule module, String name) {
        IVjoSourceModule sourceModule = (IVjoSourceModule)module;
        ScriptFolder folder = (ScriptFolder)sourceModule.getParent();
        return CodeassistUtils.createNativeModule(folder, name);
    }

    public static IType createNativeType(org.eclipse.dltk.mod.compiler.env.ISourceModule module) {
        NativeVjoSourceModule sourceModule = CodeassistUtils.createNativeModule(module);
        return sourceModule.getVjoType();
    }

    public static IType createNativeType(org.eclipse.dltk.mod.compiler.env.ISourceModule module, String name) {
        NativeVjoSourceModule sourceModule = CodeassistUtils.createNativeModule(module, name);
        return sourceModule.getVjoType();
    }

    public static IModelElement findModelElementByName(IParent type, String name) {
        IModelElement[] children = null;
        IType result = null;
        if (type == null || name == null) {
            return null;
        }
        try {
            children = type.getChildren();
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.getMessage(), (Throwable)e);
        }
        if (children == null) {
            return null;
        }
        IModelElement[] iModelElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IModelElement child = iModelElementArray[n2];
            if (name.equals(child.getElementName())) {
                result = child;
            }
            ++n2;
        }
        if (result == null) {
            result = CodeassistUtils.findResourceType((org.eclipse.dltk.mod.compiler.env.ISourceModule)((VjoSourceType)type).getSourceModule(), name);
        }
        return result;
    }

    public static boolean isMethodHasParamByName(IMethod method, String name) {
        String element = null;
        try {
            String item;
            String[] params = method.getParameters();
            String[] inits = method.getParameters();
            String[] stringArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                item = stringArray[n2];
                if (item.equals(name)) {
                    element = name;
                }
                ++n2;
            }
            stringArray = inits;
            n = inits.length;
            n2 = 0;
            while (n2 < n) {
                item = stringArray[n2];
                if (item.equals(name)) {
                    element = name;
                }
                ++n2;
            }
        }
        catch (ModelException e) {
            DLTKCore.error((String)e.getMessage(), (Throwable)e);
        }
        return element != null;
    }

    public static boolean isVjoSourceModule(IModelElement element) {
        if (!(element instanceof VjoSourceModule)) {
            return false;
        }
        IVjoSourceModule module = (IVjoSourceModule)element;
        return module.getScriptProject().getLanguageToolkit() != null && module.getScriptProject().getLanguageToolkit().getNatureId().equals("org.eclipse.vjet.core.nature");
    }

    public static IType getCurrentType(org.eclipse.dltk.mod.compiler.env.ISourceModule module, String typeName) {
        IType currentType = CodeassistUtils.findResourceType(module, typeName);
        if (currentType == null) {
            IVjoSourceModule sourceModule = (IVjoSourceModule)module;
            try {
                if (sourceModule.getTypes().length > 0) {
                    currentType = sourceModule.getTypes()[0];
                }
            }
            catch (ModelException e) {
                DLTKCore.error((String)e.toString(), (Throwable)e);
            }
        }
        return currentType;
    }

    public static int findWordOffset(char[] source, int offset) {
        char c;
        int start = -2;
        int pos = offset;
        while (pos > 0 && pos < source.length) {
            c = source[pos];
            if (!Character.isWhitespace(c) && Character.isLetter(c)) break;
            --pos;
        }
        start = pos;
        pos = offset;
        while (pos < source.length - 1) {
            c = source[pos];
            if (!Character.isWhitespace(c)) break;
            ++pos;
        }
        if (start >= -1 && start != offset) {
            return start;
        }
        return offset;
    }

    public static boolean isValidIdentifier(String value) {
        boolean isValid = true;
        if (value == null || value.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(value.charAt(0))) {
            return false;
        }
        if (value.length() > 1) {
            int i = 1;
            while (i < value.length()) {
                char c = value.charAt(i);
                if (!Character.isJavaIdentifierPart(c)) {
                    isValid = false;
                    break;
                }
                ++i;
            }
        }
        return isValid;
    }

    public static int getRelevance(CompletionProposal proposal) {
        int baseRelevance = 60;
        Object obj = proposal.extraInfo;
        if (obj == null) {
            baseRelevance = 16;
        } else if (obj instanceof String) {
            String s = (String)obj;
            int index = s.lastIndexOf("-");
            if (index > -1) {
                if ("Window".equalsIgnoreCase((s = s.substring(index + 1)).trim()) || "Global".equalsIgnoreCase(s.trim())) {
                    baseRelevance = 48;
                } else if (OBJECT_TYPE.equalsIgnoreCase(s.trim())) {
                    baseRelevance = 32;
                }
            } else {
                baseRelevance = 72;
            }
        }
        return baseRelevance;
    }

    public static boolean isNativeObject(IMember member) {
        if (member instanceof IType) {
            IModelElement element = ((IType)member).getParent();
            return element instanceof NativeVjoSourceModule;
        }
        if (member.getParent() == null || member.getParent().getParent() == null) {
            return true;
        }
        return member.getParent().getParent() instanceof NativeVjoSourceModule;
    }

    public static boolean isStatic(IMember member) {
        int flags = 0;
        try {
            flags = member.getFlags();
            return (flags & 0x100) != 0;
        }
        catch (ModelException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isStaticPrefix(IMember member) {
        return CodeassistUtils.isStatic(member) && !CompletionContext.isStaticContext();
    }

    public static String getPackageName(IType type) {
        if (CodeassistUtils.isNativeObject((IMember)type)) {
            return "";
        }
        IScriptFolder path = type.getScriptFolder();
        String packageName = path.getElementName().replace('/', '.');
        return packageName;
    }

    public static boolean isNativeType(IJstType jstType) {
        JstPackage pack = jstType.getPackage();
        if (pack == null) {
            return false;
        }
        return false;
    }

    public static boolean isNativeGroup(String groupName) {
        return TsLibLoader.isDefaultLibName((String)groupName);
    }

    public static IType findNativeSourceType(String groupName, String name) {
        return CodeassistUtils.findNativeSourceType(groupName, name, null);
    }

    public static IType findNativeSourceType(String groupName, String name, IJstType jtype) {
        String actualName;
        if (jtype instanceof JstTypeRefType) {
            jtype = ((JstTypeRefType)jtype).getReferencedNode();
        }
        if ((actualName = name) == null) {
            return null;
        }
        if (groupName == null) {
            groupName = CodeassistUtils.getNativeGroupName(actualName);
        }
        if (StringUtils.isBlankOrEmpty((String)groupName)) {
            return null;
        }
        NativeVjoSourceModule nModule = CodeassistUtils.findNativeModule(groupName, actualName);
        if (nModule == null) {
            return null;
        }
        if (jtype == null || !actualName.equals(jtype.getName())) {
            IJstType jtype1 = CodeassistUtils.findJstType(groupName, name);
            nModule.setJstType(jtype1);
        } else {
            nModule.setJstType(jtype);
        }
        if (jtype == null || actualName.equals(jtype.getName())) {
            return nModule.getVjoType();
        }
        IType type = nModule.getVjoType();
        IType subType = CodeassistUtils.getSubType(type, jtype.getSimpleName());
        if (subType == null) {
            subType = nModule.getVjoType().getType(jtype.getSimpleName());
        }
        return subType;
    }

    private static IType getSubType(IType type, String simpleName) {
        try {
            IModelElement[] elements = type.getChildren();
            int i = 0;
            while (i < elements.length) {
                IType tType;
                IModelElement modelElement = elements[i];
                if (modelElement instanceof IType && (tType = (IType)modelElement).getElementName().equals(simpleName)) {
                    return tType;
                }
                ++i;
            }
        }
        catch (ModelException modelException) {
            return null;
        }
        return null;
    }

    public static IJstType getOuterType(IJstType type) {
        IJstType node = type;
        while (node != null && node instanceof IJstType) {
            type = node;
            node = type.getParentNode();
        }
        return type;
    }

    public static IType findNativeSourceType(IJstType jtype) {
        IJstType outerType = CodeassistUtils.getOuterType(jtype);
        String name = outerType.getName();
        String groupName = null;
        JstPackage pack = jtype.getPackage();
        if (pack != null) {
            groupName = pack.getGroupName();
        }
        IType type = CodeassistUtils.findNativeSourceType(groupName, name, jtype);
        return type;
    }

    public static ScriptFolder getDefaultNativeSourceFolder(String groupName) {
        if (!defaultNativeScriptFolderMap.containsKey(groupName)) {
            CodeassistUtils.createDefaultNativeSourceFolder(groupName);
        }
        return defaultNativeScriptFolderMap.get(groupName);
    }

    private static void createDefaultNativeSourceFolder(String groupName) {
        ScriptProject project = new ScriptProject(ResourcesPlugin.getWorkspace().getRoot().getProject(groupName), (ModelElement)ModelManager.getModelManager().getModel()){
            IDLTKLanguageToolkit toolkit = null;

            public IDLTKLanguageToolkit getLanguageToolkit() {
                if (this.toolkit == null) {
                    this.toolkit = (IDLTKLanguageToolkit)InternalDLTKLanguageManager.getLanguageToolkitsManager().getObject("org.eclipse.vjet.core.nature");
                }
                return this.toolkit;
            }

            public boolean isOnBuildpath(IModelElement element) {
                return true;
            }

            public String getElementName() {
                return "Native project";
            }

            public int hashCode() {
                return 1001;
            }

            protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws ModelException {
                return true;
            }
        };
        ExternalScriptFolder folder = new ExternalScriptFolder(null, (IPath)new Path(""), (IScriptProject)project){
            private final /* synthetic */ IScriptProject val$project;
            {
                this.val$project = iScriptProject;
                super($anonymous0, $anonymous1);
            }

            public IScriptProject getScriptProject() {
                return this.val$project;
            }

            public IModelElement getParent() {
                return this.val$project;
            }

            public IPath getPath() {
                return new Path("");
            }

            public int hashCode() {
                return 100;
            }

            public boolean equals(Object o) {
                return o instanceof ExternalScriptFolder && ((ExternalScriptFolder)o).getParent() == this.val$project;
            }

            protected void generateInfos(Object info, HashMap newElements, IProgressMonitor pm) throws ModelException {
            }

            protected void getHandleMemento(StringBuffer buff) {
                buff.append(this.getHandleMementoDelimiter());
                this.escapeMementoName(buff, this.getElementName());
            }

            public IResource getResource() {
                return null;
            }
        };
        defaultNativeScriptFolderMap.put(groupName, (ScriptFolder)folder);
    }

    private static NativeVjoSourceModule findNativeModule(String groupName, String name) {
        String key = String.valueOf(name) + "@" + groupName;
        if (!nativeModuleMap.containsKey(key)) {
            NativeVjoSourceModule nModule = new NativeVjoSourceModule(CodeassistUtils.getDefaultNativeSourceFolder(groupName), groupName, name);
            nativeModuleMap.put(key, nModule);
        }
        return nativeModuleMap.get(key);
    }

    public static String getNativeGroupName(String typeName) {
        if (!nativeTypeGroupMap.containsKey(typeName)) {
            TypeSpaceMgr mgr = TypeSpaceMgr.getInstance();
            int i = 0;
            while (i < TsLibLoader.getDefaultLibNames().length) {
                String groupName = TsLibLoader.getDefaultLibNames()[i];
                if (mgr.existType(groupName, typeName)) {
                    nativeTypeGroupMap.put(typeName, groupName);
                }
                ++i;
            }
        }
        return nativeTypeGroupMap.get(typeName);
    }

    private static IType findTypeByQualify(org.eclipse.dltk.mod.compiler.env.ISourceModule sourceModule, IExpr qualify) {
        Assert.isNotNull((Object)qualify);
        List al = qualify.getChildren();
        if (al == null || al.size() == 0) {
            return null;
        }
        IJstType mainJstType = null;
        IJstType type = null;
        int mainTypeIndex = 0;
        if (al.size() > 0) {
            String fieldExpr;
            IJstNode jstNode = (IJstNode)al.get(al.size() - 1);
            String mainType = "";
            if (jstNode instanceof JstIdentifier) {
                mainType = ((JstIdentifier)jstNode).toString();
                type = CodeassistUtils.findNativeJstType(mainType);
                mainTypeIndex = al.size() - 1;
            } else if (jstNode instanceof FieldAccessExpr && "this.vj$".equals(fieldExpr = ((FieldAccessExpr)jstNode).toExprText()) && al.size() > 1 && al.get(al.size() - 2) instanceof JstIdentifier) {
                mainType = ((JstIdentifier)al.get(al.size() - 2)).toString();
                IType iType = CodeassistUtils.findType(sourceModule, mainType);
                if (iType == null) {
                    iType = CodeassistUtils.findNativeSourceType(sourceModule, mainType);
                }
                type = ((IVjoSourceModule)iType.getSourceModule()).getJstType();
                mainTypeIndex = al.size() - 2;
            }
            mainJstType = type;
        }
        if (type != null && al.size() > 1 && mainTypeIndex > 1) {
            int i = mainTypeIndex - 1;
            while (i >= 0) {
                IExpr expr = (IExpr)al.get(i);
                IJstType embedType = type.getEmbededType(expr.toString());
                if (embedType == null) break;
                type = embedType;
                --i;
            }
        }
        if (mainJstType == null) {
            return null;
        }
        if (mainJstType != null && CodeassistUtils.isNativeType(mainJstType)) {
            return CodeassistUtils.findNativeSourceType(mainJstType);
        }
        return CodeassistUtils.findType(mainJstType);
    }

    public static boolean isBinaryType(IJstType jstType) {
        String group = jstType.getPackage().getGroupName();
        return CodeassistUtils.isBinaryPath(group);
    }

    public static boolean isBinaryPath(String path) {
        if (StringUtils.isBlankOrEmpty((String)path)) {
            return false;
        }
        return path.endsWith(SUFFIX_ZIP) || path.endsWith(SUFFIX_JAR);
    }

    public static boolean isDefaultNativeSourceFolder(IModelElement parent) {
        return defaultNativeScriptFolderMap.containsValue(parent);
    }

    public static boolean isVjDollarProp(IJstProperty jstProperty) {
        if (jstProperty == null) {
            return false;
        }
        return "Vj$Type".equals(jstProperty.getOwnerType().getName());
    }

    public static IJstType lookupJstType(IJstType type) {
        if (type == null) {
            return null;
        }
        if (type instanceof JstProxyType) {
            return CodeassistUtils.lookupJstType(((JstProxyType)type).getType());
        }
        return type;
    }

    public static IJstMethod findDeclaringMethod(IJstNode node) {
        while (node != null && !(node instanceof IJstType)) {
            if (node instanceof JstMethod) {
                return (IJstMethod)node;
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static IModelElement findDeclaringMethodChain(IType dltkType, IJstNode jstMethod) throws ModelException {
        ArrayDeque<String> dq = new ArrayDeque<String>();
        while (jstMethod != null && !(jstMethod instanceof IJstType)) {
            if (jstMethod instanceof JstMethod) {
                dq.push(((JstMethod)jstMethod).getName().getName());
                jstMethod = jstMethod.getParentNode();
                continue;
            }
            jstMethod = jstMethod.getParentNode();
        }
        ModelElement elem = (ModelElement)dltkType;
        block1: for (String string : dq) {
            if (elem instanceof VjoSourceType) {
                IMethod[] methods;
                IMethod[] iMethodArray = methods = dltkType.getMethods();
                int n = methods.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod method = iMethodArray[n2];
                    if (method.getElementName().equals(string)) {
                        elem = (ModelElement)method;
                        continue block1;
                    }
                    ++n2;
                }
                continue;
            }
            IModelElement[] children = elem.getChildren();
            if (children.length == 0) {
                return elem;
            }
            int i = 0;
            while (i < children.length) {
                if (9 == children[i].getElementType() && children[i].getElementName().equals(string)) {
                    elem = (JSSourceMethod)children[i];
                }
                ++i;
            }
        }
        return elem;
    }

    public static IModelElement findDeclaringObjectLiteralChain(ModelElement startingBlock, IJstNode node) throws ModelException {
        ArrayDeque<String> dq = new ArrayDeque<String>();
        while (node != null && !(node instanceof IJstType)) {
            if (node instanceof JstMethod && !(node instanceof JstProxyMethod)) break;
            if (node instanceof JstProxyMethod) {
                dq.push(((IJstMethod)node).getName().getName());
                if (node.getParentNode() instanceof JstMethod) {
                    node = node.getParentNode();
                }
                node = node.getParentNode();
                continue;
            }
            if (node instanceof ObjLiteral) {
                ObjLiteral objectLiteral = (ObjLiteral)node;
                String objLitName = ((AssignExpr)objectLiteral.getParentNode()).getLHS().toLHSText();
                dq.push(objLitName);
                node = node.getParentNode();
                continue;
            }
            node = node.getParentNode();
        }
        Iterator it = dq.iterator();
        ModelElement element = startingBlock;
        block1: while (it.hasNext()) {
            String string = (String)it.next();
            if (startingBlock instanceof VjoSourceType) continue;
            IModelElement[] children = element.getChildren();
            if (children.length == 0) {
                return element;
            }
            int i = 0;
            while (i < children.length) {
                if (children[i].getElementName().equals(string)) {
                    element = (ModelElement)children[i];
                    continue block1;
                }
                ++i;
            }
        }
        return element;
    }

    public static JstBlock findDeclaringBlock(IJstNode node) {
        while (node != null && !(node instanceof IJstType)) {
            if (node instanceof JstBlock) {
                return (JstBlock)node;
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static boolean isLocalVarDeclaration(JstIdentifier identifier) {
        if (identifier == null) {
            return false;
        }
        boolean isParentAssignExpr = identifier.getParentNode() instanceof AssignExpr;
        if (!isParentAssignExpr) {
            return false;
        }
        boolean isGradParentJstVars = identifier.getParentNode().getParentNode() instanceof JstVars;
        return isGradParentJstVars;
    }

    public static String getFirstVariableName(JstVars jstVars) {
        AssignExpr assignExpr;
        if (jstVars == null) {
            return "";
        }
        if (jstVars.getChildren().toArray()[1] instanceof AssignExpr && (assignExpr = (AssignExpr)jstVars.getChildren().toArray()[1]).getChildren().toArray()[0] instanceof JstIdentifier) {
            JstIdentifier identifier = (JstIdentifier)assignExpr.getChildren().toArray()[0];
            return identifier.getName();
        }
        return "";
    }

    public static String getGroupName(VjoSourceModule vjoSourceModule) {
        String temp;
        String tName = vjoSourceModule.getGroupName();
        SourceTypeName typeName = vjoSourceModule.getTypeName();
        if (typeName != null && StringUtils.isBlankOrEmpty((String)(temp = typeName.typeName()))) {
            tName = temp;
        }
        return tName;
    }

    public static IType convert2DLTKType(IJstType type) {
        if (type == null) {
            return null;
        }
        IModelElement element = JstNodeDLTKElementResolver.convert(null, (IJstNode)type)[0];
        if (7 == element.getElementType()) {
            return (IType)element;
        }
        return null;
    }

    public static IJstType getJstType(TypeSpace<IJstType, IJstNode> typeSpace, IVjoSourceModule module) {
        return new JstQueryExecutor(typeSpace).findType(module.getTypeName());
    }

    public static IJstType getJstType(IVjoSourceModule module) {
        ITypeSpace typeSpace = TypeSpaceMgr.getInstance().getTypeSpace();
        return CodeassistUtils.getJstType((TypeSpace<IJstType, IJstNode>)((TypeSpace)typeSpace), module);
    }

    public static boolean isVjetFileName(String fileName) {
        return !StringUtils.isBlankOrEmpty((String)fileName) && fileName.endsWith(SUFFIX_VJO);
    }

    public static boolean isModuleInBuildPath(IModelElement element) {
        IScriptProject project = element.getScriptProject();
        if (project == null || !project.exists()) {
            return false;
        }
        return project.isOnBuildpath(element);
    }

    public static String calculateRtnType(IJstMethod method) {
        IJstType type;
        RtnStmt rs;
        IExpr expr;
        BaseJstNode node;
        List list;
        String defaultS = "void";
        JstBlock block = method.getBlock();
        if (block != null && (list = block.getChildren()) != null && !list.isEmpty() && (node = (BaseJstNode)list.get(list.size() - 1)) instanceof RtnStmt && (expr = (rs = (RtnStmt)node).getExpression()) != null && (type = expr.getResultType()) != null) {
            defaultS = CodeCompletionUtils.getAliasOrTypeName((IJstType)method.getOwnerType(), (IJstType)type);
        }
        return defaultS;
    }

    public static IModelElement findDeclaringObjectLiteralFieldChain(ModelElement modelElement, IJstNode node) throws ModelException {
        ArrayDeque<String> dq = new ArrayDeque<String>();
        while (node != null && !(node instanceof IJstType)) {
            if (node instanceof JstMethod && !(node instanceof JstProxyMethod)) break;
            if (node instanceof JstProperty) {
                dq.push(((JstProperty)node).getName().getName());
                node = node.getParentNode();
                continue;
            }
            if (node instanceof JstObjectLiteralType) {
                dq.push(((JstObjectLiteralType)node).getSimpleName());
                continue;
            }
            if (node instanceof ObjLiteral) {
                ObjLiteral objectLiteral = (ObjLiteral)node;
                if (objectLiteral.getParentNode() instanceof AssignExpr) {
                    String objLitName = ((AssignExpr)objectLiteral.getParentNode()).getLHS().toLHSText();
                    dq.push(objLitName);
                }
                node = node.getParentNode();
                continue;
            }
            if (node instanceof NV) {
                dq.push(((NV)node).getName());
                node = node.getParentNode();
                continue;
            }
            node = node.getParentNode();
        }
        block1: for (String string : dq) {
            IModelElement[] children = modelElement.getChildren();
            if (children.length == 0) {
                return modelElement;
            }
            int i = 0;
            while (i < children.length) {
                if (8 == children[i].getElementType() && children[i].getElementName().equals(string)) {
                    modelElement = (JSSourceField)children[i];
                    continue block1;
                }
                ++i;
            }
        }
        return modelElement;
    }

    private static enum FieldSearchType {
        INSTANCE,
        STATIC;

        private int usegesCnt;
    }
}

