/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.codeassist.keywords;

import java.util.List;
import org.eclipse.dltk.mod.compiler.env.ISourceModule;
import org.eclipse.dltk.mod.core.CompletionProposal;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.declaration.JstMethod;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.expr.ObjCreationExpr;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jstojava.translator.JstUtil;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletionOnMemberAccess;
import org.eclipse.vjet.eclipse.codeassist.keywords.CompletionContext;
import org.eclipse.vjet.eclipse.codeassist.keywords.FieldExpressionHandler;
import org.eclipse.vjet.eclipse.codeassist.keywords.ICompletionHandler;
import org.eclipse.vjet.eclipse.codeassist.keywords.MethodCompletionHandler;
import org.eclipse.vjet.eclipse.codeassist.keywords.StaticMemberAccessHandler;
import org.eclipse.vjet.eclipse.codeassist.keywords.TypeMemberAccessHandler;
import org.eclipse.vjet.eclipse.codeassist.keywords.VjoKeywordFactory;

public class MemberAccessHandler
implements ICompletionHandler {
    public static final int SPACE_AND_DOT_LENGTH = 2;
    public static final int DOT_LENGTH = 1;
    private static StaticMemberAccessHandler staticHandler = new StaticMemberAccessHandler();
    private static TypeMemberAccessHandler typeHandler = new TypeMemberAccessHandler();
    private static FieldExpressionHandler exprHandler = new FieldExpressionHandler();
    private static MethodCompletionHandler methodHandler = new MethodCompletionHandler();
    private ISourceModule module;
    private int position;
    private JstCompletion completion;
    private List<CompletionProposal> list;

    @Override
    public void complete(ISourceModule module, int position, JstCompletion completion, List<CompletionProposal> list) {
        this.init(module, position, completion, list);
        int pos = this.getNodeEndOffset(module, position - 2);
        Object node = JstUtil.getAllNodes((IJstType)completion.getOwnerType(), (int)pos, (int)pos).get(0);
        this.complete(node);
    }

    public void complete(Object node) {
        CompletionContext.setInstanceContext(true);
        IJstType type = this.completion.getOwnerType();
        if (node instanceof ObjCreationExpr) {
            ObjCreationExpr expr = (ObjCreationExpr)node;
            CompletionContext.setVariableContext(true);
            this.completeMethodExpr(type, expr.getInvocationExpr());
        } else if (node instanceof MtdInvocationExpr) {
            this.completeMethodExpr(type, node);
        } else if (node instanceof FieldAccessExpr) {
            this.completeFieldExpr(node, type);
        } else if (node != null && !node.toString().equals("vjo")) {
            if (this.thisInStaticCntx((IJstNode)node)) {
                staticHandler.setJstType(type);
                staticHandler.setTypeName(type.getSimpleName());
                staticHandler.complete(this.module, this.position, this.completion, this.list);
            } else {
                exprHandler.complete(this.module, this.position, this.completion, this.list, node);
            }
        } else if (node == null || !node.toString().equals("vjo")) {
            methodHandler.complete(this.module, this.position, this.completion, this.list);
        }
    }

    private boolean thisInStaticCntx(IJstNode identifier) {
        JstMethod enclosedMethod;
        String name = this.getName(identifier);
        if (name.equals(VjoKeywordFactory.KWD_THIS.getName()) && (enclosedMethod = this.getEnclosedMethod(identifier)) != null) {
            return enclosedMethod.isStatic();
        }
        return false;
    }

    private String getName(IJstNode node) {
        String name = node.toString();
        if (node instanceof JstIdentifier) {
            JstIdentifier jstIdentifier = (JstIdentifier)node;
            name = jstIdentifier.getName();
        }
        return name;
    }

    private JstMethod getEnclosedMethod(IJstNode node) {
        while (node != null && !(node instanceof JstMethod)) {
            node = node.getParentNode();
        }
        return (JstMethod)node;
    }

    private void completeFieldExpr(Object node, IJstType type) {
        FieldAccessExpr fieldAccessExpr = (FieldAccessExpr)node;
        this.complete(type, fieldAccessExpr);
    }

    public void init(ISourceModule module, int position, JstCompletion completion, List<CompletionProposal> list) {
        this.position = position;
        this.module = module;
        this.completion = completion;
        this.list = list;
    }

    private void completeMethodExpr(IJstType type, Object node) {
        exprHandler.complete(this.module, this.position, this.completion, this.list, node);
    }

    private void complete(IJstType type, FieldAccessExpr invocationExpr) {
        CompletionContext.setInstanceContext(true);
        exprHandler.complete(this.module, this.position, this.completion, this.list, invocationExpr);
    }

    private int getNodeEndOffset(ISourceModule module, int pos) {
        int index = pos;
        String string = module.getSourceContents();
        int i = pos;
        while (i >= 0) {
            char c = string.charAt(i);
            if (!Character.isWhitespace(c)) {
                index = i;
                break;
            }
            --i;
        }
        return index;
    }

    @Override
    public Class<?> getCompletionClass() {
        return JstCompletionOnMemberAccess.class;
    }
}

