/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.eclipse.codeassist.keywords;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.mod.compiler.env.ISourceModule;
import org.eclipse.vjet.eclipse.codeassist.keywords.IComposable;
import org.eclipse.vjet.eclipse.codeassist.keywords.IEnclosable;
import org.eclipse.vjet.eclipse.codeassist.keywords.ITopLevel;
import org.eclipse.vjet.eclipse.codeassist.keywords.IUnclosed;
import org.eclipse.vjet.eclipse.codeassist.keywords.IVjoCompletionData;
import org.eclipse.vjet.eclipse.codeassist.keywords.KeywordCompletionEngine;
import org.eclipse.vjet.eclipse.codeassist.keywords.VjoKeywordCompletionResult;
import org.eclipse.vjet.eclipse.codeassist.keywords.VjoKeywordFactory;
import org.eclipse.vjet.eclipse.codeassist.keywords.VjoKeywordPatternHelper;

public class SimpleKeywordCompletionEngine
implements KeywordCompletionEngine {
    private static final char TRIGGER_SPACE = ' ';
    private static final char TRIGGER_TAB = '\t';
    private static final char TRIGGER_DOT = '.';
    private static final char TRIGGER_SEMICOLON = ';';
    private static final char TRIGGER_COLON = ':';
    private static final char TRIGGER_LPARENTHESIS = '(';
    private static final char TRIGGER_RPARENTHESIS = ')';
    private static final char TRIGGER_LBRACE = '{';
    private static final char TRIGGER_RBRACE = '}';
    private static final char TRIGGER_NEWLINE_1 = '\r';
    private static final char TRIGGER_NEWLINE_2 = '\n';
    private static final String TRIGGER_LINE = " \t.;:{}()\r\n";
    private static final String EMPTY = "";
    private int cursor;
    private char[] cntx;
    private int initPos;
    private int startPosToComplete;
    private static VjoKeywordCompletionResult prevResult = null;
    private List<IVjoCompletionData> keywords = new ArrayList<IVjoCompletionData>();

    public SimpleKeywordCompletionEngine(ISourceModule module, int initPos) {
        this.cntx = module.getSourceContents().toCharArray();
        this.initPos = initPos - 1;
    }

    private char[] getInvertedBackwardBlock(int size) {
        int amount = this.cursor < size ? this.cursor + 1 : size;
        int limit = this.cursor - amount;
        char[] block = new char[amount];
        int iter = this.cursor;
        while (iter > limit) {
            block[this.cursor - iter] = this.cntx[iter];
            --iter;
        }
        return block;
    }

    private void processingContext() {
        boolean stopSearching = false;
        this.cursor = this.initPos;
        int bCounter = 0;
        int pCounter = 0;
        int unclosedBFlags = 0;
        int unclosedPFlags = 0;
        while (this.cursor != -1 && !stopSearching) {
            switch (this.cntx[this.cursor]) {
                case ')': {
                    IVjoCompletionData nearestKeyword;
                    if (pCounter == 0 && (nearestKeyword = new VjoKeywordPatternHelper(this.getInvertedBackwardBlock(100)).lookupNearestKeyword()) != null) {
                        if (nearestKeyword.isTopLevelKeyword() && !nearestKeyword.isComposableKeyword()) {
                            this.keywords.addAll(((ITopLevel)((Object)nearestKeyword)).getPeerKeywords());
                            stopSearching = true;
                        } else if (nearestKeyword.isComposableKeyword()) {
                            this.keywords.addAll(((IComposable)((Object)nearestKeyword)).getAllowedCompositeKeywords());
                            stopSearching = true;
                        }
                    }
                    ++unclosedPFlags;
                    ++pCounter;
                    break;
                }
                case '(': {
                    --pCounter;
                    break;
                }
                case '}': {
                    ++unclosedBFlags;
                    ++bCounter;
                    break;
                }
                case '{': {
                    IVjoCompletionData nearestKeyword;
                    if (bCounter == 0) {
                        nearestKeyword = new VjoKeywordPatternHelper(this.getInvertedBackwardBlock(100)).lookupNearestKeyword();
                        stopSearching = true;
                        if (nearestKeyword != null) {
                            this.keywords.addAll(((IEnclosable)((Object)nearestKeyword)).getAllowedEnclosedKeywords());
                        }
                    } else if (bCounter == 1) {
                        if (pCounter == 1) {
                            nearestKeyword = new VjoKeywordPatternHelper(this.getInvertedBackwardBlock(100)).lookupNearestKeyword();
                            this.keywords.addAll(((IComposable)((Object)nearestKeyword)).getAllowedCompositeKeywords());
                            stopSearching = true;
                        } else if (unclosedBFlags == 1 && unclosedPFlags == 0 && (nearestKeyword = new VjoKeywordPatternHelper(this.getInvertedBackwardBlock(100)).lookupNearestKeyword()) != null && nearestKeyword.isUnclosed()) {
                            this.keywords = ((IUnclosed)((Object)nearestKeyword)).getComplementedKeywords();
                            int cur = this.cursor;
                            this.filter();
                            stopSearching = !((IUnclosed)((Object)nearestKeyword)).isSelfSufficient();
                            this.cursor = cur;
                        }
                    }
                    --bCounter;
                }
            }
            --this.cursor;
        }
        if (this.cursor == -1 && !stopSearching) {
            this.keywords.addAll(VjoKeywordFactory.getTopLevelKeywords());
        }
    }

    private void filter() {
        ArrayList<IVjoCompletionData> filteredKeywords = new ArrayList<IVjoCompletionData>();
        this.cursor = this.initPos;
        char[] invertedBlock = this.getInvertedBackwardBlock(100);
        for (IVjoCompletionData keyword : this.keywords) {
            if (new VjoKeywordPatternHelper(invertedBlock).isSuitableForCompleteion(keyword)) {
                this.cursor = this.initPos;
                StringBuffer buf = new StringBuffer();
                while (this.cursor > -1 && (TRIGGER_LINE.indexOf(this.cntx[this.cursor]) == -1 || keyword.isAllowedTrigger(this.cntx[this.cursor]))) {
                    buf.insert(0, this.cntx[this.cursor--]);
                }
                String word = buf.toString();
                this.startPosToComplete = this.cursor + 1;
                if (keyword.canComplete(word)) {
                    filteredKeywords.add(keyword);
                }
            }
            this.keywords = filteredKeywords;
        }
    }

    @Override
    public VjoKeywordCompletionResult getCompletionResult() {
        this.processingContext();
        this.filter();
        return SimpleKeywordCompletionEngine.getCompletionResultForVjoKeyword(this.keywords, this.startPosToComplete);
    }

    private static VjoKeywordCompletionResult getCompletionResultForVjoKeyword(List<IVjoCompletionData> keywords, int startPosToComplete) {
        prevResult = new VjoKeywordCompletionResult(keywords, startPosToComplete);
        return prevResult;
    }

    public static VjoKeywordCompletionResult getJustObtainedResult() {
        return prevResult;
    }
}

